/*
 * SchemeTokenMarker.java - Scheme token marker
 * Copyright (C) 1998, 1999 Slava Pestov
 *
 * You may use and modify this package for any purpose. Redistribution is
 * permitted, in both source and binary form, provided that this notice
 * remains intact in all source distributions of this package.
 */
package jedit.lang;


import javax.swing.text.Segment;

import jedit.Token;
import jedit.KeywordMap;
import jedit.TokenMarker;


/**
 * Scheme token marker.
 *
 * @author Kendy JEAN-MARIE
 * 2004 - Univ. Montpellier II - France
 */
public class SchemeTokenMarker extends TokenMarker {
    // private members
    private static KeywordMap schemeKeywords;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;
    private boolean isScheme;

				int nbrePar = 0;
        boolean quote = false;
        boolean avecPar = false; // 'motkelkonk   et pas  '(...)
        boolean compteestbon = false;
				int positionQuote=-1, positionFermante = -1;
				
				
    public SchemeTokenMarker() {
        this(true, getKeywords());
    }
    
    public SchemeTokenMarker(boolean isScheme, KeywordMap keywords) {
        this.isScheme = isScheme;
        this.keywords = keywords;
    }


				
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        char[] array = line.array;
        int offset = line.offset;

        lastOffset = offset;
        lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        String NO_WORD_SEP = "_-+?:*/!";
 

				
        loop:
        for (int i = offset; i < length; i++) {
            int i1 = (i + 1);

            char c = array[i];

            switch (token) {
            case Token.NULL: {
                switch (c) {

                case '"': { 	
									 //System.out.println("c="+c+" i="+i+" quote="+quote+" GUILLEMENTS");
                   // doKeyword(line,i,c);  // DOKEYWORD
                    if (backslash) {
                       backslash = false;
                   } else {
                        addToken(i - lastOffset, token);
                        token = Token.LITERAL1;
                        lastOffset = lastKeyword = i;
                   }
                    break;
                }
			
                case ';': {
                    if (length - i > 1) {
                        addToken(i - lastOffset, token);
                        addToken(length - i, Token.COMMENT1);
                        lastOffset = lastKeyword = length;
                        break loop;
                    }
                }

                case '#': { // //System.out.println("c= "+ c +" ==> " + "j'entre dans ce case ! #1 \n");
			
                    if (backslash) {
                        backslash = false;
                    } 

                    /*
                     backslash = false;
                     doKeyword(line,i,c);  // DOKEYWORD
                     
                     */
                    if (length - i > 1) {

                        switch (array[i1]) { /*
                         case 'f':
                         case 'F':
                         case 'T':
                         case 't':
                         //System.out.println("c= "+ c +" ==> " + "j'entre dans ce case ! #1 i="+i+ " lastoffset="+lastOffset);   
                         addToken((i+1)  - lastOffset,token);
                         lastOffset = lastKeyword = i+1;
                         token = Token.LITERAL2;
                         //doKeyword(line,i,c);
                         break ; */
					    
                        case '|':
                            addToken(i - lastOffset, token);
                            lastOffset = lastKeyword = i;
                            if (length - i > 2 && array[i + 2] == '|') {
                                token = Token.COMMENT2;
                            } else { // //System.out.println("COMMENT 11111111111111111111111111");
                                token = Token.COMMENT2;
                            }
                            break;
                        }
                    } 
			    
                    break;
                }
			
			/*
                case '\'': {
                 //System.out.println("c="+c+" i="+i+" quote="+quote+" QUOTE");
                 //   try {
			
                  //  //System.out.println("========TEST==========>>>>>>>>>>>>> C = " + c);
                    if (length - i > 1) {
                       if (array[i1] == '(') {
                            //System.out.println( "==================>>>>>>>>>>>>> C = " + c + array[i1]);
                            quote = true;
                            avecPar = true;
														
                //      //System.out.println("test quote=" + quote);
											
                           addToken(1, token);
														token = Token.LABEL;
                           lastOffset = lastKeyword =  i;		
														
														
														positionQuote=i;
						//		  //System.out.println("test2 quote=" + quote);
									
                            //System.out.println("positionQuote = " + i);
                            //System.out.println( "==========>>>> i - lastOffset = " + (i - lastOffset));
                       }
                 
                        // else { // sans PARENTHESE
                        // avecPar = false;
                        // //System.out.println("quote ICI= " + i + " YEAHHHHHH");
                        // doKeyword(line, i, c); // DOKEYWORD
                 
                        // }
                 
                   }
                //    }catch (Exception e) {}
                 
                 
               break;
                }
								
                 
                case '(':
                case ')': {
									 //System.out.println("c="+c+" i="+i+" quote="+quote+" nbrePar="+nbrePar+" PARENTHESE");
                    if (c == '(') {
                     
                        // doKeyword(line,i,c);  // DOKEYWORD
                        if (quote) {
                            avecPar = true;
                            nbrePar++; 

                            //System.out.println(
                                    "xxxxxxxxxxparenthese! c=" + c + " et i="
                                    + i + " et nbrePar=" + nbrePar);
																		
																		
															
                 
                        }
                
                    } else if (c == ')') { // //System.out.println("ON TOMBE SUR )");
                        if (quote) { 
                            // //System.out.println("ON TOMBE SUR ), nbrePar="+nbrePar);
                            nbrePar--; 
                            //System.out.println(
                                    "yyyyyyyyyyyparnthese! c=" + c + " et i="
                                    + i + " et nbrePar=" + nbrePar); 
																		
																		
																		
																
														
														
		 if(nbrePar == 0)
		 {
		 	compteestbon = true;
			positionFermante = i;
			//System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>COMPTE EST BOn !!!!<<<<<<<<<<<<<<<<<<<<");
		 }
                        }
               
                    }
		 
                    // break;
                }
								
								*/
		 
                default: { // //System.out.println("j'entre dans ce case ! DEFAULT c = " + c);
                    // backslash = false;
			
		
			
			
                    if (!Character.isLetterOrDigit(c) && c != '_'
                            && NO_WORD_SEP.lastIndexOf(c) == -1) {
                        doKeyword(line, i, c);
                    }
		    
                     else  if (Character.isDigit(c)) { // POUR LES CHIFFRES
                     
                     try {
                     //System.out.println("je rencontre un chiffre c="+c);
                     //  doKeyword(line, i, c);
                     
                     if ( !Character.isLetter(array[i-1]) ) {
                     addToken(i - lastOffset, token);
                     token = Token.LABEL;
                     lastOffset = lastKeyword = i; 
                     }
                     } catch (ArrayIndexOutOfBoundsException e) {
                     //System.out.println(e);
                     
                     addToken(i - lastOffset, token);
                     token = Token.LABEL;
                     lastOffset = lastKeyword = i;     
                     
                     }

                     
                     }
                    break;
                }
			
                }
                break;

            }

            /*
             case Token.LABEL: {
             // //System.out.println("j'entre dans ce case ! Token.LABEL c = " + c);	
             
             if (avecPar == true && quote != -1 && length - i > 1
             && nbrePar == 1) {
             if (array[i1] == ')') {
             i++;
             //System.out.println(
             "j'entre dans ce case ! Token.LABEL c = " + c + " OK !!");

             addToken((i + 1) - lastOffset, token);
             token = Token.NULL;
             lastOffset = lastKeyword = i + 1;
             
             //System.out.println("quote remis  -1 !!!!!!!!!!!!");
             quote = -1; // remise  defaut
             avecPar = false;  
             }
             
             }

             break;
             }
             
            
            case Token.LABEL: {
             //   //System.out.println("j'entre dans ce case ! Token.LABEL c="+c + " quote="+quote+" avecPar="+avecPar+" nbrePar="+nbrePar+" compteestbon="+compteestbon);	
             
					
              
							if (quote && avecPar && nbrePar == 0 &&compteestbon ) {
								
									 //if (quote && avecPar && c == ')' && nbrePar == 0 &&compteestbon ) {
								//	nbrePar--;
                    //System.out.println(
                            "j'entre dans ce case ! Token.LABEL c = " + c
                            + " OK !!");
                    // TEST
                    //System.out.println("jentre la !!! CATCH A FIRE");
                  addToken(1, token);
                    token = Token.NULL;
                   lastOffset = lastKeyword = i1;
										

                    // TEST
                    // i++;
                    // addToken((i1) - lastOffset,token);
                    // token = Token.NULL;
                    // lastOffset = lastKeyword = i1;
             
                    // PAS MAL !
                   //  i++;
                   //  addToken((i+1) - lastOffset,token);
                   //  token = Token.NULL;
                   //  lastOffset = lastKeyword = i+1;
             
                    //System.out.println("quote remis  -1 !!!!!!!!!!!!");
                   // remise  defaut
									 quote = false; 
									  //System.out.println("test3 quote=" + quote);
                    avecPar = false;
										nbrePar = 0;
										compteestbon = false;
										positionQuote = -1;
										
                }
             
                // else if (avecPar == false  ) {
                // addToken(i - quote +1, token);	
                // token = Token.NULL;
                // lastOffset = lastKeyword = i;
                // }
								
								
                break;
            }
						*/
             
             case Token.LABEL: { // POUR LES NOMBRES
             
             if (c==')' || c==' ' || c=='(' || Character.isLetter(c)) {
             addToken(i - lastOffset, token);
             token = Token.NULL;
             lastOffset = lastKeyword = i;
             
             //System.out.println("DANS OPERATOR !!!!");
             }
             break;
             }
            case Token.COMMENT1: 
            case Token.COMMENT2: {
                backslash = false;
                if (c == '|' && length - i > 1) {
                    if (array[i1] == '#') {
                        i++;
                        addToken((i + 1) - lastOffset, token);
                        token = Token.NULL;
                        lastOffset = lastKeyword = i + 1;
                    }
                }
                break;
            }

            case Token.LITERAL1: {
                if (backslash) {
                    backslash = false;
                } else if (c == '"') {
                    addToken(i1 - lastOffset, token);
                    token = Token.NULL;
                    lastOffset = lastKeyword = i1;
									
                }
                break;
            }

            case Token.LITERAL2: {
                if (backslash) {
                    backslash = false;
                } else if (c == '\'') {
                    //System.out.println( "c= " + c + " ==> "   + "j'entre dans ce case ' BIS \n");
                    addToken(i1 - lastOffset, Token.LITERAL2);
                    token = Token.NULL;
                    lastOffset = lastKeyword = i1;
                }

                break;
            }

            default: { // //System.out.println("c= "+ c +" ==> " + "j'entre dans ce case ! DEFAULT2 \n");
                throw new InternalError("Invalid state: " + token);
            }
            }
        }

        if (token == Token.NULL) {
            // //System.out.println( "j'entre dans ce IF ! Token.NULL \n");
            doKeyword(line, length, '\0');
        }

        switch (token) {
        case Token.LITERAL1:
        case Token.LITERAL2: {
            //System.out.println("j'entre dans ce case ! LITERAL2 \n");
            addToken(length - lastOffset, Token.INVALID);
            token = Token.NULL;
            break;
        }

        case Token.KEYWORD2: { // //System.out.println("j'entre dans ce case ! KEYWORD2 \n");
            addToken(length - lastOffset, token);
            if (!backslash) {
                token = Token.NULL;
            }
        }

        default: { // //System.out.println("j'entre dans ce case ! DEFAULT3 \n");
            addToken(length - lastOffset, token);
            break;
        }
        }

        return token;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        boolean klassname = false;

        int len = i - lastKeyword;
        byte id = keywords.lookup(line, lastKeyword, len);

        if (id == Token.NULL) {
            klassname = true;
            for (int at = lastKeyword; at < lastKeyword + len; at++) {
                char ch = line.array[at];

                if (ch != '_' && !Character.isUpperCase(ch)) {
                    klassname = false;
                    break;
                }
            }
            // if ( klassname )
            // id = Token.KEYWORD3;
        }

        if (id != Token.NULL) {
            if (lastKeyword != lastOffset) {
                addToken(lastKeyword - lastOffset, Token.NULL);
            }
            addToken(len, id);
            lastOffset = i;
        }
        lastKeyword = i1;
        return false;
    }

    public static KeywordMap getKeywords() {
        if (schemeKeywords == null) {
            schemeKeywords = new KeywordMap(false); // FALSE BECAUSE SCHEME IS CASE-SENSITIVE

						
						 schemeKeywords.add("define", Token.LABEL);
						 
						 
						 
            // KEYWORD 1
            schemeKeywords.add("and", Token.KEYWORD1);
            schemeKeywords.add("begin", Token.KEYWORD1);
            schemeKeywords.add("cond", Token.KEYWORD1);
           // schemeKeywords.add("define", Token.KEYWORD1);
            schemeKeywords.add("if", Token.KEYWORD1);
            schemeKeywords.add("else", Token.KEYWORD1);
            schemeKeywords.add("lambda", Token.KEYWORD1);
            schemeKeywords.add("let", Token.KEYWORD1);
            schemeKeywords.add("let*", Token.KEYWORD1);
            schemeKeywords.add("letrec", Token.KEYWORD1);
            schemeKeywords.add("or", Token.KEYWORD1);
            schemeKeywords.add("`", Token.KEYWORD1);
            schemeKeywords.add("quasiquote", Token.KEYWORD1);
            schemeKeywords.add("quote", Token.KEYWORD1);
            schemeKeywords.add("'", Token.KEYWORD1);
            schemeKeywords.add("set!", Token.KEYWORD1);
            schemeKeywords.add("trace", Token.KEYWORD1);
            schemeKeywords.add("unquote", Token.KEYWORD1);
            schemeKeywords.add(",", Token.KEYWORD1);
            schemeKeywords.add("unquote-splicing", Token.KEYWORD1);
            schemeKeywords.add(",@", Token.KEYWORD1);
            schemeKeywords.add("untrace", Token.KEYWORD1);

            // KEYWORD 2 
            schemeKeywords.add("abs", Token.KEYWORD2);
            schemeKeywords.add("append", Token.KEYWORD2);
            schemeKeywords.add("apply", Token.KEYWORD2);
            schemeKeywords.add("assoc", Token.KEYWORD2);
            schemeKeywords.add("car", Token.KEYWORD2);
            schemeKeywords.add("cdr", Token.KEYWORD2);
	    
            schemeKeywords.add("caar", Token.KEYWORD2);
            schemeKeywords.add("cddr", Token.KEYWORD2);
	    
            schemeKeywords.add("cadr", Token.KEYWORD2);
            schemeKeywords.add("cdar", Token.KEYWORD2);
	    
            schemeKeywords.add("char-downcase", Token.KEYWORD2);
            schemeKeywords.add("char-upcase", Token.KEYWORD2);
            schemeKeywords.add("char->integer", Token.KEYWORD2);
            schemeKeywords.add("cons", Token.KEYWORD2);
            schemeKeywords.add("display", Token.KEYWORD2);
            schemeKeywords.add("=", Token.KEYWORD2);
            schemeKeywords.add("integer->char", Token.KEYWORD2);
            schemeKeywords.add("<", Token.KEYWORD2);
            schemeKeywords.add(">", Token.KEYWORD2);
            schemeKeywords.add("<=", Token.KEYWORD2);
            schemeKeywords.add(">=", Token.KEYWORD2);
            schemeKeywords.add("length", Token.KEYWORD2);
            schemeKeywords.add("list", Token.KEYWORD2);
            schemeKeywords.add("list->string", Token.KEYWORD2);
            schemeKeywords.add("list->vector", Token.KEYWORD2);
            schemeKeywords.add("load", Token.KEYWORD2);
            schemeKeywords.add("map", Token.KEYWORD2);
            schemeKeywords.add("max", Token.KEYWORD2);
            schemeKeywords.add("member", Token.KEYWORD2);
            schemeKeywords.add("min", Token.KEYWORD2);
            schemeKeywords.add("-", Token.KEYWORD2);
            schemeKeywords.add("*", Token.KEYWORD2);
            schemeKeywords.add("newline", Token.KEYWORD2);
            schemeKeywords.add("not", Token.KEYWORD2);
            schemeKeywords.add("number->string", Token.KEYWORD2);
            schemeKeywords.add("+", Token.KEYWORD2);
            schemeKeywords.add("quotient", Token.KEYWORD2);
            schemeKeywords.add("remainder", Token.KEYWORD2);
            schemeKeywords.add("reverse", Token.KEYWORD2);
            schemeKeywords.add("setcar!", Token.KEYWORD2);
            schemeKeywords.add("setcdr!", Token.KEYWORD2);
            schemeKeywords.add("string", Token.KEYWORD2);
            schemeKeywords.add("string-length", Token.KEYWORD2);
            schemeKeywords.add("string-append", Token.KEYWORD2);
            schemeKeywords.add("string-copy", Token.KEYWORD2);
            schemeKeywords.add("vector", Token.KEYWORD2);

            // KEYWORd 3
            schemeKeywords.add("boolean?", Token.KEYWORD3);
            schemeKeywords.add("char?", Token.KEYWORD3);
            schemeKeywords.add("char=?", Token.KEYWORD3);
            schemeKeywords.add("charchar>?", Token.KEYWORD3);
            schemeKeywords.add("char<=?", Token.KEYWORD3);
            schemeKeywords.add("char>=?", Token.KEYWORD3);
            schemeKeywords.add("char-ci=?", Token.KEYWORD3);
            schemeKeywords.add("char-cichar-ci>?", Token.KEYWORD3);
            schemeKeywords.add("char-ci<=?", Token.KEYWORD3);
            schemeKeywords.add("char-ci>=?", Token.KEYWORD3);
            schemeKeywords.add("char-alphabetic?", Token.KEYWORD3);
            schemeKeywords.add("char-lower-case?", Token.KEYWORD3);
            schemeKeywords.add("char-numeric?", Token.KEYWORD3);
            schemeKeywords.add("char-upper-case?", Token.KEYWORD3);
            schemeKeywords.add("char-whitespace?", Token.KEYWORD3);
            schemeKeywords.add("equal?", Token.KEYWORD3);
            schemeKeywords.add("eq?", Token.KEYWORD3);
            schemeKeywords.add("eqv?", Token.KEYWORD3);
            schemeKeywords.add("even?", Token.KEYWORD3);
            schemeKeywords.add("integer?", Token.KEYWORD3);
            schemeKeywords.add("negative?", Token.KEYWORD3);
            schemeKeywords.add("null?", Token.KEYWORD3);
            schemeKeywords.add("odd?", Token.KEYWORD3);
            schemeKeywords.add("pair?", Token.KEYWORD3);
            schemeKeywords.add("positive?", Token.KEYWORD3);
            schemeKeywords.add("procedure?", Token.KEYWORD3);
            schemeKeywords.add("string?", Token.KEYWORD3);
            schemeKeywords.add("string=?", Token.KEYWORD3);
            schemeKeywords.add("stringstring>?", Token.KEYWORD3);
            schemeKeywords.add("string<=?", Token.KEYWORD3);
            schemeKeywords.add("string>=?", Token.KEYWORD3);
            schemeKeywords.add("string-ci=?", Token.KEYWORD3);
            schemeKeywords.add("string-cistring-ci>?", Token.KEYWORD3);
            schemeKeywords.add("string-ci<=?", Token.KEYWORD3);
            schemeKeywords.add("string-ci>=?", Token.KEYWORD3);
            schemeKeywords.add("symbol?", Token.KEYWORD3);
            schemeKeywords.add("vector?", Token.KEYWORD3);
            schemeKeywords.add("zero?", Token.KEYWORD3);

            // LITERAL2 
            schemeKeywords.add("#f", Token.LITERAL2);
            schemeKeywords.add("#t", Token.LITERAL2);
            schemeKeywords.add("#F", Token.LITERAL2);
            schemeKeywords.add("#T", Token.LITERAL2);
            schemeKeywords.add("true", Token.LITERAL2);
            schemeKeywords.add("false", Token.LITERAL2);
        }
        return schemeKeywords;
    }
}
