/*
 * JessTokenMarker.java - Jess token marker
 * Copyright (C) 1998, 1999 Slava Pestov
 *
 * You may use and modify this package for any purpose. Redistribution is
 * permitted, in both source and binary form, provided that this notice
 * remains intact in all source distributions of this package.
 */
package jedit.lang;


import javax.swing.text.Segment;

import jedit.Token;
import jedit.KeywordMap;
import jedit.TokenMarker;


/**
 * Jess token marker.
 *
 * @author Kendy JEAN-MARIE
 * 2004 - Univ. Montpellier II - France
 */
public class JessTokenMarker extends SchemeTokenMarker {
    // private members
    private static KeywordMap jessKeywords;

    /*
    private KeywordMap keywords;
     private int lastOffset;
     private int lastKeyword;
   */
   
    public JessTokenMarker() {
       // this.keywords = getKeywordMap();
         super(false, getKeywordMap()); // false because it's not Scheme
     
    }

    public static KeywordMap getKeywordMap() {
        if (jessKeywords == null) {
            jessKeywords = new KeywordMap(false); // FALSE BECAUSE SCHEME IS CASE-SENSITIVE
            addMiscellaneousfunctions();
            addFunctionsrelatedtofilesandotherIO();
            addFunctionsforinteractingwithJavacode();
            addLogicalfunctions();
            addFunctionsusedprimarilyfordebugging();
            addFunctionsforworkingwithdefqueries();
            addControlstructures();
            addFunctionsforprettyprintingconstructs();
            addFunctionsforinteractingwiththeruleengine();
            addMathematicalfunctions();
            addFunctionswhichquerythetypeofaValue();
            addStringmanipulationfunctions();
            addFunctionsforworkingwithmultifields();
            addFunctionsforworkingwithfacts();
        }
        return jessKeywords;
    }	
    
    /*
     public static KeywordMap getKeywords() {
     if (jessKeywords == null) {
     jessKeywords = new KeywordMap(false); // FALSE BECAUSE SCHEME IS CASE-SENSITIVE

     // KEYWORD 1
     jessKeywords.add("and", Token.KEYWORD1);


     // KEYWORD 2 
     jessKeywords.add("abs", Token.KEYWORD2);
     

     // KEYWORd 3
     jessKeywords.add("boolean?", Token.KEYWORD3);
     
     // LITERAL2 
     jessKeywords.add("#f", Token.LITERAL2);
     
     }
     return jessKeywords;
     }
     */
    
    
    private static void addFunctionsforinteractingwithJavacode() {// KEYWORDS 1
    jessKeywords.add("call", Token.KEYWORD1);  
    jessKeywords.add("context", Token.KEYWORD1); 
    jessKeywords.add("defclass", Token.KEYWORD1);  
    jessKeywords.add("definstance", Token.KEYWORD1);  
    jessKeywords.add("get", Token.KEYWORD1);   
    jessKeywords.add("get-member", Token.KEYWORD1);   
    jessKeywords.add("import", Token.KEYWORD1); 
    jessKeywords.add("instanceof", Token.KEYWORD1); 
    jessKeywords.add("load-function", Token.KEYWORD1);  
    jessKeywords.add("load-package", Token.KEYWORD1); 
    jessKeywords.add("new", Token.KEYWORD1);  
    jessKeywords.add("set", Token.KEYWORD1);  
    jessKeywords.add("set-member", Token.KEYWORD1);   
    jessKeywords.add("throw", Token.KEYWORD1); 
    jessKeywords.add("try", Token.KEYWORD1);  
    jessKeywords.add("undefinstance", Token.KEYWORD1); 
    }

    private static void addControlstructures() {// KEYWORDS 1
    jessKeywords.add("apply", Token.KEYWORD1); 
    jessKeywords.add("call-on-engine", Token.KEYWORD1);  
    jessKeywords.add("foreach", Token.KEYWORD1);  
    jessKeywords.add("if", Token.KEYWORD1);  
        jessKeywords.add("then", Token.KEYWORD1);  
	    jessKeywords.add("else", Token.KEYWORD1);  
    jessKeywords.add("progn", Token.KEYWORD1);  
    jessKeywords.add("return", Token.KEYWORD1);  
    jessKeywords.add("while", Token.KEYWORD1); 
        jessKeywords.add("do", Token.KEYWORD1); 
    }

    private static void addFunctionswhichquerythetypeofaValue() {// KEYWORDS 1
    jessKeywords.add("evenp", Token.KEYWORD1); 
    jessKeywords.add("external-addressp", Token.KEYWORD1);  
    jessKeywords.add("floatp", Token.KEYWORD1);  
    jessKeywords.add("integerp", Token.KEYWORD1);  
    jessKeywords.add("lexemep", Token.KEYWORD1);  
    jessKeywords.add("longp", Token.KEYWORD1);   
    jessKeywords.add("multifieldp", Token.KEYWORD1);  
    jessKeywords.add("numberp", Token.KEYWORD1); 
    jessKeywords.add("oddp", Token.KEYWORD1); 
    jessKeywords.add("stringp", Token.KEYWORD1);   
    jessKeywords.add("subsetp", Token.KEYWORD1);  
    jessKeywords.add("symbolp", Token.KEYWORD1);  
    }
	    
	    
	    
    private static void addMiscellaneousfunctions() {// KEYWORDS 2
    jessKeywords.add("bag", Token.KEYWORD2); 
    jessKeywords.add("bind", Token.KEYWORD2); 
    jessKeywords.add("clear-storage", Token.KEYWORD2); 
    jessKeywords.add("fetch", Token.KEYWORD2);  
    jessKeywords.add("gensym*", Token.KEYWORD2); 
    jessKeywords.add("jess-version-number", Token.KEYWORD2); 
    jessKeywords.add("jess-version-string", Token.KEYWORD2);
    jessKeywords.add("set-factory", Token.KEYWORD2); 
    jessKeywords.add("setgen", Token.KEYWORD2); 
    jessKeywords.add("store", Token.KEYWORD2);  
    jessKeywords.add("system", Token.KEYWORD2); 
    jessKeywords.add("time", Token.KEYWORD2);
    }
	   
    private static void addFunctionsusedprimarilyfordebugging() {// KEYWORDS 2
    jessKeywords.add("list-function$", Token.KEYWORD2);
    jessKeywords.add("matches", Token.KEYWORD2);
    jessKeywords.add("show-jess-listeners", Token.KEYWORD2);
    jessKeywords.add("unwatch", Token.KEYWORD2);
    jessKeywords.add("view", Token.KEYWORD2);
    jessKeywords.add("watch", Token.KEYWORD2); 
    }
	    
    private static void addFunctionsforinteractingwiththeruleengine() {// KEYWORDS 2
    jessKeywords.add("agenda", Token.KEYWORD2);
    jessKeywords.add("batch", Token.KEYWORD2);
    jessKeywords.add("bload", Token.KEYWORD2);
    jessKeywords.add("bsave", Token.KEYWORD2);
    jessKeywords.add("build", Token.KEYWORD2);
    jessKeywords.add("clear", Token.KEYWORD2);
    jessKeywords.add("defadvice", Token.KEYWORD2);
    jessKeywords.add("do-backward-chaining", Token.KEYWORD2);
    jessKeywords.add("engine", Token.KEYWORD2);
    jessKeywords.add("eval", Token.KEYWORD2);
    jessKeywords.add("exit", Token.KEYWORD2);
    jessKeywords.add("focus", Token.KEYWORD2);
    jessKeywords.add("get-reset-globals", Token.KEYWORD2);
    jessKeywords.add("get-salience-evaluation", Token.KEYWORD2);
    jessKeywords.add("halt", Token.KEYWORD2);
    jessKeywords.add("reset", Token.KEYWORD2);
    jessKeywords.add("run", Token.KEYWORD2);
    jessKeywords.add("run-until-halt", Token.KEYWORD2);
    jessKeywords.add("set-node-index-hash", Token.KEYWORD2);
    jessKeywords.add("set-reset-globals", Token.KEYWORD2);
    jessKeywords.add("set-salience-evaluation", Token.KEYWORD2);
    jessKeywords.add("set-strategy", Token.KEYWORD2);
    jessKeywords.add("undefadvice", Token.KEYWORD2);
    jessKeywords.add("undefrule", Token.KEYWORD2);
    jessKeywords.add("get-focus", Token.KEYWORD2);
    jessKeywords.add("set-current-module", Token.KEYWORD2);
    jessKeywords.add("get-current-module", Token.KEYWORD2);
    jessKeywords.add("list-focus-stack", Token.KEYWORD2);
    jessKeywords.add("get-focus-stack", Token.KEYWORD2);
    jessKeywords.add("clear-focus-stack", Token.KEYWORD2);
    jessKeywords.add("pop-focus", Token.KEYWORD2); 
    }
	    
	    
	    
	  
    private static void addFunctionsrelatedtofilesandotherIO() {// KEYWORDS 3
    jessKeywords.add("close", Token.KEYWORD3); 
    jessKeywords.add("format", Token.KEYWORD3);  
    jessKeywords.add("get-multithreaded-io", Token.KEYWORD3);  
    jessKeywords.add("open", Token.KEYWORD3);   
    jessKeywords.add("printout", Token.KEYWORD3);   
    jessKeywords.add("read", Token.KEYWORD3);  
    jessKeywords.add("readline", Token.KEYWORD3);  
    jessKeywords.add("set-multithreaded-io", Token.KEYWORD3);   
    jessKeywords.add("socket", Token.KEYWORD3);
    }

    private static void addFunctionsforworkingwithdefqueries() {// KEYWORDS 3
    jessKeywords.add("count-query-results", Token.KEYWORD3); 
    jessKeywords.add("run-query", Token.KEYWORD3);
    }
	    
    private static void addFunctionsforprettyprintingconstructs() {// KEYWORDS 3
    jessKeywords.add("ppdeffunction", Token.KEYWORD3);  
    jessKeywords.add("ppdefglobal", Token.KEYWORD3);   
    jessKeywords.add("ppdefquery", Token.KEYWORD3); 
    jessKeywords.add("ppdefrule", Token.KEYWORD3);  
    jessKeywords.add("ppdeffacts", Token.KEYWORD3); 
    jessKeywords.add("ppdeftemplate", Token.KEYWORD3);  
    
    
        jessKeywords.add("deffunction", Token.KEYWORD3);  
    jessKeywords.add("defglobal", Token.KEYWORD3);   
    jessKeywords.add("defquery", Token.KEYWORD3); 
    jessKeywords.add("defrule", Token.KEYWORD3);  
    jessKeywords.add("deffacts", Token.KEYWORD3); 
    jessKeywords.add("deftemplate", Token.KEYWORD3);  
    
    
    jessKeywords.add("rules", Token.KEYWORD3);    
    jessKeywords.add("show-deffacts", Token.KEYWORD3);   
    jessKeywords.add("show-deftemplates", Token.KEYWORD3);  
    jessKeywords.add("list-deftemplates", Token.KEYWORD3);
    }
	    
    private static void addFunctionsforworkingwithmultifields() {// KEYWORDS 3
    jessKeywords.add("complement$", Token.KEYWORD3);  
    jessKeywords.add("create$", Token.KEYWORD3); 
    jessKeywords.add("delete$", Token.KEYWORD3);  
    jessKeywords.add("explode$", Token.KEYWORD3);   
    jessKeywords.add("first$", Token.KEYWORD3);  
    jessKeywords.add("implode$", Token.KEYWORD3);   
    jessKeywords.add("insert$", Token.KEYWORD3);  
    jessKeywords.add("intersection$", Token.KEYWORD3);  
    jessKeywords.add("length$", Token.KEYWORD3);  
    jessKeywords.add("member$", Token.KEYWORD3);    
    jessKeywords.add("nth$", Token.KEYWORD3);  
    jessKeywords.add("replace$", Token.KEYWORD3);  
    jessKeywords.add("rest$", Token.KEYWORD3);  
    jessKeywords.add("subseq$", Token.KEYWORD3); 
    jessKeywords.add("union$", Token.KEYWORD3);
    }

    private static void addFunctionsforworkingwithfacts() {// KEYWORDS 3
    jessKeywords.add("assert", Token.KEYWORD3);  
    jessKeywords.add("assert-string", Token.KEYWORD3); 
    jessKeywords.add("fact-id", Token.KEYWORD3);  
    jessKeywords.add("fact-slot-value", Token.KEYWORD3); 
    jessKeywords.add("facts", Token.KEYWORD3); 
    jessKeywords.add("load-facts", Token.KEYWORD3);
    jessKeywords.add("modify", Token.KEYWORD3);  
    jessKeywords.add("duplicate", Token.KEYWORD3);  
    jessKeywords.add("retract", Token.KEYWORD3); 
    jessKeywords.add("retract-string", Token.KEYWORD3);
    jessKeywords.add("save-facts", Token.KEYWORD3); 
    }
	    
	    
	    
	    
	    
    private static void addLogicalfunctions() {// LITERAL2
    jessKeywords.add("and", Token.LITERAL2); 
    jessKeywords.add("bit-and", Token.LITERAL2); 
    jessKeywords.add("bit-not", Token.LITERAL2);  
    jessKeywords.add("bit-or", Token.LITERAL2);  
    jessKeywords.add("not", Token.LITERAL2);   
    jessKeywords.add("or", Token.LITERAL2);
    
        jessKeywords.add("t", Token.LITERAL2);
        jessKeywords.add("f", Token.LITERAL2);
        jessKeywords.add("true", Token.LITERAL2);
        jessKeywords.add("false", Token.LITERAL2);
     jessKeywords.add("crlf", Token.LITERAL2);
    }

    private static void addMathematicalfunctions() {// LITERAL2
    jessKeywords.add("**", Token.LITERAL2); 
    jessKeywords.add("+", Token.LITERAL2);
     jessKeywords.add("-", Token.LITERAL2);  
     jessKeywords.add("/", Token.LITERAL2);  
     jessKeywords.add("<", Token.LITERAL2);  
     jessKeywords.add("<=", Token.LITERAL2); 
     jessKeywords.add("<>", Token.LITERAL2);  
     jessKeywords.add("=", Token.LITERAL2);   
     jessKeywords.add(">", Token.LITERAL2); 
     jessKeywords.add(">=", Token.LITERAL2);  
     jessKeywords.add("abs", Token.LITERAL2);  
     jessKeywords.add("div", Token.LITERAL2);  
     jessKeywords.add("e", Token.LITERAL2);  
     jessKeywords.add("eq", Token.LITERAL2);  
     jessKeywords.add("eq*", Token.LITERAL2); 
     jessKeywords.add("exp", Token.LITERAL2);   
     jessKeywords.add("float", Token.LITERAL2);  
     jessKeywords.add("integer", Token.LITERAL2);
     jessKeywords.add("log", Token.LITERAL2);  
     jessKeywords.add("log10", Token.LITERAL2);  
     jessKeywords.add("long", Token.LITERAL2);  
     jessKeywords.add("max", Token.LITERAL2);   
     jessKeywords.add("min", Token.LITERAL2);  
     jessKeywords.add("mod", Token.LITERAL2); 
     jessKeywords.add("neq", Token.LITERAL2);  
     jessKeywords.add("pi", Token.LITERAL2); 
     jessKeywords.add("random", Token.LITERAL2); 
    jessKeywords.add("round", Token.LITERAL2); 
    jessKeywords.add("sqrt", Token.LITERAL2);  
    jessKeywords.add("*", Token.LITERAL2); 
    }

    private static void addStringmanipulationfunctions() {// LITERAL2
    jessKeywords.add("lowcase", Token.LITERAL2); 
    jessKeywords.add("str-cat", Token.LITERAL2); 
    jessKeywords.add("str-compare", Token.LITERAL2); 
    jessKeywords.add("str-index", Token.LITERAL2);  
    jessKeywords.add("str-length", Token.LITERAL2);  
    jessKeywords.add("sub-string", Token.LITERAL2);   
    jessKeywords.add("sym-cat", Token.LITERAL2);  
    jessKeywords.add("upcase", Token.LITERAL2); 
    }

}
