/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat.share;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import madkit.MadChat.share.AbstractServerAgent;
import madkit.MadChat.share.EndDownloadMessage;
import madkit.MadChat.share.FicDataBase;
import madkit.MadChat.share.OffsetMessage;
import madkit.MadChat.share.ReturnMessage;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;

public class SmallSenderAgent
extends Agent {
    AbstractServerAgent senderAgent;
    AgentAddress clientAddress;
    String virtualPath;
    int offsetStart;
    int offsetEnd;
    FicDataBase dataBase;
    boolean live = true;

    public SmallSenderAgent() {
    }

    public SmallSenderAgent(AgentAddress agentAddress, String string, int n, int n2, FicDataBase ficDataBase, AbstractServerAgent abstractServerAgent) {
        this.clientAddress = agentAddress;
        this.virtualPath = string;
        this.offsetStart = n;
        this.offsetEnd = n2;
        this.dataBase = ficDataBase;
        this.senderAgent = abstractServerAgent;
    }

    public void activate() {
        String string = this.senderAgent.getGroupName();
        this.createGroup(true, string, null, null);
        this.requestRole(string, "SmallSender", null);
        this.sendReturnMessage();
    }

    public void live() {
        while (this.live) {
            this.exitImmediatlyOnKill();
            Message message = this.waitNextMessage();
            try {
                this.handleMessage(message);
            }
            catch (IOException iOException) {
                System.out.println("Error : AbstractServerAgent --> HandleMessage");
            }
        }
    }

    public void end() {
    }

    void handleMessage(Message message) throws IOException {
        if (message instanceof OffsetMessage) {
            this.virtualPath = ((OffsetMessage)message).getName();
            this.offsetStart = ((OffsetMessage)message).getOffsetStart();
            this.offsetEnd = ((OffsetMessage)message).getOffsetEnd();
            this.sendReturnMessage();
        }
        if (message instanceof EndDownloadMessage) {
            this.senderAgent.removeSmallSenderAgent(this);
            this.live = false;
        }
    }

    public void sendReturnMessage() {
        String string = this.dataBase.searchRealPath(this.virtualPath);
        if (string.equals("error")) {
            System.out.println("(SmallSenderAgent) Fichier non autorise :" + this.virtualPath);
            return;
        }
        try {
            File file = new File(string);
            long l = file.lastModified();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            randomAccessFile.seek(this.offsetStart);
            byte[] byArray = new byte[this.offsetEnd - this.offsetStart];
            randomAccessFile.read(byArray, 0, this.offsetEnd - this.offsetStart);
            randomAccessFile.close();
            this.sendMessage(this.clientAddress, new ReturnMessage(byArray, this.virtualPath, this.offsetStart, this.offsetEnd, l));
        }
        catch (IOException iOException) {
            System.out.println("Error : SmallSenderAgent --> can't access file \"" + string + "\".");
        }
    }
}

