/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat.share;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import madkit.MadChat.share.ListFile;
import madkit.MadChat.share.vList;

public class ExplorerPanel
extends JPanel
implements ActionListener,
KeyListener {
    Panel p1;
    Panel p2;
    private String location = null;
    static MenuBar menubar;
    private TextArea textArea;
    private boolean ModeVisual;
    private TextField selection;
    private vList l;
    private String pathname;
    private String filename;
    public int ind;

    public ExplorerPanel(String string) {
        JLabel jLabel = new JLabel("PATH:");
        this.selection = new TextField(string);
        this.selection.addKeyListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)this.selection, "Center");
        this.p1 = new Panel(new BorderLayout());
        this.p1.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.p1);
        jScrollPane.setPreferredSize(new Dimension(450, 320));
        jScrollPane.createHorizontalScrollBar();
        jScrollPane.createVerticalScrollBar();
        jScrollPane.setViewportView(this.p1);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.setBackground(Color.white);
        menubar = new MenuBar();
        Menu menu = new Menu("Options", false);
        menubar.add(menu);
        MenuItem menuItem = new MenuItem("List   ");
        menu.add(menuItem);
        menuItem.addActionListener(this);
        MenuItem menuItem2 = new MenuItem("Icon   ");
        menu.add(menuItem2);
        menuItem2.addActionListener(this);
        this.l = new ListFile();
        this.p1.add((Component)((ListFile)this.l), "Center");
        this.path();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() instanceof TextField) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 10: {
                    this.validTextField();
                    break;
                }
                default: {
                    this.ind = -1;
                }
            }
        }
    }

    public void path() {
        this.location = this.selection.getText();
        File file = new File(this.location);
        this.pathname = file.getAbsolutePath();
        if (this.pathname.endsWith(".")) {
            this.pathname = this.pathname.substring(0, this.pathname.length() - 2);
        }
        this.read();
    }

    public boolean read() {
        File file = new File(this.pathname);
        if (file.isDirectory() || this.pathname.length() < 3) {
            this.selection.setText(this.pathname);
            this.l.clear();
            if (this.pathname.length() > 3) {
                this.l.addItem("..", "..");
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                file = new File(this.pathname + File.separator + stringArray[i]);
                this.l.addItem(stringArray[i] + (file.isDirectory() ? File.separator : ""), this.pathname);
            }
            return true;
        }
        return false;
    }

    public String getFileName() {
        return this.selection.getText() + "/" + this.filename;
    }

    private void readUp() {
        this.pathname = this.getParent(this.pathname);
        this.read();
    }

    private String getParent(String string) {
        return string.substring(0, string.lastIndexOf(File.separatorChar));
    }

    private void validTextField() {
        String string = this.pathname;
        this.pathname = this.selection.getText();
        if (this.pathname.charAt(this.pathname.length() - 1) == File.separatorChar) {
            this.pathname = this.getParent(this.pathname);
        }
        if (!this.read()) {
            this.pathname = string;
            this.selection.setText(this.pathname);
        }
    }

    public boolean action(Event event, Object object) {
        if (((String)object).equals("..")) {
            this.readUp();
        } else {
            String string = (String)object;
            if (string.charAt(string.length() - 1) == File.separatorChar) {
                String string2 = this.pathname;
                this.pathname = this.pathname + File.separator + this.getParent(string);
                if (!this.read()) {
                    this.pathname = string2;
                    this.selection.setText(this.pathname);
                }
            }
        }
        return super.action(event, object);
    }
}

