/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import madkit.MadChat.ClockThread;
import madkit.MadChat.Config;
import madkit.MadChat.ConfigChangeListener;
import madkit.MadChat.SmileyTab;

public class WriteToolbar
extends JToolBar
implements ActionListener,
ConfigChangeListener {
    Config configuration;
    JTextField tWriteArea;
    JButton bColor;
    JButton bBold;
    JButton bItalic;
    JComboBox bPolice;
    JComboBox bSmiley;
    JComboBox bTailleFont;
    JCheckBox bSaveLog;
    JLabel bHorloge;
    JColorChooser colorChooser;
    Color currentColor;
    String currentFont;
    String tailleFont;
    String path;
    String separator;

    public WriteToolbar(JTextField jTextField, Config config) {
        this.configuration = config;
        this.separator = this.configuration.getFileSeparator();
        this.currentFont = "Default";
        this.tailleFont = "4";
        this.tWriteArea = jTextField;
        this.currentColor = Color.decode(this.configuration.getDefaultColor());
        this.configuration.addConfigChangeListener(this);
        this.colorChooser = new JColorChooser();
        System.out.println("C le path des Smiley :" + this.path);
        this.bHorloge = new JLabel();
        this.bHorloge.setOpaque(false);
        this.bColor = new JButton();
        this.bColor.addActionListener(this);
        this.bColor.setPreferredSize(new Dimension(18, 18));
        this.bColor.setMaximumSize(new Dimension(18, 18));
        this.bColor.setBackground(this.currentColor);
        this.bColor.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_COLOR_TOOLTIP"));
        this.bBold = new JButton("B");
        this.bBold.addActionListener(this);
        this.bBold.setPreferredSize(new Dimension(20, 20));
        this.bBold.setMaximumSize(new Dimension(20, 20));
        this.bBold.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_BOLD_TOOLTIP"));
        this.bItalic = new JButton("I");
        this.bItalic.addActionListener(this);
        this.bItalic.setPreferredSize(new Dimension(20, 20));
        this.bItalic.setMaximumSize(new Dimension(20, 20));
        this.bItalic.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_ITALIC_TOOLTIP"));
        this.bSmiley = new JComboBox();
        SmileyTab smileyTab = this.configuration.getSmileyTab();
        String[] stringArray = smileyTab.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            this.bSmiley.addItem(new ImageIcon(smileyTab.getPathBySmiley(stringArray[i])));
            System.out.println("Ajout smiley : [" + stringArray[i] + "]=" + smileyTab.getPathBySmiley(stringArray[i]));
        }
        this.bSmiley.addActionListener(this);
        this.bSmiley.setPreferredSize(new Dimension(40, 20));
        this.bSmiley.setMaximumSize(new Dimension(40, 20));
        this.bSmiley.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_SMILEY_TOOLTIP"));
        this.bPolice = new JComboBox();
        this.bPolice.addItem("Default");
        this.bPolice.addItem("Arial Black");
        this.bPolice.addItem("impact");
        this.bPolice.setPreferredSize(new Dimension(100, 20));
        this.bPolice.setMaximumSize(new Dimension(100, 20));
        this.bPolice.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_FONT_TOOLTIP"));
        this.bTailleFont = new JComboBox();
        this.bTailleFont.addItem("2");
        this.bTailleFont.addItem("3");
        this.bTailleFont.addItem("4");
        this.bTailleFont.addItem("5");
        this.bTailleFont.addItem("6");
        this.bTailleFont.addItem("7");
        this.bTailleFont.addItem("8");
        this.bTailleFont.setSelectedIndex(2);
        this.bTailleFont.setPreferredSize(new Dimension(40, 20));
        this.bTailleFont.setMaximumSize(new Dimension(40, 20));
        this.bTailleFont.addActionListener(this);
        this.bTailleFont.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_FONTSIZE_TOOLTIP"));
        this.bSaveLog = new JCheckBox(this.configuration.getLangProperty("WRITE_TOOLBAR_LOGCHAN"));
        this.bSaveLog.setBorderPaintedFlat(true);
        this.bSaveLog.addActionListener(this);
        this.bSaveLog.setPreferredSize(new Dimension(170, 20));
        this.bSaveLog.setOpaque(false);
        this.bSaveLog.setSelected(this.configuration.isLogAuto());
        this.bSmiley.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_LOGCHAN_TOOLTIP"));
        this.addSeparator();
        this.add(this.bColor);
        this.addSeparator();
        this.add(this.bBold);
        this.addSeparator();
        this.add(this.bItalic);
        this.addSeparator();
        this.add(this.bPolice);
        this.addSeparator();
        this.add(this.bTailleFont);
        this.addSeparator();
        this.add(this.bSmiley);
        this.addSeparator();
        this.add(this.bHorloge);
        this.addSeparator(new Dimension(60, 18));
        this.add(this.bSaveLog);
        ClockThread clockThread = new ClockThread(this.bHorloge);
        clockThread.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = "";
        int n = 0;
        String string2 = this.tWriteArea.getText();
        if (actionEvent.getSource() == this.bBold) {
            string = string2.substring(0, this.tWriteArea.getSelectionStart());
            String string3 = string2.substring(this.tWriteArea.getSelectionEnd());
            string2 = this.tWriteArea.getSelectedText() == null ? string + "[g][/g]" + string3 : string + "[g]" + this.tWriteArea.getSelectedText() + "[/g]" + string3;
            n = string.length() + 3;
            this.tWriteArea.setText(string2);
        } else if (actionEvent.getSource() == this.bItalic) {
            string = string2.substring(0, this.tWriteArea.getSelectionStart());
            String string4 = string2.substring(this.tWriteArea.getSelectionEnd());
            string2 = this.tWriteArea.getSelectedText() == null ? string + "[i][/i]" + string4 : string + "[i]" + this.tWriteArea.getSelectedText() + "[/i]" + string4;
            this.tWriteArea.setText(string2);
            n = string.length() + 3;
        } else if (actionEvent.getSource() == this.bSmiley) {
            if (this.bSmiley.getItemCount() > 0) {
                string = string2.substring(0, this.tWriteArea.getSelectionStart());
                String string5 = string2.substring(this.tWriteArea.getSelectionEnd());
                String string6 = ((ImageIcon)this.bSmiley.getSelectedItem()).toString();
                SmileyTab smileyTab = this.configuration.getSmileyTab();
                String string7 = smileyTab.getSmileyByPath(string6);
                string2 = string + string7 + string5;
                System.out.println("buf=====>" + string2);
                this.tWriteArea.setText(string2);
                n = string.length() + string7.length();
            }
        } else if (actionEvent.getSource() == this.bColor) {
            JDialog jDialog = JColorChooser.createDialog(this, "Pick a Color", true, this.colorChooser, this, null);
            this.colorChooser.setColor(this.currentColor);
            jDialog.setVisible(true);
            n = string2.length();
        } else if (actionEvent.getActionCommand().equals("OK")) {
            this.bColor.setBackground(this.colorChooser.getColor());
            this.currentColor = this.colorChooser.getColor();
            System.out.println(Integer.toHexString(this.currentColor.getRGB()));
            n = string2.length();
        } else if (actionEvent.getSource() == this.bTailleFont) {
            this.tailleFont = (String)this.bTailleFont.getSelectedItem();
            n = string2.length();
        } else if (actionEvent.getSource() == this.bPolice) {
            this.currentFont = (String)this.bTailleFont.getSelectedItem();
            n = string2.length();
        }
        this.tWriteArea.grabFocus();
        this.tWriteArea.setCaretPosition(n);
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public String getPolice() {
        return this.currentFont;
    }

    public String getTaillePolice() {
        return this.tailleFont;
    }

    public boolean isSaveLog() {
        return this.bSaveLog.isSelected();
    }

    public void configChanged(String string) {
        System.out.println("config changed " + string);
        if (string.equals("theme")) {
            this.bSmiley.removeAllItems();
            SmileyTab smileyTab = this.configuration.getSmileyTab();
            String[] stringArray = smileyTab.getKeys();
            for (int i = 0; i < stringArray.length; ++i) {
                this.bSmiley.addItem(new ImageIcon(smileyTab.getPathBySmiley(stringArray[i])));
                System.out.println("Ajout smiley : [" + stringArray[i] + "]=" + smileyTab.getPathBySmiley(stringArray[i]));
            }
        } else if (string.equals("lang")) {
            System.out.println("LOG_CHAN=" + this.configuration.getLangProperty("LOG_CHAN"));
            this.bColor.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_COLOR_TOOLTIP"));
            this.bBold.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_BOLD_TOOLTIP"));
            this.bItalic.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_ITALIC_TOOLTIP"));
            this.bPolice.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_FONT_TOOLTIP"));
            this.bSmiley.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_SMILEY_TOOLTIP"));
            this.bTailleFont.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_FONTSIZE_TOOLTIP"));
            this.bSaveLog.setText(this.configuration.getLangProperty("WRITE_TOOLBAR_LOGCHAN"));
            this.bSaveLog.setToolTipText(this.configuration.getLangProperty("WRITE_TOOLBAR_LOGCHAN_TOOLTIP"));
        }
    }
}

