/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import madkit.MadChat.ChatPanel;
import madkit.MadChat.Chatter;
import madkit.MadChat.ChatterList;
import madkit.MadChat.Config;
import madkit.MadChat.ConfigChan;
import madkit.MadChat.ConfigChangeListener;
import madkit.MadChat.JDialogChanList;
import madkit.MadChat.MadChat;
import madkit.MadChat.MadChatHello;
import madkit.MadChat.PanneauConfig;
import madkit.MadChat.PanneauJoin;
import madkit.MadChat.PanneauPM;
import madkit.MadChat.PanneauTopic;
import madkit.MadChat.share.SenderAgent;
import madkit.kernel.AbstractAgent;

public class MainToolbar
extends JToolBar
implements ActionListener,
ConfigChangeListener {
    private JButton bKick;
    private JButton bIgnore;
    private JButton bPM;
    private JButton bTopic;
    private JButton bList;
    private JButton bJoin;
    private JButton bConfig;
    private JButton bShare;
    private JButton bAffichShare;
    private MadChat chat;
    private ConfigChan cfgChan;
    protected String path;
    Config config;

    public MainToolbar(MadChat madChat, Config config) {
        this.config = config;
        this.chat = madChat;
        System.out.println("=======>" + this.config.getIconsPath());
        if (this.config.isShare()) {
            this.bShare = new JButton(new ImageIcon(this.config.getIconsPath() + "server_on.gif"));
            this.bShare.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_SHARE_STOP_TOOLTIP"));
            this.bShare.setActionCommand("1");
        } else {
            this.bShare = new JButton(new ImageIcon(this.config.getIconsPath() + "server_off.gif"));
            this.bShare.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_SHARE_START_TOOLTIP"));
            this.bShare.setActionCommand("0");
        }
        this.bShare.setBorderPainted(false);
        this.bShare.addActionListener(this);
        this.bAffichShare = new JButton(new ImageIcon(this.config.getIconsPath() + "server.gif"));
        this.bAffichShare.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_SHARE_CONFIG_TOOLTIP"));
        this.bAffichShare.setBorderPainted(false);
        this.bAffichShare.addActionListener(this);
        this.bKick = new JButton(new ImageIcon(this.config.getIconsPath() + "kick.gif"));
        this.bKick.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_KICK_TOOLTIP"));
        this.bKick.setBorderPainted(false);
        this.bIgnore = new JButton(new ImageIcon(this.config.getIconsPath() + "ban.gif"));
        this.bIgnore.setBorderPainted(false);
        this.bIgnore.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_IGNORE_TOOLTIP"));
        this.bIgnore.addActionListener(this);
        this.bJoin = new JButton(new ImageIcon(this.config.getIconsPath() + "join.gif"));
        this.bJoin.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_JOIN_TOOLTIP"));
        this.bJoin.setBorderPainted(false);
        this.bJoin.addActionListener(this);
        this.bList = new JButton(new ImageIcon(this.config.getIconsPath() + "liste.gif"));
        this.bList.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_CHANLIST_TOOLTIP"));
        this.bList.setBorderPainted(false);
        this.bList.addActionListener(this);
        this.bPM = new JButton(new ImageIcon(this.config.getIconsPath() + "pm.gif"));
        this.bPM.setBorderPainted(false);
        this.bPM.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_PM_TOOLTIP"));
        this.bPM.addActionListener(this);
        this.bTopic = new JButton(new ImageIcon(this.config.getIconsPath() + "topic.gif"));
        this.bTopic.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_TOPIC_TOOLTIP"));
        this.bTopic.setBorderPainted(false);
        this.bTopic.addActionListener(this);
        this.bConfig = new JButton(new ImageIcon(this.config.getIconsPath() + "config.gif"));
        this.bConfig.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_CONFIG_TOOLTIP"));
        this.bConfig.setBorderPainted(false);
        this.bConfig.addActionListener(this);
        this.add(this.bJoin);
        this.add(this.bList);
        this.add(this.bTopic);
        this.addSeparator(new Dimension(20, 50));
        this.add(this.bIgnore);
        this.add(this.bKick);
        this.addSeparator(new Dimension(20, 50));
        this.add(this.bPM);
        this.addSeparator(new Dimension(20, 50));
        this.add(this.bShare);
        this.add(this.bAffichShare);
        this.add(this.bConfig);
        this.config.addConfigChangeListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bJoin) {
            PanneauJoin panneauJoin = new PanneauJoin(this.config);
            panneauJoin.pack();
            panneauJoin.setTitle(this.config.getLangProperty("PANEL_JOIN_TITLE"));
            panneauJoin.setVisible(true);
        } else if (actionEvent.getSource() == this.bShare) {
            if (actionEvent.getActionCommand().equals("1")) {
                this.bShare.setActionCommand("0");
                System.out.println("===========================> coucou on arete le share");
                this.config.getChatAgent().killAgent((AbstractAgent)this.config.getSenderAgent());
                this.config.setSenderAgent(new SenderAgent());
                this.config.setShareRunning(false);
                this.bShare.setIcon(new ImageIcon(this.config.getIconsPath() + "server_off.gif"));
                this.bShare.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_SHARE_START_TOOLTIP"));
            } else {
                this.bShare.setActionCommand("1");
                System.out.println("===========================> coucou on lance le share");
                this.config.setShareRunning(true);
                this.bShare.setIcon(new ImageIcon(this.config.getIconsPath() + "server_on.gif"));
                this.bShare.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_SHARE_STOP_TOOLTIP"));
                this.config.getChatAgent().launchAgent((AbstractAgent)this.config.getSenderAgent(), "serveur", false);
            }
        } else if (actionEvent.getSource() == this.bAffichShare) {
            JFrame jFrame = new JFrame();
            jFrame.getContentPane().add(this.config.getSenderAgent().getDisplay());
            jFrame.pack();
            jFrame.setVisible(true);
            System.out.println("maintool");
        } else if (actionEvent.getSource() == this.bConfig) {
            PanneauConfig panneauConfig = new PanneauConfig(this.config);
            panneauConfig.setSize(450, 200);
            panneauConfig.setTitle(this.config.getLangProperty("PANEL_CONF_TITLE"));
            panneauConfig.setVisible(true);
        } else if (actionEvent.getSource() == this.bList) {
            JDialogChanList jDialogChanList = new JDialogChanList(this.chat, this.config);
            jDialogChanList.setSize(500, 250);
            jDialogChanList.setTitle(this.config.getLangProperty("PANEL_CHANLIST_TITLE"));
            jDialogChanList.setVisible(true);
        } else if (actionEvent.getSource() == this.bTopic) {
            MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
            ChatPanel chatPanel = madChatHello.getDisplay().getCurrentChan();
            if (chatPanel instanceof ChatPanel) {
                this.cfgChan = this.chat.getCurrentConfigChan();
                Chatter chatter = this.chat.getCurrentChan().getMe();
                PanneauTopic panneauTopic = new PanneauTopic(this.config, this.cfgChan, chatter.isOp());
                panneauTopic.pack();
                panneauTopic.setTitle(this.config.getLangProperty("PANEL_TOPIC_TITLE") + this.cfgChan.getNomChannel());
                panneauTopic.setVisible(true);
            }
        } else if (actionEvent.getSource() == this.bIgnore) {
            MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
            ChatPanel chatPanel = madChatHello.getDisplay().getCurrentChan();
            if (chatPanel instanceof ChatPanel) {
                chatPanel.gestionIgnored();
            }
        } else if (actionEvent.getSource() == this.bPM) {
            MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
            ChatterList chatterList = madChatHello.getDisplay().getChatListInChan("default");
            PanneauPM panneauPM = new PanneauPM(this.config, chatterList);
            panneauPM.setTitle(this.config.getLangProperty("PANEL_PM_TITLE"));
            panneauPM.setVisible(true);
        }
    }

    public void configChanged(String string) {
        if (string.equals("theme")) {
            this.bKick.setIcon(new ImageIcon(this.config.getIconsPath() + "kick.gif"));
            this.bIgnore.setIcon(new ImageIcon(this.config.getIconsPath() + "ban.gif"));
            this.bList.setIcon(new ImageIcon(this.config.getIconsPath() + "liste.gif"));
            this.bPM.setIcon(new ImageIcon(this.config.getIconsPath() + "pm.gif"));
            this.bTopic.setIcon(new ImageIcon(this.config.getIconsPath() + "topic.gif"));
            this.bJoin.setIcon(new ImageIcon(this.config.getIconsPath() + "join.gif"));
            this.bAffichShare.setIcon(new ImageIcon(this.config.getIconsPath() + "server.gif"));
        } else if (string.equals("lang")) {
            if (this.config.isShare()) {
                this.bShare.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_SHARE_STOP_TOOLTIP"));
            } else {
                this.bShare.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_SHARE_START_TOOLTIP"));
            }
            this.bKick.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_KICK_TOOLTIP"));
            this.bIgnore.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_IGNORE_TOOLTIP"));
            this.bPM.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_PM_TOOLTIP"));
            this.bTopic.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_TOPIC_TOOLTIP"));
            this.bList.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_CHANLIST_TOOLTIP"));
            this.bJoin.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_JOIN_TOOLTIP"));
            this.bConfig.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_CONFIG_TOOLTIP"));
            this.bAffichShare.setToolTipText(this.config.getLangProperty("MAIN_TOOLBAR_SHARE_CONFIG_TOOLTIP"));
        }
    }
}

