/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import madkit.MadChat.Config;
import madkit.MadChat.HTMLEditor;

public class LogExplorer
extends JFrame
implements MouseListener,
ActionListener {
    private JPanel panel;
    private JPanel buttonPanel;
    private JScrollPane scrollPane;
    private JScrollPane scrollPane2;
    private JButton quit;
    private JButton delete;
    private JButton deleteAll;
    private JList listLog;
    private HTMLEditor viewLog;
    private Config config;
    private Vector listeLog;

    public LogExplorer(Config config) {
        this.config = config;
        File file = new File(this.config.getLogPath());
        String[] stringArray = file.list();
        this.listeLog = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            this.listeLog.add(stringArray[i]);
        }
        this.panel = new JPanel(new BorderLayout());
        this.buttonPanel = new JPanel(new BorderLayout());
        this.quit = new JButton("Close");
        this.quit.addActionListener(this);
        this.delete = new JButton("Delete selected");
        this.delete.addActionListener(this);
        this.deleteAll = new JButton("Delete all");
        this.deleteAll.addActionListener(this);
        this.listLog = new JList(this.listeLog);
        this.listLog.addMouseListener(this);
        this.listLog.setFixedCellWidth(100);
        this.viewLog = new HTMLEditor();
        this.viewLog.setEditable(false);
        if (this.config.getOsName().startsWith("Windows")) {
            this.viewLog.insertHTML("<body background=\"file:///" + this.config.getBackground() + "\">");
        } else {
            this.viewLog.insertHTML("<body background=\"file://" + this.config.getBackground() + "\">");
        }
        this.viewLog.insertHTML("Click on a log in the list to display it.");
        this.buttonPanel.add((Component)this.delete, "West");
        this.buttonPanel.add((Component)this.deleteAll, "Center");
        this.buttonPanel.add((Component)this.quit, "East");
        this.scrollPane = new JScrollPane(this.viewLog, 20, 31);
        this.scrollPane.setWheelScrollingEnabled(true);
        this.scrollPane2 = new JScrollPane(this.listLog, 20, 31);
        this.scrollPane2.setWheelScrollingEnabled(true);
        this.panel.add((Component)this.scrollPane2, "West");
        this.panel.add((Component)this.scrollPane, "Center");
        this.panel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add(this.panel);
        this.pack();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.listLog) {
            JList jList = (JList)mouseEvent.getSource();
            if (mouseEvent.getClickCount() == 1) {
                this.viewLog.setText("");
                String string = (String)jList.getSelectedValue();
                File file = new File(this.config.getLogPath() + string);
                try {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        this.viewLog.insertHTML(string2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.quit) {
            this.dispose();
        } else if (actionEvent.getSource() == this.delete) {
            System.out.println("deleting log : " + (String)this.listLog.getSelectedValue());
            File file = new File(this.config.getLogPath() + (String)this.listLog.getSelectedValue());
            file.delete();
            this.listeLog.remove(this.listLog.getSelectedValue());
            this.listLog.setListData(this.listeLog);
            this.viewLog.setText("");
            if (this.config.getOsName().startsWith("Windows")) {
                this.viewLog.insertHTML("<body background=\"file:///" + this.config.getBackground() + "\">");
            } else {
                this.viewLog.insertHTML("<body background=\"file://" + this.config.getBackground() + "\">");
            }
            this.viewLog.insertHTML("Click on a log in the list to display it.");
        } else if (actionEvent.getSource() == this.deleteAll) {
            for (int i = 0; i < this.listeLog.size(); ++i) {
                System.out.println("deleting log : " + (String)this.listeLog.get(i));
                File file = new File(this.config.getLogPath() + (String)this.listeLog.get(i));
                file.delete();
            }
            this.listeLog.removeAllElements();
            this.listLog.setListData(this.listeLog);
            this.viewLog.setText("");
            if (this.config.getOsName().startsWith("Windows")) {
                this.viewLog.insertHTML("<body background=\"file:///" + this.config.getBackground() + "\">");
            } else {
                this.viewLog.insertHTML("<body background=\"file://" + this.config.getBackground() + "\">");
            }
            this.viewLog.insertHTML("Click on a log in the list to display it.");
        }
    }
}

