/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import madkit.MadChat.ConfigChangeListener;
import madkit.MadChat.SmileyTab;
import madkit.MadChat.share.SenderAgent;
import madkit.MadChat.share.ShareAgent;
import madkit.kernel.Agent;

public class Config {
    private Agent chatAgent;
    private SenderAgent senderAgent;
    private ShareAgent shareAgent;
    private SmileyTab smileyTab;
    private String configPath;
    private String iconsPath;
    private String smileyPath;
    private String fileSeparator;
    private String configFile;
    private String theme;
    private boolean logAuto;
    private boolean timestamp;
    private String background;
    private String defaultColor;
    private String login;
    private String osName;
    private String logPath;
    private Vector configChangeListeners;
    private String themePath;
    private String lang;
    private Hashtable langProperties;
    private boolean share;
    private boolean shareRunning;
    private Vector tabRepertoiresPartages = new Vector();

    public Config(Agent agent) {
        this.chatAgent = agent;
        this.configChangeListeners = new Vector();
        this.configFile = "madchat.ini";
        this.osName = System.getProperty("os.name");
        this.smileyTab = new SmileyTab();
        this.fileSeparator = System.getProperty("file.separator");
        this.configPath = System.getProperty("user.dir") + this.fileSeparator + "plugins" + this.fileSeparator + "MadChat" + this.fileSeparator + "madchat" + this.fileSeparator;
        this.themePath = new String(this.configPath + "Themes" + this.fileSeparator);
        this.langProperties = new Hashtable();
        File file = new File(this.configPath + this.configFile);
        if (file.exists()) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    int n = string.indexOf("=");
                    if (n <= -1) continue;
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    if (string2.equalsIgnoreCase("theme")) {
                        this.theme = string3;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("share")) {
                        this.share = string3.equals("1");
                        this.shareRunning = string3.equals("1");
                        continue;
                    }
                    if (string2.equalsIgnoreCase("nomrep")) {
                        this.tabRepertoiresPartages.add(string3);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("logauto")) {
                        this.logAuto = string3.equals("1");
                        continue;
                    }
                    if (string2.equalsIgnoreCase("timestamp")) {
                        this.timestamp = string3.equals("1");
                        continue;
                    }
                    if (string2.equalsIgnoreCase("background")) {
                        if (!string3.equals("")) {
                            this.background = string3;
                            continue;
                        }
                        this.background = this.configPath + "Themes" + this.fileSeparator + this.theme + this.fileSeparator + "background.jpg";
                        continue;
                    }
                    if (string2.equalsIgnoreCase("color")) {
                        this.defaultColor = string3;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("lang")) {
                        this.lang = string3;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("login")) {
                        this.login = string3;
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("logpath")) continue;
                    this.logPath = string3;
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                System.out.println("Erreur d'ouverture");
            }
        } else {
            this.share = true;
            this.shareRunning = true;
            this.theme = "Aqua";
            this.background = this.configPath + "Themes" + this.fileSeparator + this.theme + this.fileSeparator + "background.jpg";
            this.logPath = this.configPath + "log" + this.fileSeparator;
            this.logAuto = false;
            this.timestamp = false;
            this.defaultColor = "#FFFFFF";
            this.login = "MadChatteur" + (int)(Math.random() * 1000.0);
            this.lang = "francais";
        }
        this.smileyPath = this.configPath + "Themes" + this.fileSeparator + this.theme + this.fileSeparator + "Smileys" + this.fileSeparator;
        this.iconsPath = this.configPath + "Themes" + this.fileSeparator + this.theme + this.fileSeparator + "Icons" + this.fileSeparator;
        this.insertSmileys();
        this.loadLang();
        System.out.println("smileyPath=" + this.smileyPath);
        System.out.println("iconsPath=" + this.iconsPath);
        System.out.println("logauto=" + this.logAuto);
        System.out.println("timestamp=" + this.timestamp);
        System.out.println("background=" + this.background);
        System.out.println("color=" + this.defaultColor);
        System.out.println("login=" + this.login);
        System.out.println("themePath= " + this.themePath);
        this.save();
    }

    private void loadLang() {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.configPath + "Lang" + File.separator + this.lang + ".lang"));
            this.langProperties.clear();
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf("=");
                if (n <= -1) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                System.out.println("LangPropertie : " + string2 + "=" + string3);
                this.langProperties.put(string2, string3);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Erreur pendant le chargement de " + this.configPath + "Lang" + File.separator + this.lang + ".lang!");
        }
    }

    public boolean isShareRunning() {
        return this.shareRunning;
    }

    public void setShareRunning(boolean bl) {
        this.shareRunning = bl;
    }

    public Agent getChatAgent() {
        return this.chatAgent;
    }

    public ShareAgent getShareAgent() {
        return this.shareAgent;
    }

    public void setShareAgent(ShareAgent shareAgent) {
        this.shareAgent = shareAgent;
    }

    public void setSenderAgent(SenderAgent senderAgent) {
        this.senderAgent = senderAgent;
    }

    public SenderAgent getSenderAgent() {
        return this.senderAgent;
    }

    public void save() {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.configPath + this.configFile)));
            printWriter.println("theme=" + this.theme);
            if (this.share) {
                printWriter.println("share=1");
            } else {
                printWriter.println("share=0");
            }
            for (int i = 0; i < this.tabRepertoiresPartages.size(); ++i) {
                printWriter.println(this.tabRepertoiresPartages.get(i));
            }
            if (this.logAuto) {
                printWriter.println("logauto=1");
            } else {
                printWriter.println("logauto=0");
            }
            if (this.timestamp) {
                printWriter.println("timestamp=1");
            } else {
                printWriter.println("timestamp=0");
            }
            printWriter.println("background=" + this.background);
            printWriter.println("color=" + this.defaultColor);
            printWriter.println("login=" + this.login);
            printWriter.println("logpath=" + this.logPath);
            printWriter.println("lang=" + this.lang);
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String string) {
        if (!this.background.equals(string)) {
            this.background = string;
            this.fireConfigChanged("background");
        }
    }

    public String getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(String string) {
        if (!this.defaultColor.equals(string)) {
            this.defaultColor = string;
            this.fireConfigChanged("defaultcolor");
        }
    }

    public boolean isShare() {
        return this.share;
    }

    public void setShare(boolean bl) {
        if (this.share != bl) {
            this.share = bl;
            this.fireConfigChanged("share");
        }
    }

    public Vector getTabRepertoiresPartages() {
        return this.tabRepertoiresPartages;
    }

    public void setTabRepertoiresPartages(Vector vector) {
        this.tabRepertoiresPartages = vector;
    }

    public boolean isLogAuto() {
        return this.logAuto;
    }

    public void setLogAuto(boolean bl) {
        if (this.logAuto != bl) {
            this.logAuto = bl;
            this.fireConfigChanged("logauto");
        }
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String string) {
        if (!this.login.equals(string)) {
            this.login = string;
            this.fireConfigChanged("login");
        }
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String string) {
        if (!this.theme.equals(string)) {
            this.theme = string;
            this.smileyPath = this.configPath + "Themes" + this.fileSeparator + string + this.fileSeparator + "Smileys" + this.fileSeparator;
            this.iconsPath = this.configPath + "Themes" + this.fileSeparator + string + this.fileSeparator + "Icons" + this.fileSeparator;
            this.insertSmileys();
            this.fireConfigChanged("theme");
        }
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(boolean bl) {
        if (this.timestamp != bl) {
            this.timestamp = bl;
            this.fireConfigChanged("timestamp");
        }
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getIconsPath() {
        return this.iconsPath;
    }

    public String getSmileyPath() {
        return this.smileyPath;
    }

    public SmileyTab getSmileyTab() {
        return this.smileyTab;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String string) {
        if (!this.logPath.equals(string)) {
            this.logPath = string;
            this.fireConfigChanged("logpath");
        }
    }

    public String getThemePath() {
        return this.themePath;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String string) {
        if (!this.lang.equals(string)) {
            this.lang = string;
            this.loadLang();
            this.fireConfigChanged("lang");
        }
    }

    public String getLangProperty(String string) {
        System.out.println("getLangProperty(" + string + ")");
        return (String)this.langProperties.get(string);
    }

    public void addConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.configChangeListeners.add(configChangeListener);
    }

    public void removeConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.configChangeListeners.remove(configChangeListener);
    }

    public void fireConfigChanged(String string) {
        for (int i = 0; i < this.configChangeListeners.size(); ++i) {
            ((ConfigChangeListener)this.configChangeListeners.get(i)).configChanged(string);
        }
    }

    public void insertSmileys() {
        this.smileyTab.clear();
        this.smileyTab.insertSmiley(":)", this.smileyPath + "smile1.gif");
        this.smileyTab.insertSmiley(":-)", this.smileyPath + "smile2.gif");
        this.smileyTab.insertSmiley(":(", this.smileyPath + "negat1.gif");
        this.smileyTab.insertSmiley(":-(", this.smileyPath + "negat2.gif");
        this.smileyTab.insertSmiley(":'(", this.smileyPath + "pleure.gif");
        this.smileyTab.insertSmiley(";)", this.smileyPath + "oeil1.gif");
        this.smileyTab.insertSmiley(";-)", this.smileyPath + "oeil2.gif");
        this.smileyTab.insertSmiley(":D", this.smileyPath + "content1.gif");
        this.smileyTab.insertSmiley(":-D", this.smileyPath + "content2.gif");
        this.smileyTab.insertSmiley(":S", this.smileyPath + "mhh2.gif");
        this.smileyTab.insertSmiley("^^", this.smileyPath + "huhu.gif");
        this.smileyTab.insertSmiley("O:)", this.smileyPath + "ange.gif");
        this.smileyTab.insertSmiley(":!", this.smileyPath + "demon.gif");
        this.smileyTab.insertSmiley(":p", this.smileyPath + "langue1.gif");
        this.smileyTab.insertSmiley(":-p", this.smileyPath + "langue2.gif");
        this.smileyTab.insertSmiley(":X", this.smileyPath + "muet.gif");
        this.smileyTab.insertSmiley("8-)", this.smileyPath + "lunette.gif");
        this.smileyTab.insertSmiley(":B", this.smileyPath + "beer.gif");
    }
}

