/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat.CloseAndMaxTabbedPane;

import com.sun.java.swing.plaf.windows.WindowsIconFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import madkit.MadChat.CloseAndMaxTabbedPane.CloseAndMaxTabbedPane;

public class CloseTabPaneUI
extends BasicTabbedPaneUI {
    private ContainerListener containerListener;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    protected ScrollableTabSupport tabScroller;
    private int tabCount;
    protected MyMouseMotionListener motionListener;
    private static final int INACTIVE = 0;
    private static final int OVER = 1;
    private static final int PRESSED = 2;
    protected static final int BUTTONSIZE = 15;
    protected static final int WIDTHDELTA = 5;
    private static final Border PRESSEDBORDER = new SoftBevelBorder(1);
    private static final Border OVERBORDER = new SoftBevelBorder(0);
    private BufferedImage closeImgB = new BufferedImage(15, 15, 6);
    private BufferedImage maxImgB = new BufferedImage(15, 15, 6);
    private BufferedImage closeImgI = new BufferedImage(15, 15, 6);
    private BufferedImage maxImgI = new BufferedImage(15, 15, 6);
    private JButton closeB = new JButton(new ImageIcon("E:\\[Prog]\\madkit\\plugins\\MadChat\\src\\madkit\\MadChat\\CloseAndMaxTabbedPane\\almost.gif"));
    private JButton maxB;
    private int overTabIndex = -1;
    private int closeIndexStatus = 0;
    private int maxIndexStatus = 0;
    private boolean mousePressed = false;
    private boolean isCloseButtonEnabled = true;
    private boolean isMaxButtonEnabled = true;
    protected JPopupMenu actionPopupMenu;
    protected JMenuItem maxItem;
    protected JMenuItem closeItem;
    private static final int CROP_SEGMENT = 12;

    public CloseTabPaneUI() {
        this.closeB.setSize(15, 15);
        this.maxB = new JButton();
        this.maxB.setSize(15, 15);
        WindowsIconFactory.createFrameMaximizeIcon().paintIcon(this.maxB, this.maxImgI.createGraphics(), 0, 0);
        this.actionPopupMenu = new JPopupMenu();
        this.maxItem = new JMenuItem("Detach");
        this.closeItem = new JMenuItem("Close");
        this.maxItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((CloseAndMaxTabbedPane)CloseTabPaneUI.this.tabPane).fireMaxTabEvent(null, CloseTabPaneUI.this.tabPane.getSelectedIndex());
            }
        });
        this.closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((CloseAndMaxTabbedPane)CloseTabPaneUI.this.tabPane).fireCloseTabEvent(null, CloseTabPaneUI.this.tabPane.getSelectedIndex());
            }
        });
        this.setPopupMenu();
    }

    protected boolean isOneActionButtonEnabled() {
        return this.isCloseButtonEnabled || this.isMaxButtonEnabled;
    }

    public boolean isCloseEnabled() {
        return this.isCloseButtonEnabled;
    }

    public boolean isMaxEnabled() {
        return this.isMaxButtonEnabled;
    }

    public void setCloseIcon(boolean bl) {
        this.isCloseButtonEnabled = bl;
        this.setPopupMenu();
    }

    public void setMaxIcon(boolean bl) {
        this.isMaxButtonEnabled = bl;
        this.setPopupMenu();
    }

    private void setPopupMenu() {
        this.actionPopupMenu.removeAll();
        if (this.isMaxButtonEnabled) {
            this.actionPopupMenu.add(this.maxItem);
        }
        if (this.isMaxButtonEnabled && this.isCloseButtonEnabled) {
            this.actionPopupMenu.addSeparator();
        }
        if (this.isCloseButtonEnabled) {
            this.actionPopupMenu.add(this.closeItem);
        }
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        int n3 = 2;
        if (!this.isOneActionButtonEnabled()) {
            n3 += 6;
        } else {
            if (this.isCloseButtonEnabled) {
                n3 += 20;
            }
            if (this.isMaxButtonEnabled) {
                n3 += 20;
            }
        }
        return super.calculateTabWidth(n, n2, fontMetrics) + n3;
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        return super.calculateTabHeight(n, n2, n3) + 5;
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 2, 0, 0, rectangle, rectangle2, rectangle3, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        rectangle2.x = rectangle.x + 8;
        rectangle3.x = rectangle2.x + rectangle2.width + this.textIconGap;
    }

    protected MouseListener createMouseListener() {
        return new MyMouseHandler();
    }

    protected ScrollableTabButton createScrollableTabButton(int n) {
        return new ScrollableTabButton(n);
    }

    protected Rectangle newCloseRect(Rectangle rectangle) {
        int n = rectangle.x + rectangle.width;
        int n2 = (rectangle.y + rectangle.height) / 2 - 6;
        return new Rectangle(n - 15 - 5, n2, 15, 15);
    }

    protected Rectangle newMaxRect(Rectangle rectangle) {
        int n = rectangle.x + rectangle.width;
        int n2 = (rectangle.y + rectangle.height) / 2 - 6;
        if (this.isCloseButtonEnabled) {
            n -= 15;
        }
        return new Rectangle(n - 15 - 5, n2, 15, 15);
    }

    protected void updateOverTab(int n, int n2) {
        this.overTabIndex = this.getTabAtLocation(n, n2);
        if (this.overTabIndex != this.overTabIndex) {
            this.tabScroller.tabPanel.repaint();
        }
    }

    protected void updateCloseIcon(int n, int n2) {
        if (this.overTabIndex != -1) {
            int n3 = 0;
            Rectangle rectangle = this.newCloseRect(this.rects[this.overTabIndex]);
            if (rectangle.contains(n, n2)) {
                int n4 = n3 = this.mousePressed ? 2 : 1;
            }
            if ((this.closeIndexStatus = n3) != this.closeIndexStatus) {
                this.tabScroller.tabPanel.repaint();
            }
        }
    }

    protected void updateMaxIcon(int n, int n2) {
        if (this.overTabIndex != -1) {
            int n3 = 0;
            Rectangle rectangle = this.newMaxRect(this.rects[this.overTabIndex]);
            if (rectangle.contains(n, n2)) {
                int n4 = n3 = this.mousePressed ? 2 : 1;
            }
            if ((this.maxIndexStatus = n3) != this.maxIndexStatus) {
                this.tabScroller.tabPanel.repaint();
            }
        }
    }

    private void setTabIcons(int n, int n2) {
        if (!this.mousePressed) {
            this.updateOverTab(n, n2);
        }
        if (this.isCloseButtonEnabled) {
            this.updateCloseIcon(n, n2);
        }
        if (this.isMaxButtonEnabled) {
            this.updateMaxIcon(n, n2);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new CloseTabPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        return new TabbedPaneScrollLayout();
    }

    protected void installComponents() {
        if (this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
        }
    }

    protected void uninstallComponents() {
        this.tabPane.remove(this.tabScroller.viewport);
        this.tabPane.remove(this.tabScroller.scrollForwardButton);
        this.tabPane.remove(this.tabScroller.scrollBackwardButton);
        this.tabScroller = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler()) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
        if ((this.motionListener = new MyMouseMotionListener()) != null) {
            this.tabScroller.tabPanel.addMouseMotionListener(this.motionListener);
        }
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        if (this.motionListener != null) {
            this.tabScroller.tabPanel.removeMouseMotionListener(this.motionListener);
            this.motionListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getMyInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, inputMap);
        inputMap = this.getMyInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, inputMap);
        ActionMap actionMap = this.createMyActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, actionMap);
        this.tabScroller.scrollForwardButton.setAction(actionMap.get("scrollTabsForwardAction"));
        this.tabScroller.scrollBackwardButton.setAction(actionMap.get("scrollTabsBackwardAction"));
    }

    InputMap getMyInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        }
        if (n == 0) {
            return (InputMap)UIManager.get("TabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap createMyActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigateNext", new NextAction());
        actionMapUIResource.put("navigatePrevious", new PreviousAction());
        actionMapUIResource.put("navigateRight", new RightAction());
        actionMapUIResource.put("navigateLeft", new LeftAction());
        actionMapUIResource.put("navigateUp", new UpAction());
        actionMapUIResource.put("navigateDown", new DownAction());
        actionMapUIResource.put("navigatePageUp", new PageUpAction());
        actionMapUIResource.put("navigatePageDown", new PageDownAction());
        actionMapUIResource.put("requestFocus", new RequestFocusAction());
        actionMapUIResource.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        actionMapUIResource.put("setSelectedIndex", new SetSelectedIndexAction());
        actionMapUIResource.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        actionMapUIResource.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        for (int i = this.tabPane.getTabCount() - 1; i >= 0; --i) {
            int n = this.tabPane.getMnemonicAt(i);
            if (n <= 0) continue;
            this.addMnemonic(i, n);
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int n, int n2) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(n2, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(n2), new Integer(n));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getTabCount();
        if (this.tabCount != n) {
            this.tabCount = n;
            this.updateMnemonics();
        }
        int n2 = this.tabPane.getSelectedIndex();
        int n3 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        this.paintContentBorder(graphics, n3, n2);
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        boolean bl2 = this.overTabIndex == n2;
        Graphics2D graphics2D = null;
        Shape shape = null;
        boolean bl3 = false;
        int n4 = 0;
        int n5 = 0;
        if (graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            object = this.tabScroller.viewport.getViewRect();
            int n6 = ((Rectangle)object).x + ((Rectangle)object).width;
            if (rectangle3.x < n6 && rectangle3.x + rectangle3.width > n6) {
                n4 = n6 - 1;
                n5 = rectangle3.y;
                bl3 = true;
            }
            if (bl3) {
                shape = graphics2D.getClip();
                graphics2D.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            }
        }
        this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        object = this.tabPane.getTitleAt(n2);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n2);
        this.layoutLabel(n, fontMetrics, n2, (String)object, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(graphics, n, font, fontMetrics, n2, (String)object, rectangle2, bl);
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
        if (bl3) {
            this.paintCroppedTabEdge(graphics, n, n2, bl, n4, n5);
            graphics2D.setClip(shape);
        } else if (bl2 || bl) {
            int n7 = rectangle3.x + rectangle3.width - 15 - 5;
            int n8 = (rectangle3.y + rectangle3.height) / 2 - 6;
            if (this.isCloseButtonEnabled) {
                this.paintCloseIcon(graphics2D, n7, n8, bl2);
            }
            if (this.isMaxButtonEnabled) {
                this.paintMaxIcon(graphics2D, n7, n8, bl2);
            }
        }
    }

    protected void paintCloseIcon(Graphics graphics, int n, int n2, boolean bl) {
        this.paintActionButton(graphics, n, n2, this.closeIndexStatus, bl, this.closeB, this.closeImgB);
        graphics.drawImage(this.closeImgI, n, n2 + 1, null);
    }

    protected void paintMaxIcon(Graphics graphics, int n, int n2, boolean bl) {
        if (this.isCloseButtonEnabled) {
            n -= 15;
        }
        this.paintActionButton(graphics, n, n2, this.maxIndexStatus, bl, this.maxB, this.maxImgB);
        graphics.drawImage(this.maxImgI, n, n2 + 1, null);
    }

    protected void paintActionButton(Graphics graphics, int n, int n2, int n3, boolean bl, JButton jButton, BufferedImage bufferedImage) {
        jButton.setBorder(null);
        if (bl) {
            switch (n3) {
                case 1: {
                    jButton.setBorder(OVERBORDER);
                    break;
                }
                case 2: {
                    jButton.setBorder(PRESSEDBORDER);
                }
            }
        }
        jButton.setBackground(this.tabScroller.tabPanel.getBackground());
        jButton.paint(bufferedImage.getGraphics());
        graphics.drawImage(bufferedImage, n, n2, null);
    }

    private void paintCroppedTabEdge(Graphics graphics, int n, int n2, boolean bl, int n3, int n4) {
        graphics.setColor(this.shadow);
        graphics.drawLine(n3, n4, n3, n4 + this.rects[n2].height);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        rectangle.width = this.rects[n].width;
        rectangle.height = this.rects[n].height;
        Point point = this.tabScroller.viewport.getLocation();
        Point point2 = this.tabScroller.viewport.getViewPosition();
        rectangle.x = this.rects[n].x + point.x - point2.x;
        rectangle.y = this.rects[n].y + point.y - point2.y;
        return rectangle;
    }

    private int getTabAtLocation(int n, int n2) {
        this.ensureCurrentLayout();
        int n3 = this.tabPane.getTabCount();
        for (int i = 0; i < n3; ++i) {
            if (!this.rects[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public int getOverTabIndex() {
        return this.overTabIndex;
    }

    private int getClosestTab(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = n4 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n7 = this.tabPane.getTabPlacement();
        boolean bl = n7 == 1 || n7 == 3;
        int n8 = n3 = bl ? n : n2;
        while (n5 != n6) {
            int n9;
            int n10;
            int n11 = (n6 + n5) / 2;
            if (bl) {
                n10 = this.rects[n11].x;
                n9 = n10 + this.rects[n11].width;
            } else {
                n10 = this.rects[n11].y;
                n9 = n10 + this.rects[n11].height;
            }
            if (n3 < n10) {
                n6 = n11;
                if (n5 != n6) continue;
                return Math.max(0, n11 - 1);
            }
            if (n3 >= n9) {
                n5 = n11;
                if (n6 - n5 > 1) continue;
                return Math.max(n11 + 1, n4 - 1);
            }
            return n11;
        }
        return n5;
    }

    private Point translatePointToTabPanel(int n, int n2, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n + point2.x + point3.x;
        point.y = n2 + point2.y + point3.y;
        return point;
    }

    boolean requestMyFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusTraversable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    private Vector createHTMLVector() {
        Vector<View> vector = new Vector<View>();
        int n = this.tabPane.getTabCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String string = this.tabPane.getTitleAt(i);
                if (BasicHTML.isHTMLString(string)) {
                    vector.addElement(BasicHTML.createHTMLView(this.tabPane, string));
                    continue;
                }
                vector.addElement(null);
            }
        }
        return vector;
    }

    class MyMouseMotionListener
    implements MouseMotionListener {
        MyMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (CloseTabPaneUI.this.actionPopupMenu.isVisible()) {
                return;
            }
            CloseTabPaneUI.this.mousePressed = false;
            CloseTabPaneUI.this.setTabIcons(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (CloseTabPaneUI.this.actionPopupMenu.isVisible()) {
                return;
            }
            CloseTabPaneUI.this.mousePressed = true;
            CloseTabPaneUI.this.setTabIcons(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class MyMouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        public MyMouseHandler() {
            super(CloseTabPaneUI.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (CloseTabPaneUI.this.closeIndexStatus == 1) {
                CloseTabPaneUI.this.closeIndexStatus = 2;
                CloseTabPaneUI.this.tabScroller.tabPanel.repaint();
                return;
            }
            if (CloseTabPaneUI.this.maxIndexStatus == 1) {
                CloseTabPaneUI.this.maxIndexStatus = 2;
                CloseTabPaneUI.this.tabScroller.tabPanel.repaint();
                return;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (mouseEvent.getClickCount() > 1 && CloseTabPaneUI.this.overTabIndex != -1) {
                ((CloseAndMaxTabbedPane)CloseTabPaneUI.this.tabPane).fireDoubleClickTabEvent(mouseEvent, CloseTabPaneUI.this.overTabIndex);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            CloseTabPaneUI.this.updateOverTab(mouseEvent.getX(), mouseEvent.getY());
            if (CloseTabPaneUI.this.overTabIndex == -1) {
                if (mouseEvent.isPopupTrigger()) {
                    ((CloseAndMaxTabbedPane)CloseTabPaneUI.this.tabPane).firePopupOutsideTabEvent(mouseEvent);
                }
                return;
            }
            if (CloseTabPaneUI.this.isOneActionButtonEnabled() && mouseEvent.isPopupTrigger()) {
                super.mousePressed(mouseEvent);
                CloseTabPaneUI.this.closeIndexStatus = 0;
                CloseTabPaneUI.this.maxIndexStatus = 0;
                CloseTabPaneUI.this.actionPopupMenu.show(CloseTabPaneUI.this.tabScroller.tabPanel, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (CloseTabPaneUI.this.closeIndexStatus == 2) {
                CloseTabPaneUI.this.closeIndexStatus = 1;
                CloseTabPaneUI.this.tabScroller.tabPanel.repaint();
                ((CloseAndMaxTabbedPane)CloseTabPaneUI.this.tabPane).fireCloseTabEvent(mouseEvent, CloseTabPaneUI.this.overTabIndex);
                return;
            }
            if (CloseTabPaneUI.this.maxIndexStatus == 2) {
                CloseTabPaneUI.this.maxIndexStatus = 1;
                CloseTabPaneUI.this.tabScroller.tabPanel.repaint();
                ((CloseAndMaxTabbedPane)CloseTabPaneUI.this.tabPane).fireMaxTabEvent(mouseEvent, CloseTabPaneUI.this.overTabIndex);
                return;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!CloseTabPaneUI.this.mousePressed) {
                CloseTabPaneUI.this.overTabIndex = -1;
                CloseTabPaneUI.this.tabScroller.tabPanel.repaint();
            }
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            int n = jTabbedPane.indexOfComponent(component);
            String string = jTabbedPane.getTitleAt(n);
            boolean bl = BasicHTML.isHTMLString(string);
            if (bl) {
                if (CloseTabPaneUI.this.htmlViews == null) {
                    CloseTabPaneUI.this.htmlViews = CloseTabPaneUI.this.createHTMLVector();
                } else {
                    View view = BasicHTML.createHTMLView(jTabbedPane, string);
                    CloseTabPaneUI.this.htmlViews.insertElementAt(view, n);
                }
            } else if (CloseTabPaneUI.this.htmlViews != null) {
                CloseTabPaneUI.this.htmlViews.insertElementAt(null, n);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            Integer n = (Integer)jTabbedPane.getClientProperty("__index_to_remove__");
            if (n != null) {
                int n2 = n;
                if (CloseTabPaneUI.this.htmlViews != null && CloseTabPaneUI.this.htmlViews.size() >= n2) {
                    CloseTabPaneUI.this.htmlViews.removeElementAt(n2);
                }
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
            if (jTabbedPane.getTabLayoutPolicy() == 1 && (n = jTabbedPane.getSelectedIndex()) < CloseTabPaneUI.this.rects.length && n != -1) {
                CloseTabPaneUI.this.tabScroller.tabPanel.scrollRectToVisible(CloseTabPaneUI.this.rects[n]);
            }
        }
    }

    protected class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int n) {
            super(n, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }

        public boolean scrollsForward() {
            return this.direction == 3 || this.direction == 5;
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            CloseTabPaneUI.this.paintTabArea(graphics, CloseTabPaneUI.this.tabPane.getTabPlacement(), CloseTabPaneUI.this.tabPane.getSelectedIndex());
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setScrollMode(0);
        }
    }

    private class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int n) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.scrollForwardButton = CloseTabPaneUI.this.createScrollableTabButton(3);
            this.scrollBackwardButton = CloseTabPaneUI.this.createScrollableTabButton(7);
        }

        public void scrollForward(int n) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n == 1 || n == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int n, int n2) {
            this.leadingTabIndex = n2;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            int n3 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : ((CloseTabPaneUI)CloseTabPaneUI.this).rects[this.leadingTabIndex].x;
            if (dimension.width - this.tabViewPosition.x < rectangle.width) {
                Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                this.viewport.setExtentSize(dimension2);
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n = CloseTabPaneUI.this.tabPane.getTabPlacement();
            int n2 = CloseTabPaneUI.this.tabPane.getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            this.leadingTabIndex = CloseTabPaneUI.this.getClosestTab(rectangle2.x, rectangle2.y);
            if (this.leadingTabIndex + 1 < n2 && ((CloseTabPaneUI)CloseTabPaneUI.this).rects[this.leadingTabIndex].x < rectangle2.x) {
                ++this.leadingTabIndex;
            }
            Insets insets = CloseTabPaneUI.this.getContentBorderInsets(n);
            CloseTabPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
            this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
            this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }
    }

    private class TabbedPaneScrollLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
            super(CloseTabPaneUI.this);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            return CloseTabPaneUI.this.calculateMaxTabHeight(n);
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            return CloseTabPaneUI.this.calculateMaxTabWidth(n);
        }

        public void layoutContainer(Container container) {
            int n = CloseTabPaneUI.this.tabPane.getTabPlacement();
            int n2 = CloseTabPaneUI.this.tabPane.getTabCount();
            Insets insets = CloseTabPaneUI.this.tabPane.getInsets();
            int n3 = CloseTabPaneUI.this.tabPane.getSelectedIndex();
            Component component = CloseTabPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n3 < 0) {
                if (component != null) {
                    CloseTabPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component component2 = CloseTabPaneUI.this.tabPane.getComponentAt(n3);
                boolean bl = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl = true;
                    }
                    CloseTabPaneUI.this.setVisibleComponent(component2);
                }
                Insets insets2 = CloseTabPaneUI.this.getContentBorderInsets(n);
                Rectangle rectangle = CloseTabPaneUI.this.tabPane.getBounds();
                int n4 = CloseTabPaneUI.this.tabPane.getComponentCount();
                if (n4 > 0) {
                    int n5 = rectangle.width - insets.left - insets.right;
                    int n6 = CloseTabPaneUI.this.calculateTabAreaHeight(n, CloseTabPaneUI.this.runCount, CloseTabPaneUI.this.maxTabHeight);
                    int n7 = insets.left;
                    int n8 = insets.top;
                    int n9 = n7 + insets2.left;
                    int n10 = n8 + n6 + insets2.top;
                    int n11 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                    int n12 = rectangle.height - insets.top - insets.bottom - n6 - insets2.top - insets2.bottom;
                    for (int i = 0; i < n4; ++i) {
                        int n13;
                        int n14;
                        int n15;
                        Cloneable cloneable;
                        JComponent jComponent;
                        Component component3 = CloseTabPaneUI.this.tabPane.getComponent(i);
                        if (component3 instanceof ScrollableTabViewport) {
                            jComponent = (JViewport)component3;
                            cloneable = ((JViewport)jComponent).getViewRect();
                            n15 = n5;
                            n14 = n6;
                            n13 = ((CloseTabPaneUI)CloseTabPaneUI.this).rects[n2 - 1].x + ((CloseTabPaneUI)CloseTabPaneUI.this).rects[n2 - 1].width;
                            if (n13 > n5 && n13 - cloneable.x <= (n15 = Math.max(n5 - 36, 36))) {
                                n15 = n13 - cloneable.x;
                            }
                            component3.setBounds(n7, n8, n15, n14);
                            continue;
                        }
                        if (component3 instanceof ScrollableTabButton) {
                            jComponent = (ScrollableTabButton)component3;
                            cloneable = ((BasicArrowButton)jComponent).getPreferredSize();
                            n15 = 0;
                            n14 = 0;
                            n13 = ((Dimension)cloneable).width;
                            int n16 = ((Dimension)cloneable).height;
                            boolean bl2 = false;
                            int n17 = ((CloseTabPaneUI)CloseTabPaneUI.this).rects[n2 - 1].x + ((CloseTabPaneUI)CloseTabPaneUI.this).rects[n2 - 1].width;
                            if (n17 > n5) {
                                int n18 = ((ScrollableTabButton)jComponent).scrollsForward() ? 3 : 7;
                                ((BasicArrowButton)jComponent).setDirection(n18);
                                bl2 = true;
                                n15 = n18 == 3 ? rectangle.width - insets.left - ((Dimension)cloneable).width : rectangle.width - insets.left - 2 * ((Dimension)cloneable).width;
                                n14 = n == 1 ? n8 + n6 - ((Dimension)cloneable).height : n8;
                            }
                            component3.setVisible(bl2);
                            if (!bl2) continue;
                            component3.setBounds(n15, n14, n13, n16);
                            continue;
                        }
                        component3.setBounds(n9, n10, n11, n12);
                    }
                    if (bl && !CloseTabPaneUI.this.requestMyFocusForVisibleComponent()) {
                        CloseTabPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        protected void calculateTabRects(int n, int n2) {
            FontMetrics fontMetrics = CloseTabPaneUI.this.getFontMetrics();
            Dimension dimension = CloseTabPaneUI.this.tabPane.getSize();
            Insets insets = CloseTabPaneUI.this.tabPane.getInsets();
            Insets insets2 = CloseTabPaneUI.this.getTabAreaInsets(n);
            int n3 = fontMetrics.getHeight();
            int n4 = CloseTabPaneUI.this.tabPane.getSelectedIndex();
            int n5 = insets2.left - 2;
            int n6 = insets2.top;
            int n7 = 0;
            int n8 = 0;
            CloseTabPaneUI.this.maxTabHeight = CloseTabPaneUI.this.calculateMaxTabHeight(n);
            CloseTabPaneUI.this.runCount = 0;
            CloseTabPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            CloseTabPaneUI.this.selectedRun = 0;
            CloseTabPaneUI.this.runCount = 1;
            for (int i = 0; i < n2; ++i) {
                Rectangle rectangle = CloseTabPaneUI.this.rects[i];
                if (i > 0) {
                    rectangle.x = ((CloseTabPaneUI)CloseTabPaneUI.this).rects[i - 1].x + ((CloseTabPaneUI)CloseTabPaneUI.this).rects[i - 1].width - 1;
                } else {
                    ((CloseTabPaneUI)CloseTabPaneUI.this).tabRuns[0] = 0;
                    CloseTabPaneUI.this.maxTabWidth = 0;
                    n8 += CloseTabPaneUI.this.maxTabHeight;
                    rectangle.x = n5;
                }
                rectangle.width = CloseTabPaneUI.this.calculateTabWidth(n, i, fontMetrics);
                n7 = rectangle.x + rectangle.width;
                CloseTabPaneUI.this.maxTabWidth = Math.max(CloseTabPaneUI.this.maxTabWidth, rectangle.width);
                rectangle.y = n6;
                rectangle.height = CloseTabPaneUI.this.maxTabHeight;
            }
            CloseTabPaneUI.this.tabScroller.tabPanel.setPreferredSize(new Dimension(n7, n8));
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
            closeTabPaneUI.tabScroller.scrollBackward(jTabbedPane.getTabPlacement());
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
            closeTabPaneUI.tabScroller.scrollForward(jTabbedPane.getTabPlacement());
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            if (jTabbedPane != null && jTabbedPane.getUI() instanceof CloseTabPaneUI) {
                CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 0) {
                    Integer n;
                    int n2 = actionEvent.getActionCommand().charAt(0);
                    if (n2 >= 97 && n2 <= 122) {
                        n2 -= 32;
                    }
                    if ((n = (Integer)closeTabPaneUI.mnemonicToIndexMap.get(new Integer(n2))) != null && jTabbedPane.isEnabledAt(n)) {
                        jTabbedPane.setSelectedIndex(n);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
            closeTabPaneUI.requestMyFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            jTabbedPane.requestFocus();
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                closeTabPaneUI.navigateSelectedTab(3);
            } else {
                closeTabPaneUI.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                closeTabPaneUI.navigateSelectedTab(7);
            } else {
                closeTabPaneUI.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
            closeTabPaneUI.navigateSelectedTab(13);
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
            closeTabPaneUI.navigateSelectedTab(12);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
            closeTabPaneUI.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
            closeTabPaneUI.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
            closeTabPaneUI.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            CloseTabPaneUI closeTabPaneUI = (CloseTabPaneUI)jTabbedPane.getUI();
            closeTabPaneUI.navigateSelectedTab(3);
        }
    }
}

