/*
 * Decompiled with CFR 0.152.
 */
package madkit.MadChat;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import madkit.MadChat.ChatMessage;
import madkit.MadChat.Chatter;
import madkit.MadChat.ChatterList;
import madkit.MadChat.ChatterMessage;
import madkit.MadChat.CommandMessage;
import madkit.MadChat.Config;
import madkit.MadChat.ConfigChan;
import madkit.MadChat.ConfigChangeListener;
import madkit.MadChat.HTMLEditor;
import madkit.MadChat.MadChatHello;
import madkit.MadChat.PanneauIgnored;
import madkit.MadChat.PanneauTopic;
import madkit.MadChat.SmileyTab;
import madkit.MadChat.WriteToolbar;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;

public class ChatPanel
extends JPanel
implements ActionListener,
KeyListener,
MouseListener,
ConfigChangeListener {
    private HTMLEditor tZoneLecture = null;
    private JScrollPane scrollbarZLecture = null;
    private JScrollPane scrollbarZListeChatter = null;
    private JTextField tZoneEcriture = null;
    private JList lZoneListeChatter = null;
    private WriteToolbar tWriteToolbar;
    private String nomChannel;
    private ConfigChan cfgChan;
    private Vector historique;
    private int tailleMaxHistorique;
    private int indexHistorique;
    private ChatterList listeIgnored;
    private JPopupMenu popup;
    private ChatterList listeChatter;
    private JPopupMenu p;
    private JMenuItem menuIgnore;
    private JMenuItem menuKick;
    private JMenuItem menuOP;
    private JMenuItem menuDEOP;
    private JMenuItem menuSlap;
    private JMenuItem menuPing;
    private JMenuItem menuWhois;
    String background;
    Config config;

    public ChatPanel(String string, Config config) {
        this(string, config, new ConfigChan(string, "Bienvenue sur le salon : " + string, "", false, false));
    }

    public ChatPanel(String string, Config config, ConfigChan configChan) {
        this.config = config;
        this.config.addConfigChangeListener(this);
        this.historique = new Vector();
        this.tailleMaxHistorique = 20;
        this.indexHistorique = 1;
        this.nomChannel = string;
        this.cfgChan = configChan;
        this.listeChatter = new ChatterList();
        this.listeIgnored = new ChatterList();
        this.background = this.config.getOsName().startsWith("Windows") ? "<body background=\"file:///" + this.config.getBackground() + "\">" : "<body background=\"file://" + this.config.getBackground() + "\">";
        this.setLayout(new BorderLayout());
        this.popup = new JPopupMenu();
        this.menuIgnore = new JMenuItem("Ignorer/Accepter");
        this.menuIgnore.addActionListener(this);
        this.menuKick = new JMenuItem("Kicker");
        this.menuKick.addActionListener(this);
        this.menuOP = new JMenuItem("Op");
        this.menuOP.addActionListener(this);
        this.menuDEOP = new JMenuItem("Deop");
        this.menuDEOP.addActionListener(this);
        this.menuSlap = new JMenuItem("Slap !");
        this.menuSlap.addActionListener(this);
        this.menuPing = new JMenuItem("Ping");
        this.menuPing.addActionListener(this);
        this.menuWhois = new JMenuItem("Whois");
        this.menuWhois.addActionListener(this);
        this.popup.add(this.menuOP);
        this.popup.add(this.menuDEOP);
        this.popup.addSeparator();
        this.popup.add(this.menuKick);
        this.popup.add(this.menuIgnore);
        this.popup.addSeparator();
        this.popup.add(this.menuSlap);
        this.popup.addSeparator();
        this.popup.add(this.menuPing);
        this.popup.add(this.menuWhois);
        this.tZoneLecture = new HTMLEditor();
        this.tZoneLecture.setEditable(false);
        this.tZoneLecture.addMouseListener(this);
        this.tZoneLecture.insertHTML(this.background);
        this.tZoneLecture.insertHTML("<font color =\"#3355AA\"> Welcome in MadChat ! Type /help to get command list :)</font>");
        this.lZoneListeChatter = new JList();
        this.lZoneListeChatter.setFixedCellWidth(150);
        this.lZoneListeChatter.addMouseListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.tZoneEcriture = new JTextField();
        this.tZoneEcriture.addKeyListener(this);
        this.tZoneEcriture.addActionListener(this);
        this.tWriteToolbar = new WriteToolbar(this.tZoneEcriture, config);
        this.tWriteToolbar.setFloatable(false);
        jPanel.add((Component)this.tWriteToolbar, "North");
        jPanel.add((Component)this.tZoneEcriture, "South");
        this.scrollbarZLecture = new JScrollPane(this.tZoneLecture, 20, 31);
        this.scrollbarZLecture.setWheelScrollingEnabled(true);
        this.add((Component)this.scrollbarZLecture, "Center");
        this.add((Component)jPanel, "South");
        this.scrollbarZListeChatter = new JScrollPane(this.lZoneListeChatter);
        this.scrollbarZListeChatter.setWheelScrollingEnabled(true);
        this.add((Component)this.scrollbarZListeChatter, "East");
    }

    public void setChatterList(Chatter[] chatterArray) {
        if (chatterArray != null) {
            for (int i = 0; i < chatterArray.length; ++i) {
                this.listeChatter.add(chatterArray[i]);
            }
            this.lZoneListeChatter.removeAll();
            this.lZoneListeChatter.setListData(this.listeChatter);
        } else {
            System.out.println("pb list chatter");
        }
    }

    public void addChatter(Chatter chatter) {
        this.listeChatter.add(chatter);
        this.lZoneListeChatter.setListData(this.listeChatter);
        this.insertInfoMessage("" + chatter.getNom() + " vient de se connecter au channel", "#0000ff");
    }

    public void removeChatter(AgentAddress agentAddress) {
        Chatter chatter = this.listeChatter.getByAgentAddress(agentAddress);
        if (chatter != null) {
            this.lZoneListeChatter.setListData(this.listeChatter);
            this.insertInfoMessage("" + chatter.getNom() + " vient de quitter le channel", "#ff0000");
            this.listeChatter.RemoveByAgentAddress(agentAddress);
            this.listeIgnored.RemoveByAgentAddress(agentAddress);
            this.lZoneListeChatter.setListData(this.listeChatter);
        }
    }

    public int getChatterCount() {
        return this.listeChatter.size();
    }

    public ChatterList getListeIgnored() {
        return this.listeIgnored;
    }

    public void setListeIgnored(ChatterList chatterList) {
        this.listeIgnored = chatterList;
    }

    public Chatter[] getChatterList() {
        Chatter[] chatterArray = new Chatter[this.listeChatter.size()];
        for (int i = 0; i < this.listeChatter.size(); ++i) {
            chatterArray[i] = (Chatter)this.listeChatter.get(i);
        }
        return chatterArray;
    }

    public ChatterList getChatList() {
        return this.listeChatter;
    }

    public void updateChatterNick(AgentAddress agentAddress, String string) {
        Chatter chatter = this.listeChatter.getByAgentAddress(agentAddress);
        if (chatter != null) {
            System.out.println("changement nick");
            String string2 = chatter.getNom();
            chatter.setNom(string);
            this.lZoneListeChatter.setListData(this.listeChatter);
            this.tZoneLecture.insertHTML("<font color =\"#FF0000\">" + string2 + " change de nom pour \"" + chatter.getNom() + "\" </font>");
        }
    }

    public void quit() {
        MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
        madChatHello.leaveGroup("MadChat", this.getNomChannel());
        CommandMessage commandMessage = new CommandMessage(madChatHello.getAddress(), 30, this.getNomChannel(), this.config.getLogin());
        this.config.getChatAgent().broadcastMessage("MadChat", this.getNomChannel(), "chatter", (Message)commandMessage);
        if (this.tWriteToolbar.isSaveLog()) {
            try {
                FileWriter fileWriter = new FileWriter(this.config.getLogPath() + this.getNomChannel() + ".log", true);
                fileWriter.write(this.getConversation());
                fileWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void join() {
        this.config.getChatAgent().requestRole("MadChat", this.getNomChannel(), "chatter", null);
        MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
        CommandMessage commandMessage = new CommandMessage(this.config.getChatAgent().getAddress(), 0, this.getNomChannel(), "");
        madChatHello.sendMessageToAnyone("MadChat", this.getNomChannel(), "chatter", commandMessage);
        Chatter chatter = new Chatter(this.config.getLogin(), false, madChatHello.getAddress());
        if (madChatHello.getAgentsWithRole("MadChat", this.getNomChannel(), "chatter").length == 1) {
            chatter.setOp(true);
        }
        ChatterMessage chatterMessage = new ChatterMessage(chatter, this.getNomChannel());
        madChatHello.broadcastMessage("MadChat", this.getNomChannel(), "chatter", chatterMessage);
    }

    public void insertChatMessage(String string, String string2) {
        Chatter chatter = this.listeIgnored.getByLogin(string);
        if (chatter == null) {
            String string3 = Integer.toHexString(this.tWriteToolbar.getCurrentColor().getRGB()).substring(2);
            string2 = this.filterHTML(string2);
            if (this.config.isTimestamp()) {
                Date date = new Date();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                this.tZoneLecture.insertHTML("<font color=\"white\" size=2>&lt;" + string + " " + simpleDateFormat.format(date) + "&gt;</font> <font color=\"#" + string3 + "\" face=" + this.tWriteToolbar.getPolice() + " size=\"" + this.tWriteToolbar.getTaillePolice() + "\">" + string2 + "</font>");
            } else {
                this.tZoneLecture.insertHTML("<font color=\"white\" size=2>&lt;" + string + "&gt;</font><font color=\"#" + string3 + "\" face=" + this.tWriteToolbar.getPolice() + " size=\"" + this.tWriteToolbar.getTaillePolice() + "\">" + string2 + "</font>");
            }
            System.out.println("Message: " + string2);
        }
    }

    public void insertInfoMessage(String string, String string2) {
        string = this.filterHTML(string);
        this.tZoneLecture.insertHTML("<b><font color=\"" + string2 + "\">" + string + "</font></b>");
        System.out.println("Message: " + string);
    }

    private String filterHTML(String string) {
        String string2 = string.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("\\[g\\]", "<b>");
        string2 = string2.replaceAll("\\[/g\\]", "</b>");
        string2 = string2.replaceAll("\\[i\\]", "<i>");
        string2 = string2.replaceAll("\\[/i\\]", "</i>");
        SmileyTab smileyTab = this.config.getSmileyTab();
        String[] stringArray = smileyTab.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = smileyTab.getPathBySmiley(stringArray[i]);
            if (string3 == null) continue;
            string3 = "<img src=\"" + string3 + "\">";
            int n = string2.indexOf(stringArray[i]);
            if (n == -1) continue;
            int n2 = stringArray[i].length();
            char[] cArray = string2.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n != -1) {
                stringBuffer.append(cArray, n3, n - n3);
                stringBuffer.append(string3);
                n3 = n + n2;
                n = string2.indexOf(stringArray[i], n3);
            }
            stringBuffer.append(cArray, n3, cArray.length - n3);
            string2 = stringBuffer.toString();
        }
        System.out.println(string2);
        return string2;
    }

    public String getNomChannel() {
        return this.nomChannel;
    }

    public ConfigChan getConfigChan() {
        return this.cfgChan;
    }

    public void setConfigChan(ConfigChan configChan) {
        this.cfgChan = configChan;
    }

    public String getConversation() {
        return this.tZoneLecture.getText();
    }

    public void gestionIgnored() {
        PanneauIgnored panneauIgnored = new PanneauIgnored(this.config, this.listeChatter, this.listeIgnored);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Chatter chatter;
        if (actionEvent.getSource() == this.tZoneEcriture) {
            String string = this.tZoneEcriture.getText();
            ChatMessage chatMessage = new ChatMessage(this.config.getLogin(), this.getNomChannel(), string);
            this.config.getChatAgent().broadcastMessage("MadChat", this.getNomChannel(), "chatter", (Message)chatMessage);
            if (this.historique.size() == this.tailleMaxHistorique) {
                this.historique.remove(this.historique.size() - 1);
            }
            this.historique.add(0, string);
            this.indexHistorique = -1;
            this.tZoneEcriture.setText("");
        } else if (actionEvent.getSource() == this.menuOP) {
            if (!this.lZoneListeChatter.isSelectionEmpty()) {
                if (this.getMe().isOp()) {
                    if (!((Chatter)this.lZoneListeChatter.getSelectedValue()).isOp()) {
                        MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
                        CommandMessage commandMessage = new CommandMessage(this.config.getChatAgent().getAddress(), 32, madChatHello.getDisplay().getCurrentChan().getNomChannel(), ((Chatter)this.lZoneListeChatter.getSelectedValue()).getNom());
                        madChatHello.broadcastMessage("MadChat", madChatHello.getDisplay().getCurrentChan().getNomChannel(), "chatter", commandMessage);
                    } else {
                        this.insertInfoMessage("OP failed : " + ((Chatter)this.lZoneListeChatter.getSelectedValue()).getNom() + " est deja Operateur !", "orange");
                    }
                } else {
                    this.insertInfoMessage("OP failed : Vous n'etes pas OP !", "red");
                }
            }
        } else if (actionEvent.getSource() == this.menuDEOP) {
            if (!this.lZoneListeChatter.isSelectionEmpty()) {
                if (this.getMe().isOp()) {
                    if (((Chatter)this.lZoneListeChatter.getSelectedValue()).isOp()) {
                        MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
                        CommandMessage commandMessage = new CommandMessage(this.config.getChatAgent().getAddress(), 33, madChatHello.getDisplay().getCurrentChan().getNomChannel(), ((Chatter)this.lZoneListeChatter.getSelectedValue()).getNom());
                        madChatHello.broadcastMessage("MadChat", madChatHello.getDisplay().getCurrentChan().getNomChannel(), "chatter", commandMessage);
                    } else {
                        this.insertInfoMessage("DEOP failed :" + ((Chatter)this.lZoneListeChatter.getSelectedValue()).getNom() + " n'est pas Operateur !", "orange");
                    }
                } else {
                    this.insertInfoMessage("DEOP failed : Vous n'etes pas OP !", "red");
                }
            }
        } else if (actionEvent.getSource() == this.menuSlap) {
            MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
            CommandMessage commandMessage = new CommandMessage(this.config.getChatAgent().getAddress(), 34, madChatHello.getDisplay().getCurrentChan().getNomChannel(), ((Chatter)this.lZoneListeChatter.getSelectedValue()).getNom());
            madChatHello.broadcastMessage("MadChat", madChatHello.getDisplay().getCurrentChan().getNomChannel(), "chatter", commandMessage);
        } else if (actionEvent.getSource() == this.menuKick) {
            MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
            CommandMessage commandMessage = new CommandMessage(this.config.getChatAgent().getAddress(), 35, madChatHello.getDisplay().getCurrentChan().getNomChannel(), ((Chatter)this.lZoneListeChatter.getSelectedValue()).getNom());
            madChatHello.broadcastMessage("MadChat", madChatHello.getDisplay().getCurrentChan().getNomChannel(), "chatter", commandMessage);
        } else if (actionEvent.getSource() == this.menuPing) {
            if (!this.lZoneListeChatter.isSelectionEmpty()) {
                MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
                Date date = new Date();
                System.out.println("Time : " + date.getTime());
                CommandMessage commandMessage = new CommandMessage(this.config.getChatAgent().getAddress(), 37, madChatHello.getDisplay().getCurrentChan().getNomChannel(), date.getTime());
                madChatHello.sendMessage(((Chatter)this.lZoneListeChatter.getSelectedValue()).getAdresse(), commandMessage);
            }
        } else if (actionEvent.getSource() == this.menuWhois) {
            if (!this.lZoneListeChatter.isSelectionEmpty()) {
                MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
                CommandMessage commandMessage = new CommandMessage(this.config.getChatAgent().getAddress(), 38, madChatHello.getDisplay().getCurrentChan().getNomChannel(), ((Chatter)this.lZoneListeChatter.getSelectedValue()).getNom());
                madChatHello.sendMessage(((Chatter)this.lZoneListeChatter.getSelectedValue()).getAdresse(), commandMessage);
            }
        } else if (actionEvent.getSource() == this.menuIgnore && (chatter = (Chatter)this.lZoneListeChatter.getSelectedValue()) != null) {
            if (!chatter.getNom().equals(this.config.getLogin())) {
                System.out.println("ds la liste " + this.listeIgnored.isInList(chatter.getNom()));
                if (!this.listeIgnored.isInList(chatter.getNom())) {
                    this.listeIgnored.add(chatter);
                    this.insertInfoMessage(chatter.getNom() + " est maintenant inscrit sur la liste des ignores, vous ne recevrez plus ses messages.", "yellow");
                } else {
                    this.listeIgnored.remove(chatter);
                    this.insertInfoMessage(chatter.getNom() + " a ete enleve de la liste des ignores, vous recevrez maintenant ses messages.", "yellow");
                }
            } else {
                this.insertInfoMessage("Vous ne pouvez pas vous ignorer vous meme.", "yellow");
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            System.out.println("Histo : " + this.indexHistorique + " " + (this.historique.size() - 1));
            if (this.indexHistorique < this.historique.size() - 1) {
                ++this.indexHistorique;
            }
            String string = (String)this.historique.get(this.indexHistorique);
            this.tZoneEcriture.setText(string);
        } else if (keyEvent.getKeyCode() == 40) {
            if (this.indexHistorique > -1) {
                --this.indexHistorique;
            }
            String string = this.indexHistorique > -1 ? (String)this.historique.get(this.indexHistorique) : "";
            this.tZoneEcriture.setText(string);
        }
    }

    public Chatter getMe() {
        return this.listeChatter.getByLogin(this.config.getLogin());
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.lZoneListeChatter) {
            JList jList = (JList)mouseEvent.getSource();
            if (mouseEvent.getClickCount() == 2) {
                int n = jList.locationToIndex(mouseEvent.getPoint());
                Chatter chatter = (Chatter)jList.getSelectedValue();
                CommandMessage commandMessage = new CommandMessage(this.config.getChatAgent().getAddress(), 1, this.getNomChannel(), null);
                this.config.getChatAgent().sendMessage(chatter.getAdresse(), (Message)commandMessage);
            } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                try {
                    Robot robot = new Robot();
                    robot.mousePress(16);
                    robot.mouseRelease(16);
                }
                catch (AWTException aWTException) {}
            }
        } else if (mouseEvent.getSource() == this.tZoneLecture && mouseEvent.getClickCount() == 2) {
            Chatter chatter = this.listeChatter.getByLogin(this.config.getLogin());
            PanneauTopic panneauTopic = new PanneauTopic(this.config, this.getConfigChan(), chatter.isOp());
            panneauTopic.pack();
            panneauTopic.setTitle("Informations de " + this.nomChannel);
            panneauTopic.show();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.lZoneListeChatter) {
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void configChanged(String string) {
        if (string.equals("background")) {
            String string2 = this.tZoneLecture.getText();
            this.tZoneLecture.setText("");
            if (this.config.getOsName().startsWith("Windows")) {
                this.tZoneLecture.insertHTML("<body background=\"file:///" + this.config.getBackground() + "\">");
            } else {
                this.tZoneLecture.insertHTML("<body background=\"file://" + this.config.getBackground() + "\">");
            }
            this.tZoneEcriture.setText("");
            this.tZoneLecture.insertHTML(string2);
        } else if (string.equals("login")) {
            MadChatHello madChatHello = (MadChatHello)this.config.getChatAgent();
            CommandMessage commandMessage = new CommandMessage(this.config.getChatAgent().getAddress(), 31, this.getNomChannel(), this.config.getLogin());
            madChatHello.broadcastMessage("MadChat", this.getNomChannel(), "chatter", commandMessage);
        } else if (string.equals("theme")) {
            System.out.println("theme change");
        }
    }
}

