/*
 * Decompiled with CFR 0.152.
 */
package madkit.desktopicon;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class DesktopIcon
extends JInternalFrame
implements InternalFrameListener,
MouseInputListener {
    public static final Color SELECT_COLOR = new Color(0, 0, 0, 50);
    public static final Color UNSELECT_COLOR = new Color(0, 0, 0, 0);
    JPopupMenu popupMenu;
    JLabel imglabel;
    int refX = 0;
    int refY = 0;
    String command = null;
    String type;
    LinkedList actionListener = new LinkedList();

    public DesktopIcon() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        InternalFrameUI internalFrameUI = this.getUI();
        ((BasicInternalFrameUI)internalFrameUI).setNorthPane(null);
        this.setSize(64, 64);
        this.setBackground(UNSELECT_COLOR);
        this.setOpaque(false);
        this.imglabel = new JLabel(" ");
        this.imglabel.setHorizontalAlignment(0);
        this.imglabel.setVerticalTextPosition(3);
        this.imglabel.setHorizontalTextPosition(0);
        this.imglabel.setSize(64, 64);
        this.getContentPane().add(this.imglabel);
        this.setLayer(JLayeredPane.DEFAULT_LAYER);
        this.imglabel.addMouseListener(this);
        this.imglabel.addMouseMotionListener(this);
        this.addInternalFrameListener(this);
    }

    public void setIcon(byte[] byArray) {
        ImageIcon imageIcon = new ImageIcon(byArray);
        this.imglabel.setIcon(imageIcon);
    }

    public void setIcon(ImageIcon imageIcon) {
        this.imglabel.setIcon(imageIcon);
    }

    public void setLabel(String string) {
        this.imglabel.setText(string);
    }

    public void setToolTipText(String string) {
        this.imglabel.setToolTipText(string);
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public String getActionCommand() {
        if (this.command == null) {
            return this.imglabel.getText();
        }
        return this.command;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener.add(actionListener);
    }

    public boolean removeActionListener(ActionListener actionListener) {
        return this.actionListener.remove(actionListener);
    }

    public void addMenuItem(JMenuItem jMenuItem) {
        if (jMenuItem != null) {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
            }
            this.popupMenu.add(jMenuItem);
        }
    }

    public void addSeparator() {
        this.popupMenu.addSeparator();
    }

    public void removeMenuItem(JMenuItem jMenuItem) {
        this.popupMenu.remove(jMenuItem);
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.setBackground(SELECT_COLOR);
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        this.setBackground(UNSELECT_COLOR);
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.refX = mouseEvent.getX();
        this.refY = mouseEvent.getY();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.getLayer() == JLayeredPane.DEFAULT_LAYER.intValue()) {
            this.setLayer(JLayeredPane.POPUP_LAYER);
        }
        this.setLocation(this.getX() + mouseEvent.getX() - this.refX, this.getY() + mouseEvent.getY() - this.refY);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2) {
            Iterator iterator = this.actionListener.iterator();
            while (iterator.hasNext()) {
                ((ActionListener)iterator.next()).actionPerformed(new ActionEvent(this, 0, this.command, mouseEvent.getModifiers()));
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setLayer(JLayeredPane.DEFAULT_LAYER);
        if (mouseEvent.getModifiers() == 4 && this.popupMenu != null) {
            this.popupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

