/*
 * Decompiled with CFR 0.152.
 */
package madkit.desktop2;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import madkit.desktop2.DesktopAgentGUI;
import madkit.desktop2.DesktopBooter;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.kernel.Utils;

public class DesktopAgent
extends Agent {
    protected DesktopAgentGUI desktop;
    public static String VERSION = "2.1";

    public void initGUI() {
        this.desktop = new DesktopAgentGUI(this);
        this.setGUIObject(this.desktop);
    }

    public void activate() {
        DesktopBooter.setDesktopAgent(this);
        this.desktop.init();
        this.requestRole("system", "desktop", null);
    }

    public void live() {
        while (true) {
            Message message = this.waitNextMessage();
            this.handleMessage(message);
        }
    }

    protected void handleMessage(Message message) {
        if (message.getClass().getName().equals("SEdit.SEditMessage")) {
            try {
                Class clazz = Utils.loadClass((String)"SEdit.SEditTools");
                Class[] classArray = new Class[]{Utils.loadClass((String)"madkit.kernel.AbstractAgent"), Utils.loadClass((String)"madkit.kernel.Message")};
                Method method = clazz.getMethod("createStructure", classArray);
                method.invoke((Object)clazz, new Object[]{this, message});
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Error: SEdit not installed");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("Internal error with SEdit " + noSuchMethodException + message);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Internal error with SEdit " + invocationTargetException + message);
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Internal error with SEdit " + illegalAccessException);
            }
        } else if (message instanceof StringMessage) {
            this.handleMessage((StringMessage)message);
        }
    }

    protected void handleMessage(StringMessage stringMessage) {
    }

    protected void addAgent(AbstractAgent abstractAgent, Component component, Point point, Dimension dimension) {
        this.desktop.addAgent(abstractAgent, component, point, dimension);
    }

    protected void removeGUI(Component component) {
        this.desktop.removeGUI(component);
    }

    public void windowClosing(AWTEvent aWTEvent) {
        if (this.desktop != null) {
            this.desktop.quitMadkit();
        } else {
            System.exit(0);
        }
    }
}

