/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.python.core.Options;
import org.python.core.PackageManager;
import org.python.core.PollingInputStream;
import org.python.core.Py;
import org.python.core.PyEllipsis;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFrame;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySingleton;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySyntaxError;
import org.python.core.PySystemStateFunctions;
import org.python.core.PyTuple;
import org.python.core.PythonTraceFunction;
import org.python.core.StderrWrapper;
import org.python.core.StdoutWrapper;
import org.python.core.SysPackageManager;
import org.python.core.TraceFunction;
import org.python.core.codecs;
import org.python.modules.Setup;

public class PySystemState
extends PyObject {
    public static String version = "2.1a3";
    private static int PY_MAJOR_VERSION = 2;
    private static int PY_MINOR_VERSION = 1;
    private static int PY_MICRO_VERSION = 0;
    private static int PY_RELEASE_LEVEL = 10;
    private static int PY_RELEASE_SERIAL = 3;
    public static int hexversion = PY_MAJOR_VERSION << 24 | PY_MINOR_VERSION << 16 | PY_MICRO_VERSION << 8 | PY_RELEASE_LEVEL << 4 | PY_RELEASE_SERIAL;
    public static PyTuple version_info;
    public static String copyright;
    public static String platform;
    public static int maxint;
    public static int minint;
    public static PyList warnoptions;
    private static PyJavaClass __builtin__class;
    private static PyList defaultPath;
    private static PyList defaultArgv;
    public static Properties registry;
    public static String prefix;
    public static String exec_prefix;
    private static boolean initialized;
    public static PackageManager packageManager;
    public static File cachedir;
    private static Hashtable builtinNames;
    public static String[] builtin_module_names;
    public PyList argv = new PyList();
    public PyObject modules;
    public PyList path;
    public PyObject builtins;
    public PyObject ps1 = new PyString(">>> ");
    public PyObject ps2 = new PyString("... ");
    public PyObject executable = Py.None;
    private ClassLoader classLoader = null;
    public PyObject stdout;
    public PyObject stderr;
    public PyObject stdin;
    public PyObject __stdout__;
    public PyObject __stderr__;
    public PyObject __stdin__;
    public PyObject last_value = Py.None;
    public PyObject last_type = Py.None;
    public PyObject last_traceback = Py.None;
    public PyObject __dict__;
    public TraceFunction tracefunc = null;
    public TraceFunction profilefunc = null;
    private static /* synthetic */ Class class$Lorg$python$core$__builtin__;

    public static void exit(PyObject pyObject) {
        throw new PyException(Py.SystemExit, pyObject);
    }

    public static void exit() {
        PySystemState.exit(Py.None);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static PyTuple exc_info() {
        PyException pyException = Py.getThreadState().exception;
        if (pyException == null) {
            return new PyTuple(new PyObject[]{Py.None, Py.None, Py.None});
        }
        return new PyTuple(new PyObject[]{pyException.type, pyException.value, pyException.traceback});
    }

    public static PyFrame _getframe() {
        return PySystemState._getframe(-1);
    }

    public static PyFrame _getframe(int n) {
        PyFrame pyFrame = Py.getFrame();
        while (n > 0 && pyFrame != null) {
            pyFrame = pyFrame.f_back;
            --n;
        }
        if (pyFrame == null) {
            throw Py.ValueError("call stack is not deep enough");
        }
        return pyFrame;
    }

    public PyObject __findattr__(String string) {
        if (string == "exc_value") {
            PyException pyException = Py.getThreadState().exception;
            if (pyException == null) {
                return null;
            }
            return pyException.value;
        }
        if (string == "exc_type") {
            PyException pyException = Py.getThreadState().exception;
            if (pyException == null) {
                return null;
            }
            return pyException.type;
        }
        if (string == "exc_traceback") {
            PyException pyException = Py.getThreadState().exception;
            if (pyException == null) {
                return null;
            }
            return pyException.traceback;
        }
        if (string == "warnoptions") {
            if (warnoptions == null) {
                warnoptions = new PyList();
            }
            return warnoptions;
        }
        PyObject pyObject = super.__findattr__(string);
        if (pyObject != null) {
            return pyObject;
        }
        return this.__dict__.__finditem__(string);
    }

    public void __setattr__(String string, PyObject pyObject) {
        if (this.__class__ == null) {
            return;
        }
        PyObject pyObject2 = this.__class__.lookup(string, false);
        if (pyObject2 != null) {
            pyObject2._doset(this, pyObject);
            return;
        }
        if (this.__dict__ == null) {
            this.__dict__ = new PyStringMap();
        }
        this.__dict__.__setitem__(string, pyObject);
    }

    public void __delattr__(String string) {
        if (this.__dict__ != null) {
            this.__dict__.__delitem__(string);
            return;
        }
        throw Py.AttributeError("del '" + string + "'");
    }

    protected String safeRepr() {
        return "module 'sys'";
    }

    public String toString() {
        return "sys module";
    }

    private static String findRoot(Properties properties, Properties properties2) {
        String string;
        String string2 = null;
        try {
            String string3;
            if (properties2 != null) {
                string2 = properties2.getProperty("python.home");
            }
            if (string2 == null) {
                string2 = properties.getProperty("python.home");
            }
            if (string2 == null) {
                string2 = properties.getProperty("install.root");
            }
            if ((string = properties.getProperty("java.version")) == null) {
                string = "???";
            }
            if ((string3 = string.toLowerCase()).startsWith("java")) {
                string = string.substring(4, string.length());
            }
            if (string3.startsWith("jdk") || string3.startsWith("jre")) {
                string = string.substring(3, string.length());
            }
            if (string.equals("11")) {
                string = "1.1";
            }
            if (string.equals("12")) {
                string = "1.2";
            }
            if (string != null) {
                platform = "java" + string;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (string2 != null) {
            return string2;
        }
        string = properties.getProperty("java.class.path");
        if (string == null) {
            return null;
        }
        int n = string.toLowerCase().indexOf("jython.jar");
        if (n == -1) {
            return null;
        }
        int n2 = string.lastIndexOf(File.pathSeparator, n) + 1;
        return string.substring(n2, n);
    }

    private static void initRegistry(Properties properties, Properties properties2) {
        Object object;
        if (registry != null) {
            Py.writeError("systemState", "trying to reinitialize registry");
            return;
        }
        registry = properties;
        exec_prefix = PySystemState.findRoot(properties, properties2);
        prefix = exec_prefix;
        if (prefix != null) {
            if (prefix.length() == 0) {
                exec_prefix = ".";
                prefix = ".";
            }
            try {
                PySystemState.addRegistryFile(new File(prefix, "registry"));
                object = new File(registry.getProperty("user.home"), ".jython");
                PySystemState.addRegistryFile((File)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (properties2 != null) {
            object = properties2.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                String string2 = (String)properties2.get(string);
                registry.put(string, string2);
            }
        }
        Options.setFromRegistry();
    }

    private static void addRegistryFile(File file) {
        if (file.exists()) {
            registry = new Properties(registry);
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    registry.load(fileInputStream);
                }
                finally {
                    Object var3_3 = null;
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("couldn't open registry file: " + file.toString());
            }
        }
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        PySystemState.initialize(System.getProperties(), null, new String[]{""});
    }

    public static synchronized void initialize(Properties properties, Properties properties2, String[] stringArray) {
        PySystemState.initialize(properties, properties2, stringArray, null);
    }

    public static synchronized void initialize(Properties properties, Properties properties2, String[] stringArray, ClassLoader classLoader) {
        if (initialized) {
            if (properties2 != null) {
                Py.writeError("systemState", "trying to reinitialize with new properties");
            }
            return;
        }
        initialized = true;
        PySystemState.initRegistry(properties, properties2);
        PySystemState.initBuiltins(registry);
        PySystemState.initStaticFields();
        defaultPath = PySystemState.initPath(registry);
        defaultArgv = PySystemState.initArgv(stringArray);
        PySystemState.initPackages(registry);
        Py.defaultSystemState = new PySystemState();
        Py.setSystemState(Py.defaultSystemState);
        if (classLoader != null) {
            Py.defaultSystemState.setClassLoader(classLoader);
        }
        Py.initClassExceptions(__builtin__class.__getattr__("__dict__"));
        PySyntaxError pySyntaxError = new PySyntaxError("", 1, 1, "", "");
    }

    private static void initStaticFields() {
        Py.None = new PyNone();
        Py.NoKeywords = new String[0];
        Py.EmptyObjects = new PyObject[0];
        Py.EmptyTuple = new PyTuple(Py.EmptyObjects);
        Py.NoConversion = new PySingleton("Error");
        Py.Ellipsis = new PyEllipsis();
        Py.Zero = new PyInteger(0);
        Py.One = new PyInteger(1);
        Py.EmptyString = new PyString("");
        Py.Newline = new PyString("\n");
        Py.Space = new PyString(" ");
        __builtin__class = PyJavaClass.lookup(class$Lorg$python$core$__builtin__ != null ? class$Lorg$python$core$__builtin__ : (class$Lorg$python$core$__builtin__ = PySystemState.class$("org.python.core.__builtin__")));
        Py.stderr = new StderrWrapper();
        Py.stdout = new StdoutWrapper();
        String string = null;
        if (PY_RELEASE_LEVEL == 10) {
            string = "alpha";
        } else if (PY_RELEASE_LEVEL == 11) {
            string = "beta";
        } else if (PY_RELEASE_LEVEL == 12) {
            string = "candidate";
        } else if (PY_RELEASE_LEVEL == 12) {
            string = "final";
        }
        version_info = new PyTuple(new PyObject[]{Py.newInteger(PY_MAJOR_VERSION), Py.newInteger(PY_MINOR_VERSION), Py.newInteger(PY_MICRO_VERSION), Py.newString(string), Py.newInteger(PY_RELEASE_SERIAL)});
    }

    private static void initCacheDirectory(Properties properties) {
        if (Py.frozen) {
            cachedir = null;
            return;
        }
        cachedir = new File(properties.getProperty("python.cachedir", "cachedir"));
        if (!cachedir.isAbsolute()) {
            cachedir = new File(prefix, cachedir.getPath());
        }
    }

    private static void initPackages(Properties properties) {
        PySystemState.initCacheDirectory(properties);
        File file = cachedir != null ? new File(cachedir, "packages") : null;
        packageManager = new SysPackageManager(file, properties);
    }

    private static PyList initArgv(String[] stringArray) {
        PyList pyList = new PyList();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                pyList.append(new PyString(stringArray[n]));
                ++n;
            }
        }
        return pyList;
    }

    private static void addBuiltin(String string) {
        String string2;
        String string3;
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(0, n).trim();
            string2 = string.substring(n + 1, string.length()).trim();
            if (string2.equals("null")) {
                string2 = null;
            }
        } else {
            string3 = string.trim();
            string2 = "org.python.modules." + string3;
        }
        if (string2 != null) {
            builtinNames.put(string3, string2);
        } else {
            builtinNames.remove(string3);
        }
    }

    private static void initBuiltins(Properties properties) {
        builtinNames = new Hashtable();
        int n = 0;
        while (n < Setup.builtinModules.length) {
            PySystemState.addBuiltin(Setup.builtinModules[n]);
            ++n;
        }
        String string = properties.getProperty("python.modules.builtin", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            PySystemState.addBuiltin(stringTokenizer.nextToken());
        }
        int n2 = builtinNames.size();
        builtin_module_names = new String[n2];
        Enumeration enumeration = builtinNames.keys();
        int n3 = 0;
        while (n3 < n2) {
            PySystemState.builtin_module_names[n3] = (String)enumeration.nextElement();
            ++n3;
        }
    }

    static String getBuiltin(String string) {
        return (String)builtinNames.get(string);
    }

    private static PyList initPath(Properties properties) {
        PyList pyList = new PyList();
        if (!Py.frozen) {
            PySystemState.addPaths(pyList, properties.getProperty("python.prepath", "."));
            if (prefix != null) {
                String string = new File(prefix, "Lib").toString();
                pyList.append(new PyString(string));
            }
            PySystemState.addPaths(pyList, properties.getProperty("python.path", ""));
        }
        return pyList;
    }

    private static void addPaths(PyList pyList, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            pyList.append(new PyString(stringTokenizer.nextToken().trim()));
        }
    }

    public static PyJavaPackage add_package(String string) {
        return PySystemState.add_package(string, null);
    }

    public static PyJavaPackage add_package(String string, String string2) {
        return packageManager.makeJavaPackage(string, string2, null);
    }

    public static void add_classdir(String string) {
        packageManager.addDirectory(new File(string));
    }

    public static void add_extdir(String string) {
        packageManager.addJarDir(string);
    }

    public void settrace(PyObject pyObject) {
        this.tracefunc = pyObject == Py.None ? null : new PythonTraceFunction(pyObject);
    }

    public void setprofile(PyObject pyObject) {
        this.profilefunc = pyObject == Py.None ? null : new PythonTraceFunction(pyObject);
    }

    private InputStream getSystemIn() {
        if (Options.pollStandardIn) {
            return new PollingInputStream(System.in);
        }
        return System.in;
    }

    public String getdefaultencoding() {
        return codecs.getDefaultEncoding();
    }

    public void setdefaultencoding(String string) {
        codecs.setDefaultEncoding(string);
    }

    static void displayhook(PyObject pyObject) {
        if (pyObject == Py.None) {
            return;
        }
        PySystemState pySystemState = Py.getThreadState().systemState;
        pySystemState.builtins.__setitem__("_", Py.None);
        Py.stdout.println(pyObject.__repr__());
        pySystemState.builtins.__setitem__("_", pyObject);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PySystemState() {
        PySystemState.initialize();
        this.modules = new PyStringMap();
        this.argv = (PyList)defaultArgv.repeat(1);
        this.path = (PyList)defaultPath.repeat(1);
        this.__stdout__ = this.stdout = new PyFile(System.out, "<stdout>");
        this.__stderr__ = this.stderr = new PyFile(System.err, "<stderr>");
        this.__stdin__ = this.stdin = new PyFile(this.getSystemIn(), "<stdin>");
        this.builtins = __builtin__class.__getattr__("__dict__");
        PyModule pyModule = new PyModule("__builtin__", this.builtins);
        this.modules.__setitem__("__builtin__", (PyObject)pyModule);
        if (this.__class__ != null) {
            this.__dict__ = new PyStringMap();
            this.__dict__.invoke("update", this.__class__.__getattr__("__dict__"));
            this.__dict__.__setitem__("displayhook", (PyObject)new PySystemStateFunctions("displayhook", 10, 1, 1));
        }
    }

    static {
        copyright = "Copyright (c) 2000, Jython Developers\nAll rights reserved.\n\nCopyright (c) 2000 BeOpen.com.\nAll Rights Reserved.\n\nCopyright (c) 2000 The Apache Software Foundation.  All rights\nreserved.\n\nCopyright (c) 1995-2000 Corporation for National Research Initiatives.\nAll Rights Reserved.\n\nCopyright (c) 1991-1995 Stichting Mathematisch Centrum, Amsterdam.\nAll Rights Reserved.\n\n";
        platform = "java";
        maxint = Integer.MAX_VALUE;
        minint = Integer.MIN_VALUE;
        exec_prefix = "";
        initialized = false;
        builtin_module_names = null;
    }
}

