/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.Stack;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.Future;
import org.python.compiler.ScopeConstants;
import org.python.compiler.ScopeInfo;
import org.python.core.parser;
import org.python.parser.ParseException;
import org.python.parser.SimpleNode;
import org.python.parser.Visitor;

public class ScopesCompiler
extends Visitor
implements ScopeConstants {
    private static final int GET = 0;
    private static final int SET = 1;
    private static final int DEL = 2;
    private static final int AUGSET = 4;
    private CompilationContext code_compiler;
    private boolean nested_scopes = false;
    private Stack scopes;
    private ScopeInfo cur = null;
    private int mode;
    private int level = 0;
    private int func_level = 0;

    public Object set(SimpleNode simpleNode) throws Exception {
        return this.modal(simpleNode, 1);
    }

    public Object del(SimpleNode simpleNode) throws Exception {
        return this.modal(simpleNode, 2);
    }

    public Object augset(SimpleNode simpleNode) throws Exception {
        return this.modal(simpleNode, 4);
    }

    public Object modal(SimpleNode simpleNode, int n) throws Exception {
        this.mode = n;
        simpleNode.visit(this);
        this.mode = 0;
        return null;
    }

    public void beginScope(String string, int n, SimpleNode simpleNode, ArgListCompiler argListCompiler) {
        if (this.cur != null) {
            this.scopes.push(this.cur);
        }
        if (n == 1) {
            ++this.func_level;
        }
        simpleNode.scope = this.cur = new ScopeInfo(string, simpleNode, this.level++, n, this.func_level, argListCompiler, this.nested_scopes);
    }

    public void endScope() throws Exception {
        if (this.cur.kind == 1) {
            --this.func_level;
        }
        --this.level;
        ScopeInfo scopeInfo = !this.scopes.empty() ? (ScopeInfo)this.scopes.pop() : null;
        this.cur.cook(scopeInfo, this.code_compiler);
        this.cur.dump();
        this.cur = scopeInfo;
    }

    public void parse(SimpleNode simpleNode) throws Exception {
        try {
            simpleNode.visit(this);
        }
        catch (Throwable throwable) {
            throw parser.fixParseError(null, throwable, this.code_compiler.getFilename());
        }
    }

    public Object single_input(SimpleNode simpleNode) throws Exception {
        this.beginScope("<single-top>", 0, simpleNode, null);
        this.suite(simpleNode);
        this.endScope();
        return null;
    }

    public Object file_input(SimpleNode simpleNode) throws Exception {
        this.beginScope("<file-top>", 0, simpleNode, null);
        this.suite(simpleNode);
        this.endScope();
        return null;
    }

    public Object eval_input(SimpleNode simpleNode) throws Exception {
        this.beginScope("<eval-top>", 0, simpleNode, null);
        this.return_stmt(simpleNode);
        this.endScope();
        return null;
    }

    private String def(SimpleNode simpleNode) {
        String string = (String)simpleNode.getChild(0).getInfo();
        this.cur.addBound(string);
        return string;
    }

    public Object funcdef(SimpleNode simpleNode) throws Exception {
        SimpleNode simpleNode2;
        String string = this.def(simpleNode);
        ArgListCompiler argListCompiler = new ArgListCompiler();
        if (simpleNode.getNumChildren() == 3) {
            simpleNode2 = simpleNode.getChild(2);
            simpleNode.getChild(1).visit(argListCompiler);
        } else {
            simpleNode2 = simpleNode.getChild(1);
        }
        SimpleNode[] simpleNodeArray = argListCompiler.getDefaults();
        int n = simpleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            simpleNodeArray[n2].visit(this);
            ++n2;
        }
        this.beginScope(string, 1, simpleNode, argListCompiler);
        n2 = argListCompiler.names.size();
        int n3 = 0;
        while (n3 < n2) {
            this.cur.addParam((String)argListCompiler.names.elementAt(n3));
            ++n3;
        }
        argListCompiler.init_code.visit(this);
        this.cur.markFromParam();
        simpleNode2.visit(this);
        this.endScope();
        return null;
    }

    public Object expr_stmt(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        simpleNode.getChild(n - 1).visit(this);
        int n2 = 0;
        while (n2 < n - 1) {
            this.set(simpleNode.getChild(n2));
            ++n2;
        }
        return null;
    }

    public Object print_ext(SimpleNode simpleNode) throws Exception {
        simpleNode.getChild(0).visit(this);
        return null;
    }

    public Object print_stmt(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n - 1) {
                simpleNode.getChild(n2).visit(this);
                ++n2;
            }
            if (simpleNode.getChild((int)(n - 1)).id != 84) {
                simpleNode.getChild(n - 1).visit(this);
            }
        }
        return null;
    }

    public Object del_stmt(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        int n2 = 0;
        while (n2 < n) {
            this.del(simpleNode.getChild(n2));
            ++n2;
        }
        return null;
    }

    public Object pass_stmt(SimpleNode simpleNode) throws Exception {
        return null;
    }

    public Object break_stmt(SimpleNode simpleNode) throws Exception {
        return null;
    }

    public Object continue_stmt(SimpleNode simpleNode) throws Exception {
        return null;
    }

    public Object return_stmt(SimpleNode simpleNode) throws Exception {
        if (simpleNode.getNumChildren() == 1) {
            simpleNode.getChild(0).visit(this);
        }
        return null;
    }

    public void stmt(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        int n2 = 0;
        while (n2 < n) {
            simpleNode.getChild(n2).visit(this);
            ++n2;
        }
    }

    public Object raise_stmt(SimpleNode simpleNode) throws Exception {
        this.stmt(simpleNode);
        return null;
    }

    public Object Import(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        int n2 = 0;
        while (n2 < n) {
            SimpleNode simpleNode2 = simpleNode.getChild(n2);
            switch (simpleNode2.id) {
                case 33: {
                    this.cur.addBound((String)simpleNode2.getChild(0).getInfo());
                    break;
                }
                case 32: {
                    this.cur.addBound((String)simpleNode2.getChild(1).getInfo());
                    break;
                }
            }
            ++n2;
        }
        return null;
    }

    public Object ImportFrom(SimpleNode simpleNode) throws Exception {
        Future.checkFromFuture(simpleNode);
        int n = simpleNode.getNumChildren();
        if (n == 1) {
            this.cur.from_import_star = true;
            return null;
        }
        int n2 = 1;
        while (n2 < n) {
            SimpleNode simpleNode2 = simpleNode.getChild(n2);
            switch (simpleNode2.id) {
                case 94: {
                    this.cur.addBound((String)simpleNode2.getInfo());
                    break;
                }
                case 34: {
                    this.cur.addBound((String)simpleNode2.getChild(1).getInfo());
                    break;
                }
            }
            ++n2;
        }
        return null;
    }

    public Object global_stmt(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)simpleNode.getChild(n2).getInfo();
            int n3 = this.cur.addGlobal(string);
            if (n3 >= 0) {
                if ((n3 & 8) != 0) {
                    this.code_compiler.error("name '" + string + "' is local and global", true, simpleNode);
                }
                if ((n3 & 0x42) == 0) {
                    String string2 = (n3 & 1) != 0 ? "assignment" : "use";
                    this.code_compiler.error("name '" + string + "' declared global after " + string2, false, simpleNode);
                }
            }
            ++n2;
        }
        return null;
    }

    public Object exec_stmt(SimpleNode simpleNode) throws Exception {
        this.cur.exec = true;
        int n = simpleNode.getNumChildren();
        if (n == 1) {
            this.cur.unqual_exec = true;
        }
        int n2 = 0;
        while (n2 < n) {
            simpleNode.getChild(n2).visit(this);
            ++n2;
        }
        return null;
    }

    public Object assert_stmt(SimpleNode simpleNode) throws Exception {
        this.stmt(simpleNode);
        return null;
    }

    public Object if_stmt(SimpleNode simpleNode) throws Exception {
        this.stmt(simpleNode);
        return null;
    }

    public Object while_stmt(SimpleNode simpleNode) throws Exception {
        this.stmt(simpleNode);
        return null;
    }

    public Object for_stmt(SimpleNode simpleNode) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(simpleNode);
        }
        this.set(simpleNode.getChild(0));
        simpleNode.getChild(1).visit(this);
        simpleNode.getChild(2).visit(this);
        if (simpleNode.getNumChildren() > 3) {
            simpleNode.getChild(3).visit(this);
        }
        return null;
    }

    public Object try_stmt(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        int n2 = 0;
        while (n2 < n) {
            if (n2 % 2 == 1 && n2 != n - 1) {
                switch (simpleNode.getChild(n2).getNumChildren()) {
                    case 2: {
                        this.set(simpleNode.getChild(n2).getChild(1));
                    }
                    case 1: {
                        simpleNode.getChild(n2).getChild(0).visit(this);
                    }
                }
            } else {
                simpleNode.getChild(n2).visit(this);
            }
            ++n2;
        }
        return null;
    }

    public Object suite(SimpleNode simpleNode) throws Exception {
        this.stmt(simpleNode);
        return null;
    }

    private static void illassign(SimpleNode simpleNode) throws Exception {
        String string = "operator";
        if (simpleNode.id == 72) {
            string = "function call";
        } else if (simpleNode.id == 40) {
            string = "list comprehension";
        }
        throw new ParseException("can't assign to " + string, simpleNode);
    }

    public void binaryop(SimpleNode simpleNode) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(simpleNode);
        }
        simpleNode.getChild(0).visit(this);
        simpleNode.getChild(1).visit(this);
    }

    public void unaryop(SimpleNode simpleNode) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(simpleNode);
        }
        simpleNode.getChild(0).visit(this);
    }

    public Object or_boolean(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object and_boolean(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object not_1op(SimpleNode simpleNode) throws Exception {
        this.unaryop(simpleNode);
        return null;
    }

    public Object comparision(SimpleNode simpleNode) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(simpleNode);
        }
        int n = simpleNode.getNumChildren();
        int n2 = 0;
        while (n2 < n) {
            if (n2 % 2 == 0) {
                simpleNode.getChild(n2).visit(this);
            }
            ++n2;
        }
        return null;
    }

    public Object or_2op(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object xor_2op(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object and_2op(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object lshift_2op(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object rshift_2op(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object add_2op(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object sub_2op(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object mul_2op(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object div_2op(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object mod_2op(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object pos_1op(SimpleNode simpleNode) throws Exception {
        this.unaryop(simpleNode);
        return null;
    }

    public Object neg_1op(SimpleNode simpleNode) throws Exception {
        this.unaryop(simpleNode);
        return null;
    }

    public Object invert_1op(SimpleNode simpleNode) throws Exception {
        this.unaryop(simpleNode);
        return null;
    }

    public Object pow_2op(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object str_1op(SimpleNode simpleNode) throws Exception {
        this.unaryop(simpleNode);
        return null;
    }

    public Object strjoin(SimpleNode simpleNode) throws Exception {
        this.binaryop(simpleNode);
        return null;
    }

    public Object Call_Op(SimpleNode simpleNode) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(simpleNode);
        }
        simpleNode.getChild(0).visit(this);
        if (simpleNode.getNumChildren() > 1) {
            SimpleNode simpleNode2 = simpleNode.getChild(1);
            int n = simpleNode2.getNumChildren();
            int n2 = 0;
            while (n2 < n) {
                SimpleNode simpleNode3 = simpleNode2.getChild(n2);
                switch (simpleNode3.id) {
                    case 90: {
                        simpleNode3.getChild(1).visit(this);
                        break;
                    }
                    case 88: 
                    case 89: {
                        simpleNode3.getChild(0).visit(this);
                        break;
                    }
                    default: {
                        simpleNode3.visit(this);
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public Object Index_Op(SimpleNode simpleNode) throws Exception {
        int n = this.mode;
        this.mode = 0;
        simpleNode.getChild(0).visit(this);
        simpleNode.getChild(1).visit(this);
        this.mode = n;
        return null;
    }

    public Object Dot_Op(SimpleNode simpleNode) throws Exception {
        int n = this.mode;
        this.mode = 0;
        simpleNode.getChild(0).visit(this);
        this.mode = n;
        return null;
    }

    public Object tuple(SimpleNode simpleNode) throws Exception {
        if (this.mode == 4) {
            throw new ParseException("augmented assign to tuple not possible", simpleNode);
        }
        int n = simpleNode.getNumChildren();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n - 1) {
                simpleNode.getChild(n2).visit(this);
                ++n2;
            }
            if (simpleNode.getChild((int)(n - 1)).id != 84) {
                simpleNode.getChild(n - 1).visit(this);
            }
        }
        return null;
    }

    public Object fplist(SimpleNode simpleNode) throws Exception {
        return this.list(simpleNode);
    }

    public Object list(SimpleNode simpleNode) throws Exception {
        if (this.mode == 4) {
            throw new ParseException("augmented assign to list not possible", simpleNode);
        }
        int n = simpleNode.getNumChildren();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n - 1) {
                simpleNode.getChild(n2).visit(this);
                ++n2;
            }
            if (simpleNode.getChild((int)(n - 1)).id != 84) {
                simpleNode.getChild(n - 1).visit(this);
            }
        }
        return null;
    }

    public Object list_iter(SimpleNode simpleNode) throws Exception {
        if (simpleNode.getNumChildren() == 1) {
            simpleNode.getChild(0).visit(this);
        }
        return null;
    }

    public Object dictionary(SimpleNode simpleNode) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(simpleNode);
        }
        this.stmt(simpleNode);
        return null;
    }

    public Object lambdef(SimpleNode simpleNode) throws Exception {
        SimpleNode simpleNode2;
        if (this.mode != 0) {
            ScopesCompiler.illassign(simpleNode);
        }
        ArgListCompiler argListCompiler = new ArgListCompiler();
        if (simpleNode.getNumChildren() == 2) {
            simpleNode2 = simpleNode.getChild(1);
            simpleNode.getChild(0).visit(argListCompiler);
        } else {
            simpleNode2 = simpleNode.getChild(0);
        }
        SimpleNode[] simpleNodeArray = argListCompiler.getDefaults();
        int n = simpleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            simpleNodeArray[n2].visit(this);
            ++n2;
        }
        this.beginScope("<lambda>", 1, simpleNode, argListCompiler);
        n2 = argListCompiler.names.size();
        int n3 = 0;
        while (n3 < n2) {
            this.cur.addParam((String)argListCompiler.names.elementAt(n3));
            ++n3;
        }
        argListCompiler.init_code.visit(this);
        this.cur.markFromParam();
        simpleNode2.visit(this);
        this.endScope();
        return null;
    }

    public Object Ellipses(SimpleNode simpleNode) throws Exception {
        return null;
    }

    public Object Slice(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        int n2 = 0;
        while (n2 < n) {
            SimpleNode simpleNode2 = simpleNode.getChild(n2);
            if (simpleNode2.id != 83) {
                simpleNode2.visit(this);
            }
            ++n2;
        }
        return null;
    }

    public Object classdef(SimpleNode simpleNode) throws Exception {
        String string = this.def(simpleNode);
        int n = simpleNode.getNumChildren();
        SimpleNode simpleNode2 = simpleNode.getChild(n - 1);
        int n2 = 1;
        while (n2 < n - 1) {
            simpleNode.getChild(n2).visit(this);
            ++n2;
        }
        this.beginScope(string, 2, simpleNode, null);
        simpleNode2.visit(this);
        this.endScope();
        return null;
    }

    public Object Int(SimpleNode simpleNode) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(simpleNode);
        }
        return null;
    }

    public Object Float(SimpleNode simpleNode) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(simpleNode);
        }
        return null;
    }

    public Object Complex(SimpleNode simpleNode) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(simpleNode);
        }
        return null;
    }

    public Object Name(SimpleNode simpleNode) throws Exception {
        String string = (String)simpleNode.getInfo();
        if (this.mode != 0) {
            if (string.equals("__debug__")) {
                this.code_compiler.error("can not assign to __debug__", false, simpleNode);
            }
            this.cur.addBound(string);
        } else {
            this.cur.addUsed(string);
        }
        return null;
    }

    public Object String(SimpleNode simpleNode) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(simpleNode);
        }
        return null;
    }

    public void aug_assign(SimpleNode simpleNode) throws Exception {
        this.augset(simpleNode.getChild(0));
        simpleNode.getChild(1).visit(this);
    }

    public Object aug_plus(SimpleNode simpleNode) throws Exception {
        this.aug_assign(simpleNode);
        return null;
    }

    public Object aug_minus(SimpleNode simpleNode) throws Exception {
        this.aug_assign(simpleNode);
        return null;
    }

    public Object aug_multiply(SimpleNode simpleNode) throws Exception {
        this.aug_assign(simpleNode);
        return null;
    }

    public Object aug_divide(SimpleNode simpleNode) throws Exception {
        this.aug_assign(simpleNode);
        return null;
    }

    public Object aug_modulo(SimpleNode simpleNode) throws Exception {
        this.aug_assign(simpleNode);
        return null;
    }

    public Object aug_and(SimpleNode simpleNode) throws Exception {
        this.aug_assign(simpleNode);
        return null;
    }

    public Object aug_or(SimpleNode simpleNode) throws Exception {
        this.aug_assign(simpleNode);
        return null;
    }

    public Object aug_xor(SimpleNode simpleNode) throws Exception {
        this.aug_assign(simpleNode);
        return null;
    }

    public Object aug_lshift(SimpleNode simpleNode) throws Exception {
        this.aug_assign(simpleNode);
        return null;
    }

    public Object aug_rshift(SimpleNode simpleNode) throws Exception {
        this.aug_assign(simpleNode);
        return null;
    }

    public Object aug_power(SimpleNode simpleNode) throws Exception {
        this.aug_assign(simpleNode);
        return null;
    }

    public ScopesCompiler(CompilationContext compilationContext) {
        this.code_compiler = compilationContext;
        this.scopes = new Stack();
        this.mode = 0;
        this.nested_scopes = compilationContext.getFutures().areNestedScopesOn();
    }
}

