/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.python.compiler.APIVersion;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.ClassFile;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.compiler.Constant;
import org.python.compiler.Label;
import org.python.compiler.PyCodeConstant;
import org.python.compiler.PyComplexConstant;
import org.python.compiler.PyFloatConstant;
import org.python.compiler.PyIntegerConstant;
import org.python.compiler.PyLongConstant;
import org.python.compiler.PyStringConstant;
import org.python.compiler.ScopeInfo;
import org.python.compiler.SourceFile;
import org.python.compiler.SymInfo;
import org.python.core.CompilerFlags;
import org.python.parser.SimpleNode;

public class Module {
    private static final String[] emptyStringAr = new String[0];
    ClassFile classfile;
    Constant filename;
    String sfilename;
    public Constant mainCode;
    public boolean linenumbers;
    public boolean setFile = true;
    Hashtable constants;
    Vector codes;
    private int to_cell;

    private Constant findConstant(Constant constant) {
        Constant constant2 = (Constant)this.constants.get(constant);
        if (constant2 != null) {
            return constant2;
        }
        constant2 = constant;
        constant.module = this;
        constant.name = "_" + this.constants.size();
        this.constants.put(constant2, constant2);
        return constant2;
    }

    public Constant PyInteger(int n) {
        return this.findConstant(new PyIntegerConstant(n));
    }

    public Constant PyFloat(double d) {
        return this.findConstant(new PyFloatConstant(d));
    }

    public Constant PyComplex(double d) {
        return this.findConstant(new PyComplexConstant(d));
    }

    public Constant PyString(String string) {
        return this.findConstant(new PyStringConstant(string));
    }

    public Constant PyLong(String string) {
        return this.findConstant(new PyLongConstant(string));
    }

    private boolean isJavaIdentifier(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            return false;
        }
        int n = 1;
        while (n < cArray.length) {
            if (!Character.isJavaIdentifierPart(cArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String[] toNameAr(Vector vector, boolean bl) {
        int n = vector.size();
        if (n == 0 && bl) {
            return null;
        }
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public PyCodeConstant PyCode(SimpleNode simpleNode, String string, boolean bl, String string2, boolean bl2, boolean bl3, int n, ScopeInfo scopeInfo) throws Exception {
        return this.PyCode(simpleNode, string, bl, string2, bl2, bl3, n, scopeInfo, null);
    }

    public PyCodeConstant PyCode(SimpleNode simpleNode, String string, boolean bl, String string2, boolean bl2, boolean bl3, int n, ScopeInfo scopeInfo, CompilerFlags compilerFlags) throws Exception {
        int n2;
        ArgListCompiler argListCompiler;
        PyCodeConstant pyCodeConstant = new PyCodeConstant();
        ArgListCompiler argListCompiler2 = argListCompiler = scopeInfo != null ? scopeInfo.ac : null;
        if (argListCompiler != null) {
            pyCodeConstant.arglist = argListCompiler.arglist;
            pyCodeConstant.keywordlist = argListCompiler.keywordlist;
            pyCodeConstant.argcount = argListCompiler.names.size();
        }
        pyCodeConstant.co_name = string;
        pyCodeConstant.co_firstlineno = n;
        pyCodeConstant.id = this.codes.size();
        pyCodeConstant.fname = this.isJavaIdentifier(string) ? string + "$" + pyCodeConstant.id : "f$" + pyCodeConstant.id;
        this.codes.addElement(pyCodeConstant);
        Code code = this.classfile.addMethod(pyCodeConstant.fname, "(Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;", 1);
        CodeCompiler codeCompiler = new CodeCompiler(this, bl3);
        if (argListCompiler != null && argListCompiler.init_code.getNumChildren() > 0) {
            argListCompiler.init_code.jjtAddChild(simpleNode, argListCompiler.init_code.getNumChildren());
            simpleNode = argListCompiler.init_code;
        }
        if (scopeInfo != null && (n2 = scopeInfo.jy_paramcells.size()) > 0) {
            if (this.to_cell == 0) {
                this.to_cell = this.classfile.pool.Methodref("org/python/core/PyFrame", "to_cell", "(II)V");
            }
            Hashtable hashtable = scopeInfo.tbl;
            Vector vector = scopeInfo.jy_paramcells;
            int n3 = 0;
            while (n3 < n2) {
                code.aload(1);
                SymInfo symInfo = (SymInfo)hashtable.get(vector.elementAt(n3));
                code.iconst(symInfo.locals_index);
                code.iconst(symInfo.env_index);
                code.invokevirtual(this.to_cell);
                ++n3;
            }
        }
        codeCompiler.parse(simpleNode, code, bl, string2, bl2, scopeInfo, compilerFlags);
        if (!bl2) {
            pyCodeConstant.names = this.toNameAr(codeCompiler.names, false);
        }
        if (scopeInfo != null) {
            pyCodeConstant.cellvars = this.toNameAr(scopeInfo.cellvars, true);
            pyCodeConstant.freevars = this.toNameAr(scopeInfo.freevars, true);
            pyCodeConstant.jy_npurecell = scopeInfo.jy_npurecell;
        }
        if (codeCompiler.optimizeGlobals) {
            pyCodeConstant.moreflags |= 1;
        }
        if (codeCompiler.my_scope.nested_scopes) {
            pyCodeConstant.moreflags |= 0x10;
        }
        pyCodeConstant.module = this;
        pyCodeConstant.name = pyCodeConstant.fname;
        return pyCodeConstant;
    }

    public void addInit() throws IOException {
        Code code = this.classfile.addMethod("<init>", "()V", 1);
        code.aload(0);
        code.invokespecial(code.pool.Methodref("org/python/core/PyFunctionTable", "<init>", "()V"));
        code.return_();
    }

    public void addRunnable() throws IOException {
        Code code = this.classfile.addMethod("getMain", "()Lorg/python/core/PyCode;", 1);
        this.mainCode.get(code);
        code.areturn();
    }

    public void addMain() throws IOException {
        Code code = this.classfile.addMethod("main", "([Ljava/lang/String;)V", 9);
        int n = code.pool.Fieldref(this.classfile.name, "self", "L" + this.classfile.name + ";");
        code.getstatic(n);
        code.aload(0);
        code.invokestatic(code.pool.Methodref("org/python/core/Py", "do_main", "(Lorg/python/core/PyRunnable;[Ljava/lang/String;)V"));
        code.return_();
    }

    public void addConstants() throws IOException {
        Code code = this.classfile.addMethod("<clinit>", "()V", 8);
        this.classfile.addField("self", "L" + this.classfile.name + ";", 24);
        code.new_(code.pool.Class(this.classfile.name));
        code.dup();
        code.invokespecial(code.pool.Methodref(this.classfile.name, "<init>", "()V"));
        code.putstatic(code.pool.Fieldref(this.classfile.name, "self", "L" + this.classfile.name + ";"));
        Enumeration enumeration = this.constants.elements();
        while (enumeration.hasMoreElements()) {
            Constant constant = (Constant)enumeration.nextElement();
            constant.put(code);
        }
        int n = 0;
        while (n < this.codes.size()) {
            PyCodeConstant pyCodeConstant = (PyCodeConstant)this.codes.elementAt(n);
            pyCodeConstant.put(code);
            ++n;
        }
        code.return_();
    }

    public void addFunctions() throws IOException {
        Code code = this.classfile.addMethod("call_function", "(ILorg/python/core/PyFrame;)Lorg/python/core/PyObject;", 1);
        Label label = code.getLabel();
        Label[] labelArray = new Label[this.codes.size()];
        int n = 0;
        while (n < labelArray.length) {
            labelArray[n] = code.getLabel();
            ++n;
        }
        code.iload(1);
        code.tableswitch(label, 0, labelArray);
        n = 0;
        while (n < labelArray.length) {
            labelArray[n].setPosition();
            code.aload(0);
            code.aload(2);
            code.invokevirtual(this.classfile.name, ((PyCodeConstant)this.codes.elementAt((int)n)).fname, "(Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
            code.areturn();
            ++n;
        }
        label.setPosition();
        code.aconst_null();
        code.areturn();
    }

    public void write(OutputStream outputStream) throws IOException {
        this.addInit();
        this.addRunnable();
        this.addConstants();
        this.addFunctions();
        this.classfile.addInterface("org/python/core/PyRunnable");
        if (this.sfilename != null) {
            this.classfile.addAttribute(new SourceFile(this.sfilename, this.classfile.pool));
        }
        this.classfile.addAttribute(new APIVersion(9, this.classfile.pool));
        this.classfile.write(outputStream);
    }

    public static void compile(SimpleNode simpleNode, OutputStream outputStream, String string, String string2, boolean bl, boolean bl2, boolean bl3, CompilerFlags compilerFlags) throws Exception {
        Module module = new Module(string, string2, bl);
        module.setFile = bl3;
        PyCodeConstant pyCodeConstant = module.PyCode(simpleNode, "?", false, null, false, bl2, 0, null, compilerFlags);
        module.mainCode = pyCodeConstant;
        module.write(outputStream);
    }

    public Module(String string, String string2, boolean bl) {
        this.linenumbers = bl;
        this.classfile = new ClassFile(string, "org/python/core/PyFunctionTable", 33);
        this.constants = new Hashtable();
        this.sfilename = string2;
        this.filename = string2 != null ? this.PyString(string2) : null;
        this.codes = new Vector();
    }

    public Module(String string) {
        this(string, string + ".py", true);
    }
}

