/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import org.python.core.CompilerFlags;
import org.python.parser.ParseException;
import org.python.parser.SimpleNode;

public class Future {
    private static final String FUTURE = "__future__";
    private boolean nested_scopes;

    private boolean check(SimpleNode simpleNode) throws Exception {
        SimpleNode simpleNode2 = simpleNode.getChild(0);
        if (simpleNode2.getNumChildren() != 1 || !((String)simpleNode2.getChild(0).getInfo()).equals(FUTURE)) {
            return false;
        }
        int n = simpleNode.getNumChildren();
        if (n == 1) {
            throw new ParseException("future statement does not support import *", simpleNode);
        }
        int n2 = 1;
        while (n2 < n) {
            String string;
            SimpleNode simpleNode3 = simpleNode.getChild(n2);
            switch (simpleNode3.id) {
                default: {
                    string = (String)simpleNode3.getInfo();
                    break;
                }
                case 34: {
                    string = (String)simpleNode3.getChild(0).getInfo();
                    break;
                }
            }
            if (!string.equals("nested_scopes")) {
                throw new ParseException("future feature " + string + " is not defined", simpleNode);
            }
            this.nested_scopes = true;
            ++n2;
        }
        return true;
    }

    public void preprocessFutures(SimpleNode simpleNode, CompilerFlags compilerFlags) throws Exception {
        if (compilerFlags != null) {
            this.nested_scopes = compilerFlags.nested_scopes;
        }
        if (simpleNode.id != 1 && simpleNode.id != 0) {
            return;
        }
        int n = simpleNode.getNumChildren();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        if (simpleNode.id == 1 && simpleNode.getChild((int)0).id == 10 && simpleNode.getChild((int)0).getChild((int)0).id == 95) {
            ++n2;
        }
        int n3 = n2;
        while (n3 < n) {
            SimpleNode simpleNode2 = simpleNode.getChild(n3);
            if (simpleNode2.id != 31) break;
            simpleNode2.from_future_checked = true;
            if (!this.check(simpleNode2)) break;
            ++n3;
        }
        if (compilerFlags != null) {
            compilerFlags.nested_scopes = compilerFlags.nested_scopes || this.nested_scopes;
        }
    }

    public static void checkFromFuture(SimpleNode simpleNode) throws Exception {
        if (simpleNode.from_future_checked) {
            return;
        }
        SimpleNode simpleNode2 = simpleNode.getChild(0);
        if (simpleNode2.getNumChildren() == 1 && ((String)simpleNode2.getChild(0).getInfo()).equals(FUTURE)) {
            throw new ParseException("from __future__ imports must occur at the beginning of the file", simpleNode);
        }
        simpleNode.from_future_checked = true;
    }

    public boolean areNestedScopesOn() {
        return this.nested_scopes;
    }
}

