/*
 * Decompiled with CFR 0.152.
 */
package madkit.TreeTools;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import madkit.TreeTools.AbstractFileNode;
import madkit.TreeTools.DirNode;
import madkit.TreeTools.FileNode;
import madkit.TreeTools.GenericTree;
import madkit.TreeTools.GenericTreeNode;

public class ExplorerTree
extends GenericTree
implements TreeWillExpandListener,
FileFilter {
    protected String rootPath;
    File rootFile;
    GenericTreeNode localRoot;
    String selection;
    boolean hidden;
    protected boolean onlyDir = false;
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    public void setOnlyDir(boolean bl) {
        this.onlyDir = bl;
    }

    protected void buildExplorerTree(GenericTreeNode genericTreeNode, File file) {
        if (file == null || !file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                DirNode dirNode;
                if (fileArray[i].listFiles(this) == null) {
                    System.out.println(fileArray[i].getName() + " is NOT REACHABLE");
                    dirNode = new DirNode(fileArray[i], false);
                    genericTreeNode.add(dirNode);
                    continue;
                }
                if (this.onlyDir) {
                    if (fileArray[i].listFiles(this).length == 0) {
                        dirNode = new DirNode(fileArray[i], true);
                        genericTreeNode.add(dirNode);
                        continue;
                    }
                    dirNode = new DirNode(fileArray[i], true);
                    genericTreeNode.add(dirNode);
                    this.addTreeNode(dirNode, fileArray[i]);
                    continue;
                }
                if (fileArray[i].listFiles().length == 0) {
                    dirNode = new DirNode(fileArray[i], true);
                    genericTreeNode.add(dirNode);
                    continue;
                }
                dirNode = new DirNode(fileArray[i], true);
                genericTreeNode.add(dirNode);
                this.addTreeNode(dirNode, fileArray[i]);
                continue;
            }
            if (this.onlyDir) continue;
            this.buildFileTree(genericTreeNode, fileArray[i]);
        }
    }

    protected void setLocalRoot(GenericTreeNode genericTreeNode) {
        this.localRoot = genericTreeNode;
    }

    public GenericTreeNode getLocalRoot() {
        return this.localRoot;
    }

    protected void buildFileTree(GenericTreeNode genericTreeNode, File file) {
        genericTreeNode.add(new FileNode(file));
    }

    public boolean accept(File file) {
        if (this.hidden) {
            return file.isDirectory();
        }
        return !file.isHidden() && file.isDirectory();
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void buildTree() {
        this.buildExplorerTree(this.localRoot, this.rootFile);
    }

    protected void addTreeNode(AbstractFileNode abstractFileNode, File file) {
        abstractFileNode.add(new FileNode(file));
    }

    public void addDirectory(File file) {
        this.localRoot = new DirNode(file, true);
        this.top.add(this.localRoot);
        this.buildExplorerTree((AbstractFileNode)this.localRoot, file);
        this.treeModel.reload();
    }

    protected File init(File file) {
        File file2 = file;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            System.out.println("Couldn't get Canonical File");
        }
        File file3 = file2.getParentFile();
        this.rootPath = file3 == null ? (ExplorerTree.isWindowsPlatform() ? file2.getAbsolutePath() + File.separator : File.separator) : file3.getAbsolutePath() + File.separator;
        return file2;
    }

    public ExplorerTree() {
        super(new GenericTreeNode("top"));
    }

    public ExplorerTree(File file, boolean bl) {
        super(new GenericTreeNode("top"));
        this.hidden = false;
        this.rootFile = this.init(file);
        this.localRoot = new DirNode(this.rootFile, true);
        this.top.add(this.localRoot);
        this.setOnlyDir(bl);
        this.buildTree();
        this.installTree();
    }

    public ExplorerTree(File file) {
        this(file, false);
    }

    public void installTree() {
        super.installTree();
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.addTreeWillExpandListener(this);
        this.tree.expandRow(0);
    }

    public void clear() {
        this.top.removeAllChildren();
        this.treeModel.reload();
    }

    public void reInstallRoot(File file) {
        this.clear();
        this.rootFile = this.init(file);
        System.out.println("reinstalling root:" + file + ", on top:" + this.top);
        this.localRoot = new DirNode(this.rootFile, true);
        this.top.add(this.localRoot);
        this.buildTree();
        this.treeModel.reload();
        this.tree.expandRow(0);
        this.tree.scrollPathToVisible(new TreePath(this.localRoot.getPath()));
        this.tree.repaint();
    }

    public String getPath(Object[] objectArray) {
        String string = "";
        int n = objectArray.length;
        for (int i = 1; i < n; ++i) {
            string = string + objectArray[i].toString();
            if (i == n - 1) continue;
            string = string + File.separator;
        }
        string = this.rootPath + string;
        return string;
    }

    public void expandSelectedNode() {
        System.out.println("Expansion");
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        AbstractFileNode abstractFileNode = (AbstractFileNode)treeExpansionEvent.getPath().getLastPathComponent();
        abstractFileNode.removeAllChildren();
        File file = new File(this.getPath(treeExpansionEvent.getPath().getPath()));
        this.buildExplorerTree(abstractFileNode, file);
        this.treeModel.reload(abstractFileNode);
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        System.out.println("Tree-will-collapse event detected");
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.selection = this.getPath(treeSelectionEvent.getPath().getPath());
    }

    public static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith(WIN_ID);
    }
}

