/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Kernel;
import madkit.kernel.Overlooker;
import madkit.kernel.ReferenceableAgent;

final class Role
extends HashSet {
    private transient Collection overlookers;
    private transient Collection referenceableAgents;

    Role() {
        this.referenceableAgents = new ArrayList();
        this.overlookers = new HashSet();
    }

    Role(int n) {
        super(n);
        this.referenceableAgents = new ArrayList(n);
        this.overlookers = new HashSet();
    }

    synchronized boolean addMember(AgentAddress agentAddress) {
        if (this.add(agentAddress)) {
            AbstractAgent abstractAgent = Kernel.getReference(agentAddress);
            if (abstractAgent instanceof ReferenceableAgent) {
                this.referenceableAgents.add(abstractAgent);
                Iterator iterator = this.overlookers.iterator();
                while (iterator.hasNext()) {
                    ((Overlooker)iterator.next()).update(abstractAgent, true);
                }
            }
            return true;
        }
        return false;
    }

    synchronized boolean removeMember(AgentAddress agentAddress) {
        if (this.remove(agentAddress)) {
            AbstractAgent abstractAgent = Kernel.getReference(agentAddress);
            if (this.referenceableAgents.remove(abstractAgent)) {
                Iterator iterator = this.overlookers.iterator();
                while (iterator.hasNext()) {
                    ((Overlooker)iterator.next()).update(abstractAgent, false);
                }
            }
        } else {
            return false;
        }
        return this.isEmpty() && this.overlookers.isEmpty();
    }

    synchronized boolean addOverlooker(Overlooker overlooker) {
        if (this.overlookers.add(overlooker)) {
            overlooker.setOverlookedRole(this);
            return true;
        }
        return false;
    }

    synchronized boolean removeOverlooker(Overlooker overlooker) {
        if (this.overlookers.remove(overlooker)) {
            return this.isEmpty() && this.overlookers.isEmpty();
        }
        return false;
    }

    synchronized List getAgentsList() {
        if (Kernel.fastSynchronous) {
            return (List)this.referenceableAgents;
        }
        return new ArrayList(this.referenceableAgents);
    }

    synchronized AbstractAgent getAgentNb(int n) {
        if (n < this.referenceableAgents.size()) {
            return (AbstractAgent)((List)this.referenceableAgents).get(n);
        }
        return null;
    }

    void update() {
        this.referenceableAgents = new HashSet();
        this.overlookers = new HashSet(7);
    }
}

