/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import madkit.kernel.AgentAddress;
import madkit.kernel.Group;
import madkit.kernel.GroupIdentifier;
import madkit.kernel.KernelAddress;
import madkit.kernel.Overlooker;

final class Organization
extends HashMap {
    Organization() {
    }

    synchronized int createGroup(AgentAddress agentAddress, boolean bl, String string, String string2, GroupIdentifier groupIdentifier) {
        if (!this.containsKey(string)) {
            this.put(string, new Group(agentAddress, bl, string2, groupIdentifier));
            return 1;
        }
        if (this.getGroup(string).isEmpty()) {
            this.getGroup(string).realCreation(agentAddress, bl, string2, groupIdentifier);
            return 1;
        }
        return -1;
    }

    synchronized int requestRole(AgentAddress agentAddress, String string, String string2, Object object) {
        Group group = this.getGroup(string);
        if (group != null && !group.isEmpty() && !string2.equals("group manager")) {
            return group.requestRole(agentAddress, string2, object);
        }
        return -3;
    }

    synchronized boolean leaveGroup(AgentAddress agentAddress, String string) {
        if (this.getGroup(string).leave(agentAddress)) {
            this.remove(string);
        }
        return this.isEmpty();
    }

    synchronized boolean leaveRole(AgentAddress agentAddress, String string, String string2) {
        if (this.getGroup(string).leaveRole(agentAddress, string2)) {
            this.remove(string);
        }
        return this.isEmpty();
    }

    synchronized boolean addOverlooker(AgentAddress agentAddress, Overlooker overlooker, Object object) {
        Group group = this.getGroup(overlooker.group);
        if (group != null) {
            return group.addOverlooker(agentAddress, overlooker, object);
        }
        group = new Group();
        this.put(overlooker.group, group);
        return group.addOverlooker(agentAddress, overlooker, object);
    }

    synchronized boolean removeOverlooker(Overlooker overlooker) {
        Group group = this.getGroup(overlooker.group);
        if (group != null && group.removeOverlooker(overlooker)) {
            this.remove(overlooker.group);
            return this.isEmpty();
        }
        return false;
    }

    boolean isPlayingRole(AgentAddress agentAddress, String string, String string2) {
        return this.containsKey(string) && this.getGroup(string).isPlayingRole(agentAddress, string2);
    }

    boolean isGroup(String string) {
        return this.containsKey(string) && !this.getGroup(string).isEmpty();
    }

    AgentAddress[] getRolePlayers(String string, String string2) {
        if (this.isGroup(string)) {
            return this.getGroup(string).getRolePlayers(string2);
        }
        return new AgentAddress[0];
    }

    AgentAddress getRolePlayer(String string, String string2) {
        if (this.isGroup(string)) {
            return this.getGroup(string).getRolePlayer(string2);
        }
        return null;
    }

    String[] getGroupRolesOf(AgentAddress agentAddress, String string) {
        if (this.isGroup(string)) {
            return this.getGroup(string).getRolesOf(agentAddress);
        }
        return new String[0];
    }

    Group getGroup(String string) {
        return (Group)this.get(string);
    }

    boolean isDistributed(String string) {
        Group group = this.getGroup(string);
        if (group != null) {
            return group.isDistributed();
        }
        return false;
    }

    String[] getRolesIn(String string) {
        Group group = this.getGroup(string);
        if (group != null) {
            return group.availableRoles();
        }
        return new String[0];
    }

    synchronized String[] getGroups() {
        HashSet hashSet = new HashSet(this.size());
        for (Map.Entry entry : this.entrySet()) {
            if (((Group)entry.getValue()).isEmpty()) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet.toArray(new String[0]);
    }

    synchronized String[] getCurrentGroupsOf(AgentAddress agentAddress) {
        HashSet hashSet = new HashSet(this.size());
        for (Map.Entry entry : this.entrySet()) {
            if (!((Group)entry.getValue()).isPlayingRole(agentAddress, "member")) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet.toArray(new String[0]);
    }

    AgentAddress[] getGroupMembers(String string) {
        if (this.isGroup(string)) {
            return this.getGroup(string).getRolePlayers("member");
        }
        return new AgentAddress[0];
    }

    synchronized Map getLocalOrganization() {
        Hashtable hashtable = new Hashtable();
        for (Map.Entry entry : this.entrySet()) {
            if (((Group)entry.getValue()).isEmpty()) continue;
            hashtable.put(entry.getKey(), ((Group)entry.getValue()).mapForm());
        }
        return hashtable;
    }

    synchronized Organization exportOrg() {
        Organization organization = new Organization();
        for (Map.Entry entry : this.entrySet()) {
            Group group = (Group)entry.getValue();
            if (!group.isDistributed() || group.isEmpty()) continue;
            organization.put(entry.getKey(), entry.getValue());
        }
        return organization;
    }

    synchronized void importOrg(Organization organization, boolean bl) {
        for (Map.Entry entry : organization.entrySet()) {
            if (!this.containsKey(entry.getKey())) {
                Group group = new Group();
                this.put(entry.getKey(), group);
                group.merge((Group)entry.getValue(), bl);
                continue;
            }
            ((Group)this.get(entry.getKey())).merge((Group)entry.getValue(), bl);
        }
    }

    synchronized boolean removeAgentsFromKernel(KernelAddress kernelAddress) {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (!group.isDistributed()) continue;
            AgentAddress[] agentAddressArray = group.getRolePlayers("member");
            for (int i = 0; i < agentAddressArray.length; ++i) {
                if (!agentAddressArray[i].getKernel().equals(kernelAddress) || !group.leave(agentAddressArray[i])) continue;
                iterator.remove();
            }
        }
        return this.isEmpty();
    }

    synchronized boolean removeDistantAgents() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (!group.isDistributed()) continue;
            AgentAddress[] agentAddressArray = group.getRolePlayers("member");
            for (int i = 0; i < agentAddressArray.length; ++i) {
                if (agentAddressArray[i].isLocal() || !group.leave(agentAddressArray[i])) continue;
                iterator.remove();
            }
        }
        return this.isEmpty();
    }
}

