/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import madkit.kernel.InvalidAddressException;
import madkit.kernel.KernelAddress;

public class AgentAddress
implements Serializable {
    private static final String MADKIT_PROTOCOL = "mka";
    private static int agentCounter = 0;
    private String protocol;
    private String name;
    private String localID;
    private KernelAddress kernel;

    public AgentAddress(String string, KernelAddress kernelAddress) {
        this.protocol = MADKIT_PROTOCOL;
        this.name = string;
        this.localID = Integer.toString(++agentCounter);
        this.kernel = kernelAddress;
    }

    public AgentAddress(AgentAddress agentAddress) {
        agentCounter = Integer.parseInt(agentAddress.getLocalID());
        this.localID = agentAddress.getLocalID();
        this.kernel = agentAddress.getKernel();
        this.protocol = agentAddress.getProtocol();
        this.name = agentAddress.getName();
    }

    public AgentAddress(String string) throws InvalidAddressException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":,@", true);
        try {
            this.protocol = stringTokenizer.nextToken();
            if (!this.protocol.equals(MADKIT_PROTOCOL) && !this.protocol.equals("request")) {
                throw new NoSuchElementException("invalid protocol:" + this.protocol);
            }
            stringTokenizer.nextToken();
            this.name = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            this.localID = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            this.kernel = new KernelAddress(stringBuffer.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new InvalidAddressException("Invalid AgentAddress !" + string);
        }
    }

    public String toString() {
        return this.name + "," + this.localID + "@" + this.kernel.shortString();
    }

    public boolean isLocal() {
        return this.kernel.isLocal();
    }

    public boolean equals(Object object) {
        if (object instanceof AgentAddress) {
            AgentAddress agentAddress = (AgentAddress)object;
            if (agentAddress == null) {
                return false;
            }
            return this.kernel.equals(agentAddress.getKernel()) && this.localID.equals(agentAddress.localID) && this.protocol.equals(agentAddress.protocol);
        }
        return false;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    public String getLocalID() {
        return this.localID;
    }

    public KernelAddress getKernel() {
        return this.kernel;
    }

    public int hashCode() {
        return (this.localID + this.kernel.toString()).hashCode();
    }

    void update(KernelAddress kernelAddress) {
        this.localID = Integer.toString(++agentCounter);
        this.kernel = kernelAddress;
    }

    void update(AgentAddress agentAddress) {
        agentCounter = Integer.parseInt(agentAddress.getLocalID());
        this.localID = new String(agentAddress.getLocalID());
        this.protocol = new String(agentAddress.getProtocol());
        this.name = new String(agentAddress.getName());
        this.kernel = agentAddress.getKernel();
    }
}

