/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHCastExpression;
import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.ClassPathException;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Name;
import bsh.NameSource;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.This;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NameSpace
implements Serializable,
BshClassManager.Listener,
NameSource {
    public static final NameSpace JAVACODE = new NameSpace("Called from compiled Java code");
    public String name;
    private NameSpace parent;
    private Hashtable variables;
    private Hashtable methods;
    private Hashtable importedClasses;
    private This thisReference;
    private Vector importedPackages;
    private static transient boolean superImport;
    private transient Hashtable classCache;
    SimpleNode callerInfoNode;
    Vector nameSourceListeners;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public NameSpace(String name) {
        this(null, name);
    }

    public NameSpace(NameSpace parent, String name) {
        this.setName(name);
        this.setParent(parent);
        BshClassManager.addCMListener(this);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    void setNode(SimpleNode node) {
        this.callerInfoNode = node;
    }

    SimpleNode getNode() {
        return this.callerInfoNode;
    }

    public Object get(String name, Interpreter interpreter) throws EvalError {
        CallStack callstack = new CallStack();
        return this.getNameResolver(name).toObject(callstack, interpreter);
    }

    public void setVariable(String name, Object value) throws EvalError {
        if (this.variables == null) {
            this.variables = new Hashtable();
        }
        if (value == null) {
            this.variables.remove(name);
            return;
        }
        boolean recurse = Interpreter.strictJava;
        Object current = this.getVariableImpl(name, recurse);
        if (current != null && current instanceof TypedVariable) {
            try {
                ((TypedVariable)current).setValue(value);
            }
            catch (EvalError e) {
                throw new EvalError("Typed variable: " + name + ": " + e.getMessage());
            }
        } else {
            if (Interpreter.strictJava) {
                throw new EvalError("(Strict Java mode) Assignment to undeclared variable: " + name);
            }
            this.variables.put(name, value);
        }
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        return this.enumerationToStringArray(this.variables.keys());
    }

    public String[] getMethodNames() {
        if (this.methods == null) {
            return new String[0];
        }
        return this.enumerationToStringArray(this.methods.keys());
    }

    public BshMethod[] getMethods() {
        if (this.methods == null) {
            return new BshMethod[0];
        }
        return this.flattenMethodCollection(this.methods.elements());
    }

    private String[] enumerationToStringArray(Enumeration e) {
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        Object[] sa = new String[v.size()];
        v.copyInto(sa);
        return sa;
    }

    private BshMethod[] flattenMethodCollection(Enumeration e) {
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof BshMethod) {
                v.addElement(o);
                continue;
            }
            Vector ov = (Vector)o;
            int i = 0;
            while (i < ov.size()) {
                v.addElement(ov.elementAt(i));
                ++i;
            }
        }
        Object[] bma = new BshMethod[v.size()];
        v.copyInto(bma);
        return bma;
    }

    public NameSpace getParent() {
        return this.parent;
    }

    public NameSpace getSuper() {
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    public NameSpace getGlobal() {
        if (this.parent != null) {
            return this.parent.getGlobal();
        }
        return this;
    }

    This getThis(Interpreter declaringInterpreter) {
        if (this.thisReference == null) {
            this.thisReference = This.getThis(this, declaringInterpreter);
        }
        return this.thisReference;
    }

    public void prune() {
        this.setParent(null);
    }

    public void setParent(NameSpace parent) {
        this.parent = parent;
        if (parent == null) {
            this.loadDefaultImports();
        }
    }

    public Object getVariable(String name) {
        return this.getVariable(name, true);
    }

    public Object getVariable(String name, boolean recurse) {
        Object val = this.getVariableImpl(name, recurse);
        return this.unwrapVariable(val);
    }

    protected Object unwrapVariable(Object val) {
        if (val instanceof TypedVariable) {
            val = ((TypedVariable)val).getValue();
        }
        return val == null ? Primitive.VOID : val;
    }

    protected Object getVariableImpl(String name, boolean recurse) {
        Object val = null;
        if (this.variables != null) {
            val = this.variables.get(name);
        }
        if (recurse && val == null && this.parent != null) {
            val = this.parent.getVariableImpl(name, recurse);
        }
        return val;
    }

    public void setTypedVariable(String name, Class type, Object value, boolean isFinal) throws EvalError {
        Object existing;
        if (this.variables == null) {
            this.variables = new Hashtable();
        }
        if (value == null) {
            if (type.isPrimitive()) {
                if (type == Boolean.TYPE) {
                    value = new Primitive(Boolean.FALSE);
                } else if (type == Byte.TYPE) {
                    value = new Primitive(0);
                } else if (type == Short.TYPE) {
                    value = new Primitive(0);
                } else if (type == Character.TYPE) {
                    value = new Primitive('\u0000');
                } else if (type == Integer.TYPE) {
                    value = new Primitive(0);
                } else if (type == Long.TYPE) {
                    value = new Primitive(0L);
                } else if (type == Float.TYPE) {
                    value = new Primitive(0.0f);
                } else if (type == Double.TYPE) {
                    value = new Primitive(0.0);
                }
            } else {
                value = Primitive.NULL;
            }
        }
        if (this.variables.containsKey(name) && (existing = this.getVariableImpl(name, false)) instanceof TypedVariable) {
            if (((TypedVariable)existing).getType() != type) {
                throw new EvalError("Typed variable: " + name + " was previously declared with type: " + ((TypedVariable)existing).getType());
            }
            ((TypedVariable)existing).setValue(value);
            return;
        }
        this.variables.put(name, new TypedVariable(type, value, isFinal));
    }

    public void setMethod(String name, BshMethod method) {
        Object m;
        if (this.methods == null) {
            this.methods = new Hashtable();
        }
        if ((m = this.methods.get(name)) == null) {
            this.methods.put(name, method);
        } else if (m instanceof BshMethod) {
            Vector<Object> v = new Vector<Object>();
            v.addElement(m);
            v.addElement(method);
            this.methods.put(name, v);
        } else {
            ((Vector)m).addElement(method);
        }
    }

    public BshMethod getMethod(String name, Class[] sig) {
        Object method = null;
        Object m = null;
        if (this.methods != null) {
            m = this.methods.get(name);
        }
        if (m instanceof Vector) {
            Vector vm = m;
            Object[] ma = new BshMethod[vm.size()];
            vm.copyInto(ma);
            Class[][] candidates = new Class[ma.length][];
            int i = 0;
            while (i < ma.length) {
                candidates[i] = ((BshMethod)ma[i]).getArgTypes();
                ++i;
            }
            int match = Reflect.findMostSpecificSignature(sig, candidates);
            if (match != -1) {
                method = ma[match];
            }
        } else {
            method = m;
        }
        if (method == null && this.parent != null) {
            return this.parent.getMethod(name, sig);
        }
        return method;
    }

    public void importClass(String name) {
        if (this.importedClasses == null) {
            this.importedClasses = new Hashtable();
        }
        this.importedClasses.put(Name.suffix(name, 1), name);
        this.nameSpaceChanged();
    }

    public void importPackage(String name) {
        if (this.importedPackages == null) {
            this.importedPackages = new Vector();
        }
        this.importedPackages.addElement(name);
        this.nameSpaceChanged();
    }

    public String[] getImportedPackages() {
        Vector v = this.getImportedPackages(true);
        Object[] packages = new String[v.size()];
        v.copyInto(packages);
        return packages;
    }

    public Vector getImportedPackages(boolean recurse) {
        if (!recurse) {
            return this.importedPackages;
        }
        Vector<String> v = new Vector<String>();
        if (this.parent != null) {
            String[] psa = this.parent.getImportedPackages();
            int i = 0;
            while (i < psa.length) {
                v.addElement(psa[i]);
                ++i;
            }
        }
        if (this.importedPackages != null) {
            int i = 0;
            while (i < this.importedPackages.size()) {
                v.addElement((String)this.importedPackages.elementAt(i));
                ++i;
            }
        }
        return v;
    }

    private void cacheClass(Class c) {
        if (this.classCache == null) {
            this.classCache = new Hashtable();
        }
        this.classCache.put(this.name, c);
    }

    public Class getClass(String name) throws ClassPathException {
        Class c = this.getClassImpl(name);
        if (c != null) {
            return c;
        }
        if (this.parent != null) {
            return this.parent.getClass(name);
        }
        return null;
    }

    private Class getClassImpl(String name) throws ClassPathException {
        boolean unqualifiedName = !Name.isCompound(name);
        Class c = null;
        if (this.classCache != null && (c = (Class)this.classCache.get(name)) != null) {
            return c;
        }
        if (unqualifiedName && (c = this.getImportedClassImpl(name)) != null) {
            this.cacheClass(c);
            return c;
        }
        c = this.classForName(name);
        if (c != null) {
            if (unqualifiedName) {
                this.cacheClass(c);
            }
            return c;
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("getClass(): " + name + " not\tfound in " + this);
        }
        return null;
    }

    private Class getImportedClassImpl(String name) throws ClassPathException {
        BshClassManager bcm;
        String s;
        String fullname = null;
        if (this.importedClasses != null) {
            fullname = (String)this.importedClasses.get(name);
        }
        if (fullname != null) {
            Class clas = this.classForName(fullname);
            if (clas == null) {
                if (Name.isCompound(fullname)) {
                    try {
                        clas = this.getNameResolver(fullname).toClass();
                    }
                    catch (EvalError e) {}
                } else if (Interpreter.DEBUG) {
                    Interpreter.debug("imported unpackaged name not found:" + fullname);
                }
                if (clas != null) {
                    BshClassManager.cacheClassInfo(fullname, clas);
                    return clas;
                }
            } else {
                return clas;
            }
            return null;
        }
        if (this.importedPackages != null) {
            int i = this.importedPackages.size() - 1;
            while (i >= 0) {
                s = String.valueOf((String)this.importedPackages.elementAt(i)) + "." + name;
                Class c = this.classForName(s);
                if (c != null) {
                    return c;
                }
                --i;
            }
        }
        if (superImport && (bcm = BshClassManager.getClassManager()) != null && (s = bcm.getClassNameByUnqName(name)) != null) {
            return this.classForName(s);
        }
        return null;
    }

    private Class classForName(String name) {
        return BshClassManager.classForName(name);
    }

    public String[] getAllNames() {
        Vector vec = new Vector();
        this.getAllNamesAux(vec);
        Object[] names = new String[vec.size()];
        vec.copyInto(names);
        return names;
    }

    protected void getAllNamesAux(Vector vec) {
        Enumeration varNames = this.variables.keys();
        while (varNames.hasMoreElements()) {
            vec.addElement(varNames.nextElement());
        }
        Enumeration methodNames = this.methods.keys();
        while (methodNames.hasMoreElements()) {
            vec.addElement(methodNames.nextElement());
        }
        if (this.parent != null) {
            this.parent.getAllNamesAux(vec);
        }
    }

    public void addNameSourceListener(NameSource.Listener listener) {
        if (this.nameSourceListeners == null) {
            this.nameSourceListeners = new Vector();
        }
        this.nameSourceListeners.addElement(listener);
    }

    public static void doSuperImport() throws EvalError {
        BshClassManager bcm = BshClassManager.getClassManager();
        if (bcm != null) {
            bcm.doSuperImport();
        }
        superImport = true;
    }

    public static Object checkAssignableFrom(Object rhs, Class lhsType) throws EvalError {
        return NameSpace.getAssignableForm(rhs, lhsType);
    }

    /*
     * Unable to fully structure code
     */
    public static Object getAssignableForm(Object rhs, Class lhsType) throws EvalError {
        block169: {
            block171: {
                block170: {
                    block166: {
                        block168: {
                            block167: {
                                block163: {
                                    block165: {
                                        block164: {
                                            block160: {
                                                block162: {
                                                    block161: {
                                                        block159: {
                                                            block158: {
                                                                if (lhsType == null) {
                                                                    throw new InterpreterError("Null value for type in getAssignableForm");
                                                                }
                                                                if (rhs == null) {
                                                                    throw new InterpreterError("Null value in getAssignableForm.");
                                                                }
                                                                if (rhs == Primitive.VOID) {
                                                                    throw new EvalError("Undefined variable or class name");
                                                                }
                                                                if (rhs == Primitive.NULL) {
                                                                    if (!lhsType.isPrimitive()) {
                                                                        return rhs;
                                                                    }
                                                                    throw new EvalError("Can't assign null to primitive type " + lhsType.getName());
                                                                }
                                                                if (!(rhs instanceof Primitive)) break block158;
                                                                originalType = ((Primitive)rhs).getType();
                                                                rhsType = originalType;
                                                                if (lhsType.isPrimitive()) break block159;
                                                                v0 = NameSpace.class$0;
                                                                if (v0 == null) {
                                                                    try {
                                                                        v0 = NameSpace.class$0 = Class.forName("[Ljava.lang.Boolean;").getComponentType();
                                                                    }
                                                                    catch (ClassNotFoundException v1) {
                                                                        throw new NoClassDefFoundError(v1.getMessage());
                                                                    }
                                                                }
                                                                if (v0.isAssignableFrom(lhsType)) ** GOTO lbl-1000
                                                                v2 = NameSpace.class$1;
                                                                if (v2 == null) {
                                                                    try {
                                                                        v2 = NameSpace.class$1 = Class.forName("[Ljava.lang.Character;").getComponentType();
                                                                    }
                                                                    catch (ClassNotFoundException v3) {
                                                                        throw new NoClassDefFoundError(v3.getMessage());
                                                                    }
                                                                }
                                                                if (v2.isAssignableFrom(lhsType)) ** GOTO lbl-1000
                                                                v4 = NameSpace.class$2;
                                                                if (v4 == null) {
                                                                    try {
                                                                        v4 = NameSpace.class$2 = Class.forName("[Ljava.lang.Number;").getComponentType();
                                                                    }
                                                                    catch (ClassNotFoundException v5) {
                                                                        throw new NoClassDefFoundError(v5.getMessage());
                                                                    }
                                                                }
                                                                if (v4.isAssignableFrom(lhsType)) lbl-1000:
                                                                // 3 sources

                                                                {
                                                                    rhs = ((Primitive)rhs).getValue();
                                                                    rhsType = rhs.getClass();
                                                                } else {
                                                                    NameSpace.assignmentError(lhsType, originalType);
                                                                }
                                                                break block159;
                                                            }
                                                            originalType = rhs.getClass();
                                                            rhsType = originalType;
                                                            if (lhsType.isPrimitive()) {
                                                                v6 = NameSpace.class$0;
                                                                if (v6 == null) {
                                                                    try {
                                                                        v6 = NameSpace.class$0 = Class.forName("[Ljava.lang.Boolean;").getComponentType();
                                                                    }
                                                                    catch (ClassNotFoundException v7) {
                                                                        throw new NoClassDefFoundError(v7.getMessage());
                                                                    }
                                                                }
                                                                if (rhsType == v6) {
                                                                    rhs = new Primitive((Boolean)rhs);
                                                                    rhsType = Boolean.TYPE;
                                                                } else {
                                                                    v8 = NameSpace.class$1;
                                                                    if (v8 == null) {
                                                                        try {
                                                                            v8 = NameSpace.class$1 = Class.forName("[Ljava.lang.Character;").getComponentType();
                                                                        }
                                                                        catch (ClassNotFoundException v9) {
                                                                            throw new NoClassDefFoundError(v9.getMessage());
                                                                        }
                                                                    }
                                                                    if (rhsType == v8) {
                                                                        rhs = new Primitive((Character)rhs);
                                                                        rhsType = Character.TYPE;
                                                                    } else {
                                                                        v10 = NameSpace.class$2;
                                                                        if (v10 == null) {
                                                                            try {
                                                                                v10 = NameSpace.class$2 = Class.forName("[Ljava.lang.Number;").getComponentType();
                                                                            }
                                                                            catch (ClassNotFoundException v11) {
                                                                                throw new NoClassDefFoundError(v11.getMessage());
                                                                            }
                                                                        }
                                                                        if (v10.isAssignableFrom(rhsType)) {
                                                                            rhs = new Primitive((Number)rhs);
                                                                            rhsType = ((Primitive)rhs).getType();
                                                                        } else {
                                                                            NameSpace.assignmentError(lhsType, originalType);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        if (Reflect.isAssignableFrom(lhsType, rhsType)) {
                                                            return rhs;
                                                        }
                                                        v12 = NameSpace.class$3;
                                                        if (v12 == null) {
                                                            try {
                                                                v12 = NameSpace.class$3 = Class.forName("[Ljava.lang.Short;").getComponentType();
                                                            }
                                                            catch (ClassNotFoundException v13) {
                                                                throw new NoClassDefFoundError(v13.getMessage());
                                                            }
                                                        }
                                                        if (lhsType == v12) {
                                                            v14 = NameSpace.class$4;
                                                            if (v14 == null) {
                                                                try {
                                                                    v14 = NameSpace.class$4 = Class.forName("[Ljava.lang.Byte;").getComponentType();
                                                                }
                                                                catch (ClassNotFoundException v15) {
                                                                    throw new NoClassDefFoundError(v15.getMessage());
                                                                }
                                                            }
                                                            if (rhsType == v14) {
                                                                return new Short(((Number)rhs).shortValue());
                                                            }
                                                        }
                                                        if ((v16 = NameSpace.class$5) == null) {
                                                            try {
                                                                v16 = NameSpace.class$5 = Class.forName("[Ljava.lang.Integer;").getComponentType();
                                                            }
                                                            catch (ClassNotFoundException v17) {
                                                                throw new NoClassDefFoundError(v17.getMessage());
                                                            }
                                                        }
                                                        if (lhsType != v16) break block160;
                                                        v18 = NameSpace.class$4;
                                                        if (v18 == null) {
                                                            try {
                                                                v18 = NameSpace.class$4 = Class.forName("[Ljava.lang.Byte;").getComponentType();
                                                            }
                                                            catch (ClassNotFoundException v19) {
                                                                throw new NoClassDefFoundError(v19.getMessage());
                                                            }
                                                        }
                                                        if (rhsType == v18) break block161;
                                                        v20 = NameSpace.class$3;
                                                        if (v20 == null) {
                                                            try {
                                                                v20 = NameSpace.class$3 = Class.forName("[Ljava.lang.Short;").getComponentType();
                                                            }
                                                            catch (ClassNotFoundException v21) {
                                                                throw new NoClassDefFoundError(v21.getMessage());
                                                            }
                                                        }
                                                        if (rhsType != v20) break block162;
                                                    }
                                                    return new Integer(((Number)rhs).intValue());
                                                }
                                                v22 = NameSpace.class$1;
                                                if (v22 == null) {
                                                    try {
                                                        v22 = NameSpace.class$1 = Class.forName("[Ljava.lang.Character;").getComponentType();
                                                    }
                                                    catch (ClassNotFoundException v23) {
                                                        throw new NoClassDefFoundError(v23.getMessage());
                                                    }
                                                }
                                                if (rhsType == v22) {
                                                    return new Integer(((Number)rhs).intValue());
                                                }
                                            }
                                            if ((v24 = NameSpace.class$6) == null) {
                                                try {
                                                    v24 = NameSpace.class$6 = Class.forName("[Ljava.lang.Long;").getComponentType();
                                                }
                                                catch (ClassNotFoundException v25) {
                                                    throw new NoClassDefFoundError(v25.getMessage());
                                                }
                                            }
                                            if (lhsType != v24) break block163;
                                            v26 = NameSpace.class$4;
                                            if (v26 == null) {
                                                try {
                                                    v26 = NameSpace.class$4 = Class.forName("[Ljava.lang.Byte;").getComponentType();
                                                }
                                                catch (ClassNotFoundException v27) {
                                                    throw new NoClassDefFoundError(v27.getMessage());
                                                }
                                            }
                                            if (rhsType == v26) break block164;
                                            v28 = NameSpace.class$3;
                                            if (v28 == null) {
                                                try {
                                                    v28 = NameSpace.class$3 = Class.forName("[Ljava.lang.Short;").getComponentType();
                                                }
                                                catch (ClassNotFoundException v29) {
                                                    throw new NoClassDefFoundError(v29.getMessage());
                                                }
                                            }
                                            if (rhsType == v28) break block164;
                                            v30 = NameSpace.class$5;
                                            if (v30 == null) {
                                                try {
                                                    v30 = NameSpace.class$5 = Class.forName("[Ljava.lang.Integer;").getComponentType();
                                                }
                                                catch (ClassNotFoundException v31) {
                                                    throw new NoClassDefFoundError(v31.getMessage());
                                                }
                                            }
                                            if (rhsType != v30) break block165;
                                        }
                                        return new Long(((Number)rhs).longValue());
                                    }
                                    v32 = NameSpace.class$1;
                                    if (v32 == null) {
                                        try {
                                            v32 = NameSpace.class$1 = Class.forName("[Ljava.lang.Character;").getComponentType();
                                        }
                                        catch (ClassNotFoundException v33) {
                                            throw new NoClassDefFoundError(v33.getMessage());
                                        }
                                    }
                                    if (rhsType == v32) {
                                        return new Long(((Number)rhs).longValue());
                                    }
                                }
                                if ((v34 = NameSpace.class$7) == null) {
                                    try {
                                        v34 = NameSpace.class$7 = Class.forName("[Ljava.lang.Float;").getComponentType();
                                    }
                                    catch (ClassNotFoundException v35) {
                                        throw new NoClassDefFoundError(v35.getMessage());
                                    }
                                }
                                if (lhsType != v34) break block166;
                                v36 = NameSpace.class$4;
                                if (v36 == null) {
                                    try {
                                        v36 = NameSpace.class$4 = Class.forName("[Ljava.lang.Byte;").getComponentType();
                                    }
                                    catch (ClassNotFoundException v37) {
                                        throw new NoClassDefFoundError(v37.getMessage());
                                    }
                                }
                                if (rhsType == v36) break block167;
                                v38 = NameSpace.class$3;
                                if (v38 == null) {
                                    try {
                                        v38 = NameSpace.class$3 = Class.forName("[Ljava.lang.Short;").getComponentType();
                                    }
                                    catch (ClassNotFoundException v39) {
                                        throw new NoClassDefFoundError(v39.getMessage());
                                    }
                                }
                                if (rhsType == v38) break block167;
                                v40 = NameSpace.class$5;
                                if (v40 == null) {
                                    try {
                                        v40 = NameSpace.class$5 = Class.forName("[Ljava.lang.Integer;").getComponentType();
                                    }
                                    catch (ClassNotFoundException v41) {
                                        throw new NoClassDefFoundError(v41.getMessage());
                                    }
                                }
                                if (rhsType == v40) break block167;
                                v42 = NameSpace.class$6;
                                if (v42 == null) {
                                    try {
                                        v42 = NameSpace.class$6 = Class.forName("[Ljava.lang.Long;").getComponentType();
                                    }
                                    catch (ClassNotFoundException v43) {
                                        throw new NoClassDefFoundError(v43.getMessage());
                                    }
                                }
                                if (rhsType != v42) break block168;
                            }
                            return new Float(((Number)rhs).floatValue());
                        }
                        v44 = NameSpace.class$1;
                        if (v44 == null) {
                            try {
                                v44 = NameSpace.class$1 = Class.forName("[Ljava.lang.Character;").getComponentType();
                            }
                            catch (ClassNotFoundException v45) {
                                throw new NoClassDefFoundError(v45.getMessage());
                            }
                        }
                        if (rhsType == v44) {
                            return new Float(((Number)rhs).floatValue());
                        }
                    }
                    if ((v46 = NameSpace.class$8) == null) {
                        try {
                            v46 = NameSpace.class$8 = Class.forName("[Ljava.lang.Double;").getComponentType();
                        }
                        catch (ClassNotFoundException v47) {
                            throw new NoClassDefFoundError(v47.getMessage());
                        }
                    }
                    if (lhsType != v46) break block169;
                    v48 = NameSpace.class$4;
                    if (v48 == null) {
                        try {
                            v48 = NameSpace.class$4 = Class.forName("[Ljava.lang.Byte;").getComponentType();
                        }
                        catch (ClassNotFoundException v49) {
                            throw new NoClassDefFoundError(v49.getMessage());
                        }
                    }
                    if (rhsType == v48) break block170;
                    v50 = NameSpace.class$3;
                    if (v50 == null) {
                        try {
                            v50 = NameSpace.class$3 = Class.forName("[Ljava.lang.Short;").getComponentType();
                        }
                        catch (ClassNotFoundException v51) {
                            throw new NoClassDefFoundError(v51.getMessage());
                        }
                    }
                    if (rhsType == v50) break block170;
                    v52 = NameSpace.class$5;
                    if (v52 == null) {
                        try {
                            v52 = NameSpace.class$5 = Class.forName("[Ljava.lang.Integer;").getComponentType();
                        }
                        catch (ClassNotFoundException v53) {
                            throw new NoClassDefFoundError(v53.getMessage());
                        }
                    }
                    if (rhsType == v52) break block170;
                    v54 = NameSpace.class$6;
                    if (v54 == null) {
                        try {
                            v54 = NameSpace.class$6 = Class.forName("[Ljava.lang.Long;").getComponentType();
                        }
                        catch (ClassNotFoundException v55) {
                            throw new NoClassDefFoundError(v55.getMessage());
                        }
                    }
                    if (rhsType == v54) break block170;
                    v56 = NameSpace.class$7;
                    if (v56 == null) {
                        try {
                            v56 = NameSpace.class$7 = Class.forName("[Ljava.lang.Float;").getComponentType();
                        }
                        catch (ClassNotFoundException v57) {
                            throw new NoClassDefFoundError(v57.getMessage());
                        }
                    }
                    if (rhsType != v56) break block171;
                }
                return new Double(((Number)rhs).doubleValue());
            }
            v58 = NameSpace.class$1;
            if (v58 == null) {
                try {
                    v58 = NameSpace.class$1 = Class.forName("[Ljava.lang.Character;").getComponentType();
                }
                catch (ClassNotFoundException v59) {
                    throw new NoClassDefFoundError(v59.getMessage());
                }
            }
            if (rhsType == v58) {
                return new Double(((Number)rhs).doubleValue());
            }
        }
        if (Capabilities.canGenerateInterfaces() && lhsType.isInterface() && rhs instanceof This) {
            return ((This)rhs).getInterface(lhsType);
        }
        NameSpace.assignmentError(lhsType, originalType);
        return rhs;
    }

    private static void assignmentError(Class lhs, Class rhs) throws EvalError {
        String lhsType = Reflect.normalizeClassName(lhs);
        String rhsType = Reflect.normalizeClassName(rhs);
        throw new EvalError("Can't assign " + rhsType + " to " + lhsType);
    }

    public String toString() {
        return "NameSpace: " + (this.name == null ? super.toString() : String.valueOf(this.name) + " (" + super.toString() + ")");
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    public Object invokeMethod(String methodName, Object[] args, Interpreter interpreter) throws EvalError {
        return this.invokeMethod(methodName, args, interpreter, null, null);
    }

    public Object invokeMethod(String methodName, Object[] args, Interpreter interpreter, CallStack callstack, SimpleNode callerInfo) throws EvalError {
        BshMethod meth;
        if (callstack == null) {
            callstack = new CallStack();
            callstack.push(this);
        }
        if ((meth = this.getMethod(methodName, Reflect.getTypes(args))) != null) {
            return meth.invokeDeclaredMethod(args, interpreter, callstack, callerInfo);
        }
        meth = this.getMethod("invoke", new Class[2]);
        if (meth != null) {
            return meth.invokeDeclaredMethod(new Object[]{methodName, args}, interpreter, callstack, callerInfo);
        }
        throw new EvalError("No locally declared method: " + methodName + " in namespace: " + this);
    }

    public void classLoaderChanged() {
        this.nameSpaceChanged();
    }

    public void nameSpaceChanged() {
        this.classCache = null;
    }

    public void loadDefaultImports() {
        this.importClass("bsh.EvalError");
        this.importPackage("javax.swing.event");
        this.importPackage("javax.swing");
        this.importPackage("java.awt.event");
        this.importPackage("java.awt");
        this.importPackage("java.net");
        this.importPackage("java.util");
        this.importPackage("java.io");
        this.importPackage("java.lang");
    }

    Name getNameResolver(String name) {
        return new Name(this, name);
    }

    public int getInvocationLine() {
        SimpleNode node = this.getNode();
        if (node != null) {
            return node.getLineNumber();
        }
        return -1;
    }

    public String getInvocationText() {
        SimpleNode node = this.getNode();
        if (node != null) {
            return node.getText();
        }
        return "<invoked from Java code>";
    }

    public static Class identifierToClass(Name.ClassIdentifier ci) {
        return ci.getTargetClass();
    }

    public void clear() {
        this.variables = null;
        this.methods = null;
        this.importedClasses = null;
        this.importedPackages = null;
        superImport = false;
        if (this.parent == null) {
            this.loadDefaultImports();
        }
        this.classCache = null;
    }

    static class TypedVariable
    implements Serializable {
        Class type;
        Object value = null;
        boolean isFinal;

        TypedVariable(Class type, Object value, boolean isFinal) throws EvalError {
            this.type = type;
            if (type == null) {
                throw new InterpreterError("null type in typed var: " + value);
            }
            this.isFinal = isFinal;
            this.setValue(value);
        }

        void setValue(Object val) throws EvalError {
            if (this.isFinal && this.value != null) {
                throw new EvalError("Final variable, can't assign");
            }
            if ((val = NameSpace.getAssignableForm(val, this.type)) instanceof Primitive && ((Primitive)val).isNumber()) {
                try {
                    val = BSHCastExpression.castPrimitive((Primitive)val, this.type);
                }
                catch (EvalError e) {
                    throw new InterpreterError("auto assignment cast failed");
                }
            }
            this.value = val;
        }

        Object getValue() {
            return this.value;
        }

        Class getType() {
            return this.type;
        }

        public String toString() {
            return "TypedVariable: " + this.type + ", value:" + this.value;
        }
    }
}

