/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHMethodDeclaration;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import java.io.Serializable;

public class BshMethod
implements Serializable {
    BSHMethodDeclaration method;
    NameSpace declaringNameSpace;
    private Class[] argTypes;

    BshMethod(BSHMethodDeclaration method, NameSpace declaringNameSpace) {
        this.method = method;
        this.declaringNameSpace = declaringNameSpace;
    }

    public Class[] getArgTypes() {
        if (this.argTypes == null) {
            this.argTypes = this.method.params.argTypes;
        }
        return this.argTypes;
    }

    public String getName() {
        return this.method.name;
    }

    public Object invoke(Object[] argValues, Interpreter interpreter, CallStack callstack) throws EvalError {
        return this.invokeDeclaredMethod(argValues, interpreter, callstack, null);
    }

    Object invokeDeclaredMethod(Object[] argValues, Interpreter interpreter, CallStack callstack, SimpleNode callerInfo) throws EvalError {
        if (argValues == null) {
            argValues = new Object[]{};
        }
        if (argValues.length != this.method.params.numArgs) {
            try {
                String help = (String)this.declaringNameSpace.get("bsh.help." + this.method.name, interpreter);
                interpreter.println(help);
                return Primitive.VOID;
            }
            catch (Exception e) {
                throw new EvalError("Wrong number of arguments for local method: " + this.method.name, callerInfo);
            }
        }
        NameSpace localNameSpace = new NameSpace(this.declaringNameSpace, this.method.name);
        localNameSpace.setNode(callerInfo);
        int i = 0;
        while (i < this.method.params.numArgs) {
            if (this.method.params.argTypes[i] != null) {
                try {
                    argValues[i] = NameSpace.getAssignableForm(argValues[i], this.method.params.argTypes[i]);
                }
                catch (EvalError e) {
                    throw new EvalError("Invalid argument: `" + this.method.params.argNames[i] + "'" + " for method: " + this.method.name + " : " + e.getMessage(), callerInfo);
                }
                localNameSpace.setTypedVariable(this.method.params.argNames[i], this.method.params.argTypes[i], argValues[i], false);
            } else {
                if (argValues[i] == Primitive.VOID) {
                    throw new EvalError("Undefined variable or class name, parameter: " + this.method.params.argNames[i] + " to method: " + this.method.name, callerInfo);
                }
                localNameSpace.setVariable(this.method.params.argNames[i], argValues[i]);
            }
            ++i;
        }
        callstack.push(localNameSpace);
        Object ret = this.method.block.eval(callstack, interpreter, true);
        callstack.pop();
        if (ret instanceof ReturnControl) {
            ReturnControl rs = (ReturnControl)ret;
            if (rs.kind == 40) {
                ret = ((ReturnControl)ret).value;
            } else {
                throw new EvalError("continue or break in method body", this.method);
            }
        }
        if (this.method.returnType != null) {
            if (this.method.returnType == Primitive.VOID) {
                return this.method.returnType;
            }
            try {
                ret = NameSpace.getAssignableForm(ret, (Class)this.method.returnType);
            }
            catch (EvalError e) {
                throw new EvalError("Incorrect type returned from method: " + this.method.name + e.getMessage(), this.method);
            }
        }
        return ret;
    }

    public String toString() {
        return "Bsh Method: " + this.method.name;
    }
}

