/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHArrayInitializer
extends SimpleNode {
    BSHArrayInitializer(int id) {
        super(id);
    }

    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        throw new EvalError("Array initializer has no base type.");
    }

    public Object eval(Class baseType, int dimensions, CallStack callstack, Interpreter interpreter) throws EvalError {
        int numInitializers = this.jjtGetNumChildren();
        int[] dima = new int[dimensions];
        dima[0] = numInitializers;
        Object initializers = Array.newInstance(baseType, dima);
        int i = 0;
        while (i < numInitializers) {
            Object currentInitializer;
            SimpleNode node = (SimpleNode)this.jjtGetChild(i);
            if (node instanceof BSHArrayInitializer) {
                if (dimensions < 2) {
                    throw new EvalError("Invalid Location for Intializer, position: " + i, this);
                }
                currentInitializer = ((BSHArrayInitializer)node).eval(baseType, dimensions - 1, callstack, interpreter);
            } else {
                currentInitializer = node.eval(callstack, interpreter);
            }
            if (currentInitializer == Primitive.VOID) {
                throw new EvalError("Void in array initializer, position" + i, this);
            }
            Object value = currentInitializer instanceof Primitive ? ((Primitive)currentInitializer).getValue() : currentInitializer;
            try {
                Array.set(initializers, i, value);
            }
            catch (IllegalArgumentException e) {
                Interpreter.debug("illegal arg" + e);
                this.throwTypeError(baseType, currentInitializer, i);
            }
            catch (ArrayStoreException e) {
                Interpreter.debug("arraystore" + e);
                this.throwTypeError(baseType, currentInitializer, i);
            }
            ++i;
        }
        return initializers;
    }

    private void throwTypeError(Class baseType, Object initializer, int argNum) throws EvalError {
        String lhsType = Reflect.normalizeClassName(baseType);
        String rhsType = initializer instanceof Primitive ? ((Primitive)initializer).getType().getName() : Reflect.normalizeClassName(initializer.getClass());
        throw new EvalError("Incompatible type: " + rhsType + " in initializer of array type: " + baseType + " at position: " + argNum, this);
    }
}

