/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Utils {
    public static boolean copyFile(File file, File file2, boolean bl) {
        if (!file.exists() && !file.canRead()) {
            return false;
        }
        if (file2.exists() && !bl) {
            return false;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            return Utils.copyStream(fileInputStream, fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public static boolean copyStream(InputStream inputStream, FileOutputStream fileOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        fileOutputStream.close();
        return true;
    }

    public static boolean writeToFile(String string, FileOutputStream fileOutputStream) {
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        printWriter.println(string);
        printWriter.flush();
        printWriter.close();
        return true;
    }

    public static String md5sum(File file) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        return Utils.createMD5(new FileInputStream(file));
    }

    public static boolean compareMD5(File file, String string) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        return string.equals(Utils.md5sum(file));
    }

    private static String createMD5(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
        while (digestInputStream.read() != -1) {
        }
        digestInputStream.close();
        inputStream.close();
        byte[] byArray = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(0xFF & byArray[i]);
            if (string.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

