/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.system.GraphicGroupObserver;
import madkit.system.GroupObserver;
import madkit.system.GroupTreeNode;
import madkit.system.OrgTreeCellRenderer;
import madkit.utils.graphics.GraphicUtils;

class TreeGroupObserverPanel
extends JPanel
implements ActionListener {
    GroupObserver myAgent;
    private JPanel jPanel1;
    private JScrollPane treeScrollPane;
    private JButton refreshButton;
    protected DefaultMutableTreeNode top;
    protected DefaultTreeModel treeModel;
    protected DefaultMutableTreeNode publicCommunity;
    JPopupMenu groupPopup;
    JPopupMenu communityPopup;
    JPopupMenu agentPopup;
    TreePath popupPath;
    GroupTreeNode selectedElement;
    protected JTree orgTree;
    Hashtable lastOrg = null;

    TreeGroupObserverPanel(GroupObserver groupObserver) {
        this.myAgent = groupObserver;
        this.setLayout(new BorderLayout());
        this.treeScrollPane = new JScrollPane();
        this.top = new DefaultMutableTreeNode("Madkit organization");
        this.publicCommunity = new DefaultMutableTreeNode("public");
        this.top.add(this.publicCommunity);
        this.treeModel = new DefaultTreeModel(this.top);
        this.orgTree = new JTree(this.treeModel);
        this.orgTree.getSelectionModel().setSelectionMode(1);
        this.orgTree.setShowsRootHandles(true);
        this.orgTree.setRootVisible(false);
        OrgTreeCellRenderer orgTreeCellRenderer = new OrgTreeCellRenderer();
        this.orgTree.setCellRenderer(orgTreeCellRenderer);
        this.treeScrollPane.setViewportView(this.orgTree);
        this.treeScrollPane.setPreferredSize(new Dimension(300, 200));
        this.add((Component)this.treeScrollPane, "Center");
        this.groupPopup = new JPopupMenu();
        this.addCommand(this.groupPopup, "trace messages of this group", "selectGroup");
        this.addCommand(this.groupPopup, "trace messages of all groups", "unSelectGroup");
        this.addCommand(this.groupPopup, "sequence diagram of this group", "groupSequenceDiagram");
        this.communityPopup = new JPopupMenu();
        this.addCommand(this.communityPopup, "sequence diagram of this community", "communitySequenceDiagram");
        this.agentPopup = new JPopupMenu();
        this.addCommand(this.agentPopup, "properties", "properties");
        MouseAdapter mouseAdapter = new MouseAdapter(){
            JPopupMenu groupPop;
            JPopupMenu communityPop;
            {
                this.groupPop = TreeGroupObserverPanel.this.groupPopup;
                this.communityPop = TreeGroupObserverPanel.this.communityPopup;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                int n = TreeGroupObserverPanel.this.orgTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = TreeGroupObserverPanel.this.orgTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1 && GraphicUtils.isPopupTrigger((MouseEvent)mouseEvent)) {
                    if (treePath.getPathCount() == 4) {
                        TreeGroupObserverPanel.this.popupPath = treePath;
                        TreeGroupObserverPanel.this.agentPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (treePath.getPathCount() == 3) {
                        TreeGroupObserverPanel.this.popupPath = treePath;
                        this.groupPop.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (treePath.getPathCount() == 2) {
                        TreeGroupObserverPanel.this.popupPath = treePath;
                        this.communityPop.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        };
        this.orgTree.addMouseListener(mouseAdapter);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Class[] classArray = new Class[]{};
        try {
            Method method = this.getClass().getMethod(string, classArray);
            method.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("command : " + string + " unknown");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println(invocationTargetException + ", command: " + string);
        }
    }

    public void properties() {
        String string = this.popupPath.getLastPathComponent().toString();
        System.out.println("properties of : " + string);
    }

    public void selectGroup() {
        if (this.selectedElement != null) {
            this.selectedElement.setSelected(false);
        }
        this.selectedElement = (GroupTreeNode)this.popupPath.getLastPathComponent();
        this.selectedElement.setSelected(true);
        this.myAgent.enterGroup(this.popupPath.getLastPathComponent().toString());
    }

    public void unSelectGroup() {
        if (this.selectedElement != null) {
            this.selectedElement.setSelected(false);
        }
        this.myAgent.leaveGroups();
    }

    public void groupSequenceDiagram() {
        String string = this.popupPath.getLastPathComponent().toString();
        HashMap hashMap = new HashMap();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String string2 = this.popupPath.getParentPath().getLastPathComponent().toString();
        hashMap2.put("Community", string2);
        hashMap2.put("Group", string);
        hashMap.put("toSpy", hashMap2);
        GraphicGroupObserver graphicGroupObserver = new GraphicGroupObserver(hashMap);
        this.myAgent.launchAgent((AbstractAgent)graphicGroupObserver, "spying: " + string, true);
    }

    public void communitySequenceDiagram() {
        String string = this.popupPath.getLastPathComponent().toString();
        HashMap hashMap = new HashMap();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("Community", string);
        hashMap.put("toSpy", hashMap2);
        GraphicGroupObserver graphicGroupObserver = new GraphicGroupObserver(hashMap);
        this.myAgent.launchAgent((AbstractAgent)graphicGroupObserver, "spying: " + string, true);
    }

    void addCommand(JPopupMenu jPopupMenu, String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
    }

    DefaultMutableTreeNode addCommunity(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(defaultMutableTreeNode, this.top, this.treeModel.getChildCount(this.top));
        return defaultMutableTreeNode;
    }

    DefaultMutableTreeNode addGroup(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2) {
        GroupTreeNode groupTreeNode = new GroupTreeNode(string);
        this.treeModel.insertNodeInto(groupTreeNode, defaultMutableTreeNode, this.treeModel.getChildCount(defaultMutableTreeNode));
        this.addRole(groupTreeNode, "founder", string2);
        return groupTreeNode;
    }

    void addRole(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, this.treeModel.getChildCount(defaultMutableTreeNode));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string2);
        this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, this.treeModel.getChildCount(defaultMutableTreeNode2));
    }

    void createGroup(String string, String string2, String string3) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.findCommunity(string);
        if (defaultMutableTreeNode2 == null) {
            defaultMutableTreeNode2 = this.addCommunity(string);
        }
        if ((defaultMutableTreeNode = this.findGroup(defaultMutableTreeNode2, string2)) == null) {
            this.addGroup(defaultMutableTreeNode2, string2, string3);
        }
    }

    void enterRole(String string, String string2, String string3, String string4) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3 = this.findCommunity(string);
        if (defaultMutableTreeNode3 == null) {
            defaultMutableTreeNode3 = this.addCommunity(string);
        }
        if ((defaultMutableTreeNode2 = this.findGroup(defaultMutableTreeNode3, string2)) == null) {
            defaultMutableTreeNode2 = this.addGroup(defaultMutableTreeNode3, string2, string4);
        }
        if ((defaultMutableTreeNode = this.findRole(defaultMutableTreeNode2, string3)) == null) {
            this.addRole(defaultMutableTreeNode2, string3, string4);
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(string4);
            this.treeModel.insertNodeInto(defaultMutableTreeNode4, defaultMutableTreeNode, this.treeModel.getChildCount(defaultMutableTreeNode));
        }
    }

    void leaveRole(String string, String string2, String string3, String string4) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findCommunity(string);
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.findGroup(defaultMutableTreeNode, string2);
        if (defaultMutableTreeNode2 == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = this.findRole(defaultMutableTreeNode2, string3);
        if (defaultMutableTreeNode3 == null) {
            return;
        }
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode3.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!((String)defaultMutableTreeNode4.getUserObject()).equals(string4)) continue;
            vector.addElement(defaultMutableTreeNode4);
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)vector.elementAt(i));
        }
        if (defaultMutableTreeNode3.getChildCount() == 0) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode3);
        }
        if (defaultMutableTreeNode2.getChildCount() == 0 || defaultMutableTreeNode2.getChildCount() == 1 && this.findRole(defaultMutableTreeNode2, "founder") != null) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
        if (defaultMutableTreeNode.getChildCount() == 0 && !((String)defaultMutableTreeNode.getUserObject()).equals("public")) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    void leaveGroup(String string, String string2, String string3) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findCommunity(string);
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.findGroup(defaultMutableTreeNode, string2);
        if (defaultMutableTreeNode2 == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.children();
        while (enumeration.hasMoreElements()) {
            boolean bl = false;
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode3.children();
            while (enumeration2.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)enumeration2.nextElement();
                if (!((String)defaultMutableTreeNode4.getUserObject()).equals(string3)) continue;
                vector.addElement(defaultMutableTreeNode4);
                bl = true;
            }
            if (!bl || defaultMutableTreeNode3.getChildCount() != 1) continue;
            vector.addElement(defaultMutableTreeNode3);
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)vector.elementAt(i));
        }
        if (defaultMutableTreeNode2.getChildCount() == 0) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
        if (defaultMutableTreeNode.getChildCount() == 0 && !((String)defaultMutableTreeNode.getUserObject()).equals("public")) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    void killAgent(String string) {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        Enumeration<TreeNode> enumeration = this.top.children();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            Enumeration<TreeNode> enumeration2 = stringArray.children();
            while (enumeration2.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration2.nextElement();
                Enumeration<TreeNode> enumeration3 = defaultMutableTreeNode.children();
                while (enumeration3.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration3.nextElement();
                    Enumeration<TreeNode> enumeration4 = defaultMutableTreeNode2.children();
                    while (enumeration4.hasMoreElements()) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration4.nextElement();
                        if (!((String)defaultMutableTreeNode3.getUserObject()).equals(string)) continue;
                        String[] stringArray2 = new String[]{(String)stringArray.getUserObject(), (String)defaultMutableTreeNode.getUserObject(), string};
                        vector.addElement(stringArray2);
                    }
                }
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            stringArray = (String[])vector.elementAt(i);
            this.leaveGroup(stringArray[0], stringArray[1], stringArray[2]);
        }
    }

    DefaultMutableTreeNode findGroup(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!((String)defaultMutableTreeNode2.getUserObject()).equals(string)) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    DefaultMutableTreeNode findCommunity(String string) {
        Enumeration<TreeNode> enumeration = this.top.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!((String)defaultMutableTreeNode.getUserObject()).equals(string)) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    DefaultMutableTreeNode findRole(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (defaultMutableTreeNode == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!((String)defaultMutableTreeNode2.getUserObject()).equals(string)) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    void deleteCommunity(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (!string.equals("public") && (defaultMutableTreeNode = this.findCommunity(string)) != null) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    void refresh() {
        Object var1_1 = null;
        this.myAgent.requestDumpCommunities();
    }

    void installCommunities(Map map) {
        this.top.removeAllChildren();
        for (Map.Entry entry : map.entrySet()) {
            this.top.add(new DefaultMutableTreeNode(entry.getKey()));
            this.installOrg((String)entry.getKey(), (Hashtable)entry.getValue());
        }
    }

    void addCommunities(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            if (this.findCommunity(string) != null) continue;
            this.top.add(new DefaultMutableTreeNode(string));
            this.installOrg((String)entry.getKey(), (Hashtable)entry.getValue());
        }
    }

    void installOrg(String string, Hashtable hashtable) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findCommunity(string);
        if (defaultMutableTreeNode != null) {
            defaultMutableTreeNode.removeFromParent();
        }
        defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        this.top.add(defaultMutableTreeNode);
        this.installOrg(defaultMutableTreeNode, hashtable);
    }

    void installOrg(DefaultMutableTreeNode defaultMutableTreeNode, Hashtable hashtable) {
        this.lastOrg = hashtable;
        GroupTreeNode groupTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        String string = "";
        defaultMutableTreeNode.removeAllChildren();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            groupTreeNode = new GroupTreeNode(string);
            defaultMutableTreeNode.add(groupTreeNode);
            Hashtable hashtable2 = (Hashtable)hashtable.get(string);
            if (hashtable2 == null) continue;
            Enumeration enumeration2 = hashtable2.keys();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
                groupTreeNode.add(defaultMutableTreeNode2);
                Vector vector = (Vector)hashtable2.get(string2);
                Enumeration enumeration3 = vector.elements();
                while (enumeration3.hasMoreElements()) {
                    AgentAddress agentAddress = (AgentAddress)enumeration3.nextElement();
                    String string3 = agentAddress.toString();
                    defaultMutableTreeNode3 = new DefaultMutableTreeNode(string3);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                }
            }
        }
        this.treeModel.reload();
    }

    public void clear() {
        this.top.removeAllChildren();
        this.treeModel.reload();
    }
}

