/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.system.Monitor;

public class MemoryMonitorAgent
extends Agent
implements ActionListener {
    Monitor monitor;
    Runtime runtime = Runtime.getRuntime();
    boolean working = true;
    JLabel threadsinfo;

    public void initGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.threadsinfo = new JLabel("                 ");
        JButton jButton = new JButton("GC");
        JButton jButton2 = new JButton("Start");
        JButton jButton3 = new JButton("Stop");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel2.add(jButton);
        jPanel.add((Component)this.threadsinfo, "North");
        jPanel.add((Component)jPanel2, "South");
        this.monitor = new Monitor();
        jPanel.add((Component)this.monitor, "Center");
        this.monitor.setTopString("K allocated");
        this.monitor.setBottomString("K used");
        this.setGUIObject(jPanel);
    }

    public void activate() {
        this.requestRole("system", "memory monitor", null);
        float f = this.runtime.freeMemory();
        float f2 = this.runtime.totalMemory();
        float f3 = f2 - f;
        this.monitor.setValues(f2 / 1024.0f, f3 / 1024.0f);
    }

    void showThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        String string = threadGroup.getName();
        int n = threadGroup.activeCount();
        this.threadsinfo.setText("ThreadGroup: " + string + ", num: " + n);
    }

    public void live() {
        while (true) {
            Message message;
            if (!this.working) {
                message = this.waitNextMessage();
                this.handleMessage(message);
                continue;
            }
            this.pause(1000);
            float f = this.runtime.freeMemory();
            float f2 = this.runtime.totalMemory();
            float f3 = f2 - f;
            this.monitor.setValues(f2 / 1024.0f, f3 / 1024.0f);
            message = this.nextMessage();
            if (message != null) {
                this.handleMessage(message);
            }
            this.showThreads();
        }
    }

    void handleMessage(Message message) {
        if (message instanceof StringMessage) {
            String string = ((StringMessage)message).getString();
            if (string.equals("start")) {
                this.working = true;
            } else if (string.equals("stop")) {
                this.working = false;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("GC")) {
            System.out.println("GC...");
            this.runtime.gc();
        } else if (string.equals("Start")) {
            this.sendMessage(this.getAddress(), (Message)new StringMessage("start"));
        } else if (string.equals("Stop")) {
            this.sendMessage(this.getAddress(), (Message)new StringMessage("stop"));
        }
    }
}

