/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import madkit.system.MadkitOutput;
import madkit.utils.graphics.JTextAreaOutputStream;

class MadkitOutputGUI
extends JPanel
implements ActionListener {
    protected PrintStream out;
    protected JTextAreaOutputStream outStream;
    protected JButton clear;
    protected JButton save;
    protected JTextArea outputArea;
    protected MadkitOutput myAgent;

    public MadkitOutputGUI(MadkitOutput madkitOutput) {
        this.myAgent = madkitOutput;
        JScrollPane jScrollPane = new JScrollPane();
        this.outputArea = new JTextArea(6, 90);
        jScrollPane.setSize(300, 140);
        jScrollPane.getViewport().add(this.outputArea);
        this.outStream = new JTextAreaOutputStream(this.outputArea);
        this.out = new PrintStream((OutputStream)this.outStream, true);
        System.setOut(this.out);
        System.setErr(this.out);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        this.save = new JButton("Save as...");
        this.save.addActionListener(this);
        jPanel.add(this.save);
        this.clear = new JButton("Clear output");
        this.clear.addActionListener(this);
        jPanel.add(this.clear);
        this.add((Component)jPanel, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.clear) {
            this.outStream.clear();
        }
        if (object == this.save) {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            jFileChooser.setDialogType(1);
            jFileChooser.setSelectedFile(new File("Output.txt"));
            if (jFileChooser.showOpenDialog(this) == 0) {
                try {
                    FileWriter fileWriter = new FileWriter(jFileChooser.getSelectedFile());
                    fileWriter.write(this.outputArea.getText());
                    fileWriter.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }
}

