/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import madkit.system.GroupObserver;
import madkit.system.TreeGroupObserverPanel;

class GroupObserverGUI
extends JPanel {
    JTable messagesTable;
    JTable actionsTable;
    DefaultTableModel messagesModel;
    DefaultTableModel actionsModel;
    JSplitPane jp;
    Vector messages = new Vector();
    GroupObserver myAgent;
    JLabel messageDisplay = new JLabel("msg:");
    TreeGroupObserverPanel tree;
    String[] messagesColumnNames = new String[]{"Sender", "Receiver", "Message Class", "Content", "Date"};
    String[] actionsColumnNames = new String[]{"Agent", "Action", "Community", "Group", "Role", "Date"};

    void setMessageDisplay(String string) {
        this.messageDisplay.setText("msg:" + string);
    }

    TreeGroupObserverPanel getTree() {
        return this.tree;
    }

    void addTool(JToolBar jToolBar, String string, String string2) {
        JButton jButton;
        if (string2 == null || string2.equals("")) {
            jButton = (JButton)jToolBar.add(new JButton(string));
            jButton.setActionCommand(string);
        } else {
            ImageIcon imageIcon = null;
            URL uRL = this.getClass().getResource(string2);
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
            jButton = imageIcon != null && imageIcon.getImage() != null ? (JButton)jToolBar.add(new JButton(imageIcon)) : (JButton)jToolBar.add(new JButton(string));
            jButton.setActionCommand(string);
        }
        jButton.setToolTipText(string);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupObserverGUI.this.command(actionEvent.getActionCommand());
            }
        });
    }

    public GroupObserverGUI(GroupObserver groupObserver) {
        this.myAgent = groupObserver;
        this.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        this.addTool(jToolBar, "clear messages", "/images/toolbars/clear_messages24.gif");
        this.addTool(jToolBar, "clear actions", "/images/toolbars/clear_actions24.gif");
        this.addTool(jToolBar, "refresh", "/toolbarButtonGraphics/general/Refresh24.gif");
        this.addTool(jToolBar, "show messages", "/images/toolbars/run.gif");
        this.addTool(jToolBar, "stop messages", "/images/toolbars/halt.gif");
        this.add("North", jToolBar);
        this.tree = new TreeGroupObserverPanel(this.myAgent);
        this.messagesModel = new DefaultTableModel(this.messagesColumnNames, 0);
        this.messagesTable = new JTable(this.messagesModel);
        JScrollPane jScrollPane = new JScrollPane(this.messagesTable);
        this.actionsModel = new DefaultTableModel(this.actionsColumnNames, 0);
        this.actionsTable = new JTable(this.actionsModel);
        JScrollPane jScrollPane2 = new JScrollPane(this.actionsTable);
        this.tree.setPreferredSize(new Dimension(380, 200));
        this.tree.setMinimumSize(new Dimension(100, 80));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Messages", jScrollPane);
        jTabbedPane.add("Actions", jScrollPane2);
        jTabbedPane.setPreferredSize(new Dimension(380, 200));
        jTabbedPane.setMinimumSize(new Dimension(100, 80));
        this.jp = new JSplitPane(0, this.tree, jTabbedPane);
        this.jp.setOneTouchExpandable(true);
        this.jp.setDividerSize(8);
        this.add("Center", this.jp);
        this.jp.setDividerLocation(0.5);
        this.add("South", this.messageDisplay);
    }

    public void addMessage(String string, String string2, String string3, String string4, String string5) {
        Object[] objectArray = new String[]{string, string2, string3, string4, string5};
        this.messagesModel.addRow(objectArray);
    }

    public void addAction(String string, String string2, String string3, String string4, String string5, String string6) {
        Object[] objectArray = new String[]{string, string2, string3, string4, string5, string6};
        this.actionsModel.addRow(objectArray);
    }

    void command(String string) {
        if (string.equals("observe group")) {
            this.observeGroup();
        } else if (string.equals("clear messages")) {
            this.messagesModel = new DefaultTableModel(this.messagesColumnNames, 0);
            this.messagesTable.setModel(this.messagesModel);
        } else if (string.equals("clear actions")) {
            this.actionsModel = new DefaultTableModel(this.actionsColumnNames, 0);
            this.actionsTable.setModel(this.actionsModel);
        } else if (string.equals("refresh")) {
            this.tree.refresh();
            this.jp.validate();
        } else if (string.equals("show messages")) {
            this.myAgent.setShowMessageState(true);
        } else if (string.equals("stop messages")) {
            this.myAgent.setShowMessageState(false);
        }
    }

    void observeGroup() {
    }

    void setTitle(String string) {
        Container container = this;
        while (!(container instanceof JFrame || container instanceof Frame || container instanceof JInternalFrame)) {
            if (container == null) {
                return;
            }
            container = container.getParent();
        }
        if (container instanceof Frame) {
            ((Frame)container).setTitle(string);
        } else if (container instanceof JInternalFrame) {
            ((JInternalFrame)container).setTitle(string);
        }
    }
}

