/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import madkit.kernel.AgentAddress;
import madkit.system.AgentEvent;
import madkit.system.GraphicGroupObserver;
import madkit.system.GraphicGroupObserverGUIPane;

class GraphicGroupObserverGUI
extends JPanel
implements ActionListener {
    GraphicGroupObserverGUIPane graphic;
    GraphicGroupObserver agent;

    public GraphicGroupObserverGUI(GraphicGroupObserver graphicGroupObserver) {
        super(new BorderLayout());
        this.agent = graphicGroupObserver;
        this.graphic = new GraphicGroupObserverGUIPane(this);
        JScrollPane jScrollPane = new JScrollPane(this.graphic);
        this.add((Component)jScrollPane, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Tools");
        JMenuItem jMenuItem = jMenu.add("Remove killed agent");
        jMenuItem.setActionCommand("removeKilled");
        jMenuItem.addActionListener(this);
        if (((Boolean)graphicGroupObserver.getMap().get("addFirst")).booleanValue()) {
            jMenuItem = jMenu.add("Add agent at the end");
            jMenuItem.setActionCommand("addEnd");
            jMenuItem.addActionListener(this);
        } else {
            jMenuItem = jMenu.add("Add agent at the begining");
            jMenuItem.setActionCommand("addFirst");
            jMenuItem.addActionListener(this);
        }
        jMenuBar.add(jMenu);
        this.add((Component)jMenuBar, "North");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("removeKilled")) {
            this.graphic.removeKilledAgent();
        } else if (string.equals("addEnd")) {
            ((JMenuItem)actionEvent.getSource()).setActionCommand("addFirst");
            ((JMenuItem)actionEvent.getSource()).setText("Add agent at the begining");
            this.agent.getMap().put("addFirst", new Boolean(false));
        } else if (string.equals("addFirst")) {
            ((JMenuItem)actionEvent.getSource()).setActionCommand("addEnd");
            ((JMenuItem)actionEvent.getSource()).setText("Add agent at the end");
            this.agent.getMap().put("addFirst", new Boolean(true));
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 400);
    }

    public HashMap getMap() {
        return this.agent.getMap();
    }

    public void addExistingAgent(AgentAddress agentAddress, HashMap hashMap) {
        this.graphic.addExistingAgent(agentAddress, hashMap);
    }

    public void addMemberRole(AgentEvent agentEvent, HashMap hashMap) {
        this.graphic.addMemberRole(agentEvent, hashMap);
    }

    public void removeFrom(AgentEvent agentEvent, HashMap hashMap) {
        this.graphic.removeFrom(agentEvent, hashMap);
    }

    public void removeAllFrom(AgentEvent agentEvent, HashMap hashMap) {
        this.graphic.removeAllFrom(agentEvent, hashMap);
    }

    public void killAgent(AgentEvent agentEvent) {
        this.graphic.killAgent(agentEvent);
    }

    public void addMessage(AgentEvent agentEvent) {
        this.graphic.addMessage(agentEvent);
    }

    public void addBroadcastMessage(AgentEvent agentEvent) {
        this.graphic.addBroadcastMessage(agentEvent);
    }
}

