/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import madkit.system.EditorAgent;

class EditorSetTargetDialog
extends JDialog
implements ActionListener {
    String currentCommunity;
    String currentGroup;
    String currentRole;
    String[] communities;
    String[] groups;
    String[] roles;
    JList groupList;
    JList roleList;
    EditorAgent ag;

    public EditorSetTargetDialog(EditorAgent editorAgent, Frame frame) {
        super(frame, true);
        this.setTitle("Setting a target");
        this.setLocationRelativeTo(frame);
        this.ag = editorAgent;
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Apply");
        JButton jButton3 = new JButton("Cancel");
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jPanel.add(jButton2);
        jButton2.addActionListener(this);
        jPanel.add(jButton3);
        jButton3.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 10, 10));
        this.getContentPane().add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add(jPanel3);
        JLabel jLabel = new JLabel("Communities");
        jPanel3.add((Component)jLabel, "North");
        this.communities = this.ag.getAvailableCommunities();
        JList<String> jList = new JList<String>(this.communities);
        jList.setFixedCellWidth(20);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jPanel3.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel2.add(jPanel4);
        JLabel jLabel2 = new JLabel("Groups");
        jPanel4.add((Component)jLabel2, "North");
        this.groups = this.ag.getExistingGroups("public");
        this.groupList = new JList<String>(this.groups);
        this.groupList.setFixedCellWidth(20);
        JScrollPane jScrollPane2 = new JScrollPane(this.groupList);
        jPanel4.add((Component)jScrollPane2, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel2.add(jPanel5);
        JLabel jLabel3 = new JLabel("Roles");
        jPanel5.add((Component)jLabel3, "North");
        this.roleList = new JList();
        this.roleList.setFixedCellWidth(20);
        JScrollPane jScrollPane3 = new JScrollPane(this.roleList);
        jPanel5.add((Component)jScrollPane3, "Center");
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                JList jList = (JList)listSelectionEvent.getSource();
                if (!jList.isSelectionEmpty()) {
                    int n = jList.getSelectedIndex();
                    EditorSetTargetDialog.this.currentCommunity = EditorSetTargetDialog.this.communities[n];
                    EditorSetTargetDialog.this.ag.setTargetCommunity(EditorSetTargetDialog.this.currentCommunity);
                    EditorSetTargetDialog.this.groups = EditorSetTargetDialog.this.ag.getExistingGroups(EditorSetTargetDialog.this.currentCommunity);
                    EditorSetTargetDialog.this.groupList.setListData(EditorSetTargetDialog.this.groups);
                    EditorSetTargetDialog.this.roles = new String[0];
                    EditorSetTargetDialog.this.roleList.setListData(EditorSetTargetDialog.this.roles);
                }
            }
        });
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                JList jList = (JList)listSelectionEvent.getSource();
                if (!jList.isSelectionEmpty()) {
                    int n = jList.getSelectedIndex();
                    EditorSetTargetDialog.this.currentGroup = EditorSetTargetDialog.this.groups[n];
                    EditorSetTargetDialog.this.ag.setTargetGroup(EditorSetTargetDialog.this.currentGroup);
                    EditorSetTargetDialog.this.roles = EditorSetTargetDialog.this.ag.getExistingRoles(EditorSetTargetDialog.this.currentCommunity, EditorSetTargetDialog.this.currentGroup);
                    EditorSetTargetDialog.this.roleList.setListData(EditorSetTargetDialog.this.roles);
                }
            }
        });
        this.roleList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                try {
                    JList jList = (JList)listSelectionEvent.getSource();
                    int n = jList.getSelectedIndex();
                    EditorSetTargetDialog.this.ag.setTargetRole(EditorSetTargetDialog.this.currentRole);
                    EditorSetTargetDialog.this.currentRole = EditorSetTargetDialog.this.roles[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.ag.setTarget(this.currentCommunity, this.currentGroup, this.currentRole);
            this.dispose();
        } else if (string.equals("Apply")) {
            this.ag.setTarget(this.currentGroup, this.currentRole);
        } else {
            this.dispose();
        }
    }
}

