/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import madkit.kernel.AbstractAgent;
import madkit.system.EditorAgent;
import madkit.system.EditorGroupDialog;
import madkit.system.EditorLeaveRoleDialog;
import madkit.system.EditorSetTargetDialog;
import madkit.utils.agents.AbstractEditorPanel;
import madkit.utils.graphics.GraphicUtils;

class EditorPanel
extends AbstractEditorPanel {
    JComboBox groupChooser;
    JComboBox roleChooser;
    boolean activeChooser = false;
    JLabel currentCommunityLabel;
    JLabel currentGroupLabel;
    JLabel currentRoleLabel;
    JCheckBoxMenuItem showMessagesItem;
    JCheckBoxMenuItem showOutMessagesItem;
    protected JPanel commandPanel;

    EditorPanel(EditorAgent editorAgent) {
        super((AbstractAgent)editorAgent);
        JMenuBar jMenuBar = this.getMenubar();
        JMenu jMenu = new JMenu("Actions");
        jMenuBar.add(jMenu);
        EditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Join group/role", (String)"joingroup", (int)74, (int)74);
        EditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Leave group/role", (String)"requestLeaveRole", (int)74, (int)74);
        EditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Set target", (String)"setTarget", (int)84, (int)84);
        EditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Send selection", (String)"sendsel", (int)69, (int)69);
        EditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Send buffer", (String)"sendbuff", (int)66, (int)66);
        JMenu jMenu2 = new JMenu("Options");
        jMenuBar.add(jMenu2);
        this.showMessagesItem = new JCheckBoxMenuItem("Show incoming messages");
        this.showMessagesItem.setActionCommand("showInMessages");
        this.showMessagesItem.setSelected(true);
        this.showMessagesItem.addActionListener((ActionListener)((Object)this));
        jMenu2.add(this.showMessagesItem);
        this.showOutMessagesItem = new JCheckBoxMenuItem("Show outgoing messages");
        this.showOutMessagesItem.setActionCommand("showOutMessages");
        this.showOutMessagesItem.setSelected(true);
        this.showOutMessagesItem.addActionListener((ActionListener)((Object)this));
        jMenu2.add(this.showOutMessagesItem);
        JToolBar jToolBar = this.getToolbar();
        jToolBar.addSeparator();
        this.addTool(jToolBar, "joingroup", "Join group", "/images/toolbars/joingroup.gif");
        this.addTool(jToolBar, "requestLeaveRole", "Leave role", "/images/toolbars/leaverole.gif");
        this.addTool(jToolBar, "setTarget", "Set target (group/role)", "/images/toolbars/settarget.gif");
        jToolBar.addSeparator();
        this.addTool(jToolBar, "sendbuff", "Send buffer", "/images/toolbars/sendbuf.gif");
        this.addTool(jToolBar, "sendsel", "Send selection", "/images/toolbars/sendsel.gif");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "South");
        this.currentCommunityLabel = new JLabel("Target community: none   ");
        this.currentGroupLabel = new JLabel("Target group: none");
        this.currentRoleLabel = new JLabel("Target role: none");
        jPanel.add((Component)this.currentCommunityLabel, "West");
        jPanel.add((Component)this.currentGroupLabel, "Center");
        jPanel.add((Component)this.currentRoleLabel, "East");
    }

    public void command(String string) {
        if (string.equals("sendbuff")) {
            this.evalBuffer();
        } else if (string.equals("sendsel")) {
            this.evalSelection();
        } else if (string.equals("setTarget")) {
            this.setTarget();
        } else if (string.equals("requestLeaveRole")) {
            this.requestLeaveRole();
        } else if (string.equals("joingroup")) {
            this.requestJoinGroup();
        } else if (string.equals("showInMessages")) {
            boolean bl = this.showMessagesItem.isSelected();
            ((EditorAgent)this.ag).showInMessages(bl);
        } else if (string.equals("showOutMessages")) {
            boolean bl = this.showOutMessagesItem.isSelected();
            ((EditorAgent)this.ag).showOutMessages(bl);
        } else {
            super.command(string);
        }
    }

    void showCurrentCommunity(String string) {
        this.currentCommunityLabel.setText("Target community: " + string + "   ");
    }

    void showCurrentGroup(String string) {
        this.currentGroupLabel.setText("Target group: " + string);
    }

    void showCurrentRole(String string) {
        this.currentRoleLabel.setText("Target role: " + string);
    }

    void evalBuffer() {
        String string = this.inputArea.getText();
        ((EditorAgent)this.ag).sendString(string);
    }

    void evalSelection() {
        String string = this.inputArea.getSelectedText();
        ((EditorAgent)this.ag).sendString(string);
    }

    void setTarget() {
        new EditorSetTargetDialog((EditorAgent)this.ag, GraphicUtils.getRealFrameParent((Component)((Object)this)));
    }

    void requestLeaveRole() {
        new EditorLeaveRoleDialog((EditorAgent)this.ag, GraphicUtils.getRealFrameParent((Component)((Object)this)));
    }

    void requestJoinGroup() {
        ((EditorAgent)this.ag).requestJoinGroup();
        new EditorGroupDialog((EditorAgent)this.ag, GraphicUtils.getRealFrameParent((Component)((Object)this)));
    }

    void joinGroup(Vector vector) {
        new EditorGroupDialog((EditorAgent)this.ag, GraphicUtils.getRealFrameParent((Component)((Object)this)));
    }
}

