/*
 * Decompiled with CFR 0.152.
 */
package madkit.docbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import madkit.docbrowser.DocLink;
import madkit.docbrowser.DocTree;
import madkit.docbrowser.MadkitHelpMenu;
import madkit.docbrowser.NavigationBar;
import madkit.kernel.AbstractAgent;

class BrowserGUI
extends JPanel
implements HyperlinkListener {
    private JTextField _urlField;
    private JEditorPane _htmlPane;
    private NavigationBar _navBar;
    private File _docXMLFile;
    private DocTree tree;
    AbstractAgent _agent;

    public BrowserGUI(File file, AbstractAgent abstractAgent) {
        this._agent = abstractAgent;
        this._docXMLFile = file;
        this.setLayout(new BorderLayout());
        this._urlField = new JTextField();
        this._urlField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserGUI.this.setPage(BrowserGUI.this._urlField.getText());
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this._urlField, "Center");
        jPanel.add((Component)new JLabel("Location :"), "West");
        JButton jButton = new JButton("Go");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserGUI.this.setPage(BrowserGUI.this._urlField.getText());
            }
        });
        jPanel.add((Component)jButton, "East");
        this._navBar = new NavigationBar(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this._navBar);
        jPanel2.add((Component)jToolBar, "West");
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.add(jPanel);
        jPanel2.add((Component)jToolBar2, "South");
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(new MadkitHelpMenu(this._agent, "docbrowser", "DocBrowser Plugin"));
        jPanel2.add((Component)jMenuBar, "North");
        this._htmlPane = new JEditorPane();
        this._htmlPane.addHyperlinkListener(this);
        this._htmlPane.setEditable(false);
        this.tree = new DocTree(this._docXMLFile, this);
        this.add((Component)jPanel2, "North");
        JSplitPane jSplitPane = new JSplitPane(1);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this._htmlPane);
        jSplitPane.setRightComponent(jScrollPane);
        jSplitPane.setLeftComponent(this.tree);
        this.add((Component)jSplitPane, "Center");
        this.setPreferredSize(new Dimension(600, 400));
    }

    void setPage(String string) {
        try {
            this._htmlPane.setPage(string);
            this._urlField.setText(string);
            this._navBar.setPage(string);
        }
        catch (IOException iOException) {
            this.setErrorPage(string, iOException);
        }
    }

    private void setErrorPage(String string, IOException iOException) {
        String string2 = "<html><head><title>Error</title></head><body>";
        string2 = string2 + "<h1>ERROR </h1> Impossible to load " + string + " <br> " + iOException.getMessage() + "</body></html>";
        this._htmlPane.setText(string2);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setPage(hyperlinkEvent.getURL().toExternalForm());
        }
    }

    void displayDoc(String string, String string2) {
        if (string2.equalsIgnoreCase("all")) {
            String string3 = this.tree.getHtmlForPlugin(string);
            String string4 = this._docXMLFile.getParentFile().getAbsolutePath() + File.separatorChar + string + "-all-sections.html";
            File file = new File(string4);
            try {
                BrowserGUI.writeToFile(string3, new FileOutputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.debug("FileNotFoundException caught " + fileNotFoundException.getMessage());
            }
            this.setPage("file://" + string4);
        } else {
            String string5 = this.tree.getDocURL(string, string2);
            if (string5 != null) {
                this.setPage(string5);
            } else {
                this.debug("no such plugin and section" + string + " " + string2);
            }
        }
    }

    void displayLink(String string, DocLink docLink) {
        this.tree.addLink(string, docLink);
    }

    public static boolean writeToFile(String string, FileOutputStream fileOutputStream) {
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        printWriter.println(string);
        printWriter.flush();
        printWriter.close();
        return true;
    }

    private void debug(String string) {
        System.err.println("**debug BrowserGUI** : " + string);
    }
}

