/*
 * Decompiled with CFR 0.152.
 */
package warbot.BPV_team;

import java.util.Vector;
import madkit.kernel.AgentAddress;
import warbot.BPV_team.Cible;
import warbot.BPV_team.CibleObs;
import warbot.BPV_team.Compteur;
import warbot.BPV_team.Point;
import warbot.BPV_team.Robot;
import warbot.kernel.Percept;
import warbot.kernel.WarbotMessage;

public class BPVExplorer
extends Robot {
    private int num = 0;
    private boolean launcher_vu = false;
    private Vector cibles_observees = new Vector();
    private Vector liste_autres = new Vector();
    private Point objectif = new Point();
    private AgentAddress adr_objectif = null;
    private boolean cible_launcher = false;

    public void activate() {
        super.activate();
        this.synchro = new Compteur(5);
        this.randomHeading();
        this.num = this.getAgentsWithRole(this.groupName, "explorer").length;
        this.broadcast(this.groupName, "explorer", "NUM", String.valueOf(this.num));
        this.definirRoles();
    }

    public void definirRoles() {
        this.createGroup(false, this.groupName, null, null);
        this.requestRole(this.groupName, "explorer", null);
        this.requestRole(this.groupName, "info", null);
        this.requestRole(this.groupName, "mobile", null);
    }

    public void end() {
        this.broadcast(this.groupName, "explorer", "FIN-NUM", String.valueOf(this.num));
        this.broadcast(this.groupName, "launcher", "FIN");
    }

    public void monEtat() {
        for (int i = 0; i < this.cibles_observees.size(); ++i) {
            CibleObs cibleObs = (CibleObs)this.cibles_observees.elementAt(i);
            if (cibleObs.getVuParAutre() != 0) continue;
            String[] stringArray = new String[]{String.valueOf(cibleObs.getX() - this.coordonnees.getX()), String.valueOf(cibleObs.getY() - this.coordonnees.getY()), String.valueOf(cibleObs.getEnergy())};
            if (cibleObs.getType().equals("RocketLauncher")) {
                this.broadcast(this.groupName, "mobile", "HELP1", stringArray);
                continue;
            }
            if (!cibleObs.getType().equals("Explorer")) continue;
            this.broadcast(this.groupName, "mobile", "HELP0", stringArray);
        }
    }

    private double ecartMin(Percept percept) {
        if (percept.getPerceptType().equals("Obstacle")) {
            return 20.0;
        }
        if (percept.getPerceptType().equals("Rocket")) {
            return 30.0;
        }
        if (!percept.getTeam().equals(this.getTeam())) {
            if (percept.getPerceptType().equals("RocketLauncher")) {
                return 120.0;
            }
            return 5.0;
        }
        if (percept.getPerceptType().equals("Explorer")) {
            return 154.0;
        }
        if (!this.cibles_observees.isEmpty()) {
            return 12.0;
        }
        return 0.0;
    }

    private boolean estMonSuperieur(AgentAddress agentAddress) {
        return this.liste_autres.contains(agentAddress);
    }

    private void gestionMessages() {
        while (!this.isMessageBoxEmpty()) {
            Point point;
            double d;
            WarbotMessage warbotMessage = this.readMessage();
            if (warbotMessage.getAct().equals("INFO-QG")) {
                double d2 = warbotMessage.getFromX() + this.enDouble(warbotMessage.getArgN(1)) + this.coordonnees.getX();
                point = new Point(d2, d = warbotMessage.getFromY() + this.enDouble(warbotMessage.getArgN(2)) + this.coordonnees.getY());
                if (this.baseEnnemieConnue(point)) continue;
                this.bases_ennemies.add(point);
                continue;
            }
            if (warbotMessage.getAct().equals("FIN-NUM")) {
                if (Integer.valueOf(warbotMessage.getArg1()) >= this.num) continue;
                --this.num;
                continue;
            }
            if (warbotMessage.getAct().equals("NUM")) {
                this.liste_autres.add(warbotMessage.getSender());
                continue;
            }
            if (warbotMessage.getAct().equals("FIN-QG")) {
                double d3 = warbotMessage.getFromX() + this.enDouble(warbotMessage.getArg1()) + this.coordonnees.getX();
                d = warbotMessage.getFromY() + this.enDouble(warbotMessage.getArg2()) + this.coordonnees.getY();
                point = new Point(d3, d);
                this.baseEnnemieSuppr(point);
                continue;
            }
            if (warbotMessage.getAct().equals("LAUNCHER_VU")) {
                this.launcher_vu = true;
                continue;
            }
            if (warbotMessage.getAct().equals("ROCKET-REQ")) {
                if (this.adr_objectif != null || this.cible_launcher) continue;
                this.send(warbotMessage.getSender(), "ROCKET-OFFRE");
                this.adr_objectif = warbotMessage.getSender();
                Point point2 = new Point(warbotMessage.getFromX() + this.coordonnees.getX() + this.enDouble(warbotMessage.getArg1()), warbotMessage.getFromY() + this.coordonnees.getY() + this.enDouble(warbotMessage.getArg2()));
                this.objectif.setCoord(point2.getX(), point2.getY());
                continue;
            }
            if (warbotMessage.getAct().equals("ROCKET-OK") && this.adr_objectif != null && this.adr_objectif.equals((Object)warbotMessage.getSender())) {
                Point point3 = new Point(warbotMessage.getFromX() + this.coordonnees.getX() + this.enDouble(warbotMessage.getArg1()), warbotMessage.getFromY() + this.coordonnees.getY() + this.enDouble(warbotMessage.getArg2()));
                this.objectif.setCoord(point3.getX(), point3.getY());
                continue;
            }
            if (warbotMessage.getAct().equals("ROCKET-NON")) {
                if (!this.adr_objectif.equals((Object)warbotMessage.getSender())) continue;
                this.adr_objectif = null;
                continue;
            }
            if (!this.estMonSuperieur(warbotMessage.getSender()) || !warbotMessage.getAct().equals("HELP0") && !warbotMessage.getAct().equals("HELP1")) continue;
            double d4 = warbotMessage.getFromX() + this.enDouble(warbotMessage.getArg1()) + this.coordonnees.getX();
            d = warbotMessage.getFromY() + this.enDouble(warbotMessage.getArg2()) + this.coordonnees.getY();
            point = new Point(d4, d);
            for (int i = 0; i < this.cibles_observees.size(); ++i) {
                CibleObs cibleObs = (CibleObs)this.cibles_observees.elementAt(i);
                if (!(cibleObs.distanceTo(point) <= 10.0)) continue;
                cibleObs.setVuParAutre(6);
            }
        }
    }

    public void doIt() {
        int n;
        int n2;
        Object object;
        int n3;
        this.miseAJourMouvement();
        Percept[] perceptArray = this.getPercepts();
        Vector<Percept> vector = new Vector<Percept>();
        Vector<Percept> vector2 = new Vector<Percept>();
        boolean bl = this.cibles_observees.isEmpty();
        Vector<Object> vector3 = new Vector<Object>();
        this.cible_launcher = false;
        for (n3 = 0; n3 < perceptArray.length; ++n3) {
            Object object2;
            Percept percept = perceptArray[n3];
            if (percept.getPerceptType().equals("Home")) {
                vector.add(percept);
                if (percept.getTeam().equals(this.getTeam()) || this.baseEnnemieConnue((Point)(object2 = new Point(percept.getX() + this.coordonnees.getX(), percept.getY() + this.coordonnees.getY())))) continue;
                this.bases_ennemies.add(object2);
                this.broadcast(this.groupName, "info", "INFO-QG", String.valueOf(percept.getX()), String.valueOf(percept.getY()));
                continue;
            }
            if (percept.getPerceptType().equals("RocketLauncher") && !percept.getTeam().equals(this.getTeam())) {
                if (!this.launcher_vu) {
                    this.broadcast(this.groupName, "explorer", "LAUNCHER_VU");
                }
                this.launcher_vu = true;
                this.cible_launcher = true;
                object2 = new CibleObs();
                object = new Point(percept.getX() + this.coordonnees.getX(), percept.getY() + this.coordonnees.getY());
                ((Cible)object2).setCible(percept.getPerceptType(), (Point)object, percept.getEnergy(), this.tour);
                vector3.add(object2);
                continue;
            }
            if (percept.getPerceptType().equals("Explorer") && !percept.getTeam().equals(this.getTeam())) {
                object2 = new CibleObs();
                object = new Point(percept.getX() + this.coordonnees.getX(), percept.getY() + this.coordonnees.getY());
                ((Cible)object2).setCible(percept.getPerceptType(), (Point)object, percept.getEnergy(), this.tour);
                vector3.add(object2);
                vector.add(percept);
                continue;
            }
            if (percept.getPerceptType().equals("RocketLauncher") && percept.getTeam().equals(this.getTeam())) {
                vector.add(percept);
                continue;
            }
            if (!percept.getPerceptType().equals("Rocket")) continue;
            vector2.add(percept);
        }
        if (this.adr_objectif != null) {
            if (this.coordonnees.distanceTo(this.objectif) < 110.0) {
                this.adr_objectif = null;
                this.objectif.setConnu(false);
                this.send(this.adr_objectif, "ROCKET-FIN");
            } else {
                this.setHeading(this.towards(this.objectif.getX() - this.coordonnees.getX(), this.objectif.getY() - this.coordonnees.getY()));
            }
        }
        n3 = 0;
        int n4 = this.cibles_observees.size();
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            object = (CibleObs)vector3.elementAt(n2);
            Point point = new Point(((Cible)object).getX(), ((Cible)object).getY());
            n = 0;
            for (int i = 0; n == 0 && i < n4; ++i) {
                CibleObs cibleObs = (CibleObs)this.cibles_observees.elementAt(i);
                if (cibleObs.getVuParAutre() == 0 || !(cibleObs.distanceTo(point) < 10.0)) continue;
                n = 1;
                ((CibleObs)object).setVuParAutre(cibleObs.getVuParAutre() - 1);
                ++n3;
            }
        }
        this.cibles_observees = vector3;
        n2 = 0;
        object = new Point(0.0, 0.0);
        int n5 = 0;
        for (n = 0; n < this.cibles_observees.size(); ++n) {
            double d;
            CibleObs cibleObs = (CibleObs)this.cibles_observees.elementAt(n);
            if (n5 < 2 && cibleObs.getType().equals("RocketLauncher") && cibleObs.getVuParAutre() == 0) {
                d = 130.0 - cibleObs.distanceTo(this.coordonnees);
                ((Point)object).setCoord(((Point)object).getX() + (cibleObs.getX() - this.coordonnees.getX()) * d, ((Point)object).getY() + (cibleObs.getY() - this.coordonnees.getY()) * d);
                ++n2;
                ++n5;
                continue;
            }
            if (!cibleObs.getType().equals("RocketLauncher")) continue;
            d = 300.0 - cibleObs.distanceTo(this.coordonnees);
            ((Point)object).setCoord(((Point)object).getX() + (cibleObs.getX() - this.coordonnees.getX()) * d, ((Point)object).getY() + (cibleObs.getY() - this.coordonnees.getY()) * d);
            ++n2;
        }
        this.setUserMessage(String.valueOf(n5));
        if (n2 > 0) {
            ((Point)object).setCoord(((Point)object).getX() / (double)n2, ((Point)object).getY() / (double)n2);
            double d = 180.0;
            this.setHeading(d + this.towards(((Point)object).getX(), ((Point)object).getY()));
        }
        Point point = new Point();
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < perceptArray.length; ++i) {
            Percept percept = perceptArray[i];
            double d = this.ecartMin(percept);
            double d2 = this.distanceTo(percept);
            if (!(d2 < d) || !(d2 > 0.0)) continue;
            double d3 = (d - d2) / d;
            point.setCoord(point.getX() - d3 * percept.getX() / d2, point.getY() - d3 * percept.getY() / d2);
            ++n6;
            if (!percept.getPerceptType().equals("Obstacle")) continue;
            ++n7;
        }
        this.eviteObstacles(vector);
        this.eviteRockets(vector2);
        if (n6 > 0) {
            double d = this.getHeading() * Math.PI / 180.0;
            Point point2 = new Point(Math.cos(d), Math.sin(d));
            this.setHeading(this.towards(point2.getX() + point.getX(), point2.getY() + point.getY()));
        }
        if (this.synchro.pret()) {
            this.monEtat();
        } else if (bl && !this.cibles_observees.isEmpty()) {
            this.monEtat();
        }
        this.synchro.decrementer();
        this.gestionMessages();
        this.move();
    }
}

