/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.kernel;

import madkit.kernel.Activator;
import madkit.kernel.Message;
import madkit.kernel.Scheduler;
import madkit.simulation.activators.TurboMethodActivator;
import turtlekit.kernel.TopMessage;
import turtlekit.kernel.TurtleActivator;

public class TurtleScheduler
extends Scheduler {
    String group;
    TurtleActivator turtleDoIt;
    TurboMethodActivator oberserversDoIt;
    TurboMethodActivator viewersDoIt;
    TurboMethodActivator displayAllWorld;
    TurboMethodActivator updateDisplay;
    TurboMethodActivator evaporation;
    TurboMethodActivator diffusion;
    int iteration = 0;
    int delay = 100;

    public TurtleScheduler(String string) {
        this.group = string;
    }

    public final void activate() {
        this.requestRole("Turtlekit", this.group, "scheduler", null);
        this.sendMessage("Turtlekit", this.group, "launcher", new TopMessage());
        this.waitNextMessage();
        this.turtleDoIt = new TurtleActivator(this.group);
        this.addActivator(this.turtleDoIt);
        this.oberserversDoIt = new TurboMethodActivator("watch", "Turtlekit", this.group, "observer");
        this.addActivator((Activator)this.oberserversDoIt);
        this.viewersDoIt = new TurboMethodActivator("display", "Turtlekit", this.group, "viewer");
        this.addActivator((Activator)this.viewersDoIt);
        this.diffusion = new TurboMethodActivator("diffusion", "Turtlekit", this.group, "world");
        this.addActivator((Activator)this.diffusion);
        this.evaporation = new TurboMethodActivator("evaporation", "Turtlekit", this.group, "world");
        this.addActivator((Activator)this.evaporation);
        this.displayAllWorld = new TurboMethodActivator("displayOn", "Turtlekit", this.group, "world");
        this.addActivator((Activator)this.displayAllWorld);
        this.updateDisplay = new TurboMethodActivator("displayOff", "Turtlekit", this.group, "world");
        this.addActivator((Activator)this.updateDisplay);
        this.oberserversDoIt.execute();
    }

    public final void live() {
        while (true) {
            this.exitImmediatlyOnKill();
            if (this.delay == 0) {
                Thread.yield();
            } else {
                this.pause(this.delay);
            }
            this.checkMail();
            this.scheduleWorld();
        }
    }

    public void end() {
        this.removeAllActivators();
        this.sendMessage(this.group, "launcher", new TopMessage());
        this.leaveGroup(this.group);
    }

    private final void checkMail() {
        Message message = this.nextMessage();
        if (message != null) {
            this.sendMessage(message.getSender(), new TopMessage());
            this.displayAllWorld.execute();
            while (true) {
                this.exitImmediatlyOnKill();
                message = this.nextMessage();
                if (message != null && message instanceof TopMessage) {
                    this.displayAllWorld.execute();
                    this.viewersDoIt.execute();
                    return;
                }
                this.pause(300);
                this.displayAllWorld.execute();
                this.viewersDoIt.execute();
            }
        }
    }

    protected final void executeTurtles() {
        this.turtleDoIt.execute();
    }

    protected final void executeDiffusion() {
        this.diffusion.execute();
    }

    protected final void executeEvaporation() {
        this.evaporation.execute();
    }

    protected final void executeObservers() {
        this.oberserversDoIt.execute();
    }

    protected final void executeDisplay() {
        this.viewersDoIt.execute();
        this.updateDisplay.execute();
    }

    protected final void incrementeIteration() {
        ++this.iteration;
    }

    public void scheduleWorld() {
        this.executeTurtles();
        this.executeDiffusion();
        this.executeEvaporation();
        this.executeObservers();
        this.executeDisplay();
        this.incrementeIteration();
    }
}

