/*
 * Decompiled with CFR 0.152.
 */
package madkit.python;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.messages.ControlMessage;
import madkit.utils.agents.LanguageController;
import org.python.core.PyException;
import org.python.util.PythonInterpreter;

public class PythonController
extends LanguageController {
    public static final String DATE = "3/01/2002";
    public static final String VERSION = "1.0";
    boolean okForLive = false;
    boolean okForDoIt = false;
    PythonInterpreter interp = new PythonInterpreter();

    public void setOkForLive(boolean bl) {
        this.okForLive = bl;
    }

    public boolean getOkForLive() {
        return this.okForLive;
    }

    public void setOkForDoIt(boolean bl) {
        this.okForDoIt = bl;
    }

    public boolean getOkForDoIt() {
        return this.okForDoIt;
    }

    public PythonInterpreter getInterpret() {
        return this.interp;
    }

    public PythonController(AbstractAgent abstractAgent) {
        super(abstractAgent);
    }

    public PythonController(AbstractAgent abstractAgent, String string) {
        super(abstractAgent, string);
    }

    public void activate() {
        int n = this.thisAgent.createGroup(false, "python", null, null);
        this.thisAgent.requestRole("python", "member", null);
        try {
            this.interp.exec("import sys");
            this.interp.set("self", (Object)this.thisAgent);
            this.interp.set("myController", (Object)this);
            this.interp.set("me", (Object)this.thisAgent.getAddress());
            this.interp.exec("def launch(x,s):myController.doLaunchAgent(x,s,1)");
            this.interp.exec("sys.path.append('scripts/pythonfiles')");
        }
        catch (PyException pyException) {
            this.println("Python error while activating");
        }
        this.println("PythonLib, integration of Python (jython) into Madkit");
        this.println("Version 1.0 - 3/01/2002 - Copyright (C) 2002 MadKit team");
        this.thisAgent.activate();
        this.loadFile(this.getLibFile());
        this.loadFile(this.getBehaviorFile());
        if (this.interp.get("activate") != null) {
            try {
                this.interp.exec("activate()");
            }
            catch (PyException pyException) {
                this.println("Python error doing activate()");
                pyException.printStackTrace();
            }
        }
    }

    protected void handleControlMessage(ControlMessage controlMessage) {
        String string = controlMessage.getAction();
        this.println("<< ControlMessage: " + string);
        try {
            if (string.equals("dir")) {
                this.interp.exec("print dir()");
            } else if (string.equals("eval")) {
                this.interp.exec(controlMessage.getContent());
                this.println("OK");
                this.okForLive = true;
            } else {
                super.handleControlMessage(controlMessage);
            }
        }
        catch (PyException pyException) {
            this.println("Python error doing " + string);
            pyException.printStackTrace(System.err);
        }
    }

    protected void handleMessage(Message message) {
        if (message instanceof ControlMessage) {
            this.handleControlMessage((ControlMessage)message);
        }
    }

    public void live() {
        while (true) {
            if (this.interp.get("live") != null && this.okForLive) {
                try {
                    this.interp.exec("live()");
                    break;
                }
                catch (PyException pyException) {
                    this.println("Python error doing live()");
                    pyException.printStackTrace(System.err);
                    this.setOkForLive(false);
                    continue;
                }
            }
            Message message = ((Agent)this.thisAgent).waitNextMessage();
            if (message instanceof ControlMessage) {
                this.handleControlMessage((ControlMessage)message);
            }
            if (!(message instanceof StringMessage)) continue;
            this.interp.exec(((StringMessage)message).getString());
            this.thisAgent.sendMessage(message.getSender(), (Message)new StringMessage("OK"));
        }
    }

    public void end() {
        if (this.interp.get("end") != null) {
            try {
                this.interp.exec("end()");
            }
            catch (PyException pyException) {
                this.println("Python error doing end()");
                pyException.printStackTrace(System.err);
            }
        }
        this.thisAgent.end();
    }

    public void doIt() {
        if (!this.okForDoIt && this.interp.get("doIt") != null) {
            this.setOkForDoIt(true);
        }
        if (this.okForDoIt) {
            try {
                this.interp.exec("doIt()");
            }
            catch (PyException pyException) {
                this.println("Python error doing doIt()");
                pyException.printStackTrace(System.err);
            }
        }
    }

    public void loadFile(String string) {
        FileInputStream fileInputStream = null;
        if (string != null) {
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (IOException iOException) {
                this.println("Python file not found " + string);
                return;
            }
            try {
                this.interp.execfile((InputStream)fileInputStream);
            }
            catch (PyException pyException) {
                this.println("Python error while importing " + string);
                pyException.printStackTrace(System.err);
            }
        }
    }
}

