/*
 * Decompiled with CFR 0.152.
 */
package warbot.demo;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import madkit.kernel.AgentAddress;
import warbot.kernel.Brain;
import warbot.kernel.Food;
import warbot.kernel.Percept;
import warbot.kernel.WarbotMessage;

public abstract class KoyotBenchBrain
extends Brain {
    final int percept_noPercept = 0;
    final int percept_areWeaker = 1;
    final int percept_areEqual = 2;
    final int percept_areStronger = 3;
    final int percept_seeEnnemyBase = 4;
    final int percept_haveSandwich = 5;
    final int percept_seeSandwich = 6;
    final int perceptNumber = 7;
    final int treated_message = 7;
    final int current_action = 8;
    boolean nothing = false;
    boolean overpower = false;
    boolean underpower = false;
    boolean equalpower = false;
    boolean closedSandwich = false;
    boolean farSandwich = false;
    boolean ennemyBase = false;
    final int action_walkAround = 0;
    final int action_attackBot = 1;
    final int action_attackBase = 2;
    final int action_goHelp = 3;
    final int action_goAway = 4;
    final int action_doNothing = 5;
    final int action_eat = 6;
    final int action_goToSandwich = 7;
    final int action_moveToBase = 8;
    final int actionNumber = 9;
    boolean helpBase;
    boolean currentHelpBase;
    final int message_helpMe = 0;
    final int message_attackBase = 1;
    final int message_myEnergy = 2;
    final int message_bossGroup = 3;
    final int message_localisation = 4;
    final int message_currentAttack = 5;
    int[][] behaviour;
    int[][] decision;
    WarbotMessage maxPriorityMessage;
    double objectiveX;
    double objectiveY;
    int currentAction;
    int lastAction = -1;
    int currentActionPriority = -100;
    double currentActionObjX;
    double currentActionObjY;
    final int goal_noGoal = -1;
    final int goal_attackBase = 0;
    final int goal_defendBase = 1;
    final int goal_explore = 2;
    final int goal_attackBots = 3;
    Hashtable groups;
    Hashtable groupMembers;
    String groupName = "Koyot";
    String roleName = "";
    int priotityAdjustmentForRole = 0;
    final int priority_adjustmentForGroup = -5;
    final double priority_unitDistance = 50.0;
    String currentUnderGroupName = "";
    int groupGoal;
    final double group_union_distance = 200.0;
    int currentEnergy;
    final int energy_high = 60;
    final int energy_low = 35;
    boolean skipBroadcastEnergy;
    boolean skipBroadcastLeader;
    Vector ennemis = new Vector();
    Vector friends = new Vector();
    Vector rockets = new Vector();
    Vector walls = new Vector();
    Vector blasted = new Vector();

    public void activate() {
        this.randomHeading();
        this.groupName = String.valueOf(String.valueOf(this.groupName)).concat(String.valueOf(String.valueOf(this.getTeam())));
        this.createGroup(false, this.groupName, null, null);
        this.requestRole(this.groupName, this.roleName, null);
        this.requestRole(this.groupName, "member", null);
        this.groupMembers = new Hashtable();
        this.groups = new Hashtable();
        this.helpBase = false;
        this.currentHelpBase = false;
        this.groupGoal = -1;
        this.currentAction = -1;
        this.skipBroadcastEnergy = true;
        this.skipBroadcastLeader = true;
    }

    public boolean canBlast(Percept friend) {
        double posFriX = friend.getX();
        double posFriY = friend.getY();
        double posEnnX = 0.0;
        double posEnnY = 0.0;
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                double diffY;
                Percept e = detectedEntities[i];
                if (!e.getPerceptType().equals("RocketLauncher") || e.getTeam().equals(this.getTeam())) continue;
                posEnnX = e.getX();
                posEnnY = e.getY();
                double diffX = Math.abs(posEnnX - posFriX);
                double diffDist = Math.sqrt(diffX * diffX + (diffY = Math.abs(posEnnY - posFriY)) * diffY);
                if (!(diffDist < (double)80)) continue;
                return true;
            }
        }
        return false;
    }

    public int areBlastingMy() {
        int blastersNb = 0;
        double ennX = 0.0;
        double ennY = 0.0;
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (!e.getPerceptType().equals("RocketLauncher") || e.getTeam().equals(this.getTeam())) continue;
                ennX = e.getX();
                ennY = e.getY();
                if (this.blasted.isEmpty()) continue;
                for (int j = 0; j < this.blasted.size(); ++j) {
                    double diffY;
                    WarbotMessage blaster = (WarbotMessage)this.blasted.elementAt(j);
                    double senderX = blaster.getFromX();
                    double senderY = blaster.getFromY();
                    if (Math.abs(senderX) < (double)3 && Math.abs(senderY) < (double)3) continue;
                    double viewedX = new Double(blaster.getContent()[1]);
                    double viewedY = new Double(blaster.getContent()[2]);
                    double blastedX = senderX + viewedX;
                    double blastedY = senderY + viewedY;
                    double diffX = Math.abs(ennX - blastedX);
                    double diffDist = Math.sqrt(diffX * diffX + (diffY = Math.abs(ennY - blastedY)) * diffY);
                    if (!(diffDist < (double)5)) continue;
                    ++blastersNb;
                }
            }
        }
        return blastersNb;
    }

    public boolean isBlasted(Percept robot) {
        double ennX = robot.getX();
        double ennY = robot.getY();
        if (!this.blasted.isEmpty()) {
            for (int i = 0; i < this.blasted.size(); ++i) {
                double diffY;
                WarbotMessage blaster = (WarbotMessage)this.blasted.elementAt(i);
                double senderX = blaster.getFromX();
                double senderY = blaster.getFromY();
                if (Math.abs(senderX) < (double)3 && Math.abs(senderY) < (double)3) continue;
                double viewedX = new Double(blaster.getContent()[1]);
                double viewedY = new Double(blaster.getContent()[2]);
                double blastedX = senderX + viewedX;
                double blastedY = senderY + viewedY;
                double diffX = Math.abs(ennX - blastedX);
                double diffDist = Math.sqrt(diffX * diffX + (diffY = Math.abs(ennY - blastedY)) * diffY);
                if (!(diffDist < (double)5)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBlasting(Percept friend) {
        double friX = friend.getX();
        double friY = friend.getY();
        if (!this.blasted.isEmpty()) {
            for (int i = 0; i < this.blasted.size(); ++i) {
                double diffY;
                WarbotMessage blaster = (WarbotMessage)this.blasted.elementAt(i);
                double blasterX = blaster.getFromX();
                double blasterY = blaster.getFromY();
                double diffX = Math.abs(friX - blasterX);
                double diffDist = Math.sqrt(diffX * diffX + (diffY = Math.abs(friY - blasterY)) * diffY);
                if (!(diffDist < (double)5)) continue;
                return true;
            }
        }
        return false;
    }

    public void processPercepts() {
        int i;
        int ennemyRocketNumber = 0;
        boolean ennemyActiveRocketNumber = false;
        int ennemyDetectorNumber = 0;
        int ennemyBaseNumber = 0;
        int friendsRocketNumber = 0;
        int friendsActiveRocketNumber = 0;
        int closedSandwichNumber = 0;
        int farSandwichNumber = 0;
        this.initializePerceptionProcess();
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            for (i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (e.getPerceptType().equals("Food")) {
                    if (this.distanceTo(e) < (double)2) {
                        ++closedSandwichNumber;
                        this.closedSandwich = true;
                        continue;
                    }
                    ++farSandwichNumber;
                    this.farSandwich = true;
                    continue;
                }
                if (!e.getTeam().equals(this.getTeam())) {
                    if (e.getPerceptType().equals("Home")) {
                        ++ennemyBaseNumber;
                        this.ennemyBase = true;
                        continue;
                    }
                    if (e.getPerceptType().equals("RocketLauncher")) {
                        ++ennemyRocketNumber;
                        continue;
                    }
                    if (!e.getPerceptType().equals("Explorer")) continue;
                    ++ennemyDetectorNumber;
                    continue;
                }
                if (!e.getTeam().equals(this.getTeam()) || !e.getPerceptType().equals("RocketLauncher") || !this.canBlast(e) || this.isBlasting(e)) continue;
                ++friendsRocketNumber;
            }
        }
        friendsActiveRocketNumber = this.areBlastingMy();
        if (ennemyRocketNumber == 0 && ennemyDetectorNumber == 0 && ennemyBaseNumber == 0 && closedSandwichNumber == 0 && farSandwichNumber == 0) {
            this.nothing = true;
        }
        if (ennemyRocketNumber > (friendsRocketNumber = friendsRocketNumber + friendsActiveRocketNumber + 1)) {
            this.underpower = true;
        } else if (friendsRocketNumber > ennemyRocketNumber && (ennemyRocketNumber > 0 || ennemyDetectorNumber > 0)) {
            this.overpower = true;
        } else if (friendsRocketNumber == ennemyRocketNumber) {
            this.equalpower = true;
        }
        this.decision = new int[9][9];
        for (i = 0; i < 7; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.decision[i][j] = this.behaviour[i][j];
            }
        }
        for (i = 7; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.decision[i][j] = -100;
            }
        }
        this.unactivatePerceptionLines();
    }

    public void preprocessPercepts() {
        this.ennemis.removeAllElements();
        this.friends.removeAllElements();
        this.rockets.removeAllElements();
        this.walls.removeAllElements();
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (e.getPerceptType().equals("Obstacle")) {
                    this.walls.addElement(e);
                    continue;
                }
                if (e.getPerceptType().equals("Rocket")) {
                    this.rockets.addElement(e);
                    continue;
                }
                if (e.getPerceptType().equals("RocketLauncher") && !e.getTeam().equals(this.getTeam())) {
                    this.ennemis.addElement(e);
                    continue;
                }
                if (!e.getPerceptType().equals("RocketLauncher") || !e.getTeam().equals(this.getTeam())) continue;
                this.friends.addElement(e);
            }
        }
    }

    protected void unactivatePerceptionLines() {
        if (!this.nothing) {
            this.unactivatePerception(0);
        }
        if (!this.overpower) {
            this.unactivatePerception(3);
        }
        if (!this.underpower) {
            this.unactivatePerception(1);
        }
        if (!this.equalpower) {
            this.unactivatePerception(2);
        }
        if (!this.closedSandwich) {
            this.unactivatePerception(5);
        }
        if (!this.farSandwich) {
            this.unactivatePerception(6);
        }
        if (!this.ennemyBase) {
            this.unactivatePerception(4);
        }
    }

    protected void initializePerceptionProcess() {
        this.nothing = false;
        this.overpower = false;
        this.underpower = false;
        this.equalpower = false;
        this.closedSandwich = false;
        this.farSandwich = false;
        this.ennemyBase = false;
    }

    public void unactivatePerception(int percept) {
        for (int i = 0; i < 9; ++i) {
            this.decision[percept][i] = -100;
        }
    }

    public void setPriotityAdjustmentForRole(int priorityAdjustment) {
        this.priotityAdjustmentForRole = priorityAdjustment;
    }

    public int getBestAction() {
        int max = -500;
        int bestaction = -1;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.decision[i][j] <= max) continue;
                max = this.decision[i][j];
                bestaction = j;
                if (i != 8) continue;
                this.objectiveX = this.currentActionObjX;
                this.objectiveY = this.currentActionObjY;
                this.helpBase = this.currentHelpBase;
            }
        }
        if (bestaction != this.currentAction) {
            this.lastAction = this.currentAction;
            this.currentAction = bestaction;
            this.currentActionPriority = max;
        }
        return bestaction;
    }

    public int filter() {
        int MaxActPriority = -100;
        Vector<WarbotMessage> messageVector = new Vector<WarbotMessage>();
        this.blasted.removeAllElements();
        while (!this.isMessageBoxEmpty()) {
            WarbotMessage message = this.readMessage();
            if (new Integer(message.getAct()) == 5) {
                this.blasted.add(message);
                continue;
            }
            if (new Integer(message.getAct()) == 2) {
                this.processMyGroupMembers(message);
                continue;
            }
            if (new Integer(message.getAct()) == 3) {
                this.processGroupLeaders(message);
                continue;
            }
            messageVector.add(message);
        }
        this.processGroupInfos();
        for (int i = 0; i < messageVector.size(); ++i) {
            WarbotMessage mess = (WarbotMessage)messageVector.elementAt(i);
            int priority = new Integer(mess.getContent()[0]);
            if ((priority += this.adjustPriority(mess)) <= MaxActPriority) continue;
            this.maxPriorityMessage = mess;
            MaxActPriority = priority;
        }
        messageVector.clear();
        return MaxActPriority;
    }

    public void ejectFromCurrentGroup() {
        this.leaveGroup(this.currentUnderGroupName);
        this.groupGoal = -1;
        this.currentUnderGroupName = "";
        this.skipBroadcastEnergy = true;
        this.skipBroadcastLeader = true;
    }

    public double getBossCoOrdinateX() {
        if (this.groupGoal != -1) {
            if (!this.isTheBoss(this.currentUnderGroupName)) {
                double[] attribute = new double[3];
                attribute = (double[])this.groups.get(this.currentUnderGroupName);
                return attribute[0];
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getBossCoOrdinateY() {
        if (this.groupGoal != -1) {
            if (!this.isTheBoss(this.currentUnderGroupName)) {
                double[] attribute = new double[3];
                attribute = (double[])this.groups.get(this.currentUnderGroupName);
                return attribute[1];
            }
            return 0.0;
        }
        return 0.0;
    }

    public boolean isTheBoss(String groupname) {
        return this.groupGoal != -1 && this.getAgentsWithRole(groupname, "boss").length > 0 && this.getAgentWithRole(groupname, "boss").getName().equals(this.getAddress().getName());
    }

    public boolean hasNoBoss() {
        if (this.groupGoal != -1) {
            return true;
        }
        AgentAddress[] boss = this.getAgentsWithRole(this.currentUnderGroupName, "boss");
        return boss.length <= 0;
    }

    public int adjustPriority(WarbotMessage message) {
        int retvalue = 0;
        retvalue = (int)((double)retvalue + this.adjustPriorityWithDistance(message));
        return retvalue += this.adjustPriorityWithGroup(message);
    }

    public double adjustPriorityWithDistance(WarbotMessage message) {
        double priorityadjustment = 0.0;
        double x = this.getObjectiveX(message);
        double y = this.getObjectiveY(message);
        double distance = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        priorityadjustment = -distance / 50.0;
        return priorityadjustment;
    }

    public int adjustPriorityWithGroup(WarbotMessage message) {
        String roleplayed;
        int priorityadjustment = 0;
        String undergroup = message.getContent()[3];
        if (this.groupGoal != -1 && !undergroup.equals(this.currentUnderGroupName) && !(roleplayed = message.getContent()[4]).equals("Base") && new Integer(message.getAct()) == 1) {
            priorityadjustment = -5;
        }
        return priorityadjustment;
    }

    public void initGroups() {
        this.groupMembers.clear();
        this.groups.clear();
        this.helpBase = false;
        if (this.hasNoBoss() && this.currentUnderGroupName.length() != 0 && !this.isTheBoss(this.currentUnderGroupName)) {
            this.requestRole(this.currentUnderGroupName, "boss", null);
        }
    }

    public double getObjectiveX(WarbotMessage maxprioritymessage) {
        double retValue = 0.0;
        double localX = maxprioritymessage.getFromX();
        double distantX = new Double(maxprioritymessage.getContent()[1]);
        retValue = localX + distantX;
        return retValue;
    }

    public double getObjectiveY(WarbotMessage maxprioritymessage) {
        double retValue = 0.0;
        double localY = maxprioritymessage.getFromY();
        double distantY = new Double(maxprioritymessage.getContent()[2]);
        retValue = localY + distantY;
        return retValue;
    }

    public void updateObjectives(WarbotMessage maxprioritymessage) {
        this.objectiveX = this.getObjectiveX(maxprioritymessage);
        this.objectiveY = this.getObjectiveY(maxprioritymessage);
    }

    public void processMessages() {
        block2: {
            int MaxActPriority;
            if (this.isMessageBoxEmpty() || (MaxActPriority = this.filter()) == -100) break block2;
            int act = new Integer(this.maxPriorityMessage.getAct());
            if (act == 0 && this.maxPriorityMessage.getContent()[4].equals("Base")) {
                this.helpBase = true;
            }
            if (act == 0 || act == 1) {
                this.updateObjectives(this.maxPriorityMessage);
                this.updateDecision(this.maxPriorityMessage, MaxActPriority);
            }
        }
    }

    public void updateDecision(WarbotMessage message, int MaxActPriority) {
        int act = new Integer(message.getAct());
        switch (act) {
            case 0: {
                this.decision[7][3] = MaxActPriority;
                break;
            }
            case 1: {
                this.decision[7][8] = MaxActPriority;
                break;
            }
        }
    }

    public void processGroupLeaders(WarbotMessage message) {
        double[] coord = new double[]{message.getFromX(), message.getFromY(), new Integer(message.getContent()[0]).doubleValue()};
        String key = new String();
        key = message.getContent()[1];
        this.groups.put(key, coord);
    }

    public void processMyGroupMembers(WarbotMessage message) {
        double[] energy = new double[]{new Integer(message.getContent()[0]).doubleValue(), new Integer(message.getContent()[1]).doubleValue()};
        this.groupMembers.put(message.getSender().getName(), energy);
    }

    public void throwMessage(String entitytype, int priority, int message) {
        Percept[] detectedEntities = this.getPercepts();
        double x = 0.0;
        double y = 0.0;
        if (detectedEntities.length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (e.getTeam().equals(this.getTeam()) || !e.getPerceptType().equals(entitytype)) continue;
                x = e.getX();
                y = e.getY();
                String[] parameters = new String[]{new Integer(priority).toString(), new Double(x).toString(), new Double(y).toString(), this.currentUnderGroupName, this.roleName};
                this.broadcast(this.groupName, "member", new Integer(message).toString(), parameters);
            }
        }
    }

    public void throwUsefullMessages() {
        String[] parameters;
        this.broadcast(this.groupName, "Base", new Integer(4).toString());
        if (this.isTheBoss(this.currentUnderGroupName) && !this.skipBroadcastLeader) {
            parameters = new String[]{new Integer(this.groupGoal).toString(), this.currentUnderGroupName};
            this.broadcast(this.groupName, "member", new Integer(3).toString(), parameters);
        }
        if (!this.currentUnderGroupName.equals("") && !this.skipBroadcastEnergy) {
            parameters = new String[]{new Integer(this.getEnergyLevel()).toString(), new Integer(this.getMaximumEnergy()).toString()};
            this.broadcast(this.currentUnderGroupName, "member", new Integer(2).toString(), parameters);
        }
    }

    public void warning(double x, double y) {
        int priority = 0;
        String[] parameters = new String[]{new Integer(priority).toString(), new Double(x).toString(), new Double(y).toString(), "", this.roleName};
        this.broadcast(this.groupName, "member", new Integer(5).toString(), parameters);
    }

    public boolean nearMyGroup() {
        if (this.groupGoal == -1) {
            return false;
        }
        if (this.isTheBoss(this.currentUnderGroupName)) {
            return true;
        }
        if (this.groups.containsKey(this.currentUnderGroupName)) {
            double[] coord = new double[]{((double[])this.groups.get(this.currentUnderGroupName))[0], ((double[])this.groups.get(this.currentUnderGroupName))[1]};
            if (Math.sqrt(Math.pow(coord[0], 2.0) + Math.pow(coord[1], 2.0)) <= 200.0) {
                return true;
            }
        }
        return false;
    }

    public String nearSpecificGroup(int goal) {
        String key = new String("");
        String maxkey = new String("");
        double maxkeydistance = 200.0;
        if (!this.groups.isEmpty()) {
            Enumeration enumeration = this.groups.keys();
            while (enumeration.hasMoreElements()) {
                double d;
                key = (String)enumeration.nextElement();
                double[] coord = new double[]{((double[])this.groups.get(key))[0], ((double[])this.groups.get(key))[1], ((double[])this.groups.get(key))[2]};
                if ((int)coord[2] != goal || !((d = Math.sqrt(Math.pow(coord[0], 2.0) + Math.pow(coord[1], 2.0))) < maxkeydistance)) continue;
                maxkey = key;
                maxkeydistance = d;
            }
        }
        return maxkey;
    }

    boolean testIfInMyGroup(WarbotMessage maxPriorityMessage) {
        return !this.groupMembers.isEmpty() && this.groupMembers.containsKey(maxPriorityMessage.getSender().getName());
    }

    public void affectNewRole(int goal) {
        String nameOfGroup = this.nearSpecificGroup(goal);
        if (nameOfGroup.equals("")) {
            this.currentUnderGroupName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(new Integer(goal).toString()))).append(" ").append(this.getAddress().getName())));
            this.createGroup(false, this.currentUnderGroupName, null, null);
            this.requestRole(this.currentUnderGroupName, this.roleName, null);
            this.requestRole(this.currentUnderGroupName, "member", null);
            this.requestRole(this.currentUnderGroupName, "boss", null);
            this.skipBroadcastEnergy = true;
            this.skipBroadcastLeader = false;
        } else {
            this.currentUnderGroupName = nameOfGroup;
            this.requestRole(this.currentUnderGroupName, this.roleName, null);
            this.requestRole(this.currentUnderGroupName, "member", null);
            this.skipBroadcastEnergy = false;
            this.skipBroadcastLeader = true;
        }
        this.groupGoal = goal;
    }

    public abstract void processLeaveGroup(int var1);

    public void processCreateJoinGroup(int action) {
        if (this.currentUnderGroupName.equals("") && this.groupGoal == -1) {
            if (action == 2 || action == 8) {
                this.affectNewRole(0);
            } else if (action == 3 && !this.helpBase || action == 1) {
                this.affectNewRole(3);
            } else if (action == 3 && this.helpBase) {
                this.affectNewRole(1);
            } else if (action == 0) {
                this.affectNewRole(2);
            }
        }
    }

    public void processMergeGroups() {
        String nameofgroup;
        if (!(this.groupGoal == -1 || this.currentUnderGroupName.equals("") || (nameofgroup = this.nearSpecificGroup(this.groupGoal)).equals("") || nameofgroup.equals(this.currentUnderGroupName))) {
            this.leaveGroup(this.currentUnderGroupName);
            this.currentUnderGroupName = nameofgroup;
            this.requestRole(this.currentUnderGroupName, this.roleName, null);
            this.requestRole(this.currentUnderGroupName, "member", null);
            this.skipBroadcastEnergy = false;
            this.skipBroadcastLeader = true;
        }
    }

    public void processGroup(int action) {
        this.processLeaveGroup(action);
        this.processCreateJoinGroup(action);
        this.processMergeGroups();
        this.throwUsefullMessages();
    }

    public void processGroupInfos() {
        int[][] groupModifiersTab = new int[][]{{-10, 10, 10, -5, 0, -20, 0, 0, 10}, {-10, 10, -10, 10, -10, -20, 0, 0, -10}, {15, 10, 5, 15, 0, -20, 0, 0, 0}, {-5, 10, 0, 10, -5, -20, 0, 0, -5}};
        this.affectGroupOnDecision(groupModifiersTab);
        int total = this.groupMembers.size();
        double energy = 0.0;
        double maxenergy = 0.0;
        Enumeration enumeration = this.groupMembers.elements();
        while (enumeration.hasMoreElements()) {
            double[] tab = (double[])enumeration.nextElement();
            energy += tab[0];
            maxenergy += tab[1];
        }
        double groupAverageEnergy = (energy += (double)this.getEnergyLevel()) / (double)(++total);
        double groupAverageMaxEnergy = (maxenergy += (double)this.getMaximumEnergy()) / (double)total;
        double ratio = (double)100 * groupAverageEnergy / groupAverageMaxEnergy;
        int[][] groupEnergyModifiersTab = new int[][]{{0, -5, 0, 0, 10, -20, 15, 15, 0}, {0, 0, 0, 0, 5, 0, 5, 5, 0}, {0, 5, 5, 5, 0, -20, 0, 0, 5}};
        this.affectGroupEnergyOnDecision(groupEnergyModifiersTab, ratio);
    }

    public void processPersonnalInfos() {
        int currentEnergy = this.getEnergyLevel();
        float ratio = 100 * currentEnergy / this.getMaximumEnergy();
        int[] modifier = this.GetEnergyLevelModifier(ratio);
        this.affectDecision(modifier);
    }

    public void affectDecision(int[] modifier) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                int[] nArray = this.decision[j];
                int n = i;
                nArray[n] = nArray[n] + modifier[i];
            }
        }
    }

    public void affectGroupOnDecision(int[][] modifier) {
        if (this.groupGoal != -1 && this.groupGoal < 4) {
            int[] groupmodifier = modifier[this.groupGoal];
            this.affectDecision(groupmodifier);
        }
    }

    public void affectGroupEnergyOnDecision(int[][] modifier, double ratio) {
        if (ratio > (double)60) {
            this.affectDecision(modifier[2]);
        } else if (ratio < (double)35) {
            this.affectDecision(modifier[0]);
        } else {
            this.affectDecision(modifier[1]);
        }
    }

    public abstract int[] GetEnergyLevelModifier(float var1);

    public void processCurrentAction() {
        if (this.currentAction != -1 && (this.currentAction == 3 || this.currentAction == 8)) {
            this.decision[8][this.currentAction] = this.currentActionPriority - 15;
        }
    }

    public abstract void screamMessages(int var1);

    public void doAction(int action) {
        switch (action) {
            case 0: {
                this.call_walkAround();
                break;
            }
            case 1: {
                this.call_attackBot();
                break;
            }
            case 2: {
                this.call_attackBase();
                break;
            }
            case 3: {
                this.currentActionObjX = this.objectiveX;
                this.currentActionObjY = this.objectiveY;
                this.currentHelpBase = this.helpBase;
                this.call_goHelp();
                break;
            }
            case 4: {
                this.call_goAway();
                break;
            }
            case 5: {
                this.call_doNothing();
                break;
            }
            case 6: {
                this.call_eat();
                break;
            }
            case 7: {
                this.call_goToSandwich();
                break;
            }
            case 8: {
                this.currentActionObjX = this.objectiveX;
                this.currentActionObjY = this.objectiveY;
                this.currentHelpBase = false;
                this.call_moveToBase();
                break;
            }
            default: {
                return;
            }
        }
    }

    public boolean wasDoingSomethingElseThanMoving() {
        return this.currentAction == 1 || this.currentAction == 2 || this.currentAction == 6 || this.currentAction == 5;
    }

    public void call_walkAround() {
        this.move();
    }

    public void call_goAway() {
        if (!this.ennemis.isEmpty()) {
            double launcherX = 0.0;
            double launcherY = 0.0;
            int nbLaunchers = 0;
            for (int i = 0; i < this.ennemis.size(); ++i) {
                launcherX += ((Percept)this.ennemis.elementAt(i)).getX();
                launcherY += ((Percept)this.ennemis.elementAt(i)).getY();
                ++nbLaunchers;
            }
            this.setHeading(this.towards(-launcherY, launcherX));
        }
        this.move();
    }

    public void call_doNothing() {
    }

    public void call_eat() {
        block0: {
            Percept e;
            int i;
            Percept[] detectedEntities = this.getPercepts();
            if (detectedEntities.length <= 0 || (i = 0) >= detectedEntities.length || !(e = detectedEntities[i]).getPerceptType().equals("Food") || !(this.distanceTo(e) < (double)2)) break block0;
            this.eat((Food)e);
        }
    }

    public void call_goToSandwich() {
        Percept e;
        int i;
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0 && (i = 0) < detectedEntities.length && (e = detectedEntities[i]).getPerceptType().equals("Food")) {
            this.setHeading(this.towards(e.getX(), e.getY()));
        }
        this.move();
    }

    public abstract void call_attackBot();

    public abstract void call_attackBase();

    public abstract void call_goHelp();

    public abstract void call_moveToBase();

    public void doIt() {
        if (!this.isMoving() && !this.wasDoingSomethingElseThanMoving()) {
            this.randomHeading();
            this.move();
            this.currentAction = 0;
            return;
        }
        this.processPercepts();
        this.processCurrentAction();
        this.processPersonnalInfos();
        this.initGroups();
        this.processMessages();
        int action = this.getBestAction();
        this.processGroup(action);
        this.screamMessages(action);
        this.doAction(action);
    }

    public void end() {
        if (this.groupGoal != -1) {
            this.leaveGroup(this.currentUnderGroupName);
        }
        this.leaveGroup(this.groupName);
    }
}

