/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.activators;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;

public class OneValueArgsMethodActivator
extends Activator {
    private String methodName;
    private Map methods = new HashMap();
    private Class[] argsClass;

    public OneValueArgsMethodActivator(String string, String string2, String string3, Class[] classArray) {
        this("public", string, string2, string3, classArray);
    }

    public OneValueArgsMethodActivator(String string, String string2, String string3, String string4, Class[] classArray) {
        super(string, string2, string3);
        this.methodName = string4;
        this.argsClass = classArray;
    }

    public synchronized void initialize() {
        this.findMethods(this.methodName, this.argsClass);
    }

    protected void findMethods(String string, Class[] classArray) {
        ListIterator listIterator = this.getAgentsIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            try {
                this.methods.put(e, e.getClass().getMethod(string, this.argsClass));
            }
            catch (Exception exception) {
                System.err.println("Can't find method: " + string + " on " + ((AbstractAgent)e).toString() + " " + exception);
            }
        }
    }

    public synchronized void update(AbstractAgent abstractAgent, boolean bl) {
        if (bl) {
            this.updateFieldFor(abstractAgent);
        } else {
            this.methods.remove(abstractAgent);
        }
    }

    public synchronized void updateFieldFor(Object object) {
        try {
            this.methods.put(object, object.getClass().getMethod(this.methodName, this.argsClass));
        }
        catch (Exception exception) {
            System.err.println("Can't find method: " + this.methodName + " on " + ((AbstractAgent)object).toString() + " " + exception);
        }
    }

    public synchronized Object[] execute(Object[] objectArray) {
        Object[] objectArray2 = new Object[this.methods.size()];
        int n = 0;
        for (Map.Entry entry : this.methods.entrySet()) {
            try {
                objectArray2[n] = ((Method)entry.getValue()).invoke(entry.getKey(), objectArray);
            }
            catch (Exception exception) {
                System.err.println("Can't invoke:" + entry.getValue().toString() + " on " + entry.getKey().toString() + " " + exception.toString());
            }
            ++n;
        }
        return objectArray2;
    }
}

