/*
 * Decompiled with CFR 0.152.
 */
package warbot.demo;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import madkit.kernel.AgentAddress;
import warbot.kernel.Brain;
import warbot.kernel.Percept;
import warbot.kernel.WarbotMessage;

public class KKBase
extends Brain {
    String groupName = "Koyot";
    String roleName = "";
    String currentUnderGroupName = "";
    int groupGoal;
    final double group_union_distance = 200.0;
    Hashtable groups;
    Hashtable groupMembers;
    final int goal_noGoal = -1;
    final int goal_attackBase = 0;
    final int goal_defendBase = 1;
    final int goal_explore = 2;
    final int goal_attackBots = 3;
    final int message_helpMe = 0;
    final int message_attackBase = 1;
    final int message_myEnergy = 2;
    final int message_bossGroup = 3;
    final int message_localisation = 4;
    boolean noDanger;
    boolean skipBroadcastEnergy;
    boolean skipBroadcastLeader;
    Vector coords = new Vector();
    Vector ennBases = new Vector();
    Vector newEnnBases = new Vector();
    int test = 0;

    public void activate() {
        this.roleName = "Base";
        this.groupName = String.valueOf(String.valueOf(this.groupName)).concat(String.valueOf(String.valueOf(this.getTeam())));
        this.createGroup(false, this.groupName, null, null);
        this.requestRole(this.groupName, this.roleName, null);
        this.requestRole(this.groupName, "member", null);
        this.noDanger = true;
        this.groupGoal = -1;
        this.groupMembers = new Hashtable();
        this.groups = new Hashtable();
        this.skipBroadcastEnergy = true;
        this.skipBroadcastLeader = true;
    }

    public void processLeaveGroup() {
        block0: {
            if (this.currentUnderGroupName.equals("") || !this.noDanger || this.groupGoal != 1 || this.isRole(this.currentUnderGroupName, "launcher") || this.isRole(this.currentUnderGroupName, "explorer")) break block0;
            this.leaveGroup(this.currentUnderGroupName);
            this.groupGoal = -1;
            this.currentUnderGroupName = "";
            this.skipBroadcastEnergy = true;
            this.skipBroadcastLeader = true;
        }
    }

    public void initGroups() {
        this.groupMembers.clear();
        this.groups.clear();
        if (this.hasNoBoss() && this.currentUnderGroupName.length() != 0 && !this.isTheBoss(this.currentUnderGroupName)) {
            this.requestRole(this.currentUnderGroupName, "boss", null);
        }
    }

    public boolean hasNoBoss() {
        if (this.groupGoal != -1) {
            return true;
        }
        AgentAddress[] boss = this.getAgentsWithRole(this.currentUnderGroupName, "boss");
        return boss.length <= 0;
    }

    public String nearSpecificGroup(int goal) {
        String key = new String("");
        String maxkey = new String("");
        double maxkeydistance = 200.0;
        if (!this.groups.isEmpty()) {
            Enumeration enumeration = this.groups.keys();
            while (enumeration.hasMoreElements()) {
                double d;
                key = (String)enumeration.nextElement();
                double[] coord = new double[]{((double[])this.groups.get(key))[0], ((double[])this.groups.get(key))[1], ((double[])this.groups.get(key))[2]};
                if ((int)coord[2] != goal || !((d = Math.sqrt(Math.pow(coord[0], 2.0) + Math.pow(coord[1], 2.0))) < maxkeydistance)) continue;
                maxkey = key;
                maxkeydistance = d;
            }
        }
        return maxkey;
    }

    public void processCreateJoinGroup() {
        if (this.groupGoal == -1 && !this.noDanger) {
            this.affectNewRole(1);
        }
    }

    public void affectNewRole(int goal) {
        String nameOfGroup = this.nearSpecificGroup(goal);
        if (nameOfGroup.equals("")) {
            this.currentUnderGroupName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(new Integer(goal).toString()))).append(" ").append(this.getAddress().getName())));
            this.createGroup(false, this.currentUnderGroupName, null, null);
            this.requestRole(this.currentUnderGroupName, this.roleName, null);
            this.requestRole(this.currentUnderGroupName, "member", null);
            this.requestRole(this.currentUnderGroupName, "boss", null);
            this.skipBroadcastEnergy = true;
            this.skipBroadcastLeader = false;
        } else {
            this.currentUnderGroupName = nameOfGroup;
            this.requestRole(this.currentUnderGroupName, this.roleName, null);
            this.requestRole(this.currentUnderGroupName, "member", null);
            this.skipBroadcastEnergy = false;
            this.skipBroadcastLeader = true;
        }
        this.groupGoal = goal;
    }

    public void processMergeGroups() {
        String nameofgroup;
        if (this.groupGoal != -1 && !(nameofgroup = this.nearSpecificGroup(this.groupGoal)).equals(this.currentUnderGroupName)) {
            this.leaveGroup(this.currentUnderGroupName);
            this.currentUnderGroupName = nameofgroup;
            this.requestRole(this.currentUnderGroupName, this.roleName, null);
            this.requestRole(this.currentUnderGroupName, "member", null);
            this.skipBroadcastEnergy = false;
            this.skipBroadcastLeader = true;
        }
    }

    public void processGroup() {
        this.processLeaveGroup();
        this.processCreateJoinGroup();
        this.processMergeGroups();
        this.throwUsefullMessages();
    }

    public void doIt() {
        this.processMessages();
        this.processKBase();
        this.initGroups();
        this.processPercepts();
        this.processGroup();
    }

    public void processMyGroupMembers(WarbotMessage message) {
        int[] energy = new int[]{new Integer(message.getContent()[0]), new Integer(message.getContent()[1])};
        this.groupMembers.put(message.getSender().getName(), energy);
    }

    public void processGroupLeaders(WarbotMessage message) {
        double[] coord = new double[]{message.getFromX(), message.getFromY(), new Integer(message.getContent()[0]).doubleValue()};
        String key = new String();
        key = message.getContent()[1];
        this.groups.put(key, coord);
    }

    public void processMessages() {
        this.coords.removeAllElements();
        this.newEnnBases.removeAllElements();
        if (!this.isMessageBoxEmpty()) {
            while (!this.isMessageBoxEmpty()) {
                WarbotMessage message = this.readMessage();
                int act = 0;
                act = new Integer(message.getAct());
                if (act == 4) {
                    this.coords.add(message);
                    continue;
                }
                if (act == 1) {
                    this.newEnnBases.add(message);
                    continue;
                }
                if (act == 2) {
                    this.processMyGroupMembers(message);
                    continue;
                }
                if (act != 3) continue;
                this.processGroupLeaders(message);
            }
        }
    }

    public void throwMessage(String entitytype, int priority, int message) {
        this.noDanger = true;
        Percept[] detectedEntities = this.getPercepts();
        double x = 0.0;
        double y = 0.0;
        if (detectedEntities.length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (e.getTeam().equals(this.getTeam()) || !e.getPerceptType().equals(entitytype)) continue;
                x = e.getX();
                y = e.getY();
                String[] parameters = new String[]{new Integer(priority).toString(), new Double(x).toString(), new Double(y).toString(), this.currentUnderGroupName, this.roleName};
                this.broadcast(this.groupName, "member", new Integer(message).toString(), parameters);
                this.noDanger = false;
            }
        }
    }

    public boolean isTheBoss(String groupname) {
        return this.groupGoal != -1 && this.getAgentsWithRole(groupname, "boss").length > 0 && this.getAgentWithRole(groupname, "boss").getName().equals(this.getAddress().getName());
    }

    public void throwUsefullMessages() {
        String[] parameters;
        if (this.isTheBoss(this.currentUnderGroupName) && !this.skipBroadcastLeader) {
            parameters = new String[]{new Integer(this.groupGoal).toString(), this.currentUnderGroupName};
            this.broadcast(this.groupName, "member", new Integer(3).toString(), parameters);
        }
        if (!this.currentUnderGroupName.equals("") && !this.skipBroadcastEnergy) {
            parameters = new String[]{new Integer(this.getEnergyLevel()).toString(), new Integer(this.getMaximumEnergy()).toString()};
            this.broadcast(this.currentUnderGroupName, "member", new Integer(2).toString(), parameters);
        }
    }

    public void processPercepts() {
        int nbFr = 0;
        int nbEn = 0;
        Percept[] detectedEntities = this.getPercepts();
        if (detectedEntities.length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (e.getTeam().equals(this.getTeam()) && e.getPerceptType().equals("RocketLauncher")) {
                    ++nbFr;
                    continue;
                }
                if (e.getTeam().equals(this.getTeam()) || !e.getPerceptType().equals("RocketLauncher")) continue;
                ++nbEn;
            }
        }
        if (nbFr < nbEn) {
            this.throwMessage("RocketLauncher", 90, 0);
        } else {
            this.throwMessage("RocketLauncher", 80, 0);
        }
    }

    public void processKBase() {
        this.clearKnowledge();
        this.mergeKBases();
        this.cleanEnnBase();
        this.processEnnBase();
        this.screamEnnBase();
    }

    public boolean closeToBase(WarbotMessage agent, WarbotMessage base) {
        double diffY;
        double agentX = agent.getFromX();
        double agentY = agent.getFromY();
        double senderX = base.getFromX();
        double senderY = base.getFromY();
        double viewedX = new Double(base.getContent()[1]);
        double viewedY = new Double(base.getContent()[2]);
        double baseX = senderX + viewedX;
        double baseY = senderY + viewedY;
        double diffX = Math.abs(agentX - baseX);
        double diffDist = Math.sqrt(diffX * diffX + (diffY = Math.abs(agentY - baseY)) * diffY);
        return diffDist < (double)90;
    }

    public void processEnnBase() {
        if (!this.coords.isEmpty() && !this.ennBases.isEmpty()) {
            for (int i = 0; i < this.coords.size(); ++i) {
                for (int j = 0; j < this.ennBases.size(); ++j) {
                    if (!this.closeToBase((WarbotMessage)this.coords.elementAt(i), (WarbotMessage)this.ennBases.elementAt(j))) continue;
                    this.ennBases.removeElementAt(j);
                }
            }
        }
    }

    public void clearKnowledge() {
        if (!this.coords.isEmpty() && !this.newEnnBases.isEmpty()) {
            for (int i = 0; i < this.newEnnBases.size(); ++i) {
                for (int j = 0; j < this.coords.size(); ++j) {
                    if (((WarbotMessage)this.coords.elementAt(j)).getSender() != ((WarbotMessage)this.newEnnBases.elementAt(i)).getSender()) continue;
                    this.coords.removeElementAt(j);
                }
            }
        }
    }

    public void mergeKBases() {
        if (!this.newEnnBases.isEmpty()) {
            for (int i = 0; i < this.newEnnBases.size(); ++i) {
                this.ennBases.add(this.newEnnBases.elementAt(i));
            }
        }
    }

    public boolean isTheSameBase(WarbotMessage base1, WarbotMessage base2) {
        double diffY;
        double agentX1 = base1.getFromX();
        double agentY1 = base1.getFromY();
        double viewedX1 = new Double(base1.getContent()[1]);
        double viewedY1 = new Double(base1.getContent()[2]);
        double baseX1 = agentX1 + viewedX1;
        double baseY1 = agentY1 + viewedY1;
        double agentX2 = base2.getFromX();
        double agentY2 = base2.getFromY();
        double viewedX2 = new Double(base2.getContent()[1]);
        double viewedY2 = new Double(base2.getContent()[2]);
        double baseX2 = agentX2 + viewedX2;
        double baseY2 = agentY2 + viewedY2;
        double diffX = Math.abs(baseX1 - baseX2);
        double diffDist = Math.sqrt(diffX * diffX + (diffY = Math.abs(baseY1 - baseY2)) * diffY);
        return diffDist < (double)5;
    }

    public void cleanEnnBase() {
        if (!this.ennBases.isEmpty()) {
            for (int i = 0; i < this.ennBases.size(); ++i) {
                for (int j = 0; j < this.ennBases.size(); ++j) {
                    if (j == i || !this.isTheSameBase((WarbotMessage)this.ennBases.elementAt(i), (WarbotMessage)this.ennBases.elementAt(j))) continue;
                    this.ennBases.removeElementAt(j);
                    --j;
                }
            }
        }
    }

    public void screamEnnBase() {
        if (!this.ennBases.isEmpty()) {
            for (int i = 0; i < this.ennBases.size(); ++i) {
                WarbotMessage base = (WarbotMessage)this.ennBases.elementAt(i);
                double senderX = base.getFromX();
                double senderY = base.getFromY();
                double viewedX = new Double(base.getContent()[1]);
                double viewedY = new Double(base.getContent()[2]);
                double baseX = senderX + viewedX;
                double baseY = senderY + viewedY;
                int priority = 75;
                String[] parameters = new String[]{new Integer(priority).toString(), new Double(baseX).toString(), new Double(baseY).toString(), "", this.roleName};
                this.broadcast(this.groupName, "member", new Integer(1).toString(), parameters);
            }
        }
    }
}

