/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import SEdit.Command;
import SEdit.NewNodeCommand;
import java.awt.Point;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import madkit.kernel.Message;
import madkit.kernel.ObjectMessage;
import madkit.kernel.StringMessage;
import warbot.kernel.BasicBody;
import warbot.kernel.Brain;
import warbot.kernel.Crossable;
import warbot.kernel.Entity;
import warbot.kernel.Environment2D;
import warbot.kernel.EnvironmentAgent;
import warbot.kernel.Home;
import warbot.kernel.InstallMessage;
import warbot.kernel.Percept;
import warbot.kernel.PerceptComparator;
import warbot.kernel.Rocket;
import warbot.kernel.Wall;
import warbot.kernel.WarbotStructure;

public final class WarbotEnvironment
extends EnvironmentAgent {
    public static final int HOME = 1;
    public static final int WALL = 2;
    public static final int PALMTREE = 3;
    public static final int HAMBURGER = 4;
    public static final int ROCKETLAUNCHER = 5;
    public static final int EXPLORER = 6;
    public static final String[] TYPES = new String[]{"None", "Home", "Wall", "Palmtree", "Hamburger", "RocketLauncher", "Explorer"};
    public Environment2D world;
    Vector removableEntity;
    Vector evolutiveEntities;
    Map homes;
    Collection walls = new HashSet();
    PerceptComparator perceptComparator = new PerceptComparator();
    WarbotStructure theStructure;

    WarbotEnvironment(WarbotStructure warbotStructure, int n, int n2, String string) {
        super(string);
        this.theStructure = warbotStructure;
        this.world = new Environment2D(n, n2);
        this.removableEntity = new Vector();
        this.evolutiveEntities = new Vector();
        this.homes = new HashMap();
    }

    public void activate() {
        super.activate();
        this.makeWalls();
    }

    final synchronized void removeEntity(Entity entity) {
        this.world.removeEntity(entity);
        if (!(entity instanceof BasicBody)) {
            this.evolutiveEntities.remove(entity);
        }
    }

    final synchronized boolean contains(Entity entity) {
        return this.world.contains(entity);
    }

    final synchronized boolean addEntity(Entity entity) {
        if (!(entity instanceof BasicBody) && entity.getSpeed() > 0) {
            this.evolutiveEntities.addElement(entity);
        }
        this.world.addEntity(entity);
        entity.setEnvironmentAgent(this);
        if (entity instanceof Home) {
            if (this.homes.containsKey(entity.getTeam())) {
                ((Collection)this.homes.get(entity.getTeam())).add(entity);
            } else {
                HashSet<Entity> hashSet = new HashSet<Entity>();
                hashSet.add(entity);
                this.homes.put(entity.getTeam(), hashSet);
            }
        }
        return true;
    }

    boolean dropEntity(Entity entity, Entity entity2, double d) {
        int n = entity.getRadius() + entity2.getRadius() + 1;
        double d2 = d % 360.0;
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        for (int i = 0; i < 180; ++i) {
            double d3 = Math.sin(Math.PI * d2 / 180.0);
            double d4 = Math.cos(Math.PI * d2 / 180.0);
            entity2.setXY((double)n * d4 + entity.getX(), (double)n * d3 + entity.getY());
            if (this.authorizeMove(entity2, entity2.getX(), entity2.getY())) {
                this.world.addEntity(entity2);
                entity2.reInstall(this.theStructure);
                return true;
            }
            d2 += 2.0;
            d2 %= 360.0;
        }
        return false;
    }

    void makeWorld() {
        int n;
        int n2;
        for (n2 = 500; n2 < 600; n2 += 5) {
            for (n = 40; n < 100; n += 5) {
                this.makeHamburger(n2, n);
            }
        }
        for (n2 = 200; n2 < 300; n2 += 5) {
            for (n = 760; n > 700; n -= 5) {
                this.makeHamburger(n2, n);
            }
        }
        for (n2 = 200; n2 < 275; ++n2) {
            this.makeHamburger((int)(Math.random() * (double)(this.world.getWidth() - 50) + 25.0), (int)(Math.random() * (double)(this.world.getHeight() - 50) + 25.0));
        }
    }

    void makeWalls() {
        int n;
        Iterator iterator = this.walls.iterator();
        while (iterator.hasNext()) {
            this.world.removeEntity((Entity)iterator.next());
        }
        this.walls.clear();
        int n2 = 3;
        for (n = 20; n < this.world.getWidth(); n += 50) {
            this.makeWall(n, n2);
        }
        n2 = this.world.getHeight() - 3;
        for (n = 20; n < this.world.getWidth(); n += 50) {
            this.makeWall(n, n2);
        }
        n2 = 3;
        for (n = 20; n < this.world.getHeight(); n += 50) {
            this.makeWall(n2, n);
        }
        n2 = this.world.getWidth() - 3;
        for (n = 20; n < this.world.getHeight(); n += 50) {
            this.makeWall(n2, n);
        }
    }

    void makeWall(int n, int n2) {
        this.theStructure.getAgent().doCommand((Command)new NewNodeCommand("Wall", new Point(n, n2)));
        Entity entity = this.theStructure.getLastEntity();
        entity.persistent = false;
        this.walls.add((Wall)entity);
    }

    void makeHamburger(int n, int n2) {
        this.theStructure.getAgent().doCommand((Command)new NewNodeCommand("Hamburger", new Point(n, n2)));
    }

    void setEntity(Entity entity, int n, int n2) {
        entity.setXY(n, n2);
        this.world.addEntity(entity);
    }

    synchronized void moveWorld() {
        Enumeration enumeration = this.evolutiveEntities.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.willAct()) continue;
            entity.doIt();
        }
    }

    synchronized void deleteEntities() {
        System.out.println("deleting the entities");
        Entity[] entityArray = this.removableEntity.elements();
        while (entityArray.hasMoreElements()) {
            ((Entity)entityArray.nextElement()).delete();
        }
        this.removableEntity.removeAllElements();
        entityArray = this.world.getAllEntities();
        for (int i = 0; i < entityArray.length; ++i) {
            entityArray[i].delete();
        }
        this.checkMail();
    }

    void checkVictory() {
        if (!this.homes.isEmpty()) {
            Object object;
            Iterator<Object> iterator;
            Object object22;
            boolean bl = true;
            for (Object object22 : this.homes.values()) {
                iterator = object22.iterator();
                while (iterator.hasNext()) {
                    object = (Entity)iterator.next();
                    if (((Entity)object).getEnergy() >= 0) continue;
                    iterator.remove();
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
            HashSet hashSet = new HashSet();
            object22 = null;
            iterator = this.homes.entrySet().iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                if (((Collection)object.getValue()).isEmpty()) {
                    Entity[] entityArray = this.world.getAllEntities();
                    for (int i = 0; i < entityArray.length; ++i) {
                        if (!entityArray[i].getTeam().equals(object.getKey())) continue;
                        entityArray[i].setSpeed(0);
                    }
                    hashSet.add(object.getKey());
                    iterator.remove();
                    continue;
                }
                object22 = (String)object.getKey();
            }
            if (this.homes.size() == 0) {
                iterator = new Object[]{"drawGame", hashSet};
                this.sendMessage(this.getSimulationGroup(), "warbot GUI", (Message)new ObjectMessage(iterator));
            } else if (this.homes.size() == 1) {
                iterator = new Object[]{"victory", object22};
                this.sendMessage(this.getSimulationGroup(), "warbot GUI", (Message)new ObjectMessage(iterator));
                this.homes.clear();
            }
        }
    }

    boolean authorizeMove(Entity entity, double d, double d2) {
        Entity[] entityArray = this.world.getAllEntities();
        double d3 = entity.getRadius();
        for (int i = 0; i < entityArray.length; ++i) {
            Entity entity2 = entityArray[i];
            double d4 = entity2.getRadius();
            double d5 = entity2.getX();
            double d6 = entity2.getY();
            if (entity2 == entity || entity2 instanceof Crossable || Math.abs(d5 - d) > d3 + d4 || Math.abs(d6 - d2) > d3 + d4 || Math.sqrt(Math.pow(d5 - d, 2.0) + Math.pow(d6 - d2, 2.0)) > d3 + d4) continue;
            return false;
        }
        return true;
    }

    Entity authorizeMove(Rocket rocket, double d, double d2) {
        Entity[] entityArray = this.world.getAllEntities();
        double d3 = rocket.getRadius();
        for (int i = 0; i < entityArray.length; ++i) {
            double d4 = entityArray[i].getRadius();
            double d5 = entityArray[i].getX();
            double d6 = entityArray[i].getY();
            if (entityArray[i] == rocket || Math.abs(d5 - d) > d3 + d4 || Math.abs(d6 - d2) > d3 + d4 || Math.sqrt(Math.pow(d5 - d, 2.0) + Math.pow(d2 - d6, 2.0)) > d3 + d4) continue;
            return entityArray[i];
        }
        return null;
    }

    void makePerception(BasicBody basicBody) {
        Vector<Percept> vector = new Vector<Percept>();
        Entity[] entityArray = this.world.getAllEntities();
        int n = basicBody.getDetectingRange() + basicBody.getRadius();
        int n2 = basicBody.xcor();
        int n3 = basicBody.ycor();
        for (int i = 0; i < entityArray.length; ++i) {
            Brain brain;
            double d;
            if (entityArray[i] == basicBody) continue;
            double d2 = 0.0;
            if (Math.abs(entityArray[i].xcor() - n2) >= n + entityArray[i].getRadius() || Math.abs(entityArray[i].ycor() - n3) >= n + entityArray[i].getRadius()) continue;
            d2 = Math.sqrt(Math.pow(entityArray[i].xcor() - n2, 2.0) + Math.pow(entityArray[i].ycor() - n3, 2.0));
            if (!(d < (double)(n + entityArray[i].getRadius()))) continue;
            Entity entity = entityArray[i];
            Percept percept = entity.makePercept(entity.x - basicBody.x, entity.y - basicBody.y, d2 - (double)basicBody.getRadius());
            if (entity instanceof BasicBody && entity.getTeam() != null && entity.getTeam().equals(basicBody.getTeam()) && (brain = ((BasicBody)entity).getBrain()) != null) {
                percept.setAgent(brain.getAddress());
            }
            vector.add(percept);
        }
        if (vector.size() > 0) {
            Percept[] perceptArray = vector.toArray(new Percept[0]);
            Arrays.sort(perceptArray, this.perceptComparator);
            basicBody.setPercepts(perceptArray);
        } else {
            basicBody.setPercepts(new Percept[0]);
        }
    }

    final void checkMail() {
        Message message = this.nextMessage();
        if (message != null) {
            if (message instanceof InstallMessage) {
                this.addEntity(((InstallMessage)message).getEntity());
            } else if (message instanceof StringMessage) {
                String string = ((StringMessage)message).getString();
                if (string.equals("cleanWorld")) {
                    this.deleteEntities();
                } else if (string.equals("resetWorld")) {
                    this.resetWorld();
                }
            } else if (message instanceof StringMessage) {
                this.makeWalls();
            } else {
                System.err.println("!!!!!    reset world  !!!!!!!");
                this.resetWorld();
            }
        }
    }

    final synchronized void loadConfig(URL uRL) {
    }

    final void resetWorld() {
        Entity[] entityArray = this.world.getAllEntities();
        this.homes.clear();
        this.evolutiveEntities.removeAllElements();
        for (int i = 0; i < entityArray.length; ++i) {
            entityArray[i].delete();
        }
        this.makeWalls();
    }
}

