/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import SEdit.Command;
import SEdit.NewNodeCommand;
import java.awt.Point;
import warbot.kernel.BasicBody;
import warbot.kernel.Brain;
import warbot.kernel.Percept;
import warbot.kernel.Rocket;
import warbot.kernel.WarbotEnvironment;
import warbot.kernel.WarbotStructure;

public class RocketLauncher
extends BasicBody {
    protected static final int maximumRocket = 50;
    protected int rocketNb = 300;
    protected static final int SHOOT = 10;
    protected static final int BUILD_ROCKET = 11;
    private double rocketDirection = 0.0;
    int rocketWaitMax;
    int rocketWait = this.rocketWaitMax = 3;

    public RocketLauncher(WarbotEnvironment warbotEnvironment, Brain brain, String string) {
        super(warbotEnvironment, brain, "rocket launcher", string, 15, 8000, 45);
        this.setSpeed(5);
    }

    public RocketLauncher() {
        this.setDetectingRange(45);
        this.setSpeed(5);
        this.maximumEnergy = 8000;
    }

    public Percept makePercept(double d, double d2, double d3) {
        Percept percept = super.makePercept(d, d2, d3);
        percept.setPerceptType("RocketLauncher");
        return percept;
    }

    public void launchRocket(double d) {
        this.rocketDirection = d;
        this.action = 10;
    }

    public void buildRocket() {
        this.action = 11;
    }

    public int getRocketNb() {
        return this.rocketNb;
    }

    void tryShoot() {
        if (this.rocketNb > 0 && this.rocketWait <= 0) {
            --this.rocketNb;
            this.getStructure().getAgent().doCommand((Command)new NewNodeCommand("Rocket", new Point(0, 0)));
            Rocket rocket = (Rocket)((WarbotStructure)this.getStructure()).getLastEntity();
            rocket.setHeading(this.rocketDirection);
            rocket.setXY((double)(this.radius + rocket.getRadius() + 1) * rocket.getCosAlpha() + this.x, (double)(this.radius + rocket.getRadius() + 1) * rocket.getSinAlpha() + this.y);
            this.rocketWait = this.rocketWaitMax;
        }
    }

    void tryBuildRocket() {
        ++this.rocketNb;
        if (this.rocketNb > 50) {
            this.rocketNb = 50;
        }
    }

    void doIt() {
        super.doIt();
        --this.rocketWait;
        if (this.rocketWait < 0) {
            this.rocketWait = 0;
        }
    }

    void doAction() {
        switch (this.action) {
            case 10: {
                this.tryShoot();
                break;
            }
            case 11: {
                this.tryBuildRocket();
                break;
            }
            default: {
                super.doAction();
            }
        }
    }
}

