/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import java.awt.Color;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Utils;
import warbot.kernel.Bag;
import warbot.kernel.Body;
import warbot.kernel.Brain;
import warbot.kernel.Entity;
import warbot.kernel.Food;
import warbot.kernel.GBasicBody;
import warbot.kernel.MovableEntity;
import warbot.kernel.Percept;
import warbot.kernel.Transportable;
import warbot.kernel.WarbotEnvironment;
import warbot.kernel.WarbotIdentifier;

public abstract class BasicBody
extends MovableEntity
implements Body {
    public static final int DISTANCE_TO_TAKE = 3;
    public static final int DISTANCE_TO_EAT = 5;
    Brain myBrain;
    transient Hashtable methods = new Hashtable(20);
    protected int maximumEnergy;
    protected static final int EAT = 2;
    Entity eatWhat = null;
    protected static final int TAKE = 3;
    protected static final int DROP = 4;
    protected static final int DROPALL = 5;
    public static final String[] ACTIONS = new String[]{"Nothing", "Move", "Eat", "Take", "Drop", "DropType", "Create", "Nothing", "Nothing", "Nothing", "Build rocket", "Launch rocket"};
    Bag myBag;
    int dropIndex = -1;
    Entity takeWhat;
    public static final int BAG_CAPACITY = 3;
    String gifLocation = "default";
    boolean showMessages = true;
    protected String brainClass;
    protected String behaviorFileName = null;
    boolean showUserMessage = false;
    String userMessage;
    private Percept[] percepts = new Percept[0];

    void setGifLocation(String string) {
        this.gifLocation = string;
    }

    BasicBody(WarbotEnvironment warbotEnvironment, Brain brain, String string, String string2, int n, int n2, int n3) {
        super(warbotEnvironment, string, string2, n, n2, n3);
        this.maximumEnergy = n2;
        this.myBag = new Bag(3);
        this.myBrain = brain;
    }

    BasicBody() {
        this.myBag = new Bag(3);
    }

    public Percept makePercept(double d, double d2, double d3) {
        Percept percept = super.makePercept(d, d2, d3);
        percept.setPerceptType("Robot");
        return percept;
    }

    public void createDefaultImage() {
        if (this.gifLocation == null || this.gifLocation.equals("default")) {
            super.createDefaultImage();
        } else {
            URL uRL = null;
            try {
                uRL = new URL(this.gifLocation);
                this.myGif = new ImageIcon(Toolkit.getDefaultToolkit().createImage(uRL).getScaledInstance(this.radius * 2, this.radius * 2, 4));
            }
            catch (Exception exception) {
                System.err.println("invalid gif url");
                super.createDefaultImage();
            }
        }
    }

    void showLine(double d, double d2, double d3, double d4, Color color) {
        ((GBasicBody)this.getGObject()).showLine((int)d, (int)d2, (int)d3, (int)d4, color);
    }

    public void setShowMessages(boolean bl) {
        this.showMessages = bl;
    }

    public boolean isShowMessages() {
        return this.showMessages;
    }

    public void toggleShowMessages() {
        this.showMessages = !this.showMessages;
    }

    final void setBrain(Brain brain) {
        this.myBrain = brain;
    }

    final Brain getBrain() {
        return this.myBrain;
    }

    final String getBrainClassName() {
        if (this.getBrain() != null) {
            return this.getBrain().getClass().getName();
        }
        return null;
    }

    public void setBrainClass(String string) {
        this.brainClass = string;
    }

    public String getBrainClass() {
        return this.brainClass;
    }

    public void setBehaviorFileName(String string) {
        this.behaviorFileName = string;
    }

    public String getBehaviorFileName() {
        return this.behaviorFileName;
    }

    public void makeBrain(String string, String string2, boolean bl, String string3) {
        try {
            Class clazz = Utils.loadClass((String)string);
            this.myBrain = (Brain)clazz.newInstance();
            this.myBrain.setBody(this);
            if (this.myBrain instanceof AbstractAgent) {
                String string4 = string2;
                if (string4 == null) {
                    string4 = this.getLabel();
                }
                if (string4 == null) {
                    string4 = this.getID();
                }
                if (string3 != null) {
                    this.setBehaviorFileName(string3);
                }
                this.myBrain.init();
                this.getStructure().getAgent().doLaunchAgent((AbstractAgent)this.myBrain, string4, bl);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found :" + string + " " + classNotFoundException);
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Can't instanciate ! " + string + " " + instantiationException);
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("illegal access! " + string + " " + illegalAccessException);
            illegalAccessException.printStackTrace();
        }
    }

    public void init() {
        super.init();
        String string = this.getBrainClass();
        if (string != null) {
            this.makeBrain(string, null, false, this.getBehaviorFileName());
            this.myBrain.requestRole(this.getTeam(), this.getName(), null);
            int n = this.myBrain.requestRole(this.simulationGroup, "brain", WarbotIdentifier.password);
        }
    }

    public void setShowUserMessage(boolean bl) {
        this.showUserMessage = bl;
    }

    public boolean isShowUserMessage() {
        return this.showUserMessage;
    }

    public void toggleShowUserMessage() {
        this.showUserMessage = !this.showUserMessage;
    }

    public void setUserMessage(String string) {
        this.userMessage = string;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public final void delete() {
        System.out.println("I'm dead !!! ");
        if (this.myBrain != null) {
            this.myBrain.delete();
        }
        super.delete();
    }

    public void edit() {
        if (this.myBrain != null) {
            this.myBrain.edit();
        }
    }

    void doAction() {
        switch (this.action) {
            case 1: {
                this.tryMove();
                break;
            }
            case 2: {
                this.tryEat();
                break;
            }
            case 3: {
                this.tryPutInMyBag();
                break;
            }
            case 4: {
                this.putOutOfMyBag(this.dropIndex);
            }
        }
        this.takeWhat = null;
    }

    public final void die() {
        this.delete();
    }

    protected void setPercepts(Percept[] perceptArray) {
        this.percepts = perceptArray;
    }

    public Percept[] getPercepts() {
        return this.percepts;
    }

    void createPerception() {
        this.myWorld.makePerception(this);
    }

    public void move() {
        this.action = 1;
    }

    public void eat(Food food) {
        this.action = 2;
        this.eatWhat = food.getEntity();
    }

    public int getMaximumEnergy() {
        return this.maximumEnergy;
    }

    public int getResourceLevel() {
        return 0;
    }

    boolean showResourceLevel() {
        return false;
    }

    protected void tryEat() {
        if (this.distanceFrom(this.eatWhat) <= 5.0) {
            this.increaseEnergyLevel(this.eatWhat.getEnergy());
            this.eatWhat.delete();
        }
        this.eatWhat = null;
    }

    protected void increaseEnergyLevel(int n) {
        this.energy += n;
        if (this.energy > this.maximumEnergy) {
            this.energy = this.maximumEnergy;
        }
    }

    void tryPutInMyBag() {
        if (this.takeWhat != null && this.myWorld.contains(this.takeWhat) && this.distanceFrom(this.takeWhat) <= 3.0) {
            this.takeWhat.delete();
            this.myBag.put(this.takeWhat);
        }
    }

    private void putOutOfMyBag(int n) {
        if (this.myBag.size() >= n) {
            double d = this.getHeading();
            Entity entity = this.myBag.get(n);
            if (entity != null && this.dropEntity(entity, d)) {
                this.myBag.remove(n);
            }
        }
    }

    private void putOutEverythingOfMyBag(String string) {
        double d = this.getHeading();
        for (int i = 0; i < this.myBag.size(); ++i) {
            Entity entity = this.myBag.get(i);
            this.dropEntity(entity, d);
        }
        this.myBag.clear();
    }

    public void take(Transportable transportable) {
        Percept percept = (Percept)((Object)transportable);
        this.takeWhat = percept.getEntity();
        this.action = 3;
    }

    public Percept[] inMyBag() {
        Entity[] entityArray = this.myBag.returnContent();
        Percept[] perceptArray = new Percept[entityArray.length];
        for (int i = 0; i < entityArray.length; ++i) {
            perceptArray[i] = entityArray[i].makePercept(0.0, 0.0, 0.0);
        }
        return perceptArray;
    }

    public boolean isMyBagEmpty() {
        return this.myBag.isEmpty();
    }

    public boolean isMyBagFull() {
        return this.myBag.isFull();
    }

    public int getBagCapacity() {
        return this.myBag.capacity;
    }

    public int nbOfObjectsInMyBag() {
        return this.myBag.size();
    }

    public void drop(int n) {
        this.action = 4;
        this.dropIndex = n;
    }

    public void dropAll() {
        this.action = 5;
    }

    public void launchRocket(double d) {
        System.out.println(":: LaunchRocket not accessible from " + this);
    }

    public void buildRocket() {
        System.out.println(":: buildRocket not accessible from " + this);
    }

    public int getRocketNb() {
        System.out.println(":: getRocketNb not accessible from " + this);
        return 0;
    }

    public void createAgent(String string) {
        System.out.println(":: createAgent not accessible from " + this);
    }
}

