/*
 * Decompiled with CFR 0.152.
 */
package madkit.share;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Vector;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.share.ListPluginInfo;
import madkit.share.PluginInfo;
import madkit.share.PluginInfoMessage;
import madkit.share.PluginShareAgent;
import madkit.share.PluginVersionNumber;
import madkit.share.RequestPluginInfoMessage;
import madkit.share.UpdatedPlugin;

public class SmallUpdatePluginAgent
extends Agent {
    String pluginsPath;
    AgentAddress[] agList;
    PluginShareAgent shareAgent;
    int timeout;
    boolean live;
    Calendar limitDate;
    Calendar currentDate;
    ListPluginInfo listPluginInfo;
    Vector stockUpdatedPlugin;
    int nbServer;

    public SmallUpdatePluginAgent(AgentAddress[] agentAddressArray, PluginShareAgent pluginShareAgent) {
        this.agList = agentAddressArray;
        this.shareAgent = pluginShareAgent;
        this.stockUpdatedPlugin = new Vector();
        this.timeout = 30;
        this.nbServer = this.agList.length;
        this.pluginsPath = this.shareAgent.madkitDirectory + File.separator + "plugins";
    }

    public void activate() {
        System.out.println("(SmallUpdatePlugin) created");
        String string = this.shareAgent.getGroupName();
        this.createGroup(true, string, null, null);
        this.requestRole(string, "SmallUpdatePlugin", null);
        this.live = true;
        this.sendAllRequestUpdatePluginMessage();
        this.limitDate = Calendar.getInstance();
        this.limitDate.add(13, this.timeout);
    }

    public void live() {
        while (this.live) {
            this.exitImmediatlyOnKill();
            this.checkTimeout();
            if (!this.isMessageBoxEmpty()) {
                Message message = this.waitNextMessage();
                --this.nbServer;
                try {
                    this.handleMessage(message);
                }
                catch (IOException iOException) {
                    System.out.println("Error : SmallUpdatePluginAgent --> HandleMessage");
                }
            }
            if (this.nbServer <= 0) {
                this.live = false;
                continue;
            }
            this.pause(1000);
        }
    }

    void handleMessage(Message message) throws IOException {
        if (message instanceof PluginInfoMessage) {
            AgentAddress agentAddress = ((PluginInfoMessage)message).getSender();
            String string = ((PluginInfoMessage)message).getSender().getKernel().getHost().toString();
            this.limitDate = Calendar.getInstance();
            this.limitDate.add(13, this.timeout);
            this.listPluginInfo = ((PluginInfoMessage)message).getListPluginInfo();
            this.checkUpdatePlugin(string, agentAddress);
            this.shareAgent.showUpdatedPlugin(agentAddress, this.stockUpdatedPlugin);
            System.out.println("(SmallUpdatePlugin) PluginInfoMessageReceived");
        }
    }

    public void checkUpdatePlugin(String string, AgentAddress agentAddress) {
        for (int i = 0; i < this.listPluginInfo.size(); ++i) {
            this.comparePlugin(this.listPluginInfo.elementAt(i), string, agentAddress);
        }
    }

    public void comparePlugin(PluginInfo pluginInfo, String string, AgentAddress agentAddress) {
        String string2 = pluginInfo.pluginName;
        PluginVersionNumber pluginVersionNumber = pluginInfo.pluginVersion;
        String string3 = pluginInfo.virtualPath;
        File file = new File(this.pluginsPath);
        File[] fileArray = file.listFiles();
        boolean bl = false;
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.getName().equals(string2)) continue;
                bl = true;
                try {
                    String string4;
                    File file3 = new File(this.pluginsPath + File.separator + string2 + File.separator + string2 + ".properties");
                    if (!file3.exists()) continue;
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file3, "r");
                    while ((string4 = randomAccessFile.readLine()) != null) {
                        PluginVersionNumber pluginVersionNumber2;
                        int n = string4.indexOf("madkit.plugin.version=");
                        if (n == -1 || !(pluginVersionNumber2 = new PluginVersionNumber(string4.substring((n = string4.indexOf("=")) + 1))).isSmaller(pluginVersionNumber)) continue;
                        UpdatedPlugin updatedPlugin = new UpdatedPlugin(string2, pluginVersionNumber2, pluginVersionNumber, string3, agentAddress);
                        this.stockUpdatedPlugin.add(updatedPlugin);
                    }
                    randomAccessFile.close();
                    continue;
                }
                catch (IOException iOException) {
                    System.out.println("(Client) Can't read " + string2 + ".properties");
                }
            }
        }
        if (!bl) {
            UpdatedPlugin updatedPlugin = new UpdatedPlugin(string2, new PluginVersionNumber("0"), pluginVersionNumber, string3, agentAddress);
            this.stockUpdatedPlugin.add(updatedPlugin);
        }
    }

    public void checkTimeout() {
        this.currentDate = Calendar.getInstance();
        if (this.currentDate.after(this.limitDate)) {
            this.live = false;
            System.out.println("SmallUpadtePLuginAgent --> timeout");
        }
    }

    public void sendAllRequestUpdatePluginMessage() {
        for (int i = 0; i < this.agList.length; ++i) {
            this.sendMessage(this.agList[i], new RequestPluginInfoMessage());
        }
    }
}

