/*
 * Decompiled with CFR 0.152.
 */
package kawa.lib;

import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleMethod;
import gnu.kawa.functions.NumberCompare;
import gnu.lists.CharSeq;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.Strings;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.mapping.WrongType;
import gnu.math.IntNum;
import gnu.text.Char;
import kawa.lib.lists;

public class strings
extends ModuleBody {
    static final strings $instance = new strings();
    public static final ModuleMethod isString;
    public static final ModuleMethod isString$Eq;
    public static final ModuleMethod makeString;
    public static final ModuleMethod stringLength;
    public static final ModuleMethod stringRef;
    public static final ModuleMethod stringSet$Ex;
    public static final ModuleMethod substring;
    public static final ModuleMethod string$To$List;
    public static final ModuleMethod list$To$String;
    public static final ModuleMethod stringCopy;
    public static final ModuleMethod stringFill$Ex;
    public static final ModuleMethod stringUpcase$Ex;
    public static final ModuleMethod stringDowncase$Ex;
    public static final ModuleMethod stringCapitalize$Ex;
    public static final ModuleMethod stringUpcase;
    public static final ModuleMethod stringDowncase;
    public static final ModuleMethod stringCapitalize;
    static final Binding id$$$Lsboolean$Gr;
    static final Binding id$$$Lsint$Gr;
    static final Binding id$$$Lschar$Gr;
    static final Binding id$$$Lsvoid$Gr;
    static final Char Lit0;
    static final IntNum Lit1;

    /*
     * Enabled aggressive block sorting
     */
    static {
        Lit1 = IntNum.make(0);
        Lit0 = Char.make(32);
        isString = new ModuleMethod($instance, 12, "string?", 4097);
        isString$Eq = new ModuleMethod($instance, 15, "string=?", 8194);
        makeString = new ModuleMethod($instance, 11, "make-string", 8193);
        stringLength = new ModuleMethod($instance, 10, "string-length", 4097);
        stringRef = new ModuleMethod($instance, 14, "string-ref", 8194);
        stringSet$Ex = new ModuleMethod($instance, 17, "string-set!", 12291);
        substring = new ModuleMethod($instance, 16, "substring", 12291);
        string$To$List = new ModuleMethod($instance, 9, "string->list", 4097);
        list$To$String = new ModuleMethod($instance, 8, "list->string", 4097);
        stringCopy = new ModuleMethod($instance, 7, "string-copy", 4097);
        stringFill$Ex = new ModuleMethod($instance, 13, "string-fill!", 8194);
        stringUpcase$Ex = new ModuleMethod($instance, 6, "string-upcase!", 4097);
        stringDowncase$Ex = new ModuleMethod($instance, 5, "string-downcase!", 4097);
        stringCapitalize$Ex = new ModuleMethod($instance, 4, "string-capitalize!", 4097);
        stringUpcase = new ModuleMethod($instance, 3, "string-upcase", 4097);
        stringDowncase = new ModuleMethod($instance, 2, "string-downcase", 4097);
        stringCapitalize = new ModuleMethod($instance, 1, "string-capitalize", 4097);
        Environment env$ = Environment.getCurrent();
        id$$$Lsint$Gr = env$.getBinding("<int>");
        id$$$Lschar$Gr = env$.getBinding("<char>");
        id$$$Lsvoid$Gr = env$.getBinding("<void>");
        id$$$Lsboolean$Gr = env$.getBinding("<boolean>");
    }

    public static boolean isString(Object x) {
        return x instanceof FString;
    }

    public static boolean isString$Eq(Object x, Object y) {
        return x.toString().equals(y.toString());
    }

    public static FString makeString(int n) {
        return strings.makeString(n, Lit0);
    }

    public static FString makeString(int n, Object ch) {
        try {
            return new FString(n, ((Char)ch).charValue());
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.lists.FString.<init>(int,char)", 1);
        }
    }

    public static int stringLength(CharSeq str) {
        return str.length();
    }

    public static char stringRef(CharSeq string, int k) {
        return string.charAt(k);
    }

    public static void stringSet$Ex(CharSeq string, int k, char c) {
        string.setCharAt(k, c);
    }

    public static FString substring(CharSeq str, int start, int end) {
        return new FString(str, start, end - start);
    }

    public static LList string$To$List(CharSeq str) {
        int i = strings.stringLength(str);
        LList result = LList.Empty;
        while (!NumberCompare.$Ls(IntNum.make(--i), Lit1)) {
            Pair pair = lists.cons(Char.make(strings.stringRef(str, i)), result);
            result = pair;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FString list$To$String(LList list) {
        int len = lists.length(list);
        FString result = new FString(len);
        int i = 0;
        while (!NumberCompare.$Gr$Eq(IntNum.make(i), IntNum.make(len))) {
            Pair pair = (Pair)list;
            try {
                strings.stringSet$Ex(result, i, ((Char)lists.car(pair)).charValue());
            }
            catch (ClassCastException classCastException) {
                throw WrongType.make(classCastException, "string-set!", 2);
            }
            list = (LList)lists.cdr(pair);
            ++i;
        }
        return result;
    }

    public static FString stringCopy(CharSeq str) {
        return new FString(str);
    }

    public static void stringFill$Ex(CharSeq str, char ch) {
        str.fill(ch);
    }

    public static CharSeq stringUpcase$Ex(CharSeq str) {
        Strings.makeUpperCase(str);
        return str;
    }

    public static CharSeq stringDowncase$Ex(CharSeq str) {
        Strings.makeLowerCase(str);
        return str;
    }

    public static CharSeq stringCapitalize$Ex(CharSeq str) {
        Strings.makeCapitalize(str);
        return str;
    }

    /*
     * WARNING - void declaration
     */
    public static FString stringUpcase(CharSeq str) {
        void var1_1;
        FString copy = strings.stringCopy(str);
        Strings.makeUpperCase(copy);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static FString stringDowncase(CharSeq str) {
        void var1_1;
        FString copy = strings.stringCopy(str);
        Strings.makeLowerCase(copy);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static FString stringCapitalize(CharSeq str) {
        void var1_1;
        FString copy = strings.stringCopy(str);
        Strings.makeCapitalize(copy);
        return var1_1;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply1(ModuleMethod moduleMethod, Object object2) {
        switch (moduleMethod.selector) {
            case 1: {
                return strings.stringCapitalize((CharSeq)object2);
            }
            case 2: {
                return strings.stringDowncase((CharSeq)object2);
            }
            case 3: {
                return strings.stringUpcase((CharSeq)object2);
            }
            case 4: {
                return strings.stringCapitalize$Ex((CharSeq)object2);
            }
            case 5: {
                return strings.stringDowncase$Ex((CharSeq)object2);
            }
            case 6: {
                return strings.stringUpcase$Ex((CharSeq)object2);
            }
            case 7: {
                return strings.stringCopy((CharSeq)object2);
            }
            case 8: {
                return strings.list$To$String((LList)object2);
            }
            case 9: {
                return strings.string$To$List((CharSeq)object2);
            }
            case 10: {
                return IntNum.make(strings.stringLength((CharSeq)object2));
            }
            case 11: {
                return strings.makeString(((Number)object2).intValue());
            }
            case 12: {
                Boolean bl;
                if (strings.isString(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
        }
        return super.apply1(moduleMethod, object2);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "make-string", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-length", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string->list", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "list->string", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-copy", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-upcase!", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-downcase!", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-capitalize!", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-upcase", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-downcase", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-capitalize", 0);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply2(ModuleMethod moduleMethod, Object object2, Object object3) {
        switch (moduleMethod.selector) {
            case 13: {
                CharSeq charSeq = (CharSeq)object2;
                strings.stringFill$Ex(charSeq, ((Char)object3).charValue());
                return Interpreter.voidObject;
            }
            case 14: {
                CharSeq charSeq = (CharSeq)object2;
                return Char.make(strings.stringRef(charSeq, ((Number)object3).intValue()));
            }
            case 11: {
                return strings.makeString(((Number)object2).intValue(), object3);
            }
            case 15: {
                Boolean bl;
                if (strings.isString$Eq(object2, object3)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
        }
        return super.apply2(moduleMethod, object2, object3);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "make-string", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-ref", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-ref", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-fill!", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-fill!", 0);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply3(ModuleMethod moduleMethod, Object object2, Object object3, Object object4) {
        switch (moduleMethod.selector) {
            case 16: {
                CharSeq charSeq = (CharSeq)object2;
                int n = ((Number)object3).intValue();
                return strings.substring(charSeq, n, ((Number)object4).intValue());
            }
            case 17: {
                CharSeq charSeq = (CharSeq)object2;
                int n = ((Number)object3).intValue();
                strings.stringSet$Ex(charSeq, n, ((Char)object4).charValue());
                return Interpreter.voidObject;
            }
        }
        return super.apply3(moduleMethod, object2, object3, object4);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-set!", 2);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-set!", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "string-set!", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "substring", 2);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "substring", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "substring", 0);
        }
    }
}

