/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.ModuleBody;
import gnu.kawa.reflect.ClassMemberConstraint;
import gnu.mapping.Environment;
import gnu.mapping.HasSetter;
import gnu.mapping.Procedure;
import gnu.mapping.UnboundSymbol;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class AutoloadProcedure
extends Procedure
implements Externalizable {
    String className;
    Environment env;
    Procedure loaded;

    public AutoloadProcedure() {
    }

    public AutoloadProcedure(String string, String string2) {
        super(string);
        this.className = string2;
    }

    public AutoloadProcedure(String string, String string2, Environment environment) {
        super(string);
        this.className = string2;
        this.env = environment;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<procedure ");
        if (this.name() != null) {
            printWriter.print(this.name());
        }
        printWriter.print('>');
    }

    private void throw_error(String string) {
        this.loaded = null;
        throw new RuntimeException(string + this.className + " while autoloading " + (this.name() == null ? "" : this.name().toString()));
    }

    void load() {
        block11: {
            Environment environment = this.env != null ? this.env : Environment.getCurrent();
            String string = this.name();
            try {
                this.loaded = (Procedure)Class.forName(this.className).newInstance();
                if (this.loaded == this) {
                    this.throw_error("circularity detected");
                }
                if (this.loaded instanceof ModuleBody) {
                    ClassMemberConstraint.defineAll(this.loaded, environment);
                    ((ModuleBody)this.loaded).run();
                    Procedure procedure = environment.getBinding(string).getProcedure();
                    if (procedure == null || !(procedure instanceof Procedure)) {
                        this.throw_error("invalid ModuleBody class - does not define " + string);
                    }
                    this.loaded = procedure;
                    break block11;
                }
                if (string == null) break block11;
                try {
                    if (environment.getFunction(string) == this) {
                        environment.putFunction(string, this.loaded);
                    }
                }
                catch (UnboundSymbol unboundSymbol) {
                    // empty catch block
                }
                if (this.loaded.name() == null) {
                    this.loaded.setName(string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.throw_error("failed to find class ");
            }
            catch (InstantiationException instantiationException) {
                this.throw_error("failed to instantiate class ");
            }
            catch (IllegalAccessException illegalAccessException) {
                this.throw_error("illegal access in class ");
            }
        }
    }

    public Procedure getLoaded() {
        if (this.loaded == null) {
            this.load();
        }
        return this.loaded;
    }

    public int numArgs() {
        return this.getLoaded().numArgs();
    }

    public Object apply0() throws Throwable {
        return this.getLoaded().apply0();
    }

    public Object apply1(Object object2) throws Throwable {
        return this.getLoaded().apply1(object2);
    }

    public Object apply2(Object object2, Object object3) throws Throwable {
        return this.getLoaded().apply2(object2, object3);
    }

    public Object apply3(Object object2, Object object3, Object object4) throws Throwable {
        return this.getLoaded().apply3(object2, object3, object4);
    }

    public Object apply4(Object object2, Object object3, Object object4, Object object5) throws Throwable {
        return this.getLoaded().apply4(object2, object3, object4, object5);
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        if (this.loaded == null) {
            this.load();
        }
        if (this.loaded instanceof AutoloadProcedure) {
            throw new InternalError("circularity in autoload of " + this.name());
        }
        return this.loaded.applyN(objectArray);
    }

    public Procedure getSetter() {
        if (this.loaded == null) {
            this.load();
        }
        if (this.loaded instanceof HasSetter) {
            return this.loaded.getSetter();
        }
        return super.getSetter();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.className);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        this.className = (String)objectInput.readObject();
    }

    public Object getProperty(Object object2, Object object3) {
        Object object4 = super.getProperty(object2, null);
        if (object4 != null) {
            return object4;
        }
        return this.getLoaded().getProperty(object2, object3);
    }
}

