/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.Type;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.Parser;
import gnu.expr.QuoteExp;
import gnu.kawa.functions.ConstantFunction0;
import gnu.kawa.functions.CountValues;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.xml.Document;
import gnu.kawa.xml.MakeUnescapedData;
import gnu.kawa.xml.WriteTo;
import gnu.lists.Consumer;
import gnu.lists.FormatToConsumer;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xml.XMLPrinter;
import gnu.xquery.lang.Prompter;
import gnu.xquery.lang.XQParser;
import gnu.xquery.util.IsEmptySequence;
import gnu.xquery.util.ItemAt;
import gnu.xquery.util.NumberValue;
import gnu.xquery.util.StringValue;
import gnu.xquery.util.SubList;
import gnu.xquery.util.XMLFormat;
import java.io.IOException;
import java.util.Vector;
import kawa.standard.Scheme;
import kawa.standard.set_b;
import kawa.standard.string_append;

public class XQuery
extends Interpreter {
    static boolean charIsInt = false;
    static XQuery instance;
    static int envCounter;
    public static final XMLFormat writeFormat;
    LangPrimType booleanType;

    public static Numeric asNumber(Object object2) {
        if (object2 instanceof Char) {
            return IntNum.make(((Char)object2).intValue());
        }
        return (Numeric)object2;
    }

    public static char asChar(Object object2) {
        if (object2 instanceof Char) {
            return ((Char)object2).charValue();
        }
        int n = object2 instanceof Numeric ? ((Numeric)object2).intValue() : -1;
        if (n < 0 || n > 65535) {
            throw new ClassCastException("not a character value");
        }
        return (char)n;
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        return new XQParser(inPort, sourceMessages);
    }

    public ModuleExp parse(Environment environment, Lexer lexer) throws IOException, SyntaxException {
        Compilation.usingTailCalls = true;
        SourceMessages sourceMessages = lexer.getMessages();
        Parser parser = new Parser(sourceMessages);
        ModuleExp moduleExp = new ModuleExp();
        parser.push(moduleExp);
        parser.mustCompileHere();
        parser.immediate = true;
        lexer.clearErrors();
        Expression expression = ((XQParser)lexer).parse(parser);
        if (expression == null) {
            return null;
        }
        moduleExp.body = expression;
        parser.pop(moduleExp);
        return moduleExp;
    }

    public ModuleExp parseFile(InPort inPort, SourceMessages sourceMessages) {
        Compilation.usingTailCalls = true;
        Parser parser = new Parser(sourceMessages);
        ModuleExp moduleExp = new ModuleExp();
        moduleExp.setFile(inPort.getName());
        Vector vector = new Vector(20);
        parser.push(moduleExp);
        try {
            Expression expression;
            XQParser xQParser = (XQParser)this.getLexer(inPort, sourceMessages);
            xQParser.nesting = 1;
            Vector<Expression> vector2 = new Vector<Expression>(10);
            while ((expression = xQParser.parse(parser)) != null) {
                vector2.addElement(expression);
            }
            int n = vector2.size();
            if (n == 0) {
                moduleExp.body = QuoteExp.voidExp;
            } else if (n == 1) {
                moduleExp.body = (Expression)vector2.elementAt(0);
            } else {
                Object[] objectArray = new Expression[n];
                vector2.copyInto(objectArray);
                moduleExp.body = new BeginExp((Expression[])objectArray);
            }
        }
        catch (SyntaxException syntaxException) {
            if (syntaxException.getMessages() != sourceMessages) {
                throw new RuntimeException("confussing syntax error: " + syntaxException);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("I/O exception reading file: " + iOException.toString());
        }
        parser.pop(moduleExp);
        return moduleExp;
    }

    public int getNamespaceOf(Declaration declaration) {
        return declaration.isProcedureDecl() ? 2 : 1;
    }

    public String getName() {
        return "XQuery";
    }

    public XQuery() {
        Environment environment = Scheme.builtin();
        this.environ = new Environment(environment);
        this.environ.setName("interaction-environment." + ++envCounter);
        Environment.setCurrent(this.environ);
        ModuleBody.setMainPrintValues(true);
        if (instance == null) {
            instance = this;
        }
        try {
            this.loadClass("kawa.lib.std_syntax");
            this.loadClass("kawa.lib.lists");
            this.loadClass("kawa.lib.strings");
            this.loadClass("gnu.commonlisp.lisp.PrimOps");
            this.loadClass("gnu.kawa.servlet.HTTP");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.define("define", new set_b());
        this.define("document", Document.document);
        this.define("unescaped-data", MakeUnescapedData.unescapedData);
        this.define("item-at", ItemAt.itemAt);
        this.define("count", CountValues.countValues);
        this.define("sublist", SubList.subList);
        this.define("empty", IsEmptySequence.isEmptySequence);
        this.define("false", new ConstantFunction0("false", Boolean.FALSE));
        this.define("true", new ConstantFunction0("true", Boolean.TRUE));
        this.define("number", NumberValue.numberValue);
        this.define("string-value", StringValue.stringValue);
        this.define("string", StringValue.string);
        this.define("concat", new string_append());
        this.define("write-to", WriteTo.writeTo);
    }

    public static XQuery getInstance() {
        if (instance == null) {
            Environment environment = Environment.getCurrent();
            try {
                instance = new XQuery();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                Environment.setCurrent(environment);
                throw throwable;
            }
            Environment.setCurrent(environment);
            {
            }
        }
        return instance;
    }

    public static void registerEnvironment() {
        Interpreter.defaultInterpreter = new XQuery();
    }

    public Object read(InPort inPort) throws IOException, SyntaxException {
        return XQParser.readObject(inPort);
    }

    public FormatToConsumer getFormat(boolean bl) {
        return writeFormat;
    }

    public Consumer getOutputConsumer(OutPort outPort) {
        return new XMLPrinter(outPort, false);
    }

    public Type getTypeFor(String string) {
        if (string == "t") {
            string = "java.lang.Object";
        }
        return Scheme.string2Type(string);
    }

    public Type getTypeFor(Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new LangPrimType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(string);
        }
        return Type.make(clazz);
    }

    public Procedure getPrompter() {
        return new Prompter();
    }

    static {
        envCounter = 0;
        writeFormat = new XMLFormat();
    }
}

