/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.LineBufferedReader;
import gnu.text.SourceError;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;

public class Lexer
extends Reader {
    protected LineBufferedReader port;
    protected boolean interactive;
    SourceMessages messages = null;
    public char[] tokenBuffer = new char[100];
    public int tokenBufferLength = 0;

    public Lexer(LineBufferedReader lineBufferedReader) {
        this.port = lineBufferedReader;
    }

    public Lexer(LineBufferedReader lineBufferedReader, SourceMessages sourceMessages) {
        this.port = lineBufferedReader;
        this.messages = sourceMessages;
    }

    public final LineBufferedReader getPort() {
        return this.port;
    }

    public void close() throws IOException {
        this.port.close();
    }

    public int read() throws IOException {
        return this.port.read();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.port.read(cArray, n, n2);
    }

    public void unread(int n) throws IOException {
        if (n >= 0) {
            this.port.unread();
        }
    }

    public int peek() throws IOException {
        return this.port.peek();
    }

    public void skip() throws IOException {
        this.port.skip();
    }

    protected void unread() throws IOException {
        this.port.unread();
    }

    protected void unread_quick() throws IOException {
        this.port.unread_quick();
    }

    protected void skip_quick() throws IOException {
        this.port.skip_quick();
    }

    public SourceMessages getMessages() {
        return this.messages;
    }

    public void setMessages(SourceMessages sourceMessages) {
        this.messages = sourceMessages;
    }

    public boolean checkErrors(PrintWriter printWriter, int n) {
        return this.messages != null && this.messages.checkErrors(printWriter, n);
    }

    public SourceError getErrors() {
        return this.messages == null ? null : this.messages.getErrors();
    }

    public boolean seenErrors() {
        return this.messages != null && this.messages.seenErrors();
    }

    public void clearErrors() {
        if (this.messages != null) {
            this.messages.clearErrors();
        }
    }

    public void error(char c, String string, int n, int n2, String string2) {
        if (this.messages == null) {
            this.messages = new SourceMessages();
        }
        this.messages.error(c, string, n, n2, string2);
    }

    public void error(char c, String string) {
        int n = this.port.getLineNumber();
        int n2 = this.port.getColumnNumber();
        this.error(c, this.port.getName(), n + 1, n2 >= 0 ? n2 + 1 : 0, string);
    }

    public void error(String string) {
        this.error('e', string);
    }

    public void fatal(String string) throws SyntaxException {
        this.error('f', string);
        throw new SyntaxException(this.messages);
    }

    public void eofError(String string) throws SyntaxException {
        this.fatal(string);
    }

    public void eofError(String string, int n, int n2) throws SyntaxException {
        this.error('f', this.port.getName(), n, n2, string);
        throw new SyntaxException(this.messages);
    }

    public int readOptionalExponent() throws IOException {
        int n;
        int n2;
        int n3 = this.read();
        boolean bl = false;
        boolean bl2 = false;
        if (n3 == 43 || n3 == 45) {
            n2 = this.read();
        } else {
            n2 = n3;
            n3 = 0;
        }
        if (n2 < 0 || (n = Character.digit((char)n2, 10)) < 0) {
            if (n3 != 0) {
                this.error("exponent sign not followed by digit");
            }
            n = 1;
        } else {
            int n4;
            int n5 = 0xCCCCCCB;
            while ((n4 = Character.digit((char)(n2 = this.read()), 10)) >= 0) {
                if (n > n5) {
                    bl2 = true;
                }
                n = 10 * n + n4;
            }
        }
        if (n2 >= 0) {
            this.unread(n2);
        }
        if (n3 == 45) {
            n = -n;
        }
        if (bl2) {
            return n3 == 45 ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        return n;
    }

    public static long readDigitsInBuffer(LineBufferedReader lineBufferedReader, int n) {
        char c;
        int n2;
        long l = 0L;
        boolean bl = false;
        long l2 = Long.MAX_VALUE / (long)n;
        int n3 = lineBufferedReader.pos;
        if (n3 >= lineBufferedReader.limit) {
            return 0L;
        }
        while ((n2 = Character.digit(c = lineBufferedReader.buffer[n3], n)) >= 0) {
            if (l > l2) {
                bl = true;
            } else {
                l = l * (long)n + (long)n2;
            }
            if (l < 0L) {
                bl = true;
            }
            if (++n3 < lineBufferedReader.limit) continue;
        }
        lineBufferedReader.pos = n3;
        return bl ? -1L : l;
    }

    public String getName() {
        return this.port.getName();
    }

    public int getLineNumber() {
        return this.port.getLineNumber();
    }

    public int getColumnNumber() {
        return this.port.getColumnNumber();
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    public void tokenBufferAppend(int n) {
        if (n > 65536) {
            // empty if block
        }
        int n2 = this.tokenBufferLength;
        char[] cArray = this.tokenBuffer;
        if (n2 == this.tokenBuffer.length) {
            this.tokenBuffer = new char[2 * n2];
            System.arraycopy(cArray, 0, this.tokenBuffer, 0, n2);
            cArray = this.tokenBuffer;
        }
        cArray[n2] = (char)n;
        this.tokenBufferLength = n2 + 1;
    }
}

