/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.GroupPredicate;
import gnu.lists.PositionConsumer;
import gnu.lists.PositionContainer;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import gnu.lists.TreePosition;
import java.io.PrintWriter;

public class TreeList
extends AbstractSequence
implements Consumer,
PositionConsumer,
Consumable {
    public Object[] objects;
    static final Object availObject = new String("(AVAIL)");
    public char[] data;
    public int gapStart;
    public int gapEnd;
    public int attrStart;
    public int docStart;
    static final int MAX_CHAR_SHORT = 40959;
    static final int MIN_INT_SHORT = -4096;
    static final int MAX_INT_SHORT = 8191;
    static final int INT_SHORT_ZERO = 49152;
    static final int OBJECT_REF_SHORT = 57344;
    static final int OBJECT_REF_SHORT_INDEX_MAX = 4095;
    static final char OBJECT_REF_FOLLOWS = '\uf10d';
    static final char POSITION_REF_FOLLOWS = '\uf10e';
    static final char POSITION_TRIPLE_FOLLOWS = '\uf10f';
    static final int BYTE_PREFIX = 61440;
    static final char BOOL_FALSE = '\uf100';
    static final char BOOL_TRUE = '\uf101';
    static final int INT_FOLLOWS = 61698;
    static final int LONG_FOLLOWS = 61699;
    static final int FLOAT_FOLLOWS = 61700;
    static final int DOUBLE_FOLLOWS = 61701;
    static final int CHAR_FOLLOWS = 61702;
    static final int CHAR_PAIR_FOLLOWS = 61703;
    static final int BEGIN_ATTRIBUTE_LONG = 61705;
    static final int END_ATTRIBUTE = 61706;
    static final int BEGIN_DOCUMENT = 61712;
    static final int END_DOCUMENT = 61713;
    static final int BEGIN_GROUP_SHORT = 40960;
    static final int BEGIN_GROUP_SHORT_INDEX_MAX = 4095;
    static final int END_GROUP_SHORT = 61707;
    static final int BEGIN_GROUP_LONG = 61704;
    static final int END_GROUP_LONG = 61708;
    int currentBeginGroup = 0;

    public TreeList() {
        this.resizeObjects();
        this.gapEnd = 200;
        this.data = new char[this.gapEnd];
    }

    public TreeList(TreeList treeList, int n, int n2) {
        this();
        treeList.consumeRange(n, n2, this);
    }

    public TreeList(TreeList treeList) {
        this(treeList, 0, treeList.data.length);
    }

    public void clear() {
        this.gapStart = 0;
        this.gapEnd = this.data.length;
        this.attrStart = 0;
        if (this.gapEnd > 1500) {
            this.gapEnd = 200;
            this.data = new char[this.gapEnd];
        }
        this.objects = null;
        this.resizeObjects();
    }

    public void ensureSpace(int n) {
        int n2 = this.gapEnd - this.gapStart;
        if (n > n2) {
            int n3;
            int n4 = this.data.length;
            int n5 = 2 * n4;
            int n6 = n4 - n2 + n;
            if (n5 < n6) {
                n5 = n6;
            }
            char[] cArray = new char[n5];
            if (this.gapStart > 0) {
                System.arraycopy(this.data, 0, cArray, 0, this.gapStart);
            }
            if ((n3 = n4 - this.gapEnd) > 0) {
                System.arraycopy(this.data, this.gapEnd, cArray, n5 - n3, n3);
            }
            this.gapEnd = n5 - n3;
            this.data = cArray;
        }
    }

    public final void resizeObjects() {
        Object[] objectArray;
        int n;
        int n2;
        if (this.objects == null) {
            n2 = 0;
            n = 100;
            objectArray = new Object[n];
        } else {
            n2 = this.objects.length;
            n = 2 * n2;
            objectArray = new Object[n];
            System.arraycopy(this.objects, 0, objectArray, 0, n2);
        }
        Object object2 = availObject;
        int n3 = n2;
        while (n3 < n) {
            objectArray[n3] = object2;
            ++n3;
        }
        this.objects = objectArray;
    }

    protected int find(Object object2) {
        int n = 0;
        int n2 = this.objects.length;
        Object object3 = availObject;
        int n3 = -1;
        while (n < n2) {
            Object object4 = this.objects[n];
            if (object4 == object2) {
                return n;
            }
            if (object4 == object3 && n3 < 0) {
                n3 = n;
            }
            ++n;
        }
        if (n3 >= 0) {
            this.objects[n3] = object2;
            return n3;
        }
        this.resizeObjects();
        this.objects[n2] = object2;
        return n2;
    }

    protected int find(Object object2, Object object3) {
        int n = 0;
        int n2 = this.objects.length;
        Object object4 = availObject;
        int n3 = -1;
        Object[] objectArray = this.objects;
        while (n + 1 < n2) {
            Object object5 = objectArray[n];
            if (object5 == object2 && objectArray[n + 1] == object3) {
                return n;
            }
            if (n3 < 0 && object5 == object4 && objectArray[n + 1] == object4) {
                n3 = n;
            }
            ++n;
        }
        if (n3 >= 0) {
            objectArray[n3] = object2;
            objectArray[n3 + 1] = object3;
            return n3;
        }
        this.resizeObjects();
        objectArray = this.objects;
        objectArray[n2] = object2;
        objectArray[n2 + 1] = object3;
        return n2;
    }

    protected final int getIntN(int n) {
        return this.data[n] << 16 | this.data[n + 1];
    }

    protected final long getLongN(int n) {
        char[] cArray = this.data;
        return cArray[n] << 48 | cArray[n + 1] << 32 | cArray[n + 2] << 16 | cArray[n + 3];
    }

    public final void setIntN(int n, int n2) {
        this.data[n] = (char)(n2 >> 16);
        this.data[n + 1] = (char)n2;
    }

    public boolean consume(TreePosition treePosition) {
        this.ensureSpace(3);
        int n = this.find(new TreePosition(treePosition));
        this.data[this.gapStart++] = 61710;
        this.setIntN(this.gapStart, n);
        this.gapStart += 2;
        return true;
    }

    public boolean writePosition(AbstractSequence abstractSequence, int n, Object object2) {
        this.ensureSpace(7);
        this.data[this.gapStart] = 61711;
        int n2 = this.find(abstractSequence);
        int n3 = object2 == null ? -1 : this.find(object2);
        this.setIntN(this.gapStart + 1, n2);
        this.setIntN(this.gapStart + 3, n);
        this.setIntN(this.gapStart + 5, n3);
        this.gapStart += 7;
        return true;
    }

    public void writeObject(Object object2) {
        if (object2 instanceof SeqPosition) {
            SeqPosition seqPosition = (SeqPosition)object2;
            this.writePosition(seqPosition.sequence, seqPosition.ipos, seqPosition.xpos);
            return;
        }
        this.ensureSpace(3);
        int n = this.find(object2);
        if (n < 4096) {
            this.data[this.gapStart++] = (char)(0xE000 | n);
        } else {
            this.data[this.gapStart++] = 61709;
            this.setIntN(this.gapStart, n);
            this.gapStart += 2;
        }
    }

    public void beginGroup(String string, Object object2) {
        this.beginGroup(this.find(string, object2));
    }

    public void beginDocument() {
        this.ensureSpace(4);
        --this.gapEnd;
        this.data[this.gapStart++] = 61712;
        if (this.docStart != 0) {
            throw new Error("nested document");
        }
        this.docStart = this.gapStart;
        this.setIntN(this.gapStart, this.gapEnd - this.data.length);
        this.gapStart += 2;
        this.data[this.gapEnd] = 61713;
    }

    public void endDocument() {
        if (this.data[this.gapEnd] != '\uf111' || this.docStart <= 0) {
            throw new Error("unexpected endDocument");
        }
        ++this.gapEnd;
        this.setIntN(this.docStart, this.gapStart - this.docStart + 1);
        this.docStart = 0;
        this.data[this.gapStart++] = 61713;
    }

    public void beginGroup(int n) {
        this.ensureSpace(10);
        this.gapEnd -= 7;
        this.data[this.gapStart++] = 61704;
        this.setIntN(this.gapStart, this.gapEnd - this.data.length);
        this.gapStart += 2;
        this.data[this.gapEnd] = 61708;
        this.setIntN(this.gapEnd + 1, n);
        this.setIntN(this.gapEnd + 3, this.gapStart - 3);
        this.setIntN(this.gapEnd + 5, this.currentBeginGroup);
        this.currentBeginGroup = this.gapStart - 3;
    }

    public void endGroup(String string) {
        if (this.data[this.gapEnd] != '\uf10c') {
            throw new Error("unexpected endGroup " + string);
        }
        int n = this.getIntN(this.gapEnd + 1);
        int n2 = this.getIntN(this.gapEnd + 3);
        int n3 = this.getIntN(this.gapEnd + 5);
        this.gapEnd += 7;
        int n4 = this.gapStart - n2;
        int n5 = n2 - n3;
        if (n < 4095 && n4 < 65536 && n5 < 65536) {
            this.data[n2] = (char)(0xA000 | n);
            this.data[n2 + 1] = (char)n4;
            this.data[n2 + 2] = (char)n5;
            this.data[this.gapStart] = 61707;
            this.data[this.gapStart + 1] = (char)n4;
            this.gapStart += 2;
        } else {
            this.data[n2] = 61704;
            this.setIntN(n2 + 1, n4);
            this.data[this.gapStart] = 61708;
            this.setIntN(this.gapStart + 1, n);
            this.setIntN(this.gapStart + 3, -n4);
            if (n3 >= this.gapStart || n2 <= this.gapStart) {
                n3 -= this.gapStart;
            }
            this.setIntN(this.gapStart + 5, n3);
            this.gapStart += 7;
        }
        this.currentBeginGroup = n3;
    }

    public void beginAttribute(String string, Object object2) {
        this.beginAttribute(this.find(string, object2));
    }

    public void beginAttribute(int n) {
        this.ensureSpace(6);
        --this.gapEnd;
        this.data[this.gapStart++] = 61705;
        if (this.attrStart != 0) {
            throw new Error("nested attribute");
        }
        this.attrStart = this.gapStart;
        this.setIntN(this.gapStart, n);
        this.setIntN(this.gapStart + 2, this.gapEnd - this.data.length);
        this.gapStart += 4;
        this.data[this.gapEnd] = 61706;
    }

    public void endAttribute() {
        if (this.data[this.gapEnd] != '\uf10a' || this.attrStart <= 0) {
            throw new Error("unexpected endAttribute");
        }
        ++this.gapEnd;
        this.setIntN(this.attrStart + 2, this.gapStart - this.attrStart + 1);
        this.attrStart = 0;
        this.data[this.gapStart++] = 61706;
    }

    public void writeChar(int n) {
        this.ensureSpace(3);
        if (n <= 40959) {
            this.data[this.gapStart++] = (char)n;
        } else if (n < 65536) {
            this.data[this.gapStart++] = 61702;
            this.data[this.gapStart++] = (char)n;
        } else {
            this.data[this.gapStart++] = 61703;
        }
    }

    public void writeBoolean(boolean bl) {
        this.ensureSpace(1);
        this.data[this.gapStart++] = bl ? 61697 : 61696;
    }

    public void writeByte(int n) {
        this.ensureSpace(1);
        this.data[this.gapStart++] = (char)(61440 + (n & 0xFF));
    }

    public void writeInt(int n) {
        this.ensureSpace(3);
        if (n >= -4096 && n <= 8191) {
            this.data[this.gapStart++] = (char)(49152 + n);
        } else {
            this.data[this.gapStart++] = 61698;
            this.setIntN(this.gapStart, n);
            this.gapStart += 2;
        }
    }

    public void writeLong(long l) {
        this.ensureSpace(5);
        this.data[this.gapStart++] = 61699;
        this.data[this.gapStart++] = (char)(l >>> 48);
        this.data[this.gapStart++] = (char)(l >>> 32);
        this.data[this.gapStart++] = (char)(l >>> 16);
        this.data[this.gapStart++] = (char)l;
    }

    public void writeFloat(float f) {
        this.ensureSpace(3);
        int n = Float.floatToIntBits(f);
        this.data[this.gapStart++] = 61700;
        this.data[this.gapStart++] = (char)(n >>> 16);
        this.data[this.gapStart++] = (char)n;
    }

    public void writeDouble(double d) {
        this.ensureSpace(5);
        long l = Double.doubleToLongBits(d);
        this.data[this.gapStart++] = 61701;
        this.data[this.gapStart++] = (char)(l >>> 48);
        this.data[this.gapStart++] = (char)(l >>> 32);
        this.data[this.gapStart++] = (char)(l >>> 16);
        this.data[this.gapStart++] = (char)l;
    }

    public boolean ignoring() {
        return false;
    }

    public void writeChars(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.writeChar(string.charAt(n2));
            ++n2;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        this.ensureSpace(n2);
        while (n2 > 0) {
            char c = cArray[n++];
            --n2;
            if (c <= '\u9fff') {
                this.data[this.gapStart++] = c;
                continue;
            }
            this.writeChar(c);
            this.ensureSpace(n2);
        }
    }

    public boolean isEmpty() {
        int n = this.gapStart == 0 ? this.gapEnd : 0;
        return n == this.data.length;
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while ((n2 = this.nextDataIndex(n2)) >= 0) {
            ++n;
        }
        return n;
    }

    protected void makePosition(int n, boolean bl, PositionContainer positionContainer, int n2) {
        int n3 = 0;
        while (--n >= 0) {
            if ((n3 = this.nextDataIndex(n3)) >= 0) continue;
            throw new IndexOutOfBoundsException();
        }
        positionContainer.setPosition(n2, n3 << 1 | (bl ? 1 : 0), null);
        positionContainer.setSequence(n2, this);
    }

    public boolean gotoChildrenStart(TreePosition treePosition) {
        int n = this.gotoChildrenStart(treePosition.ipos >> 1);
        if (n < 0) {
            return false;
        }
        treePosition.push(this, n << 1, null);
        return true;
    }

    public int gotoChildrenStart(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n == this.data.length) {
            return -1;
        }
        char c = this.data[n];
        if (c >= '\ua000' && c <= '\uafff' || c == '\uf108') {
            n += 3;
        } else {
            if (c == '\uf110') {
                return n + 3;
            }
            return -1;
        }
        while (true) {
            if (n >= this.gapStart) {
                n += this.gapEnd - this.gapStart;
            }
            if ((c = this.data[n]) == '\uf109') {
                int n2;
                n = n2 + ((n2 = this.getIntN(n + 3)) < 0 ? this.data.length : n);
                continue;
            }
            if (c != '\uf10a') break;
            ++n;
        }
        return n;
    }

    public boolean gotoAttributesStart(TreePosition treePosition) {
        int n = this.gotoAttributesStart(treePosition.ipos >> 1);
        if (n < 0) {
            return false;
        }
        treePosition.push(this, n << 1, null);
        return true;
    }

    public int gotoAttributesStart(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n == this.data.length) {
            return -1;
        }
        char c = this.data[n];
        if (c >= '\ua000' && c <= '\uafff' || c == '\uf108') {
            return n + 3;
        }
        return -1;
    }

    public Object get(int n) {
        int n2 = 0;
        while (--n >= 0) {
            if ((n2 = this.nextDataIndex(n2)) >= 0) continue;
            throw new IndexOutOfBoundsException();
        }
        return this.getNext(n2 << 1, null);
    }

    public boolean consumeNext(int n, Object object2, Consumer consumer) {
        if (!this.hasNext(n, object2)) {
            return false;
        }
        int n2 = n >> 1;
        int n3 = this.nextDataIndex(n2);
        if (n3 >= 0) {
            this.consumeRange(n2, n3, consumer);
        }
        return true;
    }

    public int consumeRange(int n, int n2, Consumer consumer) {
        int n3;
        block29: {
            char c;
            int n4;
            n3 = n;
            int n5 = n4 = n <= this.gapStart && n2 > this.gapStart ? this.gapStart : n2;
            block19: while (true) {
                int n6;
                int n7;
                if (n3 >= n4) {
                    if (n3 != this.gapStart || n2 <= this.gapEnd) break block29;
                    n3 = this.gapEnd;
                    n4 = n2;
                }
                if ((c = this.data[n3++]) <= '\u9fff') {
                    int n8 = n3 - 1;
                    n7 = n4;
                    while (n3 < n7) {
                        if ((c = this.data[n3++]) <= '\u9fff') continue;
                        --n3;
                        break;
                    }
                    consumer.write(this.data, n8, n3 - n8);
                    continue;
                }
                if (c >= '\ue000' && c <= '\uefff') {
                    consumer.writeObject(this.objects[c - 57344]);
                    continue;
                }
                if (c >= '\ua000' && c <= '\uafff') {
                    n6 = c - 40960;
                    consumer.beginGroup(this.objects[n6].toString(), this.objects[n6 + 1]);
                    n3 += 2;
                    continue;
                }
                if (c >= '\ub000' && c <= '\udfff') {
                    consumer.writeInt(c - 49152);
                    continue;
                }
                switch (c) {
                    case '\uf110': {
                        consumer.beginDocument();
                        n3 += 2;
                        continue block19;
                    }
                    case '\uf111': {
                        consumer.endDocument();
                        continue block19;
                    }
                    case '\uf100': 
                    case '\uf101': {
                        consumer.writeBoolean(c != '\uf100');
                        continue block19;
                    }
                    case '\uf106': {
                        consumer.write(this.data, n3, '\u0001' + c - 61702);
                        ++n3;
                        continue block19;
                    }
                    case '\uf107': {
                        consumer.write(this.data, n3, '\u0001' + c - 61702);
                        n3 += 2;
                        continue block19;
                    }
                    case '\uf10f': {
                        Object object2;
                        AbstractSequence abstractSequence = (AbstractSequence)this.objects[this.getIntN(n3)];
                        n7 = this.getIntN(n3 + 2);
                        int n9 = this.getIntN(n3 + 4);
                        Object object3 = object2 = n9 < 0 ? null : this.objects[n9];
                        if (consumer instanceof PositionConsumer) {
                            ((PositionConsumer)((Object)consumer)).writePosition(abstractSequence, n7, object2);
                        } else {
                            consumer.writeObject(SeqPosition.make(abstractSequence, n7, object2));
                        }
                        n3 += 6;
                        continue block19;
                    }
                    case '\uf10e': {
                        if (consumer instanceof PositionConsumer) {
                            ((PositionConsumer)((Object)consumer)).consume((TreePosition)this.objects[this.getIntN(n3)]);
                            n3 += 2;
                            continue block19;
                        }
                    }
                    case '\uf10d': {
                        consumer.writeObject(this.objects[this.getIntN(n3)]);
                        n3 += 2;
                        continue block19;
                    }
                    case '\uf10b': {
                        n6 = this.data[n3++];
                        n6 = this.data[n3 - 2 - n6] - 40960;
                        consumer.endGroup(this.objects[n6].toString());
                        continue block19;
                    }
                    case '\uf108': {
                        n6 = this.getIntN(n3);
                        n6 += n6 >= 0 ? n3 - 1 : this.data.length;
                        n3 += 2;
                        n6 = this.getIntN(n6 + 1);
                        consumer.beginGroup(this.objects[n6].toString(), this.objects[n6 + 1]);
                        continue block19;
                    }
                    case '\uf10c': {
                        n6 = this.getIntN(n3);
                        consumer.endGroup(this.objects[n6].toString());
                        n3 += 6;
                        continue block19;
                    }
                    case '\uf109': {
                        n6 = this.getIntN(n3);
                        consumer.beginAttribute(this.objects[n6].toString(), this.objects[n6 + 1]);
                        n3 += 4;
                        continue block19;
                    }
                    case '\uf10a': {
                        consumer.endAttribute();
                        continue block19;
                    }
                    case '\uf102': {
                        this.writeInt(this.getIntN(n3));
                        n3 += 2;
                        continue block19;
                    }
                    case '\uf104': {
                        this.writeFloat(Float.intBitsToFloat(this.getIntN(n3)));
                        n3 += 2;
                        continue block19;
                    }
                    case '\uf103': {
                        this.writeLong(this.getLongN(n3));
                        n3 += 4;
                        continue block19;
                    }
                    case '\uf105': {
                        this.writeDouble(Double.longBitsToDouble(this.getLongN(n3)));
                        n3 += 4;
                        continue block19;
                    }
                }
                break;
            }
            this.dump();
            throw new Error("unknown code:" + c);
        }
        return n3;
    }

    public boolean hasNext(int n, Object object2) {
        int n2 = n >>> 1;
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        if (n2 == this.data.length) {
            return false;
        }
        char c = this.data[n2];
        return c != '\uf10a' && c != '\uf10b' && c != '\uf10c';
    }

    public int getNextKind(int n, Object object2) {
        int n2 = n >>> 1;
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        if (n2 == this.data.length) {
            return 0;
        }
        char c = this.data[n2];
        if (c <= '\u9fff') {
            return 29;
        }
        if (c >= '\ue000' && c <= '\uefff') {
            return 32;
        }
        if (c >= '\ua000' && c <= '\uafff') {
            return 33;
        }
        if ((c & 0xFF00) == 61440) {
            return 28;
        }
        if (c >= '\ub000' && c <= '\udfff') {
            return 22;
        }
        switch (c) {
            case '\uf100': 
            case '\uf101': {
                return 27;
            }
            case '\uf102': {
                return 22;
            }
            case '\uf103': {
                return 24;
            }
            case '\uf104': {
                return 25;
            }
            case '\uf105': {
                return 26;
            }
            case '\uf106': 
            case '\uf107': {
                return 29;
            }
            case '\uf110': {
                return 34;
            }
            case '\uf108': {
                return 33;
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': 
            case '\uf111': {
                return 0;
            }
            case '\uf109': {
                return 35;
            }
        }
        return 32;
    }

    protected int getNextTypeIndex(int n, Object object2) {
        int n2 = n >>> 1;
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        if (n2 == this.data.length) {
            return 0;
        }
        char c = this.data[n2];
        if (c >= '\ua000' && c <= '\uafff') {
            return c - 40960;
        }
        if (c == '\uf108') {
            int n3;
            return this.getIntN((n3 += (n3 = this.getIntN(n2 + 1)) < 0 ? this.data.length : n2) + 1);
        }
        if (c == '\uf109') {
            return this.getIntN(n2 + 1);
        }
        return -1;
    }

    public String getNextTypeName(int n, Object object2) {
        int n2 = this.getNextTypeIndex(n, object2);
        return n2 < 0 ? null : (String)this.objects[n2];
    }

    public Object getNextTypeObject(int n, Object object2) {
        int n2 = this.getNextTypeIndex(n, object2);
        return n2 < 0 ? null : this.objects[n2 + 1];
    }

    public Object getNext(int n, Object object2) {
        int n2 = n >>> 1;
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        if (n2 == this.data.length) {
            return Sequence.eofValue;
        }
        char c = this.data[n2];
        if (c <= '\u9fff') {
            return Convert.toObject(c);
        }
        if (c >= '\ue000' && c <= '\uefff') {
            return this.objects[c - 57344];
        }
        if (c >= '\ua000' && c <= '\uafff') {
            return new TreeList(this, n2, n2 + this.data[n2 + 1] + 2);
        }
        if (c >= '\ub000' && c <= '\udfff') {
            return Convert.toObject(c - 49152);
        }
        switch (c) {
            case '\uf110': {
                int n3 = this.getIntN(n2 + 1);
                n3 += n3 < 0 ? this.data.length : n2;
                return new TreeList(this, n2, ++n3);
            }
            case '\uf100': 
            case '\uf101': {
                return Convert.toObject(c != '\uf100');
            }
            case '\uf102': {
                return Convert.toObject(this.getIntN(n2 + 1));
            }
            case '\uf103': {
                return Convert.toObject(this.getLongN(n2 + 1));
            }
            case '\uf104': {
                return Convert.toObject(Float.intBitsToFloat(this.getIntN(n2 + 1)));
            }
            case '\uf105': {
                return Convert.toObject(Double.longBitsToDouble(this.getLongN(n2 + 1)));
            }
            case '\uf106': {
                return Convert.toObject(this.data[n2 + 1]);
            }
            case '\uf109': {
                int n4 = this.getIntN(n2 + 3);
                return new TreeList(this, n2, (n4 += n4 < 0 ? this.data.length : n2) + 1);
            }
            case '\uf108': {
                int n5 = this.getIntN(n2 + 1);
                return new TreeList(this, n2, (n5 += n5 < 0 ? this.data.length : n2) + 7);
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': 
            case '\uf111': {
                return Sequence.eofValue;
            }
            case '\uf10d': 
            case '\uf10e': {
                return this.objects[this.getIntN(n2 + 1)];
            }
            case '\uf10f': {
                AbstractSequence abstractSequence = (AbstractSequence)this.objects[this.getIntN(n2 + 1)];
                n = this.getIntN(n2 + 3);
                int n6 = this.getIntN(n2 + 5);
                object2 = n6 < 0 ? null : this.objects[n6];
                return SeqPosition.make(abstractSequence, n, object2);
            }
        }
        throw this.unsupported("getNext, code=" + Integer.toHexString(c));
    }

    public int stringValue(int n, StringBuffer stringBuffer) {
        return this.stringValue(false, n, stringBuffer);
    }

    public int stringValue(boolean bl, int n, StringBuffer stringBuffer) {
        Object object2 = null;
        int n2 = 0;
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n == this.data.length) {
            return -1;
        }
        char c = this.data[n];
        ++n;
        if (c <= '\u9fff') {
            stringBuffer.append(c);
            return n;
        }
        if (c >= '\ue000' && c <= '\uefff') {
            object2 = this.objects[c - 57344];
        } else if (c >= '\ua000' && c <= '\uafff') {
            n2 = n + 2;
            n = this.data[n] + n + 1;
        } else {
            if ((c & 0xFF00) == 61440) {
                stringBuffer.append(c & 0xFF);
                return n;
            }
            if (c >= '\ub000' && c <= '\udfff') {
                stringBuffer.append(c - 49152);
                return n;
            }
            switch (c) {
                case '\uf100': 
                case '\uf101': {
                    stringBuffer.append(c != '\uf100');
                    return n;
                }
                case '\uf102': {
                    stringBuffer.append(this.getIntN(n));
                    return n + 2;
                }
                case '\uf103': {
                    stringBuffer.append(this.getLongN(n));
                    return n + 4;
                }
                case '\uf104': {
                    stringBuffer.append(Float.intBitsToFloat(this.getIntN(n)));
                    return n + 2;
                }
                case '\uf105': {
                    stringBuffer.append(Double.longBitsToDouble(this.getLongN(n)));
                    return n + 4;
                }
                case '\uf106': {
                    stringBuffer.append(this.data[n]);
                    return n + 1;
                }
                case '\uf110': {
                    n2 = n + 2;
                    int n3 = this.getIntN(n);
                    n = n3 + (n3 < 0 ? this.data.length + 1 : n);
                    break;
                }
                case '\uf108': {
                    n2 = n + 2;
                    int n3 = this.getIntN(n);
                    n = (n3 += n3 < 0 ? this.data.length : n - 1) + 7;
                    break;
                }
                case '\uf10a': 
                case '\uf10b': 
                case '\uf10c': 
                case '\uf111': {
                    return -1;
                }
                case '\uf109': {
                    int n4;
                    if (!bl) {
                        n2 = n + 4;
                    }
                    n = n4 + ((n4 = this.getIntN(n + 2)) < 0 ? this.data.length + 1 : n);
                    break;
                }
                case '\uf10f': {
                    AbstractSequence abstractSequence = (AbstractSequence)this.objects[this.getIntN(n)];
                    int n5 = this.getIntN(n + 2);
                    ((TreeList)abstractSequence).stringValue(bl, n5 >> 1, stringBuffer);
                    n += 6;
                    break;
                }
                default: {
                    throw new Error("unimplemented: " + Integer.toHexString(c) + " at:" + n);
                }
            }
        }
        if (object2 != null) {
            stringBuffer.append(object2);
        }
        if (n2 > 0) {
            while ((n2 = this.stringValue(true, n2, stringBuffer)) >= 0) {
            }
        }
        return n;
    }

    protected void makeRelativePosition(int n, Object object2, int n2, boolean bl, PositionContainer positionContainer, int n3) {
        if (n2 < 0) {
            throw this.unsupported("backwards makeRelativePostion");
        }
        int n4 = n >>> 1;
        while (--n2 >= 0) {
            if ((n4 = this.nextDataIndex(n4)) >= 0) continue;
            throw new IndexOutOfBoundsException();
        }
        positionContainer.setPosition(n3, n4 << 1 | (bl ? 1 : 0), null);
    }

    public final int nextMatchingChild(int n, GroupPredicate groupPredicate, int n2) {
        int n3 = n;
        if (n2 == -1) {
            n2 = this.data.length;
        }
        block9: while (true) {
            int n4;
            char c;
            if (n == this.gapStart) {
                n = this.gapEnd;
            }
            if (n >= n2) {
                return -1;
            }
            if ((c = this.data[n++]) <= '\u9fff' || c >= '\ue000' && c <= '\uefff' || c >= '\ub000' && c <= '\udfff') continue;
            switch (c) {
                case '\uf100': 
                case '\uf101': 
                case '\uf110': {
                    continue block9;
                }
                case '\uf102': 
                case '\uf107': 
                case '\uf10d': 
                case '\uf10e': {
                    n += 2;
                    continue block9;
                }
                case '\uf106': 
                case '\uf10b': {
                    ++n;
                    continue block9;
                }
                case '\uf10c': 
                case '\uf10f': {
                    n += 6;
                    continue block9;
                }
                case '\uf10a': 
                case '\uf111': {
                    continue block9;
                }
                case '\uf109': {
                    n4 = this.getIntN(n + 2);
                    n = n4 + n4 < 0 ? this.data.length + 1 : n;
                    continue block9;
                }
                case '\uf103': 
                case '\uf105': {
                    n += 4;
                    continue block9;
                }
            }
            if (c >= '\ua000' && c <= '\uafff') {
                n4 = c - 40960;
            } else if (c == '\uf108') {
                n4 = this.getIntN(n);
                n4 = this.getIntN(n4 + n4 < 0 ? this.data.length + 1 : n);
            } else {
                throw new Error("unknown code:" + c);
            }
            if (n == n3 + 1) {
                n += 2;
                continue;
            }
            if (groupPredicate.isInstance(this, n - 1 << 1, null)) {
                return n - 1;
            }
            n += 2;
        }
    }

    public int nextDataIndex(int n) {
        char c;
        if (n == this.gapStart) {
            n = this.gapEnd;
        }
        if (n == this.data.length) {
            return -1;
        }
        if ((c = this.data[n++]) <= '\u9fff' || c >= '\ue000' && c <= '\uefff' || c >= '\ub000' && c <= '\udfff') {
            return n;
        }
        if (c >= '\ua000' && c <= '\uafff') {
            return this.data[n] + n + 1;
        }
        switch (c) {
            case '\uf110': {
                int n2 = this.getIntN(n);
                return (n2 += n2 < 0 ? this.data.length : n - 1) + 1;
            }
            case '\uf100': 
            case '\uf101': {
                return n;
            }
            case '\uf106': {
                return n + 1;
            }
            case '\uf102': 
            case '\uf107': 
            case '\uf10d': 
            case '\uf10e': {
                return n + 2;
            }
            case '\uf10f': {
                return n + 6;
            }
            case '\uf10a': 
            case '\uf10b': 
            case '\uf10c': 
            case '\uf111': {
                return -1;
            }
            case '\uf108': {
                int n3 = this.getIntN(n);
                return (n3 += n3 < 0 ? this.data.length : n - 1) + 7;
            }
            case '\uf109': {
                int n4 = this.getIntN(n + 2);
                return (n4 += n4 < 0 ? this.data.length : n - 1) + 1;
            }
            case '\uf103': 
            case '\uf105': {
                return n + 4;
            }
        }
        throw new Error("unknown code:" + c);
    }

    public void consume(Consumer consumer) {
        this.consumeRange(0, this.data.length, consumer);
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("TreeList @" + System.identityHashCode(this) + " gapStart:" + this.gapStart + " gapEnd:" + this.gapEnd + " length:" + this.data.length);
        int n = 0;
        int n2 = 0;
        while (n2 < this.data.length) {
            if (n2 < this.gapStart || n2 >= this.gapEnd) {
                int n3 = this.data[n2];
                printWriter.print("" + n2 + ": 0x" + Integer.toHexString(n3) + '=' + (short)n3);
                if (--n < 0) {
                    int n4;
                    Object object2;
                    if (n3 <= 40959) {
                        if (n3 >= 32 && n3 < 127) {
                            printWriter.print("='" + (char)n3 + "'");
                        } else if (n3 == 10) {
                            printWriter.print("='\\n'");
                        } else {
                            printWriter.print("='\\u" + Integer.toHexString(n3) + "'");
                        }
                    } else if (n3 >= 57344 && n3 <= 61439) {
                        object2 = this.objects[n3 -= 57344];
                        printWriter.print("=Object#" + n3 + '=' + object2 + ':' + object2.getClass().getName());
                    } else if (n3 >= 40960 && n3 <= 45055) {
                        n4 = this.data[n2 + 1] + n2;
                        printWriter.print("=BEGIN_GROUP_SHORT end:" + n4 + " index#" + (n3 -= 40960) + "=<" + this.objects[n3] + "::" + this.objects[n3 + 1] + '>');
                        n = 2;
                    } else if (n3 >= 45056 && n3 <= 57343) {
                        printWriter.print("= INT_SHORT:" + (n3 - 49152));
                    } else {
                        switch (n3) {
                            case 61698: {
                                n4 = this.getIntN(n2 + 1);
                                printWriter.print("=INT_FOLLOWS value:" + n4);
                                n = 2;
                                break;
                            }
                            case 61699: {
                                long l = this.getLongN(n2 + 1);
                                printWriter.print("=LONG_FOLLOWS value:" + l);
                                n = 4;
                                break;
                            }
                            case 61700: {
                                n4 = this.getIntN(n2 + 1);
                                printWriter.print("=FLOAT_FOLLOWS value:" + Float.intBitsToFloat(n4));
                                n = 2;
                                break;
                            }
                            case 61701: {
                                long l = this.getLongN(n2 + 1);
                                printWriter.print("=DOUBLE_FOLLOWS value:" + Double.longBitsToDouble(l));
                                n = 4;
                                break;
                            }
                            case 61712: {
                                n4 = this.getIntN(n2 + 1);
                                int n5 = n4 < 0 ? this.data.length : n2;
                                printWriter.print("=BEGIN_DOCUMENT end:");
                                printWriter.print(n4 += n5);
                                n = 2;
                                break;
                            }
                            case 61713: {
                                printWriter.print("=END_DOCUMENT");
                                break;
                            }
                            case 61696: {
                                printWriter.print("= false");
                                break;
                            }
                            case 61697: {
                                printWriter.print("= true");
                                break;
                            }
                            case 61702: {
                                printWriter.print("=CHAR_FOLLOWS");
                                n = 1;
                                break;
                            }
                            case 61703: {
                                printWriter.print("=CHAR_PAIR_FOLLOWS");
                                n = 2;
                                break;
                            }
                            case 61709: 
                            case 61710: {
                                n = 2;
                                break;
                            }
                            case 61707: {
                                printWriter.print("=END_GROUP_SHORT begin:");
                                n4 = n2 - this.data[n2 + 1];
                                printWriter.print(n4);
                                n4 = this.data[n4] - 40960;
                                printWriter.print(" -> #");
                                printWriter.print(n4);
                                printWriter.print("=<");
                                printWriter.print(this.objects[n4]);
                                printWriter.print('>');
                                n = 1;
                                break;
                            }
                            case 61704: {
                                n4 = this.getIntN(n2 + 1);
                                int n6 = n4 < 0 ? this.data.length : n2;
                                printWriter.print("=BEGIN_GROUP_LONG end:");
                                printWriter.print(n4 += n6);
                                n4 = this.getIntN(n4 + 1);
                                printWriter.print(" -> #" + n4 + "=<" + this.objects[n4] + "::" + this.objects[n4 + 1] + '>');
                                n = 2;
                                break;
                            }
                            case 61708: {
                                n4 = this.getIntN(n2 + 1);
                                printWriter.print("=END_GROUP_LONG name:" + n4 + "=<" + this.objects[n4] + '>');
                                n4 = this.getIntN(n2 + 3);
                                n4 = n4 < 0 ? n2 + n4 : n4;
                                printWriter.print(" begin:" + n4);
                                n4 = this.getIntN(n2 + 5);
                                n4 = n4 < 0 ? n2 + n4 : n4;
                                printWriter.print(" parent:" + n4);
                                n = 6;
                                break;
                            }
                            case 61705: {
                                n4 = this.getIntN(n2 + 1);
                                printWriter.print("=BEGIN_ATTRIBUTE name:" + n4 + "=" + this.objects[n4]);
                                n4 = this.getIntN(n2 + 3);
                                printWriter.print(" end:" + (n4 += n4 < 0 ? this.data.length : n2));
                                n = 4;
                                break;
                            }
                            case 61706: {
                                printWriter.print("=END_ATTRIBUTE");
                                break;
                            }
                            case 61711: {
                                printWriter.print("=POSITION_TRIPLE_FOLLOWS seq:");
                                n4 = this.getIntN(n2 + 1);
                                printWriter.print(n4);
                                printWriter.print("=@");
                                object2 = this.objects[n4];
                                if (object2 == null) {
                                    printWriter.print("null");
                                } else {
                                    printWriter.print(System.identityHashCode(object2));
                                }
                                printWriter.print(" ipos:");
                                printWriter.print(this.getIntN(n2 + 3));
                                printWriter.print(" xpos:");
                                printWriter.print(this.getIntN(n2 + 5));
                                n = 6;
                            }
                        }
                    }
                }
                printWriter.println();
            }
            ++n2;
        }
    }
}

