/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.PositionContainer;
import gnu.lists.Sequence;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SeqPosition
implements PositionContainer,
Enumeration {
    public AbstractSequence sequence;
    public int ipos;
    public Object xpos;

    public SeqPosition() {
    }

    public SeqPosition(AbstractSequence abstractSequence) {
        this.sequence = abstractSequence;
    }

    public SeqPosition(AbstractSequence abstractSequence, int n, boolean bl) {
        this.sequence = abstractSequence;
        abstractSequence.makePosition(n, bl, this, 0);
    }

    public SeqPosition(AbstractSequence abstractSequence, int n, Object object2) {
        this.sequence = abstractSequence;
        this.ipos = n;
        this.xpos = object2;
    }

    public static SeqPosition make(AbstractSequence abstractSequence, int n, Object object2) {
        SeqPosition seqPosition = new SeqPosition();
        abstractSequence.copyPosition(n, object2, seqPosition, 0);
        return seqPosition;
    }

    public final void gotoStart(AbstractSequence abstractSequence) {
        if (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
        }
        this.sequence = abstractSequence;
        abstractSequence.makeStartPosition(this, 0);
    }

    public final void gotoEnd(AbstractSequence abstractSequence) {
        if (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
        }
        this.sequence = abstractSequence;
        abstractSequence.makeEndPosition(this, 0);
    }

    public boolean hasMoreElements() {
        return this.sequence.hasNext(this.ipos, this.xpos);
    }

    public boolean hasNext() {
        return this.sequence.hasNext(this.ipos, this.xpos);
    }

    public int getNextKind() {
        return this.sequence.getNextKind(this.ipos, this.xpos);
    }

    public String getNextTypeName() {
        return this.sequence.getNextTypeName(this.ipos, this.xpos);
    }

    public Object getNextTypeObject() {
        return this.sequence.getNextTypeObject(this.ipos, this.xpos);
    }

    public boolean hasPrevious() {
        return this.sequence.hasPrevious(this.ipos, this.xpos);
    }

    public Object next() {
        Object object2 = this.sequence.getNext(this.ipos, this.xpos);
        if (object2 == Sequence.eofValue || !this.sequence.gotoNext(this)) {
            throw new NoSuchElementException();
        }
        return object2;
    }

    public final boolean gotoNext() {
        return this.sequence.gotoNext(this);
    }

    public Object previous() {
        Object object2 = this.sequence.getPrevious(this.ipos, this.xpos);
        if (object2 == Sequence.eofValue || !this.sequence.gotoPrevious(this, 0)) {
            throw new NoSuchElementException();
        }
        return object2;
    }

    public Object nextElement() throws NoSuchElementException {
        Object object2 = this.sequence.getNext(this.ipos, this.xpos);
        if (object2 == Sequence.eofValue || !this.sequence.gotoNext(this)) {
            throw new NoSuchElementException();
        }
        return object2;
    }

    public Object getNext() {
        return this.sequence.getNext(this.ipos, this.xpos);
    }

    public Object getPrevious() {
        return this.sequence.getPrevious(this.ipos, this.xpos);
    }

    public final int nextIndex() {
        return this.sequence.nextIndex(this.ipos, this.xpos);
    }

    public final int fromEndIndex() {
        return this.sequence.fromEndIndex(this.ipos, this.xpos);
    }

    public int getContainingSequenceSize() {
        return this.sequence.getContainingSequenceSize(this.ipos, this.xpos);
    }

    public final int previousIndex() {
        return this.sequence.nextIndex(this.ipos, this.xpos) - 1;
    }

    public final boolean isAfter() {
        return this.sequence.isAfter(this.ipos, this.xpos);
    }

    public final void set(Object object2) {
        if (this.sequence.isAfter(this.ipos, this.xpos)) {
            this.sequence.setPrevious(this.ipos, this.xpos, object2);
        } else {
            this.sequence.setNext(this.ipos, this.xpos, object2);
        }
    }

    public void remove() {
        this.sequence.remove(this.ipos, this.xpos, this.isAfter() ? -1 : 1);
    }

    public void add(Object object2) {
        this.sequence.add(this, 0, object2);
    }

    public int getPositionInt(int n) {
        return this.ipos;
    }

    public Object getPositionPtr(int n) {
        return this.xpos;
    }

    public void setPosition(int n, int n2, Object object2) {
        this.ipos = n2;
        this.xpos = object2;
    }

    public void setSequence(int n, AbstractSequence abstractSequence) {
        this.sequence = abstractSequence;
    }

    public int countPositions() {
        return 1;
    }

    public void init(AbstractSequence abstractSequence, int n, boolean bl) {
        if (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
        }
        this.sequence = abstractSequence;
        abstractSequence.makePosition(n, bl, this, 0);
    }

    public void init(SeqPosition seqPosition) {
        if (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
        }
        this.sequence = seqPosition.sequence;
        this.sequence.copyPosition(seqPosition.ipos, seqPosition.xpos, this, 0);
    }

    public void release() {
        if (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
            this.sequence = null;
        }
    }

    public void finalize() {
        this.release();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append('{');
        if (this.sequence == null) {
            stringBuffer.append("null sequence");
        } else {
            stringBuffer.append(this.sequence.getClass().getName());
            stringBuffer.append('@');
            stringBuffer.append(System.identityHashCode(this.sequence));
        }
        stringBuffer.append(" ipos: ");
        stringBuffer.append(this.ipos);
        stringBuffer.append(" xpos: ");
        stringBuffer.append(this.xpos);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

