/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Interpreter;
import gnu.expr.Keyword;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.SlotSet;
import gnu.lists.FString;
import gnu.mapping.Binding;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.WrongType;

public class Invoke
extends ProcedureN
implements CanInline,
Inlineable {
    char kind;
    Interpreter interpreter;
    public static final Invoke invoke = new Invoke("invoke", 'V');
    public static final Invoke invokeStatic = new Invoke("invoke-static", 'S');
    public static final Invoke make = new Invoke("make", 'N');
    private PrimProcedure[] cacheMethods;
    private Expression[] cacheArgs;
    private int cacheDefinitelyApplicableMethodCount;
    private int cachePossiblyApplicableMethodCount;

    public Invoke(String string, char c) {
        super(string);
        this.kind = c;
        this.interpreter = Interpreter.getInterpreter();
    }

    public Invoke(String string, char c, Interpreter interpreter) {
        super(string);
        this.kind = c;
        this.interpreter = interpreter;
    }

    public static Object invoke$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(invoke, objectArray);
    }

    public static Object invokeStatic$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(invokeStatic, objectArray);
    }

    public static Object make$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(make, objectArray);
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        return Invoke.applyN(this, objectArray);
    }

    protected static Object applyN(Invoke invoke, Object[] objectArray) throws Throwable {
        Object object2;
        String string;
        ClassType classType;
        int n = objectArray.length;
        Procedure.checkArgCount(invoke, n);
        Object object3 = objectArray[0];
        char c = invoke.kind;
        if (c == 'V') {
            classType = (ClassType)Type.make(object3.getClass());
        } else {
            if (object3 instanceof Class) {
                object3 = Type.make((Class)object3);
            }
            if (object3 instanceof ClassType) {
                classType = (ClassType)object3;
            } else if (object3 instanceof String || object3 instanceof FString || object3 instanceof Binding) {
                classType = ClassType.make(object3.toString());
            } else {
                throw new WrongType(invoke, 0, null);
            }
        }
        Object object4 = null;
        if (c == 'N') {
            string = "<init>";
            if (classType instanceof PairClassType) {
                object2 = (PairClassType)classType;
                classType = ((PairClassType)object2).instanceType;
                object4 = ((PairClassType)object2).getStaticLink();
            }
        } else {
            object2 = objectArray[1];
            if (!(object2 instanceof String || object2 instanceof FString || object2 instanceof Binding)) {
                throw new WrongType(invoke, 1, null);
            }
            string = object2.toString();
            string = Compilation.mangleName(string);
        }
        if ((object2 = ClassMethods.apply(classType, string, null, null, invoke.kind == 'S' ? 8 : 0, 8)) == null) {
            throw new RuntimeException(invoke.getName() + ": no method named `" + string + "' in class " + classType.getName());
        }
        Object[] objectArray2 = new Object[n - (c == 'S' ? 2 : (object4 != null ? 0 : 1))];
        int n2 = 0;
        if (c == 'V') {
            objectArray2[n2++] = objectArray[0];
        } else if (object4 != null) {
            objectArray2[n2++] = object4;
        }
        System.arraycopy(objectArray, c == 'N' ? 1 : 2, objectArray2, n2, n - (c == 'N' ? 1 : 2));
        if (c == 'N') {
            CallContext callContext = CallContext.getInstance();
            int n3 = ((MethodProc)object2).match(callContext, objectArray2);
            int n4 = n - 1;
            if (n3 == 0) {
                return ((MethodProc)object2).applyV(callContext);
            }
            if ((n4 & 1) == 0) {
                Object object5;
                n2 = 0;
                while (n2 < n4) {
                    if (!(objectArray2[n2] instanceof Keyword)) {
                        throw MethodProc.matchFailAsException(n3, invoke, objectArray);
                    }
                    n2 += 2;
                }
                if (object4 == null) {
                    object5 = ((ProcedureN)object2).apply0();
                    n2 = 0;
                } else {
                    object5 = ((ProcedureN)object2).apply1(object4);
                    n2 = 1;
                }
                while (n2 < n4) {
                    Keyword keyword = (Keyword)objectArray2[n2];
                    Object object6 = objectArray2[n2 + 1];
                    SlotSet.apply(false, object5, keyword.getName(), object6);
                    n2 += 2;
                }
                return object5;
            }
            throw MethodProc.matchFailAsException(n3, invoke, objectArray);
        }
        return ((MethodProc)object2).applyN(objectArray2);
    }

    public int numArgs() {
        return 0xFFFFF000 | (this.kind == 'N' ? 1 : 2);
    }

    protected PrimProcedure[] getMethods(ClassType classType, String string, Expression[] expressionArray, int n) {
        if (expressionArray == this.cacheArgs) {
            return this.cacheMethods;
        }
        int n2 = expressionArray.length;
        Type[] typeArray = new Type[n2 - n];
        int n3 = 0;
        if (this.kind == 'V') {
            typeArray[n3++] = classType;
        }
        while (n3 < typeArray.length) {
            typeArray[n3] = expressionArray[n3 + n].getType();
            ++n3;
        }
        PrimProcedure[] primProcedureArray = ClassMethods.getMethods(classType, string, this.kind == 'S' ? 8 : 0, 8, this.interpreter);
        long l = ClassMethods.selectApplicable(primProcedureArray, typeArray);
        this.cacheArgs = expressionArray;
        this.cacheDefinitelyApplicableMethodCount = (int)(l >> 32);
        this.cachePossiblyApplicableMethodCount = (int)l;
        this.cacheMethods = primProcedureArray;
        return this.cacheMethods;
    }

    static Object[] checkKeywords(Type type, Expression[] expressionArray, int n) {
        int n2 = expressionArray.length;
        if ((n2 - n & 1) != 0) {
            return null;
        }
        Object[] objectArray = new Object[n2 - n >> 1];
        int n3 = objectArray.length;
        while (--n3 >= 0) {
            Expression expression = expressionArray[n + 2 * n3];
            if (!(expression instanceof QuoteExp)) {
                return null;
            }
            Object object2 = ((QuoteExp)expression).getValue();
            if (!(object2 instanceof Keyword)) {
                return null;
            }
            String string = ((Keyword)object2).getName();
            Object object3 = SlotSet.getField(type, string);
            Object object4 = objectArray[n3] = object3 != null ? object3 : string;
        }
        return objectArray;
    }

    public Expression inline(ApplyExp applyExp) {
        return this.kind == 'V' ? applyExp : Invoke.inlineClassName(applyExp, 0, this.interpreter);
    }

    public static Expression inlineClassName(ApplyExp applyExp, int n, Interpreter interpreter) {
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length > n) {
            ClassType classType;
            Type type = interpreter.getTypeFor(expressionArray[n]);
            if (type instanceof PairClassType) {
                classType = ((PairClassType)type).instanceType;
            } else if (type instanceof ClassType) {
                classType = (ClassType)type;
            } else {
                return applyExp;
            }
            Expression[] expressionArray2 = new Expression[expressionArray.length];
            System.arraycopy(expressionArray, 0, expressionArray2, 0, expressionArray.length);
            expressionArray2[n] = new QuoteExp(classType);
            return new ApplyExp(applyExp.getFunction(), expressionArray2);
        }
        return applyExp;
    }

    /*
     * Unable to fully structure code
     */
    public void compile(ApplyExp var1_1, Compilation var2_2, Target var3_3) {
        block23: {
            block25: {
                block26: {
                    block24: {
                        var4_4 = var1_1.getArgs();
                        var5_5 = var4_4.length;
                        var6_6 = this.getClassType(var4_4);
                        var7_7 = this.getMethodName(var4_4);
                        if (var6_6 == null || var7_7 == null) break block23;
                        var11_8 = this;
                        synchronized (var11_8) {
                            try {
                                var8_9 = this.getMethods(var6_6, var7_7, var4_4, this.kind == 'S' ? 2 : 1);
                            }
                            catch (Exception var12_10) {
                                var2_2.error('w', "unknown class: " + var6_6.getName());
                                var8_9 = null;
                            }
                            var9_12 = this.cacheDefinitelyApplicableMethodCount;
                            var10_13 = this.cachePossiblyApplicableMethodCount;
                        }
                        if (var8_9 == null) break block23;
                        var12_11 = -1;
                        if (var8_9.length != 0) break block24;
                        var2_2.error('w', "no method `" + var7_7 + "' in " + var6_6.getName());
                        break block25;
                    }
                    if (var9_12 + var10_13 != 0) break block26;
                    if (this.kind != 'N' || ClassMethods.selectApplicable((PrimProcedure[])var8_9, Type.typeArray0) >> 32 != 1L || (var13_15 = Invoke.checkKeywords(var6_6, var4_4, 1)) == null) ** GOTO lbl65
                    var14_19 = null;
                    var15_21 = 0;
                    while (var15_21 < var13_15.length) {
                        if (var13_15[var15_21] instanceof String) {
                            if (var14_19 == null) {
                                var14_19 = new StringBuffer();
                                var14_19.append("no field or setter ");
                            } else {
                                var14_19.append(", ");
                            }
                            var14_19.append('`');
                            var14_19.append(var13_15[var15_21]);
                            var14_19.append('\'');
                        }
                        ++var15_21;
                    }
                    if (var14_19 != null) {
                        var14_19.append(" in class ");
                        var14_19.append(var6_6.getName());
                        var2_2.error('w', var14_19.toString());
                    } else {
                        var16_23 = var8_9[0];
                        var17_24 = var2_2.getCode();
                        var16_23.compile(new ApplyExp(var16_23, new Expression[0]), var2_2, Target.pushObject);
                        var18_25 = 0;
                        while (var18_25 < var13_15.length) {
                            var17_24.emitDup(var6_6);
                            SlotSet.compileSet(this, var6_6, var4_4[2 * var18_25 + 2], var13_15[var18_25], var2_2);
                            ++var18_25;
                        }
                        var3_3.compileFromStack(var2_2, var6_6);
                        return;
lbl65:
                        // 1 sources

                        var2_2.error('w', "no possibly applicable method `" + var7_7 + "' in " + var6_6.getName());
                    }
                    break block25;
                }
                if (var9_12 == 1 || var9_12 == 0 && var10_13 == 1) {
                    var12_11 = 0;
                } else if (var9_12 > 0) {
                    var12_11 = MethodProc.mostSpecific(var8_9, var9_12);
                    if (var12_11 < 0) {
                        var2_2.error('w', "more than one definitely applicable method `" + var7_7 + "' in " + var6_6.getName());
                        var13_16 = 0;
                        while (var13_16 < var9_12) {
                            var2_2.error('w', "candidate: " + var8_9[var13_16]);
                            ++var13_16;
                        }
                    }
                } else if (var9_12 == 0) {
                    var2_2.error('w', "no definitely applicable method `" + var7_7 + "' in " + var6_6.getName());
                } else {
                    var2_2.error('w', "more than one possibly applicable method `" + var7_7 + "' in " + var6_6.getName());
                    var13_17 = 0;
                    while (var13_17 < var9_12) {
                        var2_2.error('w', "candidate: " + var8_9[var13_17]);
                    }
                }
            }
            if (var12_11 >= 0) {
                var13_18 = new Expression[var5_5 - (this.kind == 'S' ? 2 : 1)];
                var14_20 = 0;
                if (this.kind == 'V') {
                    var13_18[var14_20++] = var4_4[0];
                }
                System.arraycopy(var4_4, this.kind == 'N' ? 1 : 2, var13_18, var14_20, var5_5 - (this.kind == 'N' ? 1 : 2));
                var15_22 = var8_9[var12_11];
                var15_22.compile(new ApplyExp(var15_22, var13_18), var2_2, var3_3);
                return;
            }
        }
        ApplyExp.compile(var1_1, var2_2, var3_3);
    }

    private ClassType getClassType(Expression[] expressionArray) {
        if (expressionArray.length > 0) {
            Type type;
            Expression expression = expressionArray[0];
            Type type2 = type = this.kind == 'V' ? expression.getType() : this.interpreter.getTypeFor(expression);
            if (type instanceof PairClassType) {
                return ((PairClassType)type).instanceType;
            }
            if (type instanceof ClassType) {
                return (ClassType)type;
            }
        }
        return null;
    }

    private String getMethodName(Expression[] expressionArray) {
        if (this.kind == 'N') {
            return "<init>";
        }
        if (expressionArray.length >= 2) {
            return ClassMethods.checkName(expressionArray[1]);
        }
        return null;
    }

    public synchronized Type getReturnType(Expression[] expressionArray) {
        int n = expressionArray.length;
        if (n > 0) {
            PrimProcedure[] primProcedureArray;
            Type type;
            Expression expression = expressionArray[0];
            Type type2 = type = this.kind == 'V' ? expression.getType() : this.interpreter.getTypeFor(expression);
            if (this.kind == 'N') {
                return type == null ? Type.pointer_type : type;
            }
            Object object2 = null;
            if (n >= 2 && expressionArray[1] instanceof QuoteExp) {
                object2 = ((QuoteExp)expressionArray[1]).getValue();
            }
            if (type instanceof ClassType && (object2 instanceof FString || object2 instanceof String || object2 instanceof Binding) && (primProcedureArray = this.getMethods((ClassType)type, object2.toString(), expressionArray, this.kind == 'S' ? 2 : 1)) != null && (this.cacheDefinitelyApplicableMethodCount == 1 || this.cacheDefinitelyApplicableMethodCount == 0 && this.cachePossiblyApplicableMethodCount == 1)) {
                return primProcedureArray[0].getReturnType(expressionArray);
            }
        }
        return Type.pointer_type;
    }

    public static synchronized ApplyExp makeInvokeStatic(ClassType classType, String string, Expression[] expressionArray) {
        PrimProcedure primProcedure = Invoke.getStaticMethod(classType, string, expressionArray);
        if (primProcedure == null) {
            throw new RuntimeException("missing or ambiguous method `" + string + "' in " + classType.getName());
        }
        return new ApplyExp(primProcedure, expressionArray);
    }

    public static synchronized PrimProcedure getStaticMethod(ClassType classType, String string, Expression[] expressionArray) {
        MethodProc[] methodProcArray = invokeStatic.getMethods(classType, string, expressionArray, 0);
        int n = Invoke.invokeStatic.cacheDefinitelyApplicableMethodCount;
        int n2 = Invoke.invokeStatic.cachePossiblyApplicableMethodCount;
        int n3 = methodProcArray == null ? -1 : (n > 0 ? MethodProc.mostSpecific(methodProcArray, n) : (n2 == 1 ? 0 : -1));
        return n3 < 0 ? null : methodProcArray[n3];
    }

    public static synchronized PrimProcedure getMethod(ClassType classType, String string, boolean bl, Type[] typeArray, Interpreter interpreter) {
        MethodProc[] methodProcArray = ClassMethods.getMethods(classType, string, bl ? 8 : 0, 8, interpreter);
        long l = ClassMethods.selectApplicable((PrimProcedure[])methodProcArray, typeArray);
        int n = (int)(l >> 32);
        int n2 = (int)l;
        int n3 = methodProcArray == null ? -1 : (n > 0 ? MethodProc.mostSpecific(methodProcArray, n) : (n2 == 1 ? 0 : -1));
        return n3 < 0 ? null : methodProcArray[n3];
    }
}

