/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.mapping.Binding;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.Named;
import gnu.mapping.TrivialConstraint;
import gnu.mapping.UnboundSymbol;
import gnu.mapping.WrappedException;
import java.lang.reflect.Field;

public class ClassMemberConstraint
extends Constraint {
    ClassType type;
    String name;
    Field rfield;

    public ClassMemberConstraint(ClassType classType, String string) {
        this.type = classType;
        this.name = string;
    }

    public ClassMemberConstraint(Class clazz, String string) {
        this.type = (ClassType)Type.make(clazz);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public ClassType getDeclaringClass() {
        return this.type;
    }

    public ClassMemberConstraint(Field field) {
        this.rfield = field;
        this.name = field.getName();
    }

    void setup(Binding binding) {
        if (this.rfield == null) {
            Class clazz;
            try {
                clazz = this.type.getReflectClass();
            }
            catch (RuntimeException runtimeException) {
                String string = binding.getName();
                throw new UnboundSymbol(string, "Unbound symbol " + string + " - " + runtimeException.toString());
            }
            try {
                this.rfield = clazz.getField(this.name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string = binding.getName();
                throw new UnboundSymbol(string, "Unbound symbol " + string + " - no field " + string + " in " + this.type.getName());
            }
        }
    }

    public Object get(Binding binding, Object object2) {
        this.setup(binding);
        try {
            return this.rfield.get(Constraint.getValue(binding));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WrappedException(illegalAccessException);
        }
    }

    public void set(Binding binding, Object object2) {
        this.setup(binding);
        try {
            this.rfield.set(Constraint.getValue(binding), object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            Constraint.setConstraint(binding, new TrivialConstraint(this.getEnvironment(binding)));
            Constraint.setValue(binding, object2);
            return;
        }
    }

    public static void define(String string, Object object2, String string2) {
        ClassMemberConstraint.define(string, object2, string2, Environment.getCurrent());
    }

    public static void define(String string, Object object2, String string2, Environment environment) {
        Binding binding;
        Binding binding2 = binding = environment.getBinding(string);
        synchronized (binding2) {
            Constraint.setValue(binding, object2);
            Constraint.setConstraint(binding, new ClassMemberConstraint(object2.getClass(), string2));
        }
    }

    public static void define(String string, Object object2, Field field, Environment environment) {
        if ((field.getModifiers() & 0x10) != 0) {
            try {
                Object object3 = field.get(object2);
                if (object3 instanceof Binding) {
                    environment.addBinding((Binding)object3);
                    return;
                }
                String string2 = object3 instanceof Named ? ((Named)object3).getName() : null;
                string = string2 != null ? string2 : Compilation.demangleName(string, true);
                string = string.intern();
                environment.define(string, object3);
                return;
            }
            catch (Exception exception) {
                throw new WrappedException("error accessing field " + field, exception);
            }
        }
        string = string.intern();
        Binding binding = new Binding(string);
        Constraint.setValue(binding, object2);
        Constraint.setConstraint(binding, new ClassMemberConstraint(field));
        environment.addBinding(binding);
    }

    public static void defineAll(Object object2, Environment environment) {
        Class<?> clazz = object2.getClass();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        while (--n >= 0) {
            Field field = fieldArray[n];
            ClassMemberConstraint.define(field.getName(), object2, field, environment);
        }
    }
}

